/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.user;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.UserSearchViewTable;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.database.documentViews.DocumentViewsTable;
import com.plusmpm.database.documentViews.dto.AddDocumentViewsTableDto;
import com.plusmpm.database.documentViews.dto.ReadDocumentViewsTableDto;
import com.plusmpm.database.documentViews.exception.DocumentViewNotFoundException;
import com.plusmpm.i18n.AbstractI18N;
import com.plusmpm.struts.form.UserViewConfForm;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.menuitem.MenuTabCache;
import com.suncode.plugin.framework.Module;
import com.suncode.plugin.framework.ModuleAccessor;
import com.suncode.plugin.framework.web.support.DefaultView;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.administration.user.UserSettingsService;
import com.suncode.pwfl.administration.user.UserViewDataDto;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentViewsService;
import com.suncode.pwfl.archive.Link;
import com.suncode.pwfl.archive.LinkService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.userAppearanceSettings.UserConfigureFormValidator;
import com.suncode.pwfl.util.DtoComparator;
import com.suncode.pwfl.util.Paginator;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.view.ViewService;
import com.suncode.pwfl.web.controller.api.administration.processes.documentViews.DocumentViewsAuditHelper;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NoRightsException;
import com.suncode.pwfl.web.support.DocumentViewsMapper;
import com.suncode.pwfl.web.support.UserLocaleResolver;
import com.suncode.pwfl.web.support.ajax.RestResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"user/settings"})
public class UserSettingsController {
    private static final Logger log = LoggerFactory.getLogger(UserSettingsController.class);
    @Autowired
    private UserLocaleResolver userLocaleResolver;
    @Autowired
    private DocumentViewsService documentViewsService;
    @Autowired
    private DocumentViewsMapper documentViewsMapper;
    @Autowired
    private DocumentViewsAuditHelper auditHelper;
    @Autowired
    private UserSettingsService userSettingsService;
    @Autowired
    private ViewService viewService;
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    private ModuleAccessor moduleAccessor;
    @Autowired
    private LinkService linkService;
    @Autowired
    private UserFinder userFinder;
    @Autowired
    private MessageHelperBean messageHelper;
    @Autowired
    private UserService userService;
    @Autowired
    private AuthorizationHelper authorizationHelper;
    @Autowired
    private UserConfigureFormValidator userConfigureFormValidator;
    private Map<UserSettingsService.UserSetting, Function<UserViewConfForm, String>> settingsSupplierMap = new ImmutableMap.Builder().put((Object)UserSettingsService.UserSetting.LANGUAGE, UserViewConfForm::getLanguage).put((Object)UserSettingsService.UserSetting.PAGE_SIZE, UserViewConfForm::getPageSize).put((Object)UserSettingsService.UserSetting.NOTIFICATIONS, UserViewConfForm::getNotifs).put((Object)UserSettingsService.UserSetting.EMAILS, UserViewConfForm::getEmails).put((Object)UserSettingsService.UserSetting.VIEW_AVATAR, UserViewConfForm::getViewAvatar).put((Object)UserSettingsService.UserSetting.TASK_AVATAR, UserViewConfForm::getTaskAvatar).put((Object)UserSettingsService.UserSetting.TEMPlATE, UserViewConfForm::getTemplate).put((Object)UserSettingsService.UserSetting.COMPACT_TEMPlATE, UserViewConfForm::getCompactTemplate).build();

    @RequestMapping(value={"locale"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, String> getLocale(HttpServletRequest request) {
        Locale locale = this.userLocaleResolver.resolveLocale(request);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("languageCode", locale.getLanguage());
        map.put("countryCode", locale.getCountry());
        return map;
    }

    @RequestMapping(value={"appearance/{name}"}, method={RequestMethod.GET})
    @ResponseBody
    public String getUserSettingValueBySettingName(@PathVariable String name) {
        if (!this.settingsSupplierMap.keySet().toString().contains(name)) {
            throw new ServiceException(this.messageHelper.getMessage("Ustawienie_o_podanej_nazwie_nie_istnieje"));
        }
        String username = UserContext.current().getUser().getUserName();
        String setting = this.userSettingsService.getSetting(username, name);
        return setting == null ? "on" : setting;
    }

    @RequestMapping(value={"appearance"}, method={RequestMethod.GET})
    @ResponseBody
    public UserSettingsDto getUserAppearanceSettings() {
        UserSettingsDto userSettings = new UserSettingsDto();
        Map settings = this.userSettingsService.getSettings(UserContext.current().getUser().getUserName());
        AtomicReference<String> defaultView = new AtomicReference<String>((String)settings.get(UserSettingsService.UserSetting.DEFAULT_VIEW.getName()));
        String defaultViewName = this.getDefaultViewName(defaultView);
        List defaultUserViews = this.userSettingsService.getDefaultUserViews(UserContext.current().getUser().getUserName());
        boolean isViewAvailableForUser = defaultUserViews.stream().anyMatch(userViewDataDto -> userViewDataDto.getViewId().equals(defaultView.get()));
        userSettings.setEmails((String)settings.get(UserSettingsService.UserSetting.EMAILS.toString()));
        userSettings.setTemplate((String)settings.get(UserSettingsService.UserSetting.TEMPlATE.toString()));
        userSettings.setCompactTemplate((String)settings.get(UserSettingsService.UserSetting.COMPACT_TEMPlATE.toString()));
        userSettings.setDefaultView((String)settings.get(UserSettingsService.UserSetting.DEFAULT_VIEW.toString()));
        userSettings.setNotifs((String)settings.get(UserSettingsService.UserSetting.NOTIFICATIONS.toString()));
        userSettings.setLaguage((String)settings.get(UserSettingsService.UserSetting.LANGUAGE.toString()));
        userSettings.setPageSize((String)settings.get(UserSettingsService.UserSetting.PAGE_SIZE.toString()));
        userSettings.setTaskAvatar((String)settings.get(UserSettingsService.UserSetting.TASK_AVATAR.toString()));
        userSettings.setViewAvatar((String)settings.get(UserSettingsService.UserSetting.VIEW_AVATAR.toString()));
        if (!isViewAvailableForUser && StringUtils.isNotBlank((String)defaultView.get())) {
            userSettings.setDefaultViewName(defaultViewName + " (" + this.messageHelper.getMessage("Niedostepne") + ")");
            userSettings.setViewAvailable(false);
            return userSettings;
        }
        userSettings.setViewAvailable(true);
        userSettings.setDefaultViewName(defaultViewName);
        return userSettings;
    }

    @RequestMapping(value={"appearance"}, method={RequestMethod.POST})
    @ResponseBody
    public RestResult saveUserAppearanceSettings(@RequestBody UserViewConfForm userViewConfForm, HttpServletRequest request, HttpSession session) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_USER_SETTINGS);
        userViewConfForm.setGlobalChange(false);
        Map<String, Object> auditParams = this.createAuditParameters(userViewConfForm);
        auditBuilder.params(auditParams);
        this.userConfigureFormValidator.validateUserViewConfigureForm(userViewConfForm, false);
        User user = this.userFinder.findByUserName(UserContext.current().getUser().getUserName(), new String[0]);
        Map<String, String> settings = this.prepareSettingsToUpdate(userViewConfForm);
        if (StringUtils.isNotBlank((String)userViewConfForm.getDefaultView())) {
            settings.put(UserSettingsService.UserSetting.DEFAULT_VIEW.getName(), userViewConfForm.getDefaultView());
        }
        try {
            this.updateUserSettings(userViewConfForm, session, user, settings);
        }
        catch (DataIntegrityViolationException e) {
            auditBuilder.buildFailure(request);
            throw new ServiceException(this.messageHelper.getMessage("Nie_udalo_sie_zmienic_ustawien"), (Throwable)e);
        }
        catch (ServiceException e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
        auditBuilder.buildSuccess(request);
        return new RestResult(true);
    }

    private void updateUserSettings(UserViewConfForm userViewConfForm, HttpSession session, User user, Map<String, String> settings) {
        this.userSettingsService.setUserSetting(user, settings);
        MenuTabCache.clear((String)user.getUserName());
        this.setSessionLocale(user.getUserName(), userViewConfForm, session);
    }

    private List<User> getUsersToChange(String resourceName, Boolean isGroup) {
        if (StringUtils.isBlank((String)resourceName)) {
            return this.userFinder.getAll(new String[0]);
        }
        return isGroup != false ? new ArrayList(this.userService.getGroup(resourceName, new String[]{"users"}).getUsers()) : Collections.singletonList(this.userService.getUser(resourceName, new String[0]));
    }

    @RequestMapping(value={"appearance/globally"}, method={RequestMethod.POST})
    @ResponseBody
    public RestResult saveUserAppearanceSettingsGlobally(@RequestBody UserViewConfForm userViewConfForm, HttpServletRequest request, HttpSession session) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_USER_SETTINGS_GLOBAL);
        userViewConfForm.setGlobalChange(true);
        Map<String, Object> auditParams = this.createAuditParameters(userViewConfForm);
        auditBuilder.params(auditParams);
        this.userConfigureFormValidator.validateUserViewConfigureForm(userViewConfForm, true);
        this.authorizationHelper.assertFullOrPartRights(RightTreeBuilder.builder().system().admin().build(), () -> auditBuilder.buildFailure(request));
        Map<String, String> settings = this.prepareSettingsToUpdate(userViewConfForm);
        if (StringUtils.isNotBlank((String)userViewConfForm.getDefaultView())) {
            settings.put(UserSettingsService.UserSetting.DEFAULT_VIEW.getName(), userViewConfForm.getDefaultView());
        }
        List<User> usersToChange = this.getUsersToChange(userViewConfForm.getResourceName(), Boolean.valueOf(userViewConfForm.getIsGroup()));
        auditParams.put("usernames", usersToChange.stream().map(User::getUserName).collect(Collectors.joining(", ")));
        auditBuilder.params(auditParams);
        try {
            List userChunks = Lists.partition(usersToChange, (int)500);
            AtomicInteger count = new AtomicInteger();
            IntStream.range(0, userChunks.size()).parallel().forEach(chunkIndex -> {
                List chunk = (List)userChunks.get(chunkIndex);
                for (User user : chunk) {
                    this.updateUserSettings(userViewConfForm, session, user, settings);
                    if (count.incrementAndGet() % 500 != 0) continue;
                    log.info("Updated {} users so far", (Object)count);
                }
            });
        }
        catch (DataIntegrityViolationException e) {
            auditBuilder.buildFailure(request);
            throw new ServiceException(this.messageHelper.getMessage("Nie_udalo_sie_zmienic_ustawien"), (Throwable)e);
        }
        catch (ServiceException e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
        auditBuilder.buildSuccess(request);
        return new RestResult(true);
    }

    private Map<String, Object> createAuditParameters(final UserViewConfForm userViewConfForm) {
        return new LinkedHashMap<String, Object>(){
            {
                this.put("language", StringUtils.defaultString((String)userViewConfForm.getLanguage()));
                this.put("pageSize", StringUtils.defaultString((String)userViewConfForm.getPageSize()));
                this.put("defaultView", StringUtils.defaultString((String)userViewConfForm.getDefaultViewName()));
                this.put("notifs", StringUtils.defaultString((String)userViewConfForm.getNotifs()));
                this.put("emails", StringUtils.defaultString((String)userViewConfForm.getEmails()));
                this.put("taskAvatar", StringUtils.defaultString((String)userViewConfForm.getTaskAvatar()));
                this.put("viewAvatar", StringUtils.defaultString((String)userViewConfForm.getViewAvatar()));
                this.put("template", StringUtils.defaultString((String)userViewConfForm.getTemplate()));
                this.put("compactTemplate", StringUtils.defaultString((String)userViewConfForm.getCompactTemplate()));
            }
        };
    }

    @RequestMapping(value={"default-views"}, method={RequestMethod.GET})
    @ResponseBody
    public List<UserViewDataDto> getUserDefaultViews() {
        return this.userSettingsService.getDefaultUserViews(UserContext.current().getUser().getUserName());
    }

    @RequestMapping(value={"document/views"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<ReadDocumentViewsTableDto> getDocumentViewsByLoggedUsername(@RequestParam(required=false, defaultValue="0") Integer start, @RequestParam(required=false, defaultValue="20") Integer limit, @RequestParam(required=false, defaultValue="documentViewName") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        List documentViews = this.documentViewsService.getDocumentViewsByUsername(UserContext.current().getUser().getUserName()).stream().map(this.documentViewsMapper::toDto).sorted((Comparator<ReadDocumentViewsTableDto>)DtoComparator.of(ReadDocumentViewsTableDto.class, (String)sortBy, (SortDirection)sortDirection)).collect(Collectors.toList());
        return Paginator.forAll(documentViews).viewPageByOffset(start, limit);
    }

    @RequestMapping(value={"document/views/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public RestResult deleteDocumentView(HttpServletRequest request, @PathVariable Long id) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_DOCUMENT_VIEW);
        DocumentViewsTable view = (DocumentViewsTable)this.documentViewsService.get((Serializable)id);
        if (view == null) {
            throw new DocumentViewNotFoundException(this.messageHelper.getMessage("Widok_o_podanym_id_nie_istnieje"));
        }
        auditBuilder.params(this.auditHelper.createDeleteDocumentViewAuditParams(id, view.getProc_def_id()));
        String username = UserContext.current().getUser().getUserName();
        if (!view.getUser_id().equals(username) && !Authorization.checkIsUserAdmin((String)username)) {
            throw new NoRightsException();
        }
        try {
            this.documentViewsService.deleteDocumentViewById(id);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
        auditBuilder.buildSuccess(request);
        return new RestResult(true);
    }

    @RequestMapping(value={"document/views"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public RestResult addDocumentView(HttpServletRequest request, @RequestBody AddDocumentViewsTableDto addDocumentViewsTableDto) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_DOCUMENT_VIEW);
        addDocumentViewsTableDto.setUserId(UserContext.current().getUser().getUserName());
        Map<String, Object> addDocumentViewAuditParams = this.auditHelper.createAddDocumentViewAuditParams(addDocumentViewsTableDto);
        auditBuilder.params(addDocumentViewAuditParams);
        try {
            DocumentViewsTable viewsTable = this.documentViewsMapper.toEntity(addDocumentViewsTableDto);
            long documentViewId = this.documentViewsService.addDocumentView(viewsTable);
            addDocumentViewAuditParams.put("documentViewId", StringUtils.defaultString((String)String.valueOf(documentViewId)));
            auditBuilder.params(addDocumentViewAuditParams);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
        auditBuilder.buildSuccess(request);
        return new RestResult(true);
    }

    @RequestMapping(value={"document/views/{id}"}, method={RequestMethod.PATCH})
    @ResponseBody
    public RestResult changeDocumentView(HttpServletRequest request, @RequestBody AddDocumentViewsTableDto addDocumentViewsTableDto, @PathVariable Long id) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_EDIT_DOCUMENT_VIEW);
        DocumentViewsTable documentView = (DocumentViewsTable)this.documentViewsService.get((Serializable)id);
        if (Objects.isNull(documentView)) {
            throw new DocumentViewNotFoundException(this.messageHelper.getMessage("Widok_o_podanym_id_nie_istnieje"));
        }
        String username = UserContext.current().getUser().getUserName();
        if (!documentView.getUser_id().equals(username) && !Authorization.checkIsUserAdmin((String)username)) {
            throw new NoRightsException();
        }
        addDocumentViewsTableDto.setUserId(UserContext.current().getUser().getUserName());
        auditBuilder.params(this.auditHelper.createEditDocumentViewAuditParams(addDocumentViewsTableDto, documentView));
        try {
            DocumentViewsTable documentViewsTable = this.documentViewsMapper.toEntity(addDocumentViewsTableDto);
            documentViewsTable.setId(id);
            this.documentViewsService.changeDocumentView(documentViewsTable);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
        auditBuilder.buildSuccess(request);
        return new RestResult(true);
    }

    @ExceptionHandler(value={IllegalArgumentException.class, ServiceException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleIllegalArgumentException(Exception e) {
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={DocumentViewNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    public RestResult handleNotFoundException(DocumentViewNotFoundException e) {
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={NoRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNoRightsException(NoRightsException e) {
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_widoku_dokumentu"));
    }

    private Map<String, String> prepareSettingsToUpdate(UserViewConfForm userViewConfForm) {
        HashMap<String, String> settings = new HashMap<String, String>();
        this.settingsSupplierMap.forEach((setting, supplierFunction) -> {
            String settingValue = (String)supplierFunction.apply(userViewConfForm);
            if (settingValue != null) {
                settings.put(setting.getName(), settingValue);
            }
        });
        return settings;
    }

    private void setSessionLocale(String userName, UserViewConfForm userViewConfForm, HttpSession session) {
        String language = userViewConfForm.getLanguage();
        if (StringUtils.isNotBlank((String)language) && session.getAttribute("username").equals(userName)) {
            AbstractI18N.setSessionLocale((HttpSession)session, (String)language);
        }
    }

    private String getDefaultViewName(AtomicReference<String> defaultViewAtomic) {
        String defaultView = defaultViewAtomic.get();
        if (StringUtils.isNotBlank((String)defaultView)) {
            Module module;
            switch (defaultView) {
                case "dashboard": {
                    return this.messageHelper.getMessage("dashboard.label");
                }
                case "admin": {
                    return this.messageHelper.getMessage("Administracja");
                }
                case "operationPanel": {
                    return this.messageHelper.getMessage("Panel_uzytkownika");
                }
                case "task": {
                    return this.messageHelper.getMessage("Skrzynka_zadan");
                }
                case "createprocess": {
                    return this.messageHelper.getMessage("Nowy_proces");
                }
                case "archive": {
                    return this.messageHelper.getMessage("Archiwum_dokumentow");
                }
                case "docclasses": {
                    return this.messageHelper.getMessage("Klasy_dokumentow");
                }
                case "links": {
                    return this.messageHelper.getMessage("Zestawy_dokumentow");
                }
                case "calendar": {
                    return this.messageHelper.getMessage("Moj_kalendarz");
                }
                case "searchprocess": {
                    return this.messageHelper.getMessage("Znajdz_proces");
                }
                case "stats": {
                    return this.messageHelper.getMessage("Statystyki");
                }
                case "myviews": {
                    return this.messageHelper.getMessage("Moje_widoki");
                }
            }
            if (defaultView.startsWith("docclass_")) {
                String[] sId = defaultView.split("_");
                if (sId.length > 0) {
                    DocumentClass documentClass = (DocumentClass)this.documentClassService.get((Serializable)Long.valueOf(Long.parseLong(sId[1])));
                    if (documentClass != null) {
                        return this.documentClassService.getDocumentClassTranslation(documentClass.getId(), TranslatedFieldType.NAME);
                    }
                    log.info("Nie znaleziono klasy dokument\u00f3w o id: " + sId[1]);
                    defaultViewAtomic.set("");
                    return "";
                }
            } else if (defaultView.startsWith("link_")) {
                String[] sId = defaultView.split("_");
                if (sId.length > 0) {
                    Link link = this.linkService.getLink(Long.valueOf(sId[1]), new String[0]);
                    if (link != null) {
                        return this.linkService.getLinkTranslation(link.getId(), TranslatedFieldType.NAME);
                    }
                    log.info("Nie znaleziono zestawu dokument\u00f3w o id: " + sId[1]);
                    defaultViewAtomic.set("");
                    return "";
                }
            } else if (defaultView.startsWith("myview_")) {
                String[] sId = defaultView.split("_");
                if (sId.length > 0) {
                    UserSearchViewTable userView = new DBManagement().getUserSearchView(sId[1]);
                    if (userView != null) {
                        return this.viewService.getViewTranslation(userView.getId(), TranslatedFieldType.NAME);
                    }
                    log.info("Nie znaleziono widoku o id: " + sId[1]);
                    defaultViewAtomic.set("");
                    return "";
                }
            } else if (!StringUtils.isEmpty((String)defaultView) && (module = this.moduleAccessor.getModule(defaultView, DefaultView.class)) != null) {
                return ((DefaultView)module.getObject()).getLabel();
            }
        }
        return "";
    }

    public static class UserSettingsDto {
        private String emails;
        private String template;
        private String compactTemplate;
        private String defaultView;
        private String notifs;
        private String laguage;
        private String pageSize;
        private String defaultViewName;
        private boolean isViewAvailable;
        private String taskAvatar;
        private String viewAvatar;

        public String getEmails() {
            return this.emails;
        }

        public String getTemplate() {
            return this.template;
        }

        public String getCompactTemplate() {
            return this.compactTemplate;
        }

        public String getDefaultView() {
            return this.defaultView;
        }

        public String getNotifs() {
            return this.notifs;
        }

        public String getLaguage() {
            return this.laguage;
        }

        public String getPageSize() {
            return this.pageSize;
        }

        public String getDefaultViewName() {
            return this.defaultViewName;
        }

        public boolean isViewAvailable() {
            return this.isViewAvailable;
        }

        public String getTaskAvatar() {
            return this.taskAvatar;
        }

        public String getViewAvatar() {
            return this.viewAvatar;
        }

        public void setEmails(String emails) {
            this.emails = emails;
        }

        public void setTemplate(String template) {
            this.template = template;
        }

        public void setCompactTemplate(String compactTemplate) {
            this.compactTemplate = compactTemplate;
        }

        public void setDefaultView(String defaultView) {
            this.defaultView = defaultView;
        }

        public void setNotifs(String notifs) {
            this.notifs = notifs;
        }

        public void setLaguage(String laguage) {
            this.laguage = laguage;
        }

        public void setPageSize(String pageSize) {
            this.pageSize = pageSize;
        }

        public void setDefaultViewName(String defaultViewName) {
            this.defaultViewName = defaultViewName;
        }

        public void setViewAvailable(boolean isViewAvailable) {
            this.isViewAvailable = isViewAvailable;
        }

        public void setTaskAvatar(String taskAvatar) {
            this.taskAvatar = taskAvatar;
        }

        public void setViewAvatar(String viewAvatar) {
            this.viewAvatar = viewAvatar;
        }
    }
}

