/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.plusmpm.database.DBManagement;
import com.plusmpm.database.UserSearchViewTable;
import com.plusmpm.struts.action.AdvanceProcessSearchAction;
import com.plusmpm.struts.form.AdvanceVariableForm;
import com.plusmpm.util.AdvanceSearchResult;
import com.plusmpm.util.AdvanceVariableListComp;
import com.plusmpm.util.XpdlPackageManager;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.audit.AuditWrapper;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.elastic.search.ElasticValueSearchModelConverter;
import com.suncode.pwfl.elastic.search.model.ElasticSearchModel;
import com.suncode.pwfl.experimental.Experimental;
import com.suncode.pwfl.experimental.ExperimentalFeature;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.search.AdvanceVariableFormBuilder;
import com.suncode.pwfl.search.elastic.ElasticAdvanceProcessSearchResults;
import com.suncode.pwfl.search.elastic.ElasticAdvanceProcessSearchService;
import com.suncode.pwfl.search.elastic.ElasticResultConverterParameters;
import com.suncode.pwfl.search.elastic.ElasticResultConverterParametersProvider;
import com.suncode.pwfl.search.elastic.ElasticResultToAdvanceSearchResultConverter;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.SharkUtils;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.web.search.model.SearchFormModelDto;
import com.suncode.pwfl.web.support.form.cache.SearchFormCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.enhydra.shark.api.client.wfservice.NotConnected;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteAdvanceSearchedProcessesAction
extends Action {
    private static final Logger log = LoggerFactory.getLogger(DeleteAdvanceSearchedProcessesAction.class);
    private static final SearchFormCache searchFormCache = (SearchFormCache)SpringContext.getBean(SearchFormCache.class);
    private static final AdvanceVariableFormBuilder advanceVariableFormBuilder = (AdvanceVariableFormBuilder)SpringContext.getBean(AdvanceVariableFormBuilder.class);
    private static final Experimental experimental = (Experimental)SpringContext.getBean(Experimental.class);
    private static final ElasticAdvanceProcessSearchService elasticAdvanceProcessSearchService = (ElasticAdvanceProcessSearchService)SpringContext.getBean(ElasticAdvanceProcessSearchService.class);
    private static final ElasticResultToAdvanceSearchResultConverter elasticResultToAdvanceSearchResultConverter = (ElasticResultToAdvanceSearchResultConverter)SpringContext.getBean(ElasticResultToAdvanceSearchResultConverter.class);
    private static final ElasticValueSearchModelConverter elasticValueSearchModelConverter = (ElasticValueSearchModelConverter)SpringContext.getBean(ElasticValueSearchModelConverter.class);
    private static final ElasticResultConverterParametersProvider elasticResultConverterParametersProvider = (ElasticResultConverterParametersProvider)SpringContext.getBean(ElasticResultConverterParametersProvider.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        log.info("******************************DeleteAdvanceSearchedProcessesAction********************");
        HttpSession session = request.getSession(false);
        String message = "";
        String messageType = "error";
        try {
            if (session == null || session.getAttribute("username") == null) {
                return mapping.findForward("welcome");
            }
            String userName = (String)session.getAttribute("username");
            String amount = request.getParameter("amount");
            String searchId = request.getParameter("searchId");
            if (StringUtils.isNotBlank((CharSequence)searchId)) {
                List alResult;
                boolean isElasticFeatureEnabled = experimental.hasFeature(ExperimentalFeature.ELASTIC) && SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.ELASTIC_ENABLED) != false;
                Optional<SearchFormModelDto> searchForm = searchFormCache.getSearchFormFromCache(searchId);
                ElasticSearchModel elasticSearchModel = null;
                SearchFormModelDto searchFormModelDto = null;
                ElasticAdvanceProcessSearchResults elasticAdvanceProcessSearchResults = null;
                if (!searchForm.isPresent()) {
                    throw new IllegalArgumentException("Search form is not cached");
                }
                searchFormModelDto = searchForm.get();
                AdvanceVariableForm[] searchVariable = advanceVariableFormBuilder.buildAdvanceFormVariables(searchFormModelDto);
                ArrayList<AdvanceVariableForm> alVariableList = new ArrayList<AdvanceVariableForm>();
                for (int i = 0; i < searchVariable.length && searchVariable[i] != null; ++i) {
                    alVariableList.add(searchVariable[i]);
                    log.info(searchVariable[i].getName() + ", " + searchVariable[i].getActive() + ", " + searchVariable[i].getValue() + ", " + searchVariable[i].getValue2() + ", " + searchVariable[i].getSortType() + ", " + searchVariable[i].getPosition());
                }
                AdvanceVariableListComp avc = new AdvanceVariableListComp();
                Collections.sort(alVariableList, avc);
                int iMaxPageSize = 0;
                DBManagement dbm = new DBManagement();
                Vector vCountQuery = new Vector();
                int iCnt = 0;
                if (isElasticFeatureEnabled) {
                    try {
                        elasticSearchModel = elasticValueSearchModelConverter.fromSearchModel(searchFormModelDto, "", "ASC");
                        iMaxPageSize = (int)elasticAdvanceProcessSearchService.getCount(elasticSearchModel);
                        elasticAdvanceProcessSearchResults = elasticAdvanceProcessSearchService.search(elasticSearchModel, 0, iMaxPageSize);
                        iMaxPageSize = (int)elasticAdvanceProcessSearchResults.getCount();
                        ElasticResultConverterParameters.ElasticResultConverterParametersBuilder elasticResultConverterParametersBuilder = elasticResultConverterParametersProvider.getParameters(searchFormModelDto, null, null, alVariableList, false, null, false, searchId, null, userName);
                        elasticResultConverterParametersBuilder.elasticAdvanceProcessSearchResults(elasticAdvanceProcessSearchResults);
                        alResult = elasticResultToAdvanceSearchResultConverter.convert(elasticResultConverterParametersBuilder.build());
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                        alResult = null;
                        iMaxPageSize = 0;
                    }
                } else {
                    alResult = dbm.AdavanceProcessSearch(searchVariable, userName, 0, 0, 0, "", vCountQuery, true, request, null);
                }
                if (alResult != null && !isElasticFeatureEnabled) {
                    String sCountQuery = (String)vCountQuery.get(0);
                    iMaxPageSize = dbm.getSizeAdavanceProcessSearch(searchVariable, userName, sCountQuery);
                }
                if (iMaxPageSize == 0) {
                    message = MessageHelper.getMessage((String)"Zaden_proces_nie_zostal_usuniety");
                } else if (iMaxPageSize != Integer.parseInt(amount)) {
                    message = MessageHelper.getMessage((String)"Wykryto_tryb_wielooknowy") + " " + MessageHelper.getMessage((String)"Zaden_proces_nie_zostal_usuniety");
                } else {
                    UserSearchViewTable userSearchViewTable;
                    ArrayList<String> pIds = new ArrayList<String>();
                    ArrayList<AuditWrapper> audits = new ArrayList<AuditWrapper>();
                    String ip = (String)StringUtils.defaultIfEmpty((CharSequence)request.getRemoteAddr(), (CharSequence)ManualAuditBuilder.UNKNOWN);
                    String viewId = request.getParameter("viewId");
                    String operationSource = "";
                    if (StringUtils.isNotBlank((CharSequence)viewId) && (userSearchViewTable = new DBManagement().getUserSearchView(viewId)) != null) {
                        operationSource = userSearchViewTable.getViewName();
                    }
                    for (int i = 0; i < alResult.size(); ++i) {
                        AdvanceSearchResult result = (AdvanceSearchResult)alResult.get(i);
                        String sProcessId = result.getProcessId();
                        pIds.add(sProcessId);
                        ++iCnt;
                        Map<String, Object> params = this.buildDeleteProcessAuditParams(sProcessId, result.getProcessDefinitionId(), request, operationSource);
                        this.buildDeleteProcessAudit(audits, params, ip, userName);
                    }
                    try {
                        ServiceFactory.getProcessService().deleteProcesses(pIds);
                        messageType = "success";
                        message = MessageHelper.getMessage((String)"Liczba_usunietych_procesow") + ": " + iCnt;
                        request.setAttribute("auditSuccess", (Object)true);
                        audits.forEach(audit -> audit.log());
                    }
                    catch (Exception e1) {
                        log.error("Can't delete process." + e1.getLocalizedMessage(), (Throwable)e1);
                        message = MessageHelper.getMessage((String)"Wystapil_blad_podczas_usuwania_procesow");
                        request.setAttribute("auditDeleteSuccess", (Object)false);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("Exception:" + e.getLocalizedMessage());
            message = MessageHelper.getMessage((String)"Wystapil_blad_podczas_usuwania_procesow");
            request.setAttribute("auditDeleteSuccess", (Object)false);
        }
        session.setAttribute("processaction", (Object)messageType);
        session.setAttribute("message", (Object)message);
        AdvanceProcessSearchAction advanceProcessSearchAction = new AdvanceProcessSearchAction();
        return advanceProcessSearchAction.execute(mapping, form, request, response);
    }

    private Map<String, Object> buildDeleteProcessAuditParams(String processId, String processDefinitionId, HttpServletRequest request, String operationSource) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        try {
            WfProcess wfProcess = SharkUtils.getExecutionAdministration().getProcess(processId);
            String processName = wfProcess.name();
            String packageId = XpdlPackageManager.getInstance().getPackageIdByProcessDefinitionId(processDefinitionId);
            params.put("processId", processId);
            params.put("package_name", packageId);
            params.put("process_name", processName);
            params.put("processDefId", processDefinitionId);
            params.put("operation_source", operationSource);
            params.put("is_group_operation", "Tak");
        }
        catch (BaseException e) {
            log.error("B\u0142\u0105d podczas pobierania informacji o procesie: " + processId + "  " + e.getLocalizedMessage());
        }
        catch (NotConnected e) {
            log.error("Brak po\u0142\u0105czenia " + e.getMessage());
        }
        return params;
    }

    private void buildDeleteProcessAudit(List<AuditWrapper> audits, Map<String, Object> params, String ip, String userName) {
        AuditWrapper auditWrapper = ManualAuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_PROCESS).success(true).started(new Date()).username(userName).ipAddress(ip).params(params).build();
        audits.add(auditWrapper);
    }
}

