/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.scheduledTasks;

import com.plusmpm.util.json.extjs.gson.GsonFactory;
import com.plusmpm.util.scheduledTasks.logging.TaskMDCBasedAppender;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ScheduledTasksLogsServlet
extends HttpServlet {
    private static Logger logger = Logger.getLogger(ScheduledTasksLogsServlet.class);
    private static final long serialVersionUID = -28382414934646842L;

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        long taskId;
        long historyId;
        logger.info((Object)"Pobieranie log\u00f3w zadania zaplanowanego");
        int start = 0;
        int limit = 0;
        try {
            String limitParam;
            historyId = Long.parseLong(req.getParameter("log"));
            taskId = Long.parseLong(req.getParameter("task"));
            String startParam = req.getParameter("start");
            if (startParam != null) {
                start = Integer.parseInt(startParam);
            }
            if ((limitParam = req.getParameter("limit")) != null) {
                limit = Integer.parseInt(limitParam);
            }
        }
        catch (NumberFormatException e) {
            logger.info((Object)"Podano niepoprawne parametry");
            resp.sendError(400);
            return;
        }
        TaskMDCBasedAppender appender = TaskMDCBasedAppender.getInstance();
        if (appender == null) {
            logger.info((Object)"Logger zada\u0144 zaplanowanych nie jest skonfigurowany");
            resp.sendError(400);
            return;
        }
        File log = appender.getLogFile(Long.valueOf(taskId), Long.valueOf(historyId));
        if (log == null) {
            logger.info((Object)("Nie znaleziono pliku log\u00f3w dla podanego historyId (" + historyId + ")"));
            resp.sendError(404);
            return;
        }
        logger.info((Object)("Odczytuj\u0119 zawarto\u015b\u0107 pliku: " + log.getAbsolutePath()));
        try {
            LogFileWrapper logFile = this.readFile(log, start, limit);
            String json = GsonFactory.getGson().toJson((Object)logFile);
            resp.setContentLength(json.getBytes("UTF-8").length);
            resp.getWriter().write(json);
        }
        catch (Exception e) {
            logger.error((Object)"B\u0142\u0105d podczas odczytywania pliku log\u00f3w zadania zaplanowanego", (Throwable)e);
            resp.sendError(500);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogFileWrapper readFile(File log, int startLine, int linesLimit) throws IOException {
        StringBuffer content = new StringBuffer();
        BufferedReader input = new BufferedReader(new FileReader(log));
        int readedLines = 0;
        int validLines = 0;
        String line = null;
        try {
            while ((line = input.readLine()) != null) {
                if (++readedLines < startLine || validLines >= linesLimit) continue;
                content.append(line).append('\n');
                ++validLines;
            }
            LogFileWrapper logFileWrapper = new LogFileWrapper(content.toString(), readedLines, validLines);
            return logFileWrapper;
        }
        finally {
            input.close();
        }
    }

    class LogFileWrapper {
        private int totalLines;
        private int lines;
        private String content;

        public LogFileWrapper() {
        }

        public LogFileWrapper(String content, int total, int lines) {
            this.content = content;
            this.totalLines = total;
            this.lines = lines;
        }

        public int getTotalLines() {
            return this.totalLines;
        }

        public String getContent() {
            return this.content;
        }

        public int getLines() {
            return this.lines;
        }
    }
}

