/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.packages;

import com.plusmpm.i18n.AbstractI18N;
import com.plusmpm.i18n.I18N;
import com.plusmpm.util.XpdlPackageManager;
import com.plusmpm.util.json.extjs.gson.GsonFactory;
import com.suncode.pwfl.license.exceptions.TooManyProcessesException;
import com.suncode.pwfl.license.exceptions.WrongProcessesException;
import com.suncode.pwfl.workflow.xpdl.XpdlDifferences;
import com.suncode.pwfl.xpdl.exception.XpdlPackageValidationException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfservice.PackageHasActiveProcesses;
import org.enhydra.shark.api.client.wfservice.PackageInUse;
import org.enhydra.shark.api.client.wfservice.PackageInvalid;
import org.enhydra.shark.xpdl.XMLInterface;

public class PackageManagementServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static Logger log = Logger.getLogger(PackageManagementServlet.class);
    private static final int CHAR_LIMIT = 1000000;

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        log.info((Object)"Pobieranie plik\u00f3w xpdl mo\u017cliwych do wgrania.");
        File xpdlDir = new File(XpdlPackageManager.XPDL_REPOSITORY_ABSOLUTE_PATH);
        String[] xpdls = xpdlDir.list();
        ArrayList<XpdlFile> files = new ArrayList<XpdlFile>(xpdls.length);
        for (String fileName : xpdls) {
            if (!FilenameUtils.isExtension((String)fileName, (String)"xpdl")) continue;
            files.add(new XpdlFile(fileName));
        }
        HashMap<String, ArrayList<XpdlFile>> result = new HashMap<String, ArrayList<XpdlFile>>();
        result.put("files", files);
        resp.getWriter().write(GsonFactory.getGson().toJson(result));
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        I18N oMessage = new I18N(request);
        XpdlDifferences diff = new XpdlDifferences(oMessage);
        String action = request.getParameter("actionType");
        if (action == null) {
            log.info((Object)"Brak parametru actionType!!!");
            response.setStatus(400);
            return;
        }
        if (action.equalsIgnoreCase("closePackage")) {
            String packageId = request.getParameter("packageId");
            String packageVersion = request.getParameter("packageVersion");
            try {
                XpdlPackageManager.getInstance().closePackage(packageId, packageVersion);
                response.getWriter().write("{success:true}");
                request.setAttribute("auditSuccess", (Object)true);
            }
            catch (PackageHasActiveProcesses e1) {
                String msg = oMessage.getString("Nie_mozna_wyladowac_tego_pakietu") + ". " + oMessage.getString("W_bazie_danych_istnieja_procesy_skojarzone_z_tym_pakietem") + "!";
                response.getWriter().write("{success:false, msg:\"" + msg + "\"}");
            }
            catch (PackageInUse e2) {
                String msg = oMessage.getString("Nie_mozna_wyladowac_tego_pakietu") + ". " + oMessage.getString("Pakiet_jest_aktualnie_uzywany") + "!";
                response.getWriter().write("{success:false, msg:\"" + msg + "\"}");
            }
            catch (Exception e) {
                log.error((Object)("Error closing package [" + packageId + "#" + packageVersion + "]"), (Throwable)e);
                String msg = oMessage.getString("Nie_mozna_wyladowac_tego_pakietu") + ". " + oMessage.getString("Wystapil_nieoczekiwany_blad") + "!";
                response.getWriter().write("{success:false, msg:\"" + msg + "\"}");
            }
        } else if (action.equalsIgnoreCase("updatePackage")) {
            String packageId = request.getParameter("packageId");
            Boolean updateFilledTables = Boolean.valueOf(request.getParameter("updateFilledTables"));
            String newestVersion = XpdlPackageManager.getInstance().getPackage(packageId).getInternalVersion();
            try {
                XpdlPackageManager.getInstance().updatePackage(packageId, updateFilledTables.booleanValue());
                String newVersion = XpdlPackageManager.getInstance().getPackage(packageId).getInternalVersion();
                String errors = diff.getAllXpdlDifferencesHtml(packageId, newestVersion, newVersion, 1000000);
                if (StringUtils.isEmpty((CharSequence)errors)) {
                    response.getWriter().write("{\"success\":true,\"isempty\":true}");
                } else {
                    response.getWriter().write(String.format("{\"success\":true,\"isempty\":false,\"basePackageVersion\":%s,\"newPackageVersion\":%s,\"packageId\":%s,\"errors\":%s}", GsonFactory.getGson().toJson((Object)newestVersion), GsonFactory.getGson().toJson((Object)newVersion), GsonFactory.getGson().toJson((Object)packageId), GsonFactory.getGson().toJson((Object)errors)));
                }
                request.setAttribute("auditSuccess", (Object)true);
            }
            catch (TooManyProcessesException e) {
                String msg = e.getPackageMessageTranslated();
                response.getWriter().write("{success:false, msg:\"" + msg + "\"}");
            }
            catch (WrongProcessesException e) {
                String msg = e.getPackageMessageTranslated();
                response.getWriter().write("{success:false, msg:\"" + msg + "\"}");
            }
            catch (PackageInvalid e) {
                String msg = oMessage.getString("Nie_mozna_odswiezyc_tego_pakietu") + ". " + oMessage.getString("Pakiet_jest_niepoprawny") + "!";
                response.getWriter().write("{success:false, msg:\"" + msg + "\"}");
            }
            catch (XpdlPackageValidationException e) {
                Locale locale = AbstractI18N.getLocale((HttpServletRequest)request);
                String msg = oMessage.getString("xpdl.validation.failure") + "<br>" + e.getTranslatedMessage(locale);
                response.getWriter().write("{success:false, msg:\"" + msg + "\"}");
            }
            catch (Exception e) {
                log.error((Object)("Error updating package [" + packageId + "]"), (Throwable)e);
                String msg = oMessage.getString("Nie_mozna_odswiezyc_tego_pakietu") + ". " + oMessage.getString("Wystapil_nieoczekiwany_blad") + "!";
                response.getWriter().write("{success:false, msg:\"" + msg + "\"}");
            }
        } else if (action.equalsIgnoreCase("packageDifferences")) {
            String secondPackageVersion;
            String firstPackageVersion;
            String packageId = request.getParameter("packageId");
            String errors = diff.getAllXpdlDifferencesHtml(packageId, firstPackageVersion = request.getParameter("firstPackageVersion"), secondPackageVersion = request.getParameter("secondPackageVersion"), 1000000);
            if (StringUtils.isEmpty((CharSequence)errors)) {
                response.getWriter().write("{\"success\":true,\"isempty\":true}");
            } else {
                response.getWriter().write(String.format("{\"success\":true,\"isempty\":false,\"firstver\":%s,\"secondver\":%s,\"packageId\":%s,\"errors\":%s}", GsonFactory.getGson().toJson((Object)firstPackageVersion), GsonFactory.getGson().toJson((Object)secondPackageVersion), GsonFactory.getGson().toJson((Object)packageId), GsonFactory.getGson().toJson((Object)errors)));
            }
        } else if (action.equalsIgnoreCase("packageVersions")) {
            String packageId = request.getParameter("packageId");
            XMLInterface xmlInterface = Shark.getInstance().getAdminInterface().getPackageAdministration().getXMLInterface();
            ArrayList packageVersions = (ArrayList)xmlInterface.getAllPackageVersions(packageId);
            ArrayList<Integer> iPackageVersions = new ArrayList<Integer>();
            for (String packageVersion : packageVersions) {
                iPackageVersions.add(Integer.parseInt(packageVersion));
            }
            Collections.sort(iPackageVersions);
            ArrayList versions = new ArrayList();
            for (int i = 0; i < iPackageVersions.size(); ++i) {
                versions.add(new ArrayList());
                ((ArrayList)versions.get(i)).add(iPackageVersions.get(i));
            }
            response.getWriter().write(String.format("{\"success\":true,\"packageid\":%s,\"versions\":%s}", GsonFactory.getGson().toJson((Object)packageId), GsonFactory.getGson().toJson(versions)));
        } else if (action.equalsIgnoreCase("updatePackageCache")) {
            try {
                Shark.getInstance().getAdminInterface().getPackageAdministration().refreshXPDLCache();
                response.getWriter().write("{success:true}");
            }
            catch (BaseException e) {
                log.error((Object)"Nie uda\u0142o si\u0119 od\u015bwie\u017cy\u0107 cache'u pakiet\u00f3w.", (Throwable)e);
                String msg = oMessage.getString("Nie_udalo_sie_odswiezyc_pamieci_podrecznej_pakietow") + ". " + oMessage.getString("Wystapil_nieoczekiwany_blad") + "!";
                response.getWriter().write("{success:false, msg:\"" + msg + "\"}");
            }
        } else if (action.equalsIgnoreCase("clearPackage")) {
            String packageId = request.getParameter("packageId");
            int count = XpdlPackageManager.getInstance().closeUnusedPackageVersions(packageId);
            response.getWriter().write("{success:true, count:" + count + "}");
            request.setAttribute("auditSuccess", (Object)true);
        } else if (action.equalsIgnoreCase("loadPackage")) {
            String url = request.getParameter("xpdlname");
            if (StringUtils.isEmpty((CharSequence)url)) {
                log.warn((Object)"Brak parametru xpdlname!");
                response.setStatus(400);
            }
            url = XpdlPackageManager.XPDL_REPOSITORY_ABSOLUTE_PATH + File.separator + url;
            try {
                XpdlPackageManager.getInstance().loadPackage(url);
                response.getWriter().write("{success:true}");
                request.setAttribute("auditSuccess", (Object)true);
            }
            catch (TooManyProcessesException e) {
                String msg = e.getPackageMessageTranslated();
                response.getWriter().write("{success:false, msg:\"" + msg + "\"}");
            }
            catch (WrongProcessesException e) {
                String msg = e.getPackageMessageTranslated();
                response.getWriter().write("{success:false, msg:\"" + msg + "\"}");
            }
            catch (PackageInvalid e) {
                String msg = oMessage.getString("Nie_mozna_zaladowac_pakietu") + ". " + oMessage.getString("Pakiet_jest_niepoprawny") + "!";
                response.getWriter().write("{success:false, msg:\"" + msg + "\"}");
            }
            catch (XpdlPackageValidationException e) {
                Locale locale = AbstractI18N.getLocale((HttpServletRequest)request);
                String msg = oMessage.getString("xpdl.validation.failure") + "<br>" + e.getTranslatedMessage(locale);
                response.getWriter().write("{success:false, msg:\"" + msg + "\"}");
            }
            catch (Exception e) {
                log.error((Object)("Error loading package from [" + url + "]"), (Throwable)e);
                String msg = oMessage.getString("Nie_mozna_zaladowac_pakietu") + ". " + oMessage.getString("Wystapil_nieoczekiwany_blad") + "!";
                response.getWriter().write("{success:false, msg:\"" + msg + "\"}");
            }
        } else {
            response.setStatus(400);
        }
    }

    class XpdlFile {
        private String name;

        public XpdlFile() {
        }

        public XpdlFile(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

