/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.authorization;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.DomainTable;
import com.plusmpm.database.notifications.Notification;
import com.plusmpm.i18n.AbstractI18N;
import com.plusmpm.ldap.LdapErrorCodes;
import com.plusmpm.security.WorkflowPrincipal;
import com.plusmpm.security.authentication.AbstractAuthenticator;
import com.plusmpm.security.authentication.AuthenticationInterceptor;
import com.plusmpm.security.authentication.Authenticator;
import com.plusmpm.security.authentication.AuthenticatorFactory;
import com.plusmpm.security.authentication.LdapAuthenticator;
import com.plusmpm.servlet.authorization.UserAuthorizationResponse;
import com.plusmpm.util.notifications.NotificationManager;
import com.plusmpm.util.notifications.NotificationReceiver;
import com.plusmpm.util.notifications.NotificationReceiverType;
import com.suncode.pwfl.administration.user.Domain;
import com.suncode.pwfl.administration.user.DomainService;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.administration.user.UserSettingsService;
import com.suncode.pwfl.administration.user.security.PasswordPolicyProfile;
import com.suncode.pwfl.administration.user.security.captcha.service.CaptchaService;
import com.suncode.pwfl.administration.user.security.service.BlockedUserService;
import com.suncode.pwfl.administration.user.security.service.PasswordPolicyResolverService;
import com.suncode.pwfl.administration.user.security.service.SelfUnblockUserService;
import com.suncode.pwfl.administration.user.security.service.UserPasswordHistoryService;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.license.LicenseVerificator;
import com.suncode.pwfl.license.exceptions.NextSessionNotAllowedException;
import com.suncode.pwfl.security.AuthenticationResult;
import com.suncode.pwfl.transaction.TransactionManagerFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.web.support.UserAgentUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class UserAuthorizationServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(UserAuthorizationServlet.class);
    private static ObjectMapper mapper = new ObjectMapper();
    private static final UserSettingsService userSettingsService = (UserSettingsService)SpringContext.getBean(UserSettingsService.class);

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        UserAuthorizationServlet.writeResponse(response, UserAuthorizationServlet.authorizeUser(request, response, null));
    }

    public static UserAuthorizationResponse authorizeUser(HttpServletRequest request, HttpServletResponse response, AuthenticationResult externalAuthenticationResult) {
        UserPasswordHistoryService passwordHistoryService = (UserPasswordHistoryService)SpringContext.getBean(UserPasswordHistoryService.class);
        UserService userService = ServiceFactory.getUserService();
        CaptchaService captchaService = (CaptchaService)SpringContext.getBean(CaptchaService.class);
        PasswordPolicyResolverService passwordProfileResolver = (PasswordPolicyResolverService)SpringContext.getBean(PasswordPolicyResolverService.class);
        BlockedUserService blockedUserService = (BlockedUserService)SpringContext.getBean(BlockedUserService.class);
        SelfUnblockUserService selfUnblockUserService = (SelfUnblockUserService)SpringContext.getBean(SelfUnblockUserService.class);
        HttpSession session = request.getSession();
        String sessionId = session.getId();
        boolean useExternalAuthentication = externalAuthenticationResult != null;
        String username = useExternalAuthentication ? externalAuthenticationResult.getUserName() : request.getParameter("username");
        String password = request.getParameter("password");
        String domainId = request.getParameter("domainId");
        String captchaId = request.getParameter("captchaId");
        String captcha = request.getParameter("captcha");
        Boolean requireCaptcha = false;
        Boolean isExternalDomain = !StringUtils.isBlank((CharSequence)domainId) && !domainId.equals("plusworkflow");
        String domainName = "";
        if (isExternalDomain.booleanValue()) {
            DomainTable domainTable = UserAuthorizationServlet.getDomainTable(domainId);
            domainName = domainTable.getDomainName();
        }
        String fullUsername = username;
        AbstractAuthenticator.InternalAuthenticationResult authenticationResult = null;
        try {
            String licenseValidationMessage;
            boolean licenseValidationError;
            Locale userLocale;
            WorkflowPrincipal principal;
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            if (useExternalAuthentication) {
                principal = new WorkflowPrincipal(externalAuthenticationResult.getUserName(), UUID.randomUUID().toString());
                domainId = externalAuthenticationResult.getAuthenticator();
            } else if (!isExternalDomain.booleanValue()) {
                principal = new WorkflowPrincipal(username, password);
            } else {
                principal = new WorkflowPrincipal(username, password, domainId, domainName);
                fullUsername = domainName + "/" + fullUsername;
            }
            if (userService.getUser(username, new String[0]) != null && (userLocale = userSettingsService.getUserLocale(username)) != null) {
                LocaleContextHolder.setLocale((Locale)userLocale);
            }
            if ((licenseValidationError = StringUtils.isNotEmpty((CharSequence)(licenseValidationMessage = LicenseVerificator.validateOnLogin()))) && !username.equals("admin")) {
                String msg = MessageHelper.getMessage((String)"Wystapil_problem_z_licencja_systemu") + ". " + MessageHelper.getMessage((String)"Skontaktuj_sie_z_administratorem_systemu") + ".";
                log.warn("Wyst\u0105pi\u0142 problem z licencj\u0105 systemu: {}", (Object)licenseValidationMessage);
                UserAuthorizationServlet.createAudit(request, false, null, domainName, domainId, null);
                return UserAuthorizationResponse.builder().success(false).license(false).msg(msg).build();
            }
            if (!LicenseVerificator.isNextSessionAllowed()) {
                NextSessionNotAllowedException exception = new NextSessionNotAllowedException();
                log.warn("Limit zalogowanych u\u017cytkownik\u00f3w wykorzystany.");
                UserAuthorizationServlet.createAudit(request, false, null, domainName, domainId, null);
                return UserAuthorizationResponse.builder().success(false).license(false).msg(exception.getMessageTranslated()).build();
            }
            log.info("fullUsername: " + fullUsername);
            Authenticator authenticator = AuthenticatorFactory.getAuthenticator((WorkflowPrincipal)principal, (HttpSession)session, (AuthenticationResult)externalAuthenticationResult);
            authenticationResult = useExternalAuthentication ? authenticator.authenticate(externalAuthenticationResult.getUserCreationStrategyDuringAuthentication()) : authenticator.authenticate();
            if (!isExternalDomain.booleanValue()) {
                if (captchaService.requireCaptcha(session)) {
                    log.info("Captcha is required for current session");
                    if (!captchaService.validateCaptcha(captchaId, captcha)) {
                        log.warn("Captcha is invalid");
                        UserAuthorizationServlet.createAudit(request, false, principal, domainName, domainId, authenticationResult.getAuthenticationMethod());
                        return UserAuthorizationResponse.builder().success(false).license(true).incorrectCaptcha(true).requireCaptcha(captchaService.requireCaptcha(session)).build();
                    }
                } else if (captchaService.requireCaptcha(fullUsername) && (StringUtils.isEmpty((CharSequence)captchaId) || !captchaService.validateCaptcha(captchaId, captcha))) {
                    log.info("Captcha is required for {}", (Object)fullUsername);
                    UserAuthorizationServlet.createAudit(request, false, principal, domainName, domainId, authenticationResult.getAuthenticationMethod());
                    return UserAuthorizationResponse.builder().success(false).license(true).incorrectCaptcha(false).requireCaptcha(captchaService.requireCaptcha(fullUsername)).build();
                }
            }
            if (authenticationResult.userExists()) {
                User user = userService.getUser(authenticationResult.getUser().getUserName(), new String[]{"groups"});
                if (authenticationResult.getAuthenticationMethod() != AuthenticationInterceptor.LoginType.SSO && user.isOnlySsoLogin()) {
                    log.error("User " + user.getUserName() + " can only log in using SSO login");
                    UserAuthorizationServlet.createAudit(request, false, principal, domainName, domainId, authenticationResult.getAuthenticationMethod());
                    return UserAuthorizationResponse.builder().success(false).build();
                }
                if (!isExternalDomain.booleanValue()) {
                    Optional optionalProfile = Optional.empty();
                    if (authenticationResult.getAuthenticationMethod() != AuthenticationInterceptor.LoginType.SSO && authenticationResult.getAuthenticationMethod() != AuthenticationInterceptor.LoginType.UNIVERSAL_PASSWORD && authenticationResult.getAuthenticationMethod() != AuthenticationInterceptor.LoginType.AUTOLOGIN) {
                        optionalProfile = passwordProfileResolver.getForUser(user);
                    }
                    log.info("Checking if user {} is blocked", (Object)fullUsername);
                    if (blockedUserService.isUserBlocked(user)) {
                        log.warn("User {} is blocked", (Object)fullUsername);
                        if (optionalProfile.isPresent() && (((PasswordPolicyProfile)optionalProfile.get()).getSendUnblockingEmail().booleanValue() || username.equals("admin"))) {
                            new Thread(() -> {
                                try {
                                    selfUnblockUserService.sendSelfUnblockEmail(user);
                                }
                                catch (Exception ex) {
                                    log.error("Error while sending self unblock email to user " + username, (Throwable)ex);
                                }
                            }).start();
                        }
                        UserAuthorizationServlet.createAudit(request, false, principal, domainName, domainId, authenticationResult.getAuthenticationMethod());
                        return UserAuthorizationResponse.builder().success(false).license(true).userBlocked(true).requireCaptcha(captchaService.requireCaptcha(session) || captchaService.requireCaptcha(user.getUserName())).build();
                    }
                    if (optionalProfile.isPresent()) {
                        PasswordPolicyProfile passwordProfile = (PasswordPolicyProfile)optionalProfile.get();
                        if (user.getPassword().equals(userService.hashPassword(password))) {
                            if (passwordProfile.getForcePassChange().booleanValue() && !passwordHistoryService.findLast(user.getObjectId()).isPresent()) {
                                log.info("First logging in for user {} and parameter 'force password change for first login' = true ", (Object)fullUsername);
                                UserAuthorizationServlet.createAudit(request, false, principal, domainName, domainId, authenticationResult.getAuthenticationMethod());
                                session.setAttribute("changePasswordUser", (Object)user.getUserName());
                                return UserAuthorizationResponse.builder().success(false).license(true).passwordChangeRequired(true).requireCaptcha(captchaService.requireCaptcha(session) || captchaService.requireCaptcha(user.getUserName())).build();
                            }
                            log.info("Checking requirements with current password for user {}", (Object)fullUsername);
                            try {
                                passwordProfileResolver.validatePasswordFulfillingRequirements(passwordProfile, password);
                            }
                            catch (IllegalArgumentException ex) {
                                log.warn("Current password for user {} is not fulfilling password profile requirements", (Object)fullUsername);
                                session.setAttribute("changePasswordUser", (Object)user.getUserName());
                                UserAuthorizationServlet.createAudit(request, false, principal, domainName, domainId, authenticationResult.getAuthenticationMethod());
                                return UserAuthorizationResponse.builder().success(false).license(true).weakPassword(true).requireCaptcha(captchaService.requireCaptcha(session) || captchaService.requireCaptcha(user.getUserName())).build();
                            }
                        }
                        log.info("Checking password expiration for user {}", (Object)fullUsername);
                        if (passwordHistoryService.hasExpiredPassword(passwordProfile, user)) {
                            log.warn("User {} has expired password", (Object)username);
                            session.setAttribute("changePasswordUser", (Object)fullUsername);
                            UserAuthorizationServlet.createAudit(request, false, principal, domainName, domainId, authenticationResult.getAuthenticationMethod());
                            return UserAuthorizationResponse.builder().success(false).license(true).expiredPassword(true).requireCaptcha(captchaService.requireCaptcha(session) || captchaService.requireCaptcha(user.getUserName())).build();
                        }
                    }
                }
                if (authenticationResult.authenticated()) {
                    UserAuthorizationResponse resp;
                    blockedUserService.invalidateFailedLogins(user.getUserName());
                    captchaService.invalidateFailedLogins(sessionId, user.getUserName());
                    if (licenseValidationError && username.equals("admin")) {
                        resp = UserAuthorizationResponse.builder().success(true).license(false).msg(licenseValidationMessage).build();
                    } else {
                        UserAuthorizationResponse.UserAuthorizationResponseBuilder userAuthorizationResponseBuilder = UserAuthorizationResponse.builder().success(true).license(true);
                        if (UserAuthorizationServlet.isLoginThroughLdap(authenticator) && UserAuthorizationServlet.willLdapPasswordExpireSoon(authenticator) && UserAuthorizationServlet.isLdapOverSsl(domainId)) {
                            userAuthorizationResponseBuilder.ldapError(LdapErrorCodes.LDAP_PASSWORD_EXPIRES_SOON.name());
                        }
                        resp = userAuthorizationResponseBuilder.build();
                    }
                    session = authenticationResult.registrateInSession();
                    if (authenticationResult.getAuthenticationMethod() == AuthenticationInterceptor.LoginType.SSO) {
                        session.setAttribute("ssoProvider", (Object)externalAuthenticationResult.getAuthenticator());
                    }
                    log.info("Uwierzytelnienie u\u017cytkownika: " + username + " w domenie: " + domainId + " powiod\u0142o si\u0119.");
                    try {
                        UserAuthorizationServlet.processLocaleForNewUser(user.getUserName(), AbstractI18N.getFromBrowserSettings((HttpServletRequest)request));
                    }
                    catch (Exception ex) {
                        log.error("Nie mo\u017cna ustawi\u0107 j\u0119zyka u\u017cytkownikowi: " + fullUsername, (Throwable)ex);
                    }
                    UserAuthorizationServlet.createAudit(request, true, principal, domainName, domainId, authenticationResult.getAuthenticationMethod());
                    return resp;
                }
                if (!isExternalDomain.booleanValue()) {
                    blockedUserService.registerFailedLoginAttempt(user.getUserName());
                    captchaService.registerFailedLoginAttempt(sessionId, user.getUserName());
                    requireCaptcha = captchaService.requireCaptcha(session) || captchaService.requireCaptcha(user.getUserName());
                }
            } else {
                captchaService.registerFailedLoginAttempt(sessionId);
                log.warn("User {} not found", (Object)fullUsername);
            }
            HashMap<String, Object> ldapError = new HashMap<String, Object>();
            UserAuthorizationResponse authResponse = UserAuthorizationServlet.buildUserAuthorizationResponse(authenticator, requireCaptcha, ldapError).build();
            log.warn("Uwierzytelnienie u\u017cytkownika: " + username + " w domenie: " + domainId + " nie powiod\u0142o si\u0119.");
            UserAuthorizationServlet.createAudit(request, false, principal, domainName, domainId, ldapError, authenticationResult.getAuthenticationMethod());
            return authResponse;
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            UserAuthorizationServlet.createAudit(request, false, null, domainName, domainId, null);
            if (authenticationResult != null) {
                authenticationResult.invalidateInSession();
            }
            return UserAuthorizationResponse.builder().success(false).requireCaptcha(captchaService.requireCaptcha(session)).build();
        }
    }

    private static void createAudit(HttpServletRequest request, boolean success, WorkflowPrincipal principal, String domainName, String domainId, AuthenticationInterceptor.LoginType loginType) {
        UserAuthorizationServlet.createAudit(request, success, principal, domainName, domainId, null, loginType);
    }

    private static void createAudit(HttpServletRequest request, boolean success, WorkflowPrincipal principal, String domainName, String domainId, Map<String, Object> ldapError, AuthenticationInterceptor.LoginType loginType) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        String userName = UserAuthorizationServlet.getAuditUserId(request, principal, domainName);
        params.put("username", userName);
        params.put("domainId", domainId == null ? "" : domainId);
        params.putAll(UserAgentUtils.resolveUserAgentAuditParams(request));
        if (ldapError != null && !ldapError.isEmpty()) {
            params.put("error_code", ldapError.get("errorCode"));
            params.put("error_message", ldapError.get("rawErrorMessage"));
            params.put("error_explanation", ldapError.get("errorExplanation"));
        }
        request.setAttribute("audit", (Object)ManualAuditBuilder.getInstance().username(userName).type(UserAuthorizationServlet.getAuditType(loginType)).success(success).params(params).build());
    }

    private static AuditTypes getAuditType(AuthenticationInterceptor.LoginType loginType) {
        if (loginType == null) {
            return AuditTypes.AUDIT_LOG_IN;
        }
        if (loginType == AuthenticationInterceptor.LoginType.UNIVERSAL_PASSWORD) {
            return AuditTypes.AUDIT_LOG_IN_UNIVERSAL_PASSWORD;
        }
        if (loginType == AuthenticationInterceptor.LoginType.SSO || loginType == AuthenticationInterceptor.LoginType.AUTOLOGIN) {
            return AuditTypes.AUDIT_AUTO_LOG_IN;
        }
        return AuditTypes.AUDIT_LOG_IN;
    }

    private static String getAuditUserId(HttpServletRequest request, WorkflowPrincipal principal, String domainName) {
        String userName = request.getParameter("username");
        if (StringUtils.isBlank((CharSequence)userName)) {
            String string = userName = principal == null ? "" : principal.getUsername();
        }
        if (StringUtils.isNotBlank((CharSequence)domainName)) {
            userName = domainName + "/" + userName;
        }
        return userName;
    }

    private static DomainTable getDomainTable(String domain) {
        DBManagement dbManagement = new DBManagement();
        DomainTable domainTable = dbManagement.getDomain(domain);
        return domainTable;
    }

    private static void processLocaleForNewUser(final String username, final Locale browserLocale) {
        TransactionTemplate template = new TransactionTemplate(TransactionManagerFactory.getHibernateTransactionManager());
        template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                if (browserLocale != null && AbstractI18N.isLocaleSupported((Locale)browserLocale) && !UserAuthorizationServlet.hasLanguageSetting(username)) {
                    log.info("Brak ustawie\u0144 j\u0119zyka dla u\u017cytkownika: " + username);
                    UserAuthorizationServlet.setUserLocale(username, browserLocale);
                    UserAuthorizationServlet.notifyUserAboutLanguage(username);
                    log.info("Ustawiono j\u0119zyk \"" + browserLocale.getLanguage() + "\" u\u017cytkownikowi \"" + username + "\"");
                }
            }
        });
    }

    private static boolean hasLanguageSetting(String username) {
        UserSettingsService userSettingsService = ServiceFactory.getUserSettingsService();
        String lang = userSettingsService.getSetting(username, UserSettingsService.UserSetting.LANGUAGE);
        return StringUtils.isNotEmpty((CharSequence)lang);
    }

    private static void setUserLocale(String username, Locale locale) {
        UserSettingsService userSettingsService = ServiceFactory.getUserSettingsService();
        userSettingsService.setUserSetting(username, UserSettingsService.UserSetting.LANGUAGE, locale.getLanguage());
    }

    private static void notifyUserAboutLanguage(String username) {
        Notification notification = new Notification();
        String languageTranslation = MessageHelper.getMessage((String)"languageName");
        notification.setFailure(Boolean.valueOf(false));
        notification.setMessage(MessageHelper.getMessage((String)"newLanguageForUser", (Object[])new Object[]{languageTranslation}));
        notification.setSender("System");
        NotificationReceiver receiver = new NotificationReceiver(NotificationReceiverType.USER, username);
        NotificationManager.add((Notification)notification, (NotificationReceiver)receiver);
    }

    private static UserAuthorizationResponse.UserAuthorizationResponseBuilder buildUserAuthorizationResponse(Authenticator authenticator, Boolean requireCaptcha, Map<String, Object> ldapError) {
        LdapErrorCodes error;
        UserAuthorizationResponse.UserAuthorizationResponseBuilder uasr = UserAuthorizationResponse.builder().success(false).license(true).requireCaptcha(requireCaptcha);
        if (authenticator instanceof LdapAuthenticator && ((LdapAuthenticator)authenticator).getErrorCode() != LdapErrorCodes.UNKNOWN && (error = ((LdapAuthenticator)authenticator).getErrorCode()) != null) {
            String rawErrorMessage = ((LdapAuthenticator)authenticator).getErrorMessage();
            String errorExplnation = MessageHelper.getMessage((String)error.getErrorMessage());
            ldapError.put("errorCode", error.toString());
            ldapError.put("rawErrorMessage", rawErrorMessage.substring(1, rawErrorMessage.length() - 2));
            ldapError.put("errorExplanation", errorExplnation);
            uasr.ldapError(error.name()).msg(MessageHelper.getMessage((String)"Nie_powiodla_sie_autoryzacja_w_serwerze_domenowym") + ". " + MessageHelper.getMessage((String)error.getErrorMessage()) + ".");
        } else {
            uasr.msg(MessageHelper.getMessage((String)"Autoryzacja_zakonczona_niepomyslnie") + ".");
        }
        return uasr;
    }

    private static void writeResponse(HttpServletResponse response, UserAuthorizationResponse responseObject) throws IOException {
        response.getWriter().write(mapper.writeValueAsString((Object)responseObject));
    }

    private static boolean isLoginThroughLdap(Authenticator authenticator) {
        return authenticator instanceof LdapAuthenticator;
    }

    private static boolean willLdapPasswordExpireSoon(Authenticator authenticator) {
        LdapErrorCodes error = ((LdapAuthenticator)authenticator).getErrorCode();
        return error == LdapErrorCodes.LDAP_PASSWORD_EXPIRES_SOON;
    }

    private static boolean isLdapOverSsl(String domainId) {
        Domain domain = ((DomainService)SpringContext.getBean(DomainService.class)).getDomain(Long.valueOf(Long.parseLong(domainId)));
        return domain.isLdapOverSsl() != false || domain.isStartTLS() != false;
    }
}

