/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.services.xfire;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xbean.spring.context.SpringApplicationContext;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.XFireException;
import org.codehaus.xfire.spring.XFireConfigLoader;
import org.codehaus.xfire.transport.http.XFireServlet;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.GenericWebApplicationContext;

public class XFireConfigurableServlet
extends XFireServlet {
    private static final long serialVersionUID = 137186179605122522L;
    private static Log log = LogFactory.getLog(XFireConfigurableServlet.class);
    private static final String CONFIG_FILE = "META-INF/xfire/services.xml";
    private static final String PARAM_CONFIG = "config";
    private ApplicationContext xFireContext;
    private String configPath;

    private String getConfigPath() {
        if (this.configPath == null || this.configPath.length() == 0) {
            return CONFIG_FILE;
        }
        return this.configPath;
    }

    public XFire createXFire() throws ServletException {
        XFire xfire;
        this.configPath = this.getInitParameter(PARAM_CONFIG);
        try {
            xfire = this.loadConfig(this.getConfigPath());
        }
        catch (XFireException e) {
            throw new ServletException((Throwable)e);
        }
        if (xfire == null || xfire.getServiceRegistry() == null || xfire.getServiceRegistry().getServices() == null || xfire.getServiceRegistry().getServices().size() == 0) {
            xfire = super.createXFire();
        }
        return xfire;
    }

    public XFire loadConfig(String configPath) throws XFireException {
        ApplicationContext newCtx;
        XFireConfigLoader loader = new XFireConfigLoader();
        loader.setBasedir(this.getWebappBase());
        log.info((Object)("Loading configuration files relative to " + loader.getBasedir().getAbsolutePath()));
        ServletContext servletCtx = this.getServletContext();
        Object parent = (ApplicationContext)servletCtx.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (parent == null) {
            GenericWebApplicationContextX webCtx = new GenericWebApplicationContextX();
            webCtx.setServletContext(this.getServletContext());
            webCtx.refresh();
            parent = webCtx;
        }
        this.xFireContext = newCtx = loader.loadContext(configPath, parent);
        XFire xfire = (XFire)newCtx.getBean("xfire");
        xfire.setProperty("xfire.home", (Object)this.getWebappBase().getAbsolutePath());
        return xfire;
    }

    public void destroy() {
        log.info((Object)"Destroying XFireConfigurableServlet");
        ServletContext servletCtx = this.getServletContext();
        ApplicationContext appContext = this.xFireContext;
        if (appContext != null && appContext instanceof AbstractApplicationContext) {
            ((AbstractApplicationContext)appContext).close();
        }
        super.destroy();
    }

    public class GenericWebApplicationContextX
    extends GenericWebApplicationContext
    implements SpringApplicationContext {
    }
}

