/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.ui.section;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.suncode.plugin.framework.service.Provides;
import com.suncode.plugin.framework.web.support.Section;
import com.suncode.pwfl.web.util.SessionUtils;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Component;

@Provides
@Component
public class SectionHolder {
    private Cache<String, Section> sections = CacheBuilder.newBuilder().maximumSize(5000L).expireAfterWrite(30L, TimeUnit.MINUTES).build();

    public void save(Section section, String searchId) {
        String key = searchId + "#" + section.getKey();
        this.sections.put((Object)key, (Object)section);
    }

    public void save(Section section) {
        String key = SessionUtils.getLoggedUserName() + "#" + section.getKey();
        this.sections.put((Object)key, (Object)section);
    }

    public <T extends Section> T get(String section, String searchId) {
        String key = searchId + "#" + section;
        Section instance = (Section)this.sections.getIfPresent((Object)key);
        this.sections.invalidate((Object)key);
        return (T)instance;
    }

    public <T extends Section> T get(String section) {
        String key = SessionUtils.getLoggedUserName() + "#" + section;
        Section instance = (Section)this.sections.getIfPresent((Object)key);
        this.sections.invalidate((Object)key);
        return (T)instance;
    }
}

