/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.dto.workflow.search;

import com.plusmpm.util.XpdlPackageManager;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.search.results.AdvanceSearchVariableType;
import com.suncode.pwfl.workflow.variable.VariableTypeResolver;
import com.suncode.pwfl.workflow.variable.type.ExtAttrUtils;
import org.enhydra.shark.xpdl.elements.DataField;
import org.enhydra.shark.xpdl.elements.ExtendedAttributes;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AdvanceSearchVariableTypeResolver {
    private final XpdlPackageManager xpdlPackageManager = XpdlPackageManager.getInstance();
    @Autowired
    private VariableTypeResolver variableTypeResolver;

    public AdvanceSearchVariableType resolveVariableExtendedType(String processDefinitionId, String variableId) {
        WorkflowProcess workflowProcess = this.xpdlPackageManager.getPackageByProcessDefinitionId(processDefinitionId).getWorkflowProcess(processDefinitionId);
        DataField dataField = workflowProcess.getDataField(variableId);
        if (dataField != null && ExtAttrUtils.hasExtAttr((ExtendedAttributes)dataField.getExtendedAttributes(), (String)"EXTYPE", (String)"USERNAME")) {
            return AdvanceSearchVariableType.USER;
        }
        return AdvanceSearchVariableType.NORMAL;
    }

    public boolean isTableVariable(String processDefinitionId, String variableId) {
        WorkflowProcess workflowProcess = this.xpdlPackageManager.getPackageByProcessDefinitionId(processDefinitionId).getWorkflowProcess(processDefinitionId);
        DataField dataField = workflowProcess.getDataField(variableId);
        return dataField != null && ExtAttrUtils.hasExtAttr((ExtendedAttributes)dataField.getExtendedAttributes(), (String)"ARRAY", (String)"true");
    }

    public Type<?> resolveVariableType(String processDefinitionId, String variableId) {
        WorkflowProcess workflowProcess = this.xpdlPackageManager.getPackageByProcessDefinitionId(processDefinitionId).getWorkflowProcess(processDefinitionId);
        DataField dataField = workflowProcess.getDataField(variableId);
        if (dataField == null) {
            return Types.STRING;
        }
        return this.variableTypeResolver.guessType(dataField);
    }
}

