/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.dto.archive;

import com.plusmpm.i18n.I18Nxpdl;
import com.plusmpm.parser.wrapper.XpdlKey;
import com.suncode.pwfl.workflow.process.ProcessType;
import java.beans.ConstructorProperties;

public class ProcessTypeDto {
    private String name;
    private String translatedName;
    private String description;
    private String translatedDescription;
    private String packageId;
    private String processDefId;
    private String abbreviation;
    private String color;

    public static ProcessTypeDto of(ProcessType processType, I18Nxpdl xpdlTranslator) {
        String translatedName = xpdlTranslator.getString(XpdlKey.forPackage((String)processType.getPackageId()).forProcess(processType.getProcessDefId()).getKey());
        String translatedDescription = xpdlTranslator.getString(XpdlKey.forPackage((String)processType.getPackageId()).forProcess(processType.getProcessDefId()).getKeyDesc());
        return ProcessTypeDto.builder().name(processType.getName()).translatedName(translatedName).description(processType.getDescription()).translatedDescription(translatedDescription).packageId(processType.getPackageId()).processDefId(processType.getProcessDefId()).abbreviation(processType.getTranslatedAbbreviation()).color(processType.getIconColor()).build();
    }

    public String getPackageWithProcessDefId() {
        return String.format("%s.%s", this.packageId, this.processDefId);
    }

    @ConstructorProperties(value={"name", "translatedName", "description", "translatedDescription", "packageId", "processDefId", "abbreviation", "color"})
    ProcessTypeDto(String name, String translatedName, String description, String translatedDescription, String packageId, String processDefId, String abbreviation, String color) {
        this.name = name;
        this.translatedName = translatedName;
        this.description = description;
        this.translatedDescription = translatedDescription;
        this.packageId = packageId;
        this.processDefId = processDefId;
        this.abbreviation = abbreviation;
        this.color = color;
    }

    public static ProcessTypeDtoBuilder builder() {
        return new ProcessTypeDtoBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getTranslatedName() {
        return this.translatedName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTranslatedDescription() {
        return this.translatedDescription;
    }

    public String getPackageId() {
        return this.packageId;
    }

    public String getProcessDefId() {
        return this.processDefId;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public String getColor() {
        return this.color;
    }

    public static class ProcessTypeDtoBuilder {
        private String name;
        private String translatedName;
        private String description;
        private String translatedDescription;
        private String packageId;
        private String processDefId;
        private String abbreviation;
        private String color;

        ProcessTypeDtoBuilder() {
        }

        public ProcessTypeDtoBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ProcessTypeDtoBuilder translatedName(String translatedName) {
            this.translatedName = translatedName;
            return this;
        }

        public ProcessTypeDtoBuilder description(String description) {
            this.description = description;
            return this;
        }

        public ProcessTypeDtoBuilder translatedDescription(String translatedDescription) {
            this.translatedDescription = translatedDescription;
            return this;
        }

        public ProcessTypeDtoBuilder packageId(String packageId) {
            this.packageId = packageId;
            return this;
        }

        public ProcessTypeDtoBuilder processDefId(String processDefId) {
            this.processDefId = processDefId;
            return this;
        }

        public ProcessTypeDtoBuilder abbreviation(String abbreviation) {
            this.abbreviation = abbreviation;
            return this;
        }

        public ProcessTypeDtoBuilder color(String color) {
            this.color = color;
            return this;
        }

        public ProcessTypeDto build() {
            return new ProcessTypeDto(this.name, this.translatedName, this.description, this.translatedDescription, this.packageId, this.processDefId, this.abbreviation, this.color);
        }

        public String toString() {
            return "ProcessTypeDto.ProcessTypeDtoBuilder(name=" + this.name + ", translatedName=" + this.translatedName + ", description=" + this.description + ", translatedDescription=" + this.translatedDescription + ", packageId=" + this.packageId + ", processDefId=" + this.processDefId + ", abbreviation=" + this.abbreviation + ", color=" + this.color + ")";
        }
    }
}

