/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.dto.archive;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.database.files.DocumentSearch;
import com.plusmpm.database.files.ExtendedDocumentData;
import com.plusmpm.struts.form.VariableListForm;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.DocumentData;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.Link;
import com.suncode.pwfl.archive.LinkIndex;
import com.suncode.pwfl.archive.LinkService;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.web.dto.archive.DocumentDto;
import com.suncode.pwfl.web.util.SessionUtils;
import java.io.Serializable;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class DocumentFilters {
    private static final Logger log = LoggerFactory.getLogger(DocumentFilters.class);
    private final DocumentClassService documentClassService = ServiceFactory.getDocumentClassService();
    private final FileService fileService = ServiceFactory.getFileService();
    DateTimeFormatter[] formatters = new DateTimeFormatter[]{DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"), DateTimeFormatter.ofPattern("yyyy-MM-dd"), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")};
    private Long documentClassId;
    private Long documentSetId;
    private Map<Long, Object> indexes = Maps.newHashMap();
    private int start = 0;
    private int limit = 100000;
    private String fromDate;
    private String endDate;

    public void validate() {
        Assert.isTrue((this.documentClassId != null || this.documentSetId != null ? 1 : 0) != 0, (String)"Document class or document set must be filled.");
        Assert.isTrue((this.documentClassId == null || this.documentSetId == null ? 1 : 0) != 0, (String)"Cannot be set both document class and document set.");
        if (this.fromDate != null) {
            this.assertDateTimeFormat(this.fromDate);
        }
        if (this.endDate != null) {
            this.assertDateTimeFormat(this.endDate);
        }
    }

    private void assertDateTimeFormat(String dateTime) {
        for (DateTimeFormatter formatter : this.formatters) {
            try {
                formatter.parse(dateTime);
                return;
            }
            catch (Exception exception) {
            }
        }
        throw new IllegalArgumentException(MessageHelper.getMessage((String)"Nieprawidlowy_format_daty") + " - yyyy-MM-dd/yyyy-MM-dd HH:mm/yyyy-MM-dd HH:mm:ss");
    }

    public List<DocumentDto> resolve() throws SQLException {
        this.validate();
        if (this.documentClassId != null) {
            return this.searchInDocumentClass();
        }
        return this.searchInLink();
    }

    public Long resolveCount() throws SQLException {
        this.validate();
        if (this.documentClassId != null) {
            return this.countInDocumentClass();
        }
        return this.countInLink();
    }

    private List<DocumentDto> searchInDocumentClass() throws SQLException {
        DocumentClass documentClass = (DocumentClass)this.documentClassService.get((Serializable)this.documentClassId, new String[]{"indexes"});
        Assert.notNull((Object)documentClass, (String)("Document class with id [" + this.documentClassId + "] doesn't exists."));
        String userName = SessionUtils.getLoggedUserName();
        int rights = Authorization.checkRight((String)RightTreeBuilder.builder().system().archive().docClasses().custom((Object)this.documentClassId).read().build(), (String)userName, (boolean)false, (boolean)false);
        if (rights == -1) {
            log.info("User [" + userName + "] has no read rights to document class: " + this.documentClassId);
            return new ArrayList<DocumentDto>();
        }
        DocumentSearch documentSearch = new DocumentSearch(userName, (long)rights);
        documentSearch.addIndexes(this.prepareIndexes(documentClass));
        documentSearch.addOnlyNewestRestriction();
        documentSearch.addLimitOffset(this.limit, this.start);
        documentSearch.setQueryingDocumentsCount(false);
        documentSearch.addDates(this.fromDate, this.endDate, true);
        ArrayList documents = Lists.newArrayList();
        for (ExtendedDocumentData documentData : documentSearch.list()) {
            documents.add(DocumentDto.fromDocumentClass(documentData, documentClass.getIndexes()));
        }
        return documents;
    }

    private Long countInDocumentClass() throws SQLException {
        DocumentClass documentClass = (DocumentClass)this.documentClassService.get((Serializable)this.documentClassId, new String[]{"indexes"});
        Assert.notNull((Object)documentClass, (String)("Document class with id [" + this.documentClassId + "] doesn't exists."));
        String userName = SessionUtils.getLoggedUserName();
        int rights = Authorization.checkRight((String)RightTreeBuilder.builder().system().archive().docClasses().custom((Object)this.documentClassId).read().build(), (String)userName, (boolean)false, (boolean)false);
        if (rights == -1) {
            log.info("User [" + userName + "] has no read rights to document class: " + this.documentClassId);
            return 0L;
        }
        DocumentSearch documentSearch = new DocumentSearch(userName, (long)rights);
        documentSearch.addIndexes(this.prepareIndexes(documentClass));
        documentSearch.addOnlyNewestRestriction();
        documentSearch.addLimitOffset(this.limit, this.start);
        documentSearch.setQueryingDocuments(false);
        documentSearch.addDates(this.fromDate, this.endDate, true);
        return documentSearch.count();
    }

    private VariableListForm[] prepareIndexes(DocumentClass documentClass) {
        Long documentClassId = documentClass.getId();
        VariableListForm first = new VariableListForm();
        first.setVarName("DocClassId");
        first.setVarValue(documentClassId.toString());
        ArrayList<VariableListForm> indices = new ArrayList<VariableListForm>();
        indices.add(first);
        Map convertedIndexes = this.fileService.convertIndexTypes(this.indexes, documentClassId.longValue());
        for (DocumentClassIndex index : documentClass.getIndexes()) {
            VariableListForm idxEntry = new VariableListForm();
            idxEntry.setVarID(index.getId().toString());
            idxEntry.setVarName(index.getName());
            idxEntry.setVarShow("on");
            idxEntry.setVarType(index.getType().toString());
            Object idxValue = convertedIndexes.get(index.getId());
            if (idxValue != null) {
                if (idxValue instanceof LinkedHashMap) {
                    Object value = ((LinkedHashMap)idxValue).get("from");
                    Object value2 = ((LinkedHashMap)idxValue).get("to");
                    idxEntry.setVarValue(this.formatIndex(value));
                    idxEntry.setVarValue2(this.formatIndex(value2));
                    idxEntry.setSearchMode("range");
                } else {
                    String varValue = this.formatIndex(idxValue);
                    idxEntry.setVarValue(varValue);
                }
            }
            indices.add(idxEntry);
        }
        return indices.toArray(new VariableListForm[indices.size()]);
    }

    private String formatIndex(Object idxValue) {
        if (idxValue == null) {
            return null;
        }
        String varValue = idxValue.toString();
        if (idxValue instanceof Date && !(idxValue instanceof Timestamp)) {
            varValue = new SimpleDateFormat("yyyy-MM-dd").format(idxValue);
        }
        return varValue;
    }

    private List<DocumentDto> searchInLink() throws SQLException {
        Link link = ((LinkService)SpringContext.getBean(LinkService.class)).getLink(this.documentSetId, new String[0]);
        Assert.notNull((Object)link, (String)("Document set with id [" + this.documentSetId + "] doesn't exists."));
        String userName = SessionUtils.getLoggedUserName();
        String rightLevel = RightTreeBuilder.builder().system().archive().links().custom((Object)this.documentSetId).read().build();
        int rights = Authorization.checkRight((String)rightLevel, (String)userName, (boolean)false, (boolean)false);
        if (rights == -1) {
            log.info("User [" + userName + "] has no read rights to document set: " + this.documentSetId);
            return new ArrayList<DocumentDto>();
        }
        DBManagement dbm = new DBManagement();
        List linkIndices = ((LinkService)SpringContext.getBean(LinkService.class)).getLinkIndicesForLink(this.documentSetId);
        ArrayList docs = dbm.SearchLink(this.prepareLinkIndexes(linkIndices), userName, this.fromDate, this.endDate, this.limit, this.start, 0, 0, null, false);
        ArrayList documents = Lists.newArrayList();
        for (DocumentData doc : docs) {
            documents.add(DocumentDto.fromLink(doc, linkIndices));
        }
        return documents;
    }

    private Long countInLink() throws SQLException {
        Link link = ((LinkService)SpringContext.getBean(LinkService.class)).getLink(this.documentSetId, new String[0]);
        Assert.notNull((Object)link, (String)("Document set with id [" + this.documentSetId + "] doesn't exists."));
        String userName = SessionUtils.getLoggedUserName();
        String rightLevel = RightTreeBuilder.builder().system().archive().links().custom((Object)this.documentSetId).read().build();
        int rights = Authorization.checkRight((String)rightLevel, (String)userName, (boolean)false, (boolean)false);
        if (rights == -1) {
            log.info("User [" + userName + "] has no read rights to document set: " + this.documentSetId);
            return 0L;
        }
        DBManagement dbm = new DBManagement();
        List linkIndices = ((LinkService)SpringContext.getBean(LinkService.class)).getLinkIndicesForLink(this.documentSetId);
        CountedResult documentDataCountedResult = dbm.searchLinkCounted(this.prepareLinkIndexes(linkIndices), userName, this.fromDate, this.endDate, 1, 0, 0, 0, null, false, true);
        return documentDataCountedResult.getTotal();
    }

    private VariableListForm[] prepareLinkIndexes(List<LinkIndex> indexDefinitions) {
        VariableListForm first = new VariableListForm();
        first.setVarName("linkId");
        first.setVarValue(this.documentSetId.toString());
        ArrayList<VariableListForm> idx = new ArrayList<VariableListForm>();
        idx.add(first);
        for (LinkIndex index : indexDefinitions) {
            VariableListForm idxEntry = new VariableListForm();
            idxEntry.setVarID(index.getId().toString());
            idxEntry.setVarName(index.getId().toString());
            idxEntry.setVarShow("on");
            idxEntry.setVarType(index.getType());
            Object idxValue = this.indexes.get(index.getId());
            if (idxValue != null) {
                if (idxValue instanceof LinkedHashMap) {
                    Object value = ((LinkedHashMap)idxValue).get("from");
                    Object value2 = ((LinkedHashMap)idxValue).get("to");
                    idxEntry.setVarValue(this.formatIndex(value));
                    idxEntry.setVarValue2(this.formatIndex(value2));
                    idxEntry.setSearchMode("range");
                } else {
                    idxEntry.setVarValue(this.formatIndex(idxValue));
                }
            }
            idx.add(idxEntry);
        }
        return idx.toArray(new VariableListForm[idx.size()]);
    }

    public void setStart(int start) {
        this.start = Math.max(start, 0);
    }

    public void setLimit(int limit) {
        this.limit = Math.min(Math.max(1, limit), 100000);
    }

    public Long getDocumentClassId() {
        return this.documentClassId;
    }

    public void setDocumentClassId(Long documentClassId) {
        this.documentClassId = documentClassId;
    }

    public Long getDocumentSetId() {
        return this.documentSetId;
    }

    public void setDocumentSetId(Long documentSetId) {
        this.documentSetId = documentSetId;
    }

    public Map<Long, Object> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(Map<Long, Object> indexes) {
        this.indexes = indexes;
    }

    public int getStart() {
        return this.start;
    }

    public int getLimit() {
        return this.limit;
    }

    public String getFromDate() {
        return this.fromDate;
    }

    public String getEndDate() {
        return this.endDate;
    }
}

