/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.search.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.suncode.pwfl.web.controller.api.workflow.search.cache.SearchResultMeta;
import com.suncode.pwfl.web.controller.api.workflow.search.cache.exception.SearchCriteriaNotCachedException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SearchResultMetaCache {
    private static final Logger log = LoggerFactory.getLogger(SearchResultMetaCache.class);
    private final Cache<String, Set<SearchResultMeta>> searchResultMetaCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build();

    public void cache(String searchId, Set<SearchResultMeta> searchResultMetas) {
        this.searchResultMetaCache.put((Object)searchId, searchResultMetas);
    }

    public Set<String> getCachedProcesses(String searchId) throws SearchCriteriaNotCachedException {
        Set searchResultMetas = (Set)this.searchResultMetaCache.getIfPresent((Object)searchId);
        this.validateSearchCriteriaCached(searchResultMetas, searchId);
        return searchResultMetas.stream().map(SearchResultMeta::getProcessId).collect(Collectors.toSet());
    }

    public Set<String> getCachedActivities(String searchId) throws SearchCriteriaNotCachedException {
        Set searchResultMetas = (Set)this.searchResultMetaCache.getIfPresent((Object)searchId);
        this.validateSearchCriteriaCached(searchResultMetas, searchId);
        return searchResultMetas.stream().map(SearchResultMeta::getActivityId).collect(Collectors.toSet());
    }

    public Set<SearchResultMeta> getCachedSearchMeta(String searchId) throws SearchCriteriaNotCachedException {
        Set searchResultMetas = (Set)this.searchResultMetaCache.getIfPresent((Object)searchId);
        this.validateSearchCriteriaCached(searchResultMetas, searchId);
        return searchResultMetas;
    }

    public void removeFromCache(String searchId) {
        this.searchResultMetaCache.invalidate((Object)searchId);
    }

    private void validateSearchCriteriaCached(Set<SearchResultMeta> searchResultMetas, String searchId) {
        if (searchResultMetas == null) {
            log.info("Nie znaleziono w cache wpisu dla searchId: " + searchId);
            throw new SearchCriteriaNotCachedException();
        }
    }
}

