/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.security;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.plusmpm.security.authentication.AuthenticationInterceptor;
import com.plusmpm.servlet.authorization.UserAuthorizationResponse;
import com.plusmpm.servlet.authorization.UserAuthorizationServlet;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.security.AuthenticationResult;
import com.suncode.pwfl.security.Authenticator;
import com.suncode.pwfl.security.AuthenticatorRegistry;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class AutoLoginController {
    private static final Logger log = LoggerFactory.getLogger(AutoLoginController.class);
    private final String AUTHENTICATOR_ID = "autologin";
    private final String FAILED_LOGIN_REDIRECT_PATH = "/LoginManual.do";
    private final ObjectMapper objectMapper = new ObjectMapper();
    @Autowired
    private AuthenticatorRegistry authenticatorRegistry;
    @Autowired
    private MessageHelperBean messageHelperBean;

    @RequestMapping(value={"autoLogin"}, method={RequestMethod.GET})
    public ResponseEntity<Void> autoLogin(@RequestParam String token, @RequestParam String configId, HttpServletRequest request, HttpServletResponse response) {
        UserAuthorizationResponse authorizationResponse;
        Authenticator autoLoginAuthenticator = this.authenticatorRegistry.getAuthenticator("autologin");
        if (autoLoginAuthenticator == null) {
            log.warn("Auto login authenticator not found in registry");
            this.redirect(response, request, false);
            return new ResponseEntity(HttpStatus.UNAUTHORIZED);
        }
        request.setAttribute("token", (Object)token);
        request.setAttribute("configId", (Object)configId);
        try {
            AuthenticationResult authenticationResult = autoLoginAuthenticator.authenticate(request);
            authenticationResult.setAuthenticator(AuthenticationInterceptor.LoginType.AUTOLOGIN.toString());
            authorizationResponse = UserAuthorizationServlet.authorizeUser(request, response, authenticationResult);
        }
        catch (Exception e) {
            log.warn("Auto login authentication failed", (Throwable)e);
            this.redirect(response, request, false);
            return new ResponseEntity(HttpStatus.UNAUTHORIZED);
        }
        if (!authorizationResponse.getSuccess().booleanValue()) {
            log.warn("Auto login authorization failed");
            this.redirect(response, request, false);
            return new ResponseEntity(HttpStatus.UNAUTHORIZED);
        }
        this.redirect(response, request, true);
        return new ResponseEntity(HttpStatus.OK);
    }

    private void redirect(HttpServletResponse response, HttpServletRequest request, boolean success) {
        try {
            String redirectUrl = "/LoginManual.do";
            if (!success) {
                redirectUrl = "/LoginManual.do";
                this.invalidateSessionAndShowErrorMessage(request);
            }
            request.setAttribute("redirectUrl", (Object)redirectUrl);
            request.getRequestDispatcher("/Login.do").forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            log.warn("Could not redirect after auto login", (Throwable)e);
        }
    }

    private void invalidateSessionAndShowErrorMessage(HttpServletRequest request) throws JsonProcessingException {
        UserAuthorizationResponse failedAuthorization = UserAuthorizationResponse.builder().success(false).msg(this.messageHelperBean.getMessage("Autologowanie_nieudane")).build();
        request.setAttribute("externalAuthorizationResult", (Object)this.objectMapper.writeValueAsString((Object)failedAuthorization));
        request.getSession(false).invalidate();
    }
}

