/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.security;

import com.plusmpm.security.authentication.AuthenticationInterceptor;
import com.suncode.pwfl.administration.user.Domain;
import com.suncode.pwfl.administration.user.DomainService;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.web.controller.api.security.DeviceInfo;
import com.suncode.pwfl.web.dto.authentication.DomainDto;
import com.suncode.pwfl.web.exception.TranslatedException;
import com.suncode.pwfl.web.security.UserAuthorization;
import com.suncode.pwfl.web.security.UserAuthorizationResult;
import com.suncode.pwfl.web.security.exception.UserAuthorizationException;
import com.suncode.pwfl.web.support.UserLocaleResolver;
import com.suncode.pwfl.web.util.JsonMessage;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/authentication"})
public class AuthenticationController {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationController.class);
    @Autowired
    private DomainService domainService;
    @Autowired
    private UserAuthorization userAuthorization;
    @Autowired
    private UserLocaleResolver resolver;
    @Autowired
    private UserService userService;

    @RequestMapping(value={"logout"})
    @ResponseBody
    public JsonMessage logout(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        session.invalidate();
        return new JsonMessage();
    }

    @RequestMapping(value={"domains"}, method={RequestMethod.GET})
    @ResponseBody
    public List<DomainDto> getDomainList() {
        List domains = this.domainService.getDomainList();
        DomainDto defaultDomain = new DomainDto("PlusWorkflow");
        ArrayList<DomainDto> domainsDto = new ArrayList<DomainDto>();
        domainsDto.add(defaultDomain);
        for (Domain domain : domains) {
            domainsDto.add(new DomainDto(domain));
        }
        return domainsDto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"login"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String login(@RequestParam String userName, @RequestParam String password, @RequestParam(required=false) Long domainId, @RequestParam(required=false) String language, DeviceInfo deviceInfo, HttpServletRequest request, HttpServletResponse response) {
        String string;
        String msg;
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("username", userName);
        if (domainId != null) {
            parameters.put("domainId", domainId.toString());
        }
        parameters.putAll(this.collectDeviceInfoParams(deviceInfo));
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_LOG_IN_API).success(true);
        String operatingSystem = deviceInfo != null ? deviceInfo.getOperatingSystem() : "";
        boolean isMobile = "Android".equalsIgnoreCase(operatingSystem) || "IOS".equalsIgnoreCase(operatingSystem);
        try {
            UserAuthorizationResult authorizationResult = this.userAuthorization.authorizeUserWithMetaResult(userName, password, domainId, request.getSession(), true, isMobile);
            String userId = authorizationResult.getUserId();
            User user = this.userService.getUser(userId, new String[0]);
            if (user.isOnlySsoLogin()) {
                response.setStatus(403);
                String msg2 = "User " + userName + " can only log in using SSO login";
                log.error(msg2);
                auditBuilder.success(false);
                String string2 = msg2;
                return string2;
            }
            this.setLocale(request, language);
            if (authorizationResult.getLoginType() == AuthenticationInterceptor.LoginType.UNIVERSAL_PASSWORD) {
                auditBuilder.type(AuditTypes.AUDIT_LOG_IN_API_UNIVERSAL_PASSWORD);
            }
            String string3 = userId;
            return string3;
        }
        catch (TranslatedException e) {
            response.setStatus(403);
            msg = e.getMessageTranslated();
            log.warn(msg);
            auditBuilder = auditBuilder.success(false);
            string = msg;
            return string;
        }
        catch (UserAuthorizationException e) {
            response.setStatus(403);
            msg = e.getLocalizedMessage();
            log.warn(msg);
            auditBuilder = auditBuilder.success(false);
            if (e.getLoginType() == AuthenticationInterceptor.LoginType.UNIVERSAL_PASSWORD) {
                auditBuilder.type(AuditTypes.AUDIT_LOG_IN_API_UNIVERSAL_PASSWORD);
            }
            string = msg;
            return string;
        }
        finally {
            request.setAttribute("audit", (Object)auditBuilder.params(parameters).build());
        }
    }

    private Map<String, String> collectDeviceInfoParams(DeviceInfo deviceInfo) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (deviceInfo != null) {
            params.put("operatingSystem", deviceInfo.getOperatingSystem());
            params.put("deviceModel", deviceInfo.getModel());
            params.put("operatingSystemVersion", deviceInfo.getOperatingSystemVersion());
            params.put("deviceManufacturer", deviceInfo.getManufacturer());
            params.put("deviceFingerprint", deviceInfo.getFingerprint());
            params.put("deviceId", deviceInfo.getDeviceId());
            params.put("internalSystemVersion", deviceInfo.getInternalSystemVersion());
            params.put("appVersion", deviceInfo.getAppVersion());
        }
        return params.entrySet().stream().filter(entry -> StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private void setLocale(HttpServletRequest request, String language) {
        if (StringUtils.isBlank((CharSequence)language)) {
            return;
        }
        this.resolver.setLocale(request, null, new Locale(language));
    }

    @RequestMapping(value={"login/redirect"})
    public ResponseEntity<?> rewriteCookie(@RequestParam String userName, @RequestParam String password, @RequestParam(required=false) Long domainId, @RequestParam(required=false) String language, @RequestParam(value="redirect") String redirectUrl, HttpServletRequest request, HttpServletResponse response) throws URISyntaxException {
        try {
            this.userAuthorization.authorizeUser(userName, password, domainId, request.getSession(), true);
            this.setLocale(request, language);
        }
        catch (TranslatedException e) {
            response.setStatus(403);
            String msg = e.getMessageTranslated();
            log.warn(msg);
        }
        catch (UserAuthorizationException e) {
            response.setStatus(403);
            String msg = e.getLocalizedMessage();
            log.warn(msg);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(new URI(redirectUrl));
        return new ResponseEntity((MultiValueMap)headers, HttpStatus.SEE_OTHER);
    }
}

