/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.scheduledtasks.dto;

import java.util.Arrays;
import java.util.Comparator;

public enum PeriodUnit {
    MINUTES("minute", 60000L),
    HOURS("hour", 60L * MINUTES.getUnitPeriodMilliseconds()),
    DAYS("day", 24L * HOURS.getUnitPeriodMilliseconds()),
    MONTHS("month", 30L * DAYS.getUnitPeriodMilliseconds());

    private static final PeriodUnit[] VALUES;
    private final String unitName;
    private final long unitPeriodMilliseconds;

    private PeriodUnit(String unit, long milliseconds) {
        this.unitName = unit;
        this.unitPeriodMilliseconds = milliseconds;
    }

    public static PeriodUnit estimateUnit(long milliseconds) {
        return Arrays.stream(VALUES).sorted(Comparator.reverseOrder()).filter(unit -> milliseconds % unit.getUnitPeriodMilliseconds() == 0L).findFirst().orElse(MINUTES);
    }

    public String getUnitName() {
        return this.unitName;
    }

    public long getUnitPeriodMilliseconds() {
        return this.unitPeriodMilliseconds;
    }

    static {
        VALUES = PeriodUnit.values();
    }
}

