/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.logs;

import com.google.common.collect.ImmutableMap;
import com.suncode.pwfl.administration.logs.dto.LoggerDto;
import com.suncode.pwfl.administration.logs.service.LoggerService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.database.DBUtils;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.ajax.RestResult;
import java.beans.ConstructorProperties;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/loggers"})
public class LoggerController {
    private final LoggerService loggerService;
    private final AuthorizationHelper authorizationHelper;
    private final MessageHelperBean messageHelper;

    @ResponseBody
    @RequestMapping(value={"configs"}, method={RequestMethod.GET})
    public List<LoggerDto> getLoggersConfigs() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.loggerService.getCurrentLoggersConfigurations();
    }

    @ResponseBody
    @RequestMapping(value={"configs/{loggerName}"}, method={RequestMethod.PATCH})
    public RestResult setLevel(HttpServletRequest request, @PathVariable(value="loggerName") String loggerName, @RequestParam(value="level") String level) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_LOGGER_LEVEL_CHANGED).params(this.setLevelAuditParams(loggerName, level));
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        try {
            this.loggerService.setLoggerLevel(loggerName, level);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new RestResult(true);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @ResponseBody
    @RequestMapping(value={"configs/{loggerName}"}, method={RequestMethod.DELETE})
    public RestResult resetLevel(HttpServletRequest request, @PathVariable(value="loggerName") String loggerName) {
        Map<String, Object> auditParams = this.beforeResetLevelAuditParams(loggerName);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_LOGGER_LEVEL_RESET).params(auditParams);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        try {
            this.loggerService.resetLoggerLevel(loggerName);
            auditBuilder.params(this.afterResetLevelAuditParams(auditParams, loggerName));
            auditBuilder.buildSuccess(request);
            return new RestResult(true);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
    }

    @ResponseBody
    @RequestMapping(value={"configs"}, method={RequestMethod.DELETE})
    public RestResult resetAll(HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ALL_LOGGERS_LEVEL_RESET);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        try {
            this.loggerService.resetAllLoggersLevel();
            auditBuilder.buildSuccess(request);
            return new RestResult(true);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
    }

    private Map<String, Object> setLevelAuditParams(String loggerName, String newLevel) {
        return ImmutableMap.builder().put((Object)"LOGGER_NAME", (Object)loggerName).put((Object)"LOGGER_PREVIOUS_LEVEL", (Object)this.getCurrentLoggerLevelForAudit(loggerName)).put((Object)"LOGGER_NEW_LEVEL", (Object)newLevel).build();
    }

    private Map<String, Object> beforeResetLevelAuditParams(String loggerName) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("LOGGER_NAME", loggerName);
        params.put("LOGGER_PREVIOUS_LEVEL", this.getCurrentLoggerLevelForAudit(loggerName));
        return params;
    }

    private Map<String, Object> afterResetLevelAuditParams(Map<String, Object> params, String loggerName) {
        params.put("LOGGER_NEW_LEVEL", this.getCurrentLoggerLevelForAudit(loggerName));
        return params;
    }

    private String getCurrentLoggerLevelForAudit(String loggerName) {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig(loggerName.equalsIgnoreCase("ROOT") ? "" : loggerName);
        String loggerLevel = loggerConfig.getLevel().toString();
        if (loggerConfig.getName().equals(loggerName)) {
            return loggerLevel;
        }
        return String.format("DEFAULT (%s)", loggerLevel);
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNotFullRightsException(NotFullRightsException e) {
        DBUtils.log.info((Object)this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }

    @ConstructorProperties(value={"loggerService", "authorizationHelper", "messageHelper"})
    @Autowired
    public LoggerController(LoggerService loggerService, AuthorizationHelper authorizationHelper, MessageHelperBean messageHelper) {
        this.loggerService = loggerService;
        this.authorizationHelper = authorizationHelper;
        this.messageHelper = messageHelper;
    }
}

