/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.dashboards;

import com.suncode.plugin.dashboard.web.support.RestError;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.dashboard.support.UserContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;

public abstract class RestSupport {
    @Autowired
    private UserService userService;
    @Autowired
    private UserContext userContext;
    @Autowired
    private MessageSource messageSource;

    protected UserService getUserService() {
        return this.userService;
    }

    protected UserContext getUserContext() {
        return this.userContext;
    }

    protected User getCurrentUser() {
        return this.userContext.getUser();
    }

    protected User getUser(String username) {
        if (StringUtils.hasText((String)username)) {
            User user = this.userService.getUser(username, new String[]{"groups"});
            if (user == null) {
                throw new IllegalArgumentException("User [" + username + "] does not exists");
            }
            return user;
        }
        return this.userContext.getUser();
    }

    protected MessageSource getMessageSource() {
        return this.messageSource;
    }

    protected String getMessage(String code, Object ... arguments) {
        return this.messageSource.getMessage(code, arguments, LocaleContextHolder.getLocale());
    }

    protected void parseErrors(RestError error, BindingResult result) {
        for (FieldError err : result.getFieldErrors()) {
            error.getErrors().put(err.getField(), this.messageSource.getMessage((MessageSourceResolvable)err, LocaleContextHolder.getLocale()));
        }
    }
}

