/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.user.security;

import com.google.common.collect.ImmutableMap;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.administration.user.security.service.BlockedUserService;
import com.suncode.pwfl.administration.user.security.service.SelfUnblockUserService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.ajax.RestResult;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"users"})
public class BlockUserController {
    private static final Logger log = LoggerFactory.getLogger(BlockUserController.class);
    @Autowired
    private SelfUnblockUserService selfUnblockUserService;
    @Autowired
    private BlockedUserService blockedUserService;
    @Autowired
    private UserService userService;
    @Autowired
    private AuthorizationHelper authorizationHelper;
    @Autowired
    private MessageHelperBean messageHelper;

    @RequestMapping(value={"unblock/{token}"})
    public void selfUnblock(@PathVariable(value="token") String token, HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession(false);
        try {
            this.selfUnblockUserService.unblock(token);
            session.setAttribute("message", (Object)MessageHelper.getMessage((String)"Konto_zostalo_odblokowane"));
            session.setAttribute("messageSuccess", (Object)true);
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            session.setAttribute("message", (Object)MessageHelper.getMessage((String)"Konto_nie_zostalo_odblokowane"));
            session.setAttribute("messageSuccess", (Object)false);
        }
        response.sendRedirect(request.getContextPath());
    }

    @Transactional
    @ResponseBody
    @RequestMapping(value={"blocked/{userId}"})
    public Map<String, Boolean> isBlocked(@PathVariable Long userId) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        User user = this.userService.getUser(userId, new String[]{"groups"});
        boolean isBlocked = this.blockedUserService.isUserBlocked(user);
        return ImmutableMap.of((Object)"isBlocked", (Object)isBlocked);
    }

    @Transactional
    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(value={"unblock/{userId}"}, method={RequestMethod.POST})
    public void unblockUser(HttpServletRequest request, @PathVariable Long userId) {
        User user = this.userService.getUser(userId, new String[]{"groups"});
        AuditBuilder builder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UNLOCK_USER_BY_ADMIN).params((Map)ImmutableMap.of((Object)"userId", (Object)user.getUserName()));
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)builder.buildFailure()));
        try {
            boolean isBlocked = this.blockedUserService.isUserBlocked(user);
            if (!isBlocked) {
                throw new RuntimeException("User " + user.getUserName() + " is not blocked");
            }
            this.blockedUserService.unblockUser(user);
            request.setAttribute("audit", (Object)builder.buildSuccess());
        }
        catch (Exception ex) {
            request.setAttribute("audit", (Object)builder.buildFailure());
            throw ex;
        }
    }

    @Transactional
    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(value={"block/{userId}"}, method={RequestMethod.POST})
    public void blockUser(HttpServletRequest request, @PathVariable Long userId) {
        User user = this.userService.getUser(userId, new String[]{"groups"});
        AuditBuilder builder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_BLOCK_USER_BY_ADMIN).params((Map)ImmutableMap.of((Object)"userId", (Object)user.getUserName()));
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)builder.buildFailure()));
        try {
            boolean isBlocked = this.blockedUserService.isUserBlocked(user);
            if (isBlocked) {
                throw new RuntimeException("User " + user.getUserName() + " is already blocked");
            }
            this.blockedUserService.blockUserByAdmin(user);
            request.setAttribute("audit", (Object)builder.buildSuccess());
        }
        catch (Exception ex) {
            request.setAttribute("audit", (Object)builder.buildFailure());
            throw ex;
        }
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNotFullRightsException(NotFullRightsException e) {
        log.info(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }
}

