/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.user;

import com.google.common.collect.ImmutableMap;
import com.plusmpm.ldap.LDAPManager;
import com.suncode.pwfl.administration.user.Domain;
import com.suncode.pwfl.administration.user.DomainService;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.license.LicenseAccessor;
import com.suncode.pwfl.license.exceptions.TooManyUsersException;
import com.suncode.pwfl.web.controller.api.administration.user.ImportLdapUsersDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.support.ajax.RestResult;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"users/ldap"})
public class LdapUserController {
    private static final Logger log = LoggerFactory.getLogger(LdapUserController.class);
    @Autowired
    private DomainService domainService;
    @Autowired
    private UserService userService;
    @Autowired
    private AuthorizationHelper authorizationHelper;

    @ResponseBody
    @RequestMapping(value={"import"}, method={RequestMethod.POST})
    public RestResult importUsersFromLdap(HttpServletRequest request, @RequestBody ImportLdapUsersDto importLdapUsersDto) {
        Assert.notNull((Object)importLdapUsersDto.getDomainId());
        Domain domain = this.domainService.getDomain(importLdapUsersDto.getDomainId());
        AuditBuilder builder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_IMPORT_USER_FROM_LDAP).params((Map)ImmutableMap.of((Object)"domainName", (Object)domain.getDomainName()));
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)builder.buildFailure()));
        String groupNames = MessageHelper.getMessage((String)"Uzytkownicy_domenowi");
        if (importLdapUsersDto.getDefaultGroupNames() != null && importLdapUsersDto.getDefaultGroupNames().size() > 0) {
            groupNames = String.join((CharSequence)";", importLdapUsersDto.getDefaultGroupNames());
        }
        try {
            LDAPManager.addUsersFromLdap((String)domain.getDomainName(), (String)importLdapUsersDto.getDnPath(), (String)importLdapUsersDto.getImportFilter(), (String)groupNames, (boolean)importLdapUsersDto.isAddToDefaultGroup(), (boolean)importLdapUsersDto.isAddToLdapGroup(), (boolean)importLdapUsersDto.isCreateNotExistingGroups(), (boolean)false, (String)"admin", (String)"");
            request.setAttribute("audit", (Object)builder.buildSuccess());
            return new RestResult(true, MessageHelper.getMessage((String)"ldapImport.admin.success"));
        }
        catch (TooManyUsersException ex) {
            request.setAttribute("audit", (Object)builder.buildFailure());
            log.warn("U\u017cytkownicy nie zostali zaimportowani. Licencja systemu nie pozwala na liczb\u0119 u\u017cytkownik\u00f3w powy\u017cej " + LicenseAccessor.getInstance().getMaxUsers());
            return new RestResult(false, MessageHelper.getMessage((String)"Licencja_systemu_nie_pozwala_na_liczbe_uzytkownikow_powyzej") + " " + LicenseAccessor.getInstance().getMaxUsers() + ".");
        }
        catch (Exception ex) {
            request.setAttribute("audit", (Object)builder.buildFailure());
            log.error(ex.getMessage(), (Throwable)ex);
            return new RestResult(false, MessageHelper.getMessage((String)"ldapImport.admin.error"));
        }
    }
}

