/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.processes.documentViews;

import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.database.documentViews.DocumentViewsTable;
import com.plusmpm.database.documentViews.dto.AddDocumentViewsTableDto;
import com.plusmpm.database.documentViews.dto.DocumentViewsTaskDto;
import com.plusmpm.database.documentViews.dto.ReadDocumentViewsTableDto;
import com.plusmpm.database.documentViews.exception.DocumentViewNotFoundException;
import com.plusmpm.util.XpdlPackageManager;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.archive.DocumentViewsService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.util.DtoComparator;
import com.suncode.pwfl.util.Paginator;
import com.suncode.pwfl.web.controller.api.administration.processes.documentViews.DocumentViewsAuditHelper;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NoRightsException;
import com.suncode.pwfl.web.support.DocumentViewsMapper;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.workflow.activity.ActivityTranslationService;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/processes/definition/{procDefId}/document/views"})
public class DocumentViewsController {
    private static final Logger log = LoggerFactory.getLogger(DocumentViewsController.class);
    @Autowired
    private DocumentViewsService documentViewsService;
    @Autowired
    private ExportService exportService;
    @Autowired
    private ProcessService processService;
    @Autowired
    private ActivityTranslationService activityTranslationService;
    @Autowired
    private DocumentViewsMapper documentViewsMapper;
    @Autowired
    private DocumentViewsAuditHelper auditHelper;
    @Autowired
    private AuthorizationHelper authorizationHelper;
    @Autowired
    private MessageHelperBean messageHelper;
    private final String rightsPath = RightTreeBuilder.builder().system().admin().build();
    private final XpdlPackageManager xpdlPackageManager = XpdlPackageManager.getInstance();

    @RequestMapping(method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public RestResult addDocumentView(HttpServletRequest request, @RequestBody AddDocumentViewsTableDto addDocumentViewsTableDto, @PathVariable String procDefId) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_DOCUMENT_VIEW);
        Map<String, Object> addDocumentViewAuditParams = this.auditHelper.createAddDocumentViewAuditParams(addDocumentViewsTableDto);
        auditBuilder.params(addDocumentViewAuditParams);
        this.authorizationHelper.assertFullOrPartRights(this.rightsPath, () -> auditBuilder.buildFailure(request));
        try {
            DocumentViewsTable viewsTable = this.documentViewsMapper.toEntity(addDocumentViewsTableDto);
            viewsTable.setProc_def_id(procDefId);
            long documentViewId = this.documentViewsService.addDocumentView(viewsTable);
            addDocumentViewAuditParams.put("documentViewId", StringUtils.defaultString((String)String.valueOf(documentViewId)));
            auditBuilder.params(addDocumentViewAuditParams);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
        auditBuilder.buildSuccess(request);
        return new RestResult(true);
    }

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<ReadDocumentViewsTableDto> getDocumentViewsByProcessDefId(@PathVariable String procDefId, @RequestParam(required=false, defaultValue="0") Integer start, @RequestParam(required=false, defaultValue="20") Integer limit, @RequestParam(required=false, defaultValue="documentViewName") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        this.authorizationHelper.assertFullOrPartRights(this.rightsPath, () -> {});
        List documentViews = this.documentViewsService.getDocumentViewsByProcessDefId(procDefId).stream().map(this.documentViewsMapper::toDto).sorted((Comparator<ReadDocumentViewsTableDto>)DtoComparator.of(ReadDocumentViewsTableDto.class, (String)sortBy, (SortDirection)sortDirection)).collect(Collectors.toList());
        return Paginator.forAll(documentViews).viewPageByOffset(start, limit);
    }

    @RequestMapping(method={RequestMethod.PATCH}, value={"/{id}"})
    @ResponseBody
    public RestResult changeDocumentView(HttpServletRequest request, @PathVariable String procDefId, @RequestBody AddDocumentViewsTableDto addDocumentViewsTableDto, @PathVariable Long id) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_EDIT_DOCUMENT_VIEW);
        DocumentViewsTable documentView = (DocumentViewsTable)this.documentViewsService.get((Serializable)id);
        if (Objects.isNull(documentView)) {
            throw new DocumentViewNotFoundException(this.messageHelper.getMessage("Widok_o_podanym_id_nie_istnieje"));
        }
        auditBuilder.params(this.auditHelper.createEditDocumentViewAuditParams(addDocumentViewsTableDto, documentView));
        this.authorizationHelper.assertFullOrPartRights(this.rightsPath, () -> auditBuilder.buildFailure(request));
        try {
            addDocumentViewsTableDto.setProcDefId(procDefId);
            DocumentViewsTable documentViewsTable = this.documentViewsMapper.toEntity(addDocumentViewsTableDto);
            documentViewsTable.setId(id);
            this.documentViewsService.changeDocumentView(documentViewsTable);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
        auditBuilder.buildSuccess(request);
        return new RestResult(true);
    }

    @RequestMapping(method={RequestMethod.DELETE})
    @ResponseBody
    public RestResult deleteDocumentViewById(HttpServletRequest request, @RequestParam Long id, @PathVariable String procDefId) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_DOCUMENT_VIEW);
        auditBuilder.params(this.auditHelper.createDeleteDocumentViewAuditParams(id, procDefId));
        this.authorizationHelper.assertFullOrPartRights(this.rightsPath, () -> auditBuilder.buildFailure(request));
        try {
            this.documentViewsService.deleteDocumentViewById(id, procDefId);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
        auditBuilder.buildSuccess(request);
        return new RestResult(true);
    }

    @RequestMapping(value={"export/{extension}"}, method={RequestMethod.GET})
    public void export(HttpServletResponse response, @PathVariable String procDefId, @PathVariable String extension, @RequestParam Boolean isUserDocumentViews, @RequestParam(required=false, defaultValue="documentViewName") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) throws IOException {
        if (!isUserDocumentViews.booleanValue()) {
            this.authorizationHelper.assertFullOrPartRights(this.rightsPath, () -> {});
        }
        List documentViewsTables = isUserDocumentViews != false ? this.documentViewsService.getDocumentViewsByUsername(UserContext.current().getUser().getUserName()) : this.documentViewsService.getDocumentViewsByProcessDefId(procDefId);
        List<ReadDocumentViewsTableDto> readDocumentViewsTableDtos = documentViewsTables.stream().map(this.documentViewsMapper::toDto).sorted((Comparator<ReadDocumentViewsTableDto>)DtoComparator.of(ReadDocumentViewsTableDto.class, (String)sortBy, (SortDirection)sortDirection)).collect(Collectors.toList());
        List<ExportColumn> columns = Arrays.asList(this.buildExportColumn("Nazwa", readDocumentViewsTableDtos, ReadDocumentViewsTableDto::getDocumentViewName), this.buildExportColumn("Opis", readDocumentViewsTableDtos, ReadDocumentViewsTableDto::getDocumentViewDesc), this.buildExportColumn("Proces", readDocumentViewsTableDtos, ReadDocumentViewsTableDto::getProcName), this.buildExportColumn("Zadanie", readDocumentViewsTableDtos, ReadDocumentViewsTableDto::getTaskName), this.buildExportColumn("Uzytkownik", readDocumentViewsTableDtos, ReadDocumentViewsTableDto::getUserName), this.buildExportColumn("Klasa_dokumentow", readDocumentViewsTableDtos, ReadDocumentViewsTableDto::getDocClassName), this.buildExportColumn("Wyswietl_Na", readDocumentViewsTableDtos, readDocumentViewsTableDto -> this.messageHelper.getMessage(readDocumentViewsTableDto.getShowOn())), this.buildExportColumn("Najnowsze", readDocumentViewsTableDtos, readDocumentViewsTableDto -> this.messageHelper.getMessage(readDocumentViewsTableDto.getIsDescending())), this.buildExportColumn("Ilosc", readDocumentViewsTableDtos, ReadDocumentViewsTableDto::getAmount), this.buildExportColumn("Wyrazenie_regularne", readDocumentViewsTableDtos, ReadDocumentViewsTableDto::getRegex));
        this.buildExportColumn("Wyswietl_dokumenty_office365", readDocumentViewsTableDtos, readDocumentViewsTableDto -> this.messageHelper.getMessage(readDocumentViewsTableDto.getDisplayByOffice365()));
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Widoki_dokumentow")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    private ExportColumn buildExportColumn(String name, List<ReadDocumentViewsTableDto> data, Function<ReadDocumentViewsTableDto, String> supplier) {
        return ExportColumnBuilder.create().name(this.messageHelper.getMessage(name)).data(data).by(supplier).build();
    }

    @RequestMapping(value={"tasks"}, method={RequestMethod.GET})
    @ResponseBody
    public List<DocumentViewsTaskDto> getTasksForProcess(@PathVariable String procDefId) {
        String packId = this.xpdlPackageManager.getPackageIdByProcessDefinitionId(procDefId);
        return this.processService.getActivityTypes(procDefId).stream().map(activity -> new DocumentViewsTaskDto(activity.getActivityDefId(), this.activityTranslationService.getActivityTranslationTableByDefinitionIdAndLocale(packId, procDefId, activity.getActivityDefId(), LocaleContextHolder.getLocale().getLanguage()).getName())).sorted(Comparator.comparing(activity -> activity.getText().toLowerCase())).collect(Collectors.toList());
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleIllegalArgumentException(IllegalArgumentException e) {
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={DocumentViewNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    public RestResult handleNotFoundException(Exception e) {
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={NoRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNoRightsException(NoRightsException e) {
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }
}

