/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.plusmpm.util.SharkFunctions;
import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.i18n.MessageHelper;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

public class SendEmailFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(SendEmailFormatter.class);
    private final String processDefIdKey = "processId";
    private final String processIdKey = "processInstanceId";
    private final String processNameKey = "processInstanceName";
    private final String activityIdKey = "activityId";
    private final String activityInstanceIdKey = "activityInstanceId";
    private final String scheduledTaskNameKey = "scheduledTaskName";
    private final String errorMessageKey = "errorMessage";
    private final String recipientKey = "recipient";
    private final String subjectKey = "subject";
    private final String fromKey = "MAIL_SEND_FROM";
    private final String mailSubjectKey = "MAIL_SEND_SUBJECT";
    private final String recipientsKey = "MAIL_SEND_RECIPIENTS";
    private final String copiesKey = "MAIL_SEND_COPIES";
    private final String blindCopiesKey = "MAIL_SEND_BLIND_COPIES";
    private final String emailConfigNameKey = "MAIL_SEND_EMAIL_CONFIG_NAME";
    private final String emailConfigIdKey = "MAIL_SEND_EMAIL_CONFIG_ID";
    private final String mailProcessDefIdKey = "MAIL_SEND_PROCESS_DEF_ID";
    private final String mailProcessIdKey = "MAIL_SEND_PROCESS_ID";
    private final String processInstanceIdKey = "MAIL_SEND_PROCESS_INSTANCE_ID";
    private final String processInstanceNameKey = "MAIL_SEND_PROCESS_INSTANCE_NAME";
    private final String mailActivityIdKey = "MAIL_SEND_ACTIVITY_ID";
    private final String mailActivityInstanceIdKey = "MAIL_SEND_ACTIVITY_INSTANCE_ID";
    private final String mailScheduledTaskNameKey = "MAIL_SEND_SCHEDULED_TASK_NAME";
    private final String bufferKey = "MAIL_SEND_BUFFER";
    private final String attemptKey = "MAIL_SEND_ATTEMPT";
    private final String maxAttemptKey = "MAIL_SEND_MAX_ATTEMPT";

    @Override
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            this.setOldAuditParams(map, formattedMap);
            this.setNewAuditParams(map, formattedMap);
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }

    private void setNewAuditParams(HashMap<String, String> map, LinkedHashMap<String, String> formattedMap) {
        Locale locale = LocaleContextHolder.getLocale();
        String from = map.get("MAIL_SEND_FROM");
        String subject = map.get("MAIL_SEND_SUBJECT");
        String recipients = map.get("MAIL_SEND_RECIPIENTS");
        String copies = map.get("MAIL_SEND_COPIES");
        String blindCopies = map.get("MAIL_SEND_BLIND_COPIES");
        String emailConfigName = map.get("MAIL_SEND_EMAIL_CONFIG_NAME");
        String emailConfigId = map.get("MAIL_SEND_EMAIL_CONFIG_ID");
        String processId = map.get("MAIL_SEND_PROCESS_ID");
        String processDefId = map.get("MAIL_SEND_PROCESS_DEF_ID");
        String processInstanceId = map.get("MAIL_SEND_PROCESS_INSTANCE_ID");
        String processInstanceName = map.get("MAIL_SEND_PROCESS_INSTANCE_NAME");
        String activityId = map.get("MAIL_SEND_ACTIVITY_ID");
        String activityInstanceId = map.get("MAIL_SEND_ACTIVITY_INSTANCE_ID");
        String scheduledTaskName = map.get("MAIL_SEND_SCHEDULED_TASK_NAME");
        String buffer = map.get("MAIL_SEND_BUFFER");
        String attempt = map.get("MAIL_SEND_ATTEMPT");
        String maxAttempt = map.get("MAIL_SEND_MAX_ATTEMPT");
        if (StringUtils.isNotBlank((CharSequence)buffer)) {
            formattedMap.put(AuditParamsNames.MAIL_SEND_FROM.name(), from);
        }
        if (StringUtils.isNotBlank((CharSequence)subject)) {
            formattedMap.put(AuditParamsNames.MAIL_SEND_SUBJECT.name(), subject);
        }
        if (StringUtils.isNotBlank((CharSequence)recipients)) {
            formattedMap.put(AuditParamsNames.MAIL_SEND_RECIPIENTS.name(), recipients);
        }
        if (StringUtils.isNotBlank((CharSequence)copies)) {
            formattedMap.put(AuditParamsNames.MAIL_SEND_COPIES.name(), copies);
        }
        if (StringUtils.isNotBlank((CharSequence)blindCopies)) {
            formattedMap.put(AuditParamsNames.MAIL_SEND_BLIND_COPIES.name(), blindCopies);
        }
        if (StringUtils.isNotBlank((CharSequence)emailConfigName)) {
            formattedMap.put(AuditParamsNames.MAIL_SEND_EMAIL_CONFIG_NAME.name(), emailConfigName);
        }
        if (StringUtils.isNotBlank((CharSequence)emailConfigId)) {
            formattedMap.put(AuditParamsNames.MAIL_SEND_EMAIL_CONFIG_ID.name(), emailConfigId);
        }
        if (StringUtils.isNotBlank((CharSequence)processId)) {
            formattedMap.put(AuditParamsNames.MAIL_SEND_PROCESS_ID.name(), processId);
        }
        if (StringUtils.isNotBlank((CharSequence)processDefId)) {
            formattedMap.put(AuditParamsNames.MAIL_SEND_PROCESS_DEF_ID.name(), processDefId);
        }
        if (StringUtils.isNotBlank((CharSequence)processInstanceId)) {
            formattedMap.put(AuditParamsNames.MAIL_SEND_PROCESS_INSTANCE_ID.name(), processInstanceId);
        }
        if (StringUtils.isNotBlank((CharSequence)processInstanceName)) {
            formattedMap.put(AuditParamsNames.MAIL_SEND_PROCESS_INSTANCE_NAME.name(), processInstanceName);
        }
        if (StringUtils.isNotBlank((CharSequence)activityId)) {
            formattedMap.put(AuditParamsNames.MAIL_SEND_ACTIVITY_ID.name(), activityId);
        }
        if (StringUtils.isNotBlank((CharSequence)activityInstanceId)) {
            formattedMap.put(AuditParamsNames.MAIL_SEND_ACTIVITY_INSTANCE_ID.name(), activityInstanceId);
        }
        if (StringUtils.isNotBlank((CharSequence)scheduledTaskName)) {
            formattedMap.put(AuditParamsNames.MAIL_SEND_SCHEDULED_TASK_NAME.name(), scheduledTaskName);
        }
        if (StringUtils.isNotBlank((CharSequence)buffer)) {
            formattedMap.put(AuditParamsNames.MAIL_SEND_BUFFER.name(), this.translateBooleanValue(buffer, locale));
        }
        if (StringUtils.isNotBlank((CharSequence)attempt)) {
            formattedMap.put(AuditParamsNames.MAIL_SEND_ATTEMPT.name(), attempt);
        }
        if (StringUtils.isNotBlank((CharSequence)maxAttempt)) {
            formattedMap.put(AuditParamsNames.MAIL_SEND_MAX_ATTEMPT.name(), maxAttempt);
        }
    }

    private void setOldAuditParams(HashMap<String, String> map, LinkedHashMap<String, String> formattedMap) {
        if (StringUtils.isNotBlank((CharSequence)map.get("recipient"))) {
            formattedMap.put(AuditParamsNames.RECIPIENT.toString(), map.get("recipient"));
        }
        if (StringUtils.isNotBlank((CharSequence)map.get("subject"))) {
            formattedMap.put(AuditParamsNames.EMAIL_SUBJECT.toString(), map.get("subject"));
        }
        this.putProcessAndActivity(map, formattedMap);
        this.putScheduledTaskName(map, formattedMap);
        this.putErrorMessage(map, formattedMap);
    }

    private void putProcessAndActivity(HashMap<String, String> map, LinkedHashMap<String, String> formattedMap) {
        String activityInstId;
        String processId;
        String processName;
        String processDefId = map.get("processId");
        if (StringUtils.isNotBlank((CharSequence)processDefId)) {
            WorkflowProcess workflowProcess = SharkFunctions.getWorkflowProcessByDefId((String)processDefId);
            formattedMap.put(AuditParamsNames.PROCESS_NAME.toString(), workflowProcess.getName());
            String activityId = map.get("activityId");
            if (StringUtils.isNotBlank((CharSequence)activityId)) {
                formattedMap.put(AuditParamsNames.ACTIVITY_NAME.toString(), workflowProcess.getActivity(activityId).getName());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(processName = map.get("processInstanceName")))) {
            formattedMap.put(AuditParamsNames.PROCESS_NAME.toString(), processName);
        }
        if (StringUtils.isNotBlank((CharSequence)(processId = map.get("processInstanceId")))) {
            formattedMap.put(AuditParamsNames.PROCESS_ID.toString(), processId);
        }
        if (StringUtils.isNotBlank((CharSequence)(activityInstId = map.get("activityInstanceId")))) {
            formattedMap.put(AuditParamsNames.ACTIVITY_ID.toString(), activityInstId);
        }
    }

    private void putScheduledTaskName(HashMap<String, String> map, LinkedHashMap<String, String> formattedMap) {
        String scheduledTaskName = map.get("scheduledTaskName");
        if (StringUtils.isNotBlank((CharSequence)scheduledTaskName)) {
            formattedMap.put(AuditParamsNames.SCHEDULED_TASK_NAME.toString(), MessageHelper.getMessage((String)scheduledTaskName, (Locale)LocaleContextHolder.getLocale(), (Object[])new Object[0]));
        }
    }

    private void putErrorMessage(HashMap<String, String> map, LinkedHashMap<String, String> formattedMap) {
        String errorMessage = map.get("errorMessage");
        if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
            formattedMap.put(AuditParamsNames.ERROR_MESSAGE.toString(), errorMessage);
        }
    }
}

