/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.util.Authorization;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.Link;
import com.suncode.pwfl.archive.LinkIndex;
import com.suncode.pwfl.archive.LinkService;
import com.suncode.pwfl.database.DBUtils;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.web.dto.archive.LinkIndexDto;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ShowIndexesForLinkSearchAction
extends Action {
    public static Logger log = Logger.getLogger(ShowIndexesForLinkSearchAction.class);
    public String m_sLinkId = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        log.info((Object)"******************************ShowIndexesForLinkSearchAction********************");
        HttpSession session = request.getSession(false);
        request.setAttribute("activeTab", (Object)"ShowArchiveViews.do");
        String username = (String)session.getAttribute("username");
        LinkService linkService = ServiceFactory.getLinkService();
        String linkId = request.getParameter("linkId");
        if (linkId == null && this.m_sLinkId != null) {
            linkId = this.m_sLinkId;
        }
        Link link = linkService.getLink(Long.valueOf(linkId), new String[]{"connections", "connections.documentClass"});
        Set<Long> documentClassIds = link.getConnections().stream().map(linkConnection -> linkConnection.getDocumentClass().getId()).collect(Collectors.toSet());
        List<DocClassCheckbox> checkboxes = this.getDocumentClasseCheckboxes(documentClassIds, username);
        int enabledCheckboxes = 0;
        for (DocClassCheckbox docClassCheckbox : checkboxes) {
            if (docClassCheckbox.isDisabled()) continue;
            ++enabledCheckboxes;
        }
        List linkIndices = linkService.getLinkIndicesForLink(Long.valueOf(linkId));
        for (LinkIndex linkIndex : linkIndices) {
            linkIndex.setName(linkService.getLinkIndexTranslation(linkIndex.getId(), TranslatedFieldType.NAME));
            linkIndex.setDescription(linkService.getLinkIndexTranslation(linkIndex.getId(), TranslatedFieldType.DESCRIPTION));
            linkIndex.setLink(link);
        }
        List list = linkIndices.stream().map(LinkIndexDto::from).collect(Collectors.toList());
        request.setAttribute("preventSearch", (Object)(enabledCheckboxes == 0 ? 1 : 0));
        session.setAttribute("alDocClasses", checkboxes);
        request.setAttribute("indexFilters", list);
        request.setAttribute("linkName", (Object)linkService.getLinkTranslation(link.getId(), TranslatedFieldType.NAME));
        request.setAttribute("linkId", (Object)linkId);
        return mapping.findForward("showIndexesForLinkSearch");
    }

    private List<DocClassCheckbox> getDocumentClasseCheckboxes(Set<Long> documentClassIds, String username) {
        DocumentClassService documentClassService = ServiceFactory.getDocumentClassService();
        Connection connection = DBUtils.connectToDB();
        try {
            ArrayList<DocClassCheckbox> checkboxes = new ArrayList<DocClassCheckbox>();
            for (Long id : documentClassIds) {
                DocumentClass docClass = (DocumentClass)documentClassService.get((Serializable)id);
                docClass.setName(documentClassService.getDocumentClassTranslation(docClass.getId(), TranslatedFieldType.NAME));
                String rightLevel = RightTreeBuilder.builder().system().archive().docClasses().custom((Object)docClass.getId()).build();
                boolean hasRights = Authorization.checkRight((Connection)connection, (String)rightLevel, (String)username, (boolean)false, (boolean)false) != -1;
                checkboxes.add(new DocClassCheckbox(docClass, !hasRights));
            }
            ArrayList<DocClassCheckbox> arrayList = checkboxes;
            return arrayList;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.error((Object)"Cannot close database connection", (Throwable)e);
            }
        }
    }

    public static class DocClassCheckbox {
        private DocumentClass documentClass;
        private boolean disabled;

        public DocClassCheckbox(DocumentClass documentClass, boolean disabled) {
            this.documentClass = documentClass;
            this.disabled = disabled;
        }

        public DocumentClass getDocumentClass() {
            return this.documentClass;
        }

        public boolean isDisabled() {
            return this.disabled;
        }
    }
}

