/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.plusmpm.database.DBManagement;
import com.plusmpm.database.DocClassTable;
import com.plusmpm.database.IndexTable;
import com.plusmpm.struts.action.ShowFileAction;
import com.plusmpm.util.DocumentData;
import com.plusmpm.util.Tools;
import com.suncode.pwfl.archive.Link;
import com.suncode.pwfl.archive.LinkConnection;
import com.suncode.pwfl.archive.LinkIndex;
import com.suncode.pwfl.archive.LinkService;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.util.SpringContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowDocumentFromArchiveAction
extends Action {
    private static final Logger log = LoggerFactory.getLogger(ShowDocumentFromArchiveAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Optional linkIndex;
        String sSearchObjectName;
        String sSearchType = request.getParameter("type");
        String sSearchObject = request.getParameter("object");
        String sSearchIndexId = request.getParameter("index");
        String sSearchObjectValue = request.getParameter("value");
        LinkService linkService = (LinkService)SpringContext.getBean(LinkService.class);
        DBManagement dbm = new DBManagement();
        if (sSearchObject == null) {
            sSearchObjectName = request.getParameter("objectName");
            if (!Tools.isNullOrEmpty((String)sSearchType) && sSearchType.compareToIgnoreCase("link") == 0) {
                Link link = linkService.getByName(sSearchObjectName, new String[0]);
                if (link != null) {
                    sSearchObject = link.getId().toString();
                } else {
                    log.error("Document set [{}] does not exist. Cannot show document.", (Object)sSearchObjectName);
                    request.setAttribute("message", (Object)(MessageHelper.getMessage((String)"Klasa_dokumentu_nie_istnieje") + "!"));
                    request.setAttribute("messageType", (Object)"error");
                    return mapping.findForward("showFileMessage");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)sSearchType) && sSearchType.compareToIgnoreCase("docclass") == 0) {
                DocClassTable docclass = dbm.getDocClassByName(sSearchObjectName);
                if (docclass != null) {
                    sSearchObject = docclass.getId().toString();
                } else {
                    log.error("Document class [{}] does not exist. Cannot show document.", (Object)sSearchObjectName);
                    request.setAttribute("message", (Object)(MessageHelper.getMessage((String)"Klasa_dokumentu_nie_istnieje") + "!"));
                    request.setAttribute("messageType", (Object)"error");
                    return mapping.findForward("showFileMessage");
                }
            }
        }
        if (sSearchIndexId == null) {
            sSearchObjectName = request.getParameter("indexName");
            if (StringUtils.isNotBlank((CharSequence)sSearchType) && sSearchType.compareToIgnoreCase("link") == 0 && (linkIndex = linkService.getLinkIndexByName(Long.valueOf(sSearchObject), sSearchObjectName)).isPresent()) {
                sSearchIndexId = ((LinkIndex)linkIndex.get()).getId().toString();
            }
            if (!Tools.isNullOrEmpty((String)sSearchType) && sSearchType.compareToIgnoreCase("docclass") == 0) {
                IndexTable index = dbm.getIndexByNameInDocClass(sSearchObject, sSearchObjectName);
                sSearchIndexId = index.getId().toString();
            }
        }
        try {
            String sFileId = "";
            if (StringUtils.isNotBlank((CharSequence)sSearchType) && sSearchType.compareToIgnoreCase("link") == 0 && (linkIndex = linkService.getLinkIndex(Long.valueOf(sSearchIndexId), new String[0])) != null) {
                List linkConnections = linkService.getLinkConnectionsForLinkIndex(Long.valueOf(sSearchIndexId), new String[]{"documentClass", "documentClassIndex"});
                for (LinkConnection linkConnection : linkConnections) {
                    Long docClassId = linkConnection.getDocumentClass().getId();
                    Long indexId = linkConnection.getDocumentClassIndex().getId();
                    HashMap<IndexTable, String> hmIndecies = new HashMap<IndexTable, String>();
                    IndexTable index = DBManagement.getIndex((String)indexId.toString());
                    log.info("sSearchObjectValue :" + sSearchObjectValue);
                    hmIndecies.put(index, sSearchObjectValue);
                    sFileId = this.getFirstDocumentByDocClassAndIndecies(dbm, docClassId.toString(), hmIndecies);
                    if (Tools.isNullOrEmpty((String)sFileId)) continue;
                    break;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)sSearchType) && sSearchType.compareToIgnoreCase("docclass") == 0) {
                String sDocClassId = sSearchObject;
                log.info("sSearchObjectValue :" + sSearchObjectValue);
                HashMap<IndexTable, String> hmIndecies = new HashMap<IndexTable, String>();
                IndexTable index = DBManagement.getIndex((String)sSearchIndexId);
                log.info("sSearchObjectValue :" + sSearchObjectValue);
                hmIndecies.put(index, sSearchObjectValue);
                hmIndecies.put(index, sSearchObjectValue);
                sFileId = this.getFirstDocumentByDocClassAndIndecies(dbm, sDocClassId, hmIndecies);
            }
            ShowFileAction fileAction = new ShowFileAction();
            fileAction.m_sFileId = Tools.encodeStringBase64((String)sFileId);
            return fileAction.execute(mapping, form, request, response);
        }
        catch (NullPointerException e) {
            String message = MessageHelper.getMessage((String)"Dokument_o_indeksach_nie_istnieje") + ", '" + sSearchIndexId + "=" + sSearchObjectValue + "'!";
            log.warn(message);
            request.setAttribute("message", (Object)message);
            request.setAttribute("messageType", (Object)"error");
            return mapping.findForward("showFileMessage");
        }
        catch (Exception e) {
            log.error("Blad podczas wyszukiwania {}" + e.getMessage());
            request.setAttribute("message", (Object)(MessageHelper.getMessage((String)"Blad_podczas_wyszukiwania") + "!"));
            request.setAttribute("messageType", (Object)"error");
            return mapping.findForward("showfileMessage");
        }
    }

    private String getFirstDocumentByDocClassAndIndecies(DBManagement dbm, String docClassId, HashMap<IndexTable, String> hmIndecies) {
        ArrayList documents = DBManagement.SearchDocClass(hmIndecies, (String)docClassId, (String)"", (String)"", (String)"", (int)1, (int)0, (int)0, (int)0, (long)0L);
        if (CollectionUtils.isEmpty((Collection)documents)) {
            log.info("Brak dokument\u00f3w dla klasy dokument\u00f3w :" + docClassId);
            return "";
        }
        DocumentData documentData = (DocumentData)documents.get(0);
        return Objects.toString(documentData.getLFileId(), "");
    }
}

