/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.plusmpm.database.CommentsTable;
import com.plusmpm.database.DBManagement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.client.wfbase.BaseException;

public class ShowCommentsAction
extends Action {
    public static Logger log = Logger.getLogger(ShowCommentsAction.class);

    public ArrayList GetComments(HttpServletRequest request, String sProcessId, String sActivityId) {
        return this.GetComments(request, sProcessId, sActivityId, "", false);
    }

    public ArrayList GetComments(HttpServletRequest request, String sProcessId, String sActivityId, Boolean formatHttpLinks) {
        return this.GetComments(request, sProcessId, sActivityId, "", formatHttpLinks);
    }

    public ArrayList GetComments(HttpServletRequest request, String sProcessId, String sActivityId, String history, Boolean formatHttpLinks) {
        HttpSession session = request.getSession(false);
        String sUserName = (String)session.getAttribute("username");
        DBManagement dbm = new DBManagement();
        ArrayList alComments = dbm.GetAllCommentsForProcess(sProcessId);
        SimpleDateFormat sdf = new SimpleDateFormat(DBManagement.CONST_DATEFORMAT);
        boolean bHistory = false;
        for (int i = 0; i < alComments.size(); ++i) {
            CommentsTable commentsTable = (CommentsTable)alComments.get(i);
            if (formatHttpLinks.booleanValue()) {
                String comment = commentsTable.getComment();
                StringBuffer formattedComment = new StringBuffer();
                Pattern p = Pattern.compile("(http(s)?://|www.)([^<> \\n\\r\\f]+)", 2);
                Matcher m = p.matcher(comment);
                int lastIndex = 0;
                while (m.find()) {
                    String url = m.group();
                    String httpLink = "<a href=\"";
                    if (!url.substring(0, 4).equalsIgnoreCase("http")) {
                        httpLink = httpLink + "http://";
                    }
                    httpLink = httpLink + url + "\">" + url + "</a>";
                    String c1 = comment.substring(lastIndex, m.start());
                    lastIndex = m.end();
                    formattedComment.append(c1);
                    formattedComment.append(httpLink);
                }
                formattedComment.append(comment.substring(lastIndex));
                commentsTable.setComment(formattedComment.toString());
            }
            commentsTable.setComment(commentsTable.getComment().replace("\n", "<BR>"));
            if (history != null && history.compareToIgnoreCase("") != 0) {
                bHistory = true;
                commentsTable.setBCanDelete(false);
            } else if (commentsTable.getActivityId().compareTo(sActivityId) == 0 && commentsTable.getUserId().compareTo(sUserName) == 0) {
                commentsTable.setBCanDelete(true);
            } else {
                commentsTable.setBCanDelete(false);
            }
            String data = sdf.format(new Date(commentsTable.getTimestamp()));
            commentsTable.setCommentDate(data);
            try {
                String sRealName = Shark.getInstance().getAdminInterface().getUserGroupAdministration().getUserRealName(commentsTable.getUserId());
                commentsTable.setUserName(sRealName);
                continue;
            }
            catch (BaseException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return alComments;
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        log.info((Object)"******************************ShowCommentsAction********************");
        HttpSession session = request.getSession(false);
        if (session == null || session.getAttribute("username") == null) {
            return mapping.findForward("disconnect");
        }
        String processId = request.getParameter("processId");
        String activityId = request.getParameter("activityId");
        String history = request.getParameter("history");
        if (history == null) {
            history = "";
        }
        ArrayList alComments = this.GetComments(request, processId, activityId, history, true);
        request.setAttribute("alComments", (Object)alComments);
        request.setAttribute("processId", (Object)processId);
        request.setAttribute("history", (Object)history);
        return mapping.findForward("showComments");
    }
}

