/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.support.io;

import com.google.common.net.PercentEscaper;
import com.suncode.pwfl.web.support.io.DownloadResource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.io.IOUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class DownloadResourceHttpMessageConverter
extends AbstractHttpMessageConverter<DownloadResource> {
    public DownloadResourceHttpMessageConverter() {
        super(MediaType.ALL);
    }

    protected boolean supports(Class<?> clazz) {
        return DownloadResource.class.isAssignableFrom(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeInternal(DownloadResource resource, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        MimetypesFileTypeMap typeMap = new MimetypesFileTypeMap();
        String mimeType = typeMap.getContentType(resource.getFileName());
        String fileName = new PercentEscaper("-_.*", false).escape(resource.getFileName());
        HttpHeaders headers = outputMessage.getHeaders();
        headers.add("Content-Disposition", "attachment; filename=\"" + fileName + "\"; filename*=UTF-8''" + fileName);
        headers.add("Content-Length", String.valueOf(resource.getSize()));
        headers.add("Content-Type", mimeType);
        InputStream in = resource.getInputStream();
        try {
            IOUtils.copy((InputStream)in, (OutputStream)outputMessage.getBody());
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        outputMessage.getBody().flush();
    }

    protected DownloadResource readInternal(Class<? extends DownloadResource> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        throw new UnsupportedOperationException();
    }
}

