/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.dto.administration;

import com.suncode.pwfl.administration.configuration.Category;
import com.suncode.pwfl.administration.configuration.ComboValue;
import com.suncode.pwfl.administration.configuration.ParameterType;
import com.suncode.pwfl.administration.configuration.SystemParameter;
import com.suncode.pwfl.web.dto.administration.CategoryExportDto;
import com.suncode.pwfl.web.dto.administration.ComboValueExportDto;
import java.beans.ConstructorProperties;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class SystemParameterExportDto
implements Comparable<SystemParameterExportDto> {
    private String key;
    private String value;
    private boolean removable;
    private String type;
    private List<ComboValueExportDto> comboValues;

    public static SystemParameterExportDto convert(SystemParameter parameter) {
        List<ComboValueExportDto> comboValuesDto = parameter.getComboValues().stream().map(comboValue -> ComboValueExportDto.convert(comboValue)).collect(Collectors.toList());
        parameter.getValue();
        return SystemParameterExportDto.builder().key(parameter.getKey()).value(SystemParameterExportDto.getStringValue(parameter)).removable(parameter.isRemovable()).type(parameter.getParameterType().toString()).comboValues(comboValuesDto).build();
    }

    private static String getStringValue(SystemParameter parameter) {
        Object value = parameter.getValue();
        if (value != null) {
            switch (parameter.getParameterType()) {
                case DOUBLE: {
                    DecimalFormatSymbols symbols = new DecimalFormatSymbols();
                    symbols.setDecimalSeparator('.');
                    DecimalFormat format = new DecimalFormat("#.#", symbols);
                    format.setMaximumFractionDigits(20);
                    format.setMaximumIntegerDigits(20);
                    return format.format(value);
                }
                case PASSWORD: {
                    return parameter.getValueString();
                }
            }
            return value.toString();
        }
        return null;
    }

    public SystemParameter convert(CategoryExportDto categoryDto) {
        SystemParameter parameter = new SystemParameter(new Category(categoryDto.getKey()), ParameterType.valueOf((String)this.type), this.key);
        parameter.setRemovable(this.removable);
        if (this.comboValues != null) {
            LinkedList<ComboValue> combos = new LinkedList<ComboValue>();
            for (ComboValueExportDto valueDto : this.comboValues) {
                ComboValue comboValue = new ComboValue(parameter, valueDto.getValue());
                combos.add(comboValue);
            }
            parameter.setComboValues(combos);
        }
        if (this.value != null) {
            if (ParameterType.valueOf((String)this.type) == ParameterType.PASSWORD) {
                parameter.setValueString(this.value);
            } else {
                parameter.setValue((Object)this.value);
            }
        }
        return parameter;
    }

    @Override
    public int compareTo(SystemParameterExportDto toCompare) {
        String key1 = this.key;
        String key2 = toCompare.getKey();
        return key1.compareToIgnoreCase(key2);
    }

    public static SystemParameterExportDtoBuilder builder() {
        return new SystemParameterExportDtoBuilder();
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isRemovable() {
        return this.removable;
    }

    public String getType() {
        return this.type;
    }

    public List<ComboValueExportDto> getComboValues() {
        return this.comboValues;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setRemovable(boolean removable) {
        this.removable = removable;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setComboValues(List<ComboValueExportDto> comboValues) {
        this.comboValues = comboValues;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SystemParameterExportDto)) {
            return false;
        }
        SystemParameterExportDto other = (SystemParameterExportDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        if (this.isRemovable() != other.isRemovable()) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List<ComboValueExportDto> this$comboValues = this.getComboValues();
        List<ComboValueExportDto> other$comboValues = other.getComboValues();
        return !(this$comboValues == null ? other$comboValues != null : !((Object)this$comboValues).equals(other$comboValues));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SystemParameterExportDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        result = result * 59 + (this.isRemovable() ? 79 : 97);
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List<ComboValueExportDto> $comboValues = this.getComboValues();
        result = result * 59 + ($comboValues == null ? 43 : ((Object)$comboValues).hashCode());
        return result;
    }

    public String toString() {
        return "SystemParameterExportDto(key=" + this.getKey() + ", value=" + this.getValue() + ", removable=" + this.isRemovable() + ", type=" + this.getType() + ", comboValues=" + this.getComboValues() + ")";
    }

    @ConstructorProperties(value={"key", "value", "removable", "type", "comboValues"})
    public SystemParameterExportDto(String key, String value, boolean removable, String type, List<ComboValueExportDto> comboValues) {
        this.key = key;
        this.value = value;
        this.removable = removable;
        this.type = type;
        this.comboValues = comboValues;
    }

    public static class SystemParameterExportDtoBuilder {
        private String key;
        private String value;
        private boolean removable;
        private String type;
        private List<ComboValueExportDto> comboValues;

        SystemParameterExportDtoBuilder() {
        }

        public SystemParameterExportDtoBuilder key(String key) {
            this.key = key;
            return this;
        }

        public SystemParameterExportDtoBuilder value(String value) {
            this.value = value;
            return this;
        }

        public SystemParameterExportDtoBuilder removable(boolean removable) {
            this.removable = removable;
            return this;
        }

        public SystemParameterExportDtoBuilder type(String type) {
            this.type = type;
            return this;
        }

        public SystemParameterExportDtoBuilder comboValues(List<ComboValueExportDto> comboValues) {
            this.comboValues = comboValues;
            return this;
        }

        public SystemParameterExportDto build() {
            return new SystemParameterExportDto(this.key, this.value, this.removable, this.type, this.comboValues);
        }

        public String toString() {
            return "SystemParameterExportDto.SystemParameterExportDtoBuilder(key=" + this.key + ", value=" + this.value + ", removable=" + this.removable + ", type=" + this.type + ", comboValues=" + this.comboValues + ")";
        }
    }
}

