/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.archive;

import com.google.common.collect.ImmutableMap;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.util.Authorization;
import com.suncode.pwfl.administration.archive.CreateDocumentRightConditionDto;
import com.suncode.pwfl.administration.archive.DocumentClassProtectionService;
import com.suncode.pwfl.administration.archive.DocumentClassRightInfo;
import com.suncode.pwfl.administration.archive.UpsertDocumentClassRightDto;
import com.suncode.pwfl.archive.DocumentProtection;
import com.suncode.pwfl.archive.DocumentProtectionService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.util.DtoComparator;
import com.suncode.pwfl.util.Paginator;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.dto.archive.DocumentRightConditionTypeDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.DocumentClassProtectionMapper;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.workflow.constant.DocumentAuthorizationConditionType;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"documents/classes/{documentClassId}/protection"})
public class DocumentClassProtectionController {
    private static final Logger log = LoggerFactory.getLogger(DocumentClassProtectionController.class);
    private final DocumentClassProtectionService documentClassProtectionService;
    private final DocumentProtectionService documentProtectionService;
    private final DocumentClassProtectionMapper documentClassProtectionMapper;
    private final ExportService exportService;
    private final AuthorizationHelper authorizationHelper;
    private final MessageHelperBean messageHelper;

    @RequestMapping(value={"conditionTypes"})
    @ResponseBody
    public List<DocumentRightConditionTypeDto> getDocumentRightConditionTypes(@PathVariable Long documentClassId) {
        return Arrays.stream(DocumentAuthorizationConditionType.values()).map(this.documentClassProtectionMapper::toDocumentRightConditionTypeDto).collect(Collectors.toList());
    }

    @RequestMapping
    @ResponseBody
    public CountedResult<DocumentClassRightInfo> getDocumentClassRights(@PathVariable Long documentClassId, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false, defaultValue="group") String sortBy, @RequestParam(required=false, defaultValue="DESC") SortDirection sortDirection) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List docClassRights = this.documentClassProtectionService.getDocumentClassRights(documentClassId).stream().sorted(DtoComparator.of(DocumentClassRightInfo.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true).withSupport("conditions", dto -> !dto.getConditions().isEmpty())).collect(Collectors.toList());
        return Paginator.forAll(docClassRights).viewPageByOffset(start, limit);
    }

    @ResponseBody
    @RequestMapping(value={"forResource"})
    public DocumentClassRightInfo getDocumentClassRight(@PathVariable Long documentClassId, @RequestParam String resourceId, @RequestParam boolean isGroup) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.documentClassProtectionService.getDocumentClassRight(resourceId, isGroup, documentClassId);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST})
    public RestResult addDocumentClassRight(HttpServletRequest request, @PathVariable Long documentClassId, @RequestBody UpsertDocumentClassRightDto documentClassRightDto) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_DOC_CLASS_PROTECTION).params(this.createAddDocClassRightAuditParams(documentClassId, documentClassRightDto));
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        try {
            this.documentClassProtectionService.addDocumentClassRight(documentClassId, documentClassRightDto);
            auditBuilder.buildSuccess(request);
            return new RestResult(true);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.PATCH})
    public RestResult updateDocumentClassRight(HttpServletRequest request, @PathVariable Long documentClassId, @RequestBody UpsertDocumentClassRightDto documentClassRightDto) {
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("docclassId", documentClassId);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_EDIT_DOC_CLASS_PROTECTION).params(auditParams);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        DocumentClassRightInfo oldDocumentClassRightInfo = this.documentClassProtectionService.getDocumentClassRight(documentClassRightDto.getResourceName(), documentClassRightDto.isGroup(), documentClassId);
        auditParams.putAll(this.createUpdateDocClassRightAuditParams(oldDocumentClassRightInfo, documentClassRightDto));
        auditBuilder.params(auditParams);
        try {
            this.documentClassProtectionService.updateDocumentClassRight(documentClassId, documentClassRightDto);
            auditBuilder.buildSuccess(request);
            return new RestResult(true);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
    }

    @RequestMapping(value={"forResource"}, method={RequestMethod.DELETE})
    @ResponseBody
    public RestResult deleteDocumentClassRight(HttpServletRequest request, @PathVariable Long documentClassId, @RequestParam String resourceId, @RequestParam boolean isGroup) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_DOC_CLASS_PROTECTION).params(this.createDeleteDocClassRightAuditParams(documentClassId, resourceId, isGroup));
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        try {
            String rightLevel = RightTreeBuilder.builder().system().archive().docClasses().custom((Object)documentClassId).build();
            Authorization.deleteRight((String)rightLevel, (String)resourceId, (boolean)isGroup);
            this.documentClassProtectionService.deleteDocumentClassProtection(resourceId, isGroup, documentClassId);
            Authorization.clearRightsTree((String)resourceId);
            auditBuilder.buildSuccess(request);
            return new RestResult(true);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
    }

    @ResponseBody
    @RequestMapping(value={"conditions"}, method={RequestMethod.POST})
    public RestResult addDocumentClassRightCondition(HttpServletRequest request, @PathVariable Long documentClassId, @RequestBody CreateDocumentRightConditionDto documentClassRightConditionDto) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_DOC_CLASS_PROTECTION_CONDITION).params(this.createAddDocClassRightConditionAuditParams(documentClassId, documentClassRightConditionDto));
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        try {
            this.documentClassProtectionService.addDocumentClassRightCondition(documentClassId, documentClassRightConditionDto);
            auditBuilder.buildSuccess(request);
            return new RestResult(true);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
    }

    @RequestMapping(value={"conditions/{conditionId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public RestResult deleteDocumentClassRightCondition(HttpServletRequest request, @PathVariable Long documentClassId, @PathVariable Long conditionId) {
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("conditionId", conditionId);
        auditParams.put("documentClassId", documentClassId);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_DOC_CLASS_PROTECTION_CONDITION).params(auditParams);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        DocumentProtection documentProtection = this.documentProtectionService.getDocumentProtection(documentClassId).stream().filter(condition -> condition.getId().equals(conditionId)).findFirst().orElseThrow(() -> new ServiceException(this.messageHelper.getMessage("Warunek_o_podanym_id_nie_istnieje")));
        auditParams.putAll(this.createDeleteDocClassRightConditionAuditParams(documentProtection));
        auditBuilder.params(auditParams);
        try {
            this.documentClassProtectionService.deleteDocumentClassRightCondition(conditionId);
            auditBuilder.buildSuccess(request);
            return new RestResult(true);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
    }

    @RequestMapping(value={"export/{extension}"})
    @ResponseBody
    public void exportDocumentClassActions(HttpServletResponse response, @PathVariable Long documentClassId, @PathVariable String extension, @RequestParam(required=false, defaultValue="group") String sortBy, @RequestParam(required=false, defaultValue="DESC") SortDirection sortDirection) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List docClassRights = this.documentClassProtectionService.getDocumentClassRights(documentClassId).stream().sorted(DtoComparator.of(DocumentClassRightInfo.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true).withSupport("conditions", dto -> !dto.getConditions().isEmpty())).collect(Collectors.toList());
        List<ExportColumn> columns = Arrays.asList(ExportColumnBuilder.create().name(this.messageHelper.getMessage("Nazwa_uzytkownika_grupy")).data(docClassRights).by(DocumentClassRightInfo::getResourceName).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Grupa")).data(docClassRights).by(documentClassRightInfo -> documentClassRightInfo.isGroup() ? this.messageHelper.getMessage("Tak") : this.messageHelper.getMessage("Nie")).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Poziom_uprawnienia")).data(docClassRights).by(documentClassRightInfo -> this.documentClassProtectionMapper.getRightLevelText(documentClassRightInfo.getRightLevel())).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Dodawanie_dokumentow_w_archiwum")).data(docClassRights).by(documentClassRightInfo -> documentClassRightInfo.isCanAddDocumentInArchive() ? this.messageHelper.getMessage("Tak") : this.messageHelper.getMessage("Nie")).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Dodawanie_dokumentow_w_procesie")).data(docClassRights).by(documentClassRightInfo -> documentClassRightInfo.isCanAddDocumentInProcess() ? this.messageHelper.getMessage("Tak") : this.messageHelper.getMessage("Nie")).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Uprawnienia_warunkowe")).data(docClassRights).by(documentClassRightInfo -> documentClassRightInfo.getConditions().isEmpty() ? this.messageHelper.getMessage("Nie") : this.messageHelper.getMessage("Tak")).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Drukowanie")).data(docClassRights).by(documentClassRightInfo -> documentClassRightInfo.isCanPrint() ? this.messageHelper.getMessage("Tak") : this.messageHelper.getMessage("Nie")).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Podglad_wszystkich_dokumentow_z_poziomu_zadania")).data(docClassRights).by(documentClassRightInfo -> documentClassRightInfo.isCanShowAllDocuments() ? this.messageHelper.getMessage("Tak") : this.messageHelper.getMessage("Nie")).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Odlaczanie_dokumentu")).data(docClassRights).by(documentClassRightInfo -> this.documentClassProtectionMapper.getDocumentDetachTypeText(documentClassRightInfo.getDocumentDetachType())).build());
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Uprawnienia")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    private Map<String, Object> createAddDocClassRightAuditParams(Long documentClassId, UpsertDocumentClassRightDto documentClassRightDto) {
        String rightLevel = documentClassRightDto.getRightLevel() != null ? documentClassRightDto.getRightLevel().subPath : "";
        String documentDetachType = documentClassRightDto.getDocumentDetachType() != null ? documentClassRightDto.getDocumentDetachType().getType() : "";
        return ImmutableMap.builder().put((Object)"docclassId", (Object)documentClassId).put((Object)"userName", (Object)documentClassRightDto.getResourceName()).put((Object)"isGroup", (Object)documentClassRightDto.isGroup()).put((Object)"rightLevel", (Object)rightLevel).put((Object)"printingRight", (Object)documentClassRightDto.isCanPrint()).put((Object)"addDocumentInArchive", (Object)documentClassRightDto.isCanAddDocumentInArchive()).put((Object)"addDocumentInProcess", (Object)documentClassRightDto.isCanAddDocumentInProcess()).put((Object)"documentDetach", (Object)documentDetachType).put((Object)"conditionsLogicalConnection", (Object)documentClassRightDto.getLogicalConnection()).build();
    }

    private Map<String, Object> createUpdateDocClassRightAuditParams(DocumentClassRightInfo oldDocumentClassRight, UpsertDocumentClassRightDto documentClassRightDto) {
        String changePattern = "%s;%s";
        String changePattern2 = "%s > %s";
        String oldRightLevel = oldDocumentClassRight.getRightLevel() != null ? oldDocumentClassRight.getRightLevel().subPath : "";
        String rightLevel = documentClassRightDto.getRightLevel() != null ? documentClassRightDto.getRightLevel().subPath : "";
        String oldDocumentDetachType = oldDocumentClassRight.getDocumentDetachType() != null ? oldDocumentClassRight.getDocumentDetachType().getType() : "";
        String documentDetachType = documentClassRightDto.getDocumentDetachType() != null ? documentClassRightDto.getDocumentDetachType().getType() : "";
        return ImmutableMap.builder().put((Object)"userName", (Object)documentClassRightDto.getResourceName()).put((Object)"isGroup", (Object)documentClassRightDto.isGroup()).put((Object)"rightLevel", (Object)String.format("%s;%s", oldRightLevel, rightLevel)).put((Object)"printingRight", (Object)String.format("%s;%s", oldDocumentClassRight.isCanPrint(), documentClassRightDto.isCanPrint())).put((Object)"addDocumentInArchive", (Object)String.format("%s;%s", oldDocumentClassRight.isCanAddDocumentInArchive(), documentClassRightDto.isCanAddDocumentInArchive())).put((Object)"addDocumentInProcess", (Object)String.format("%s;%s", oldDocumentClassRight.isCanAddDocumentInProcess(), documentClassRightDto.isCanAddDocumentInProcess())).put((Object)"documentDetach", (Object)String.format("%s;%s", oldDocumentDetachType, documentDetachType)).put((Object)"conditionsLogicalConnection", (Object)String.format("%s > %s", oldDocumentClassRight.getLogicalConnection(), documentClassRightDto.getLogicalConnection())).build();
    }

    private Map<String, Object> createDeleteDocClassRightAuditParams(Long documentClassId, String resourceId, boolean isGroup) {
        return ImmutableMap.builder().put((Object)"docclassId", (Object)documentClassId).put((Object)"userId", (Object)resourceId).put((Object)"isGroup", (Object)isGroup).build();
    }

    private Map<String, Object> createAddDocClassRightConditionAuditParams(Long documentClassId, CreateDocumentRightConditionDto documentClassRightConditionDto) {
        return ImmutableMap.builder().put((Object)"docClassId", (Object)documentClassId).put((Object)"userId", (Object)documentClassRightConditionDto.getResourceName()).put((Object)"isGroup", (Object)documentClassRightConditionDto.isGroup()).put((Object)"conditionType", (Object)documentClassRightConditionDto.getType()).put((Object)"docClassIndexId", documentClassRightConditionDto.getDocumentClassIndexId() != null ? documentClassRightConditionDto.getDocumentClassIndexId() : "").put((Object)"operator", (Object)(documentClassRightConditionDto.getOperator() != null ? documentClassRightConditionDto.getOperator() : "")).put((Object)"isNegation", (Object)documentClassRightConditionDto.isNegation()).put((Object)"value", (Object)(documentClassRightConditionDto.getValue() != null ? documentClassRightConditionDto.getValue() : "")).build();
    }

    private Map<String, Object> createDeleteDocClassRightConditionAuditParams(DocumentProtection documentProtection) {
        String conditionType = "";
        String condition = "";
        if (documentProtection != null) {
            conditionType = documentProtection.getConditionType();
            condition = documentProtection.getCondition() != null ? documentProtection.getCondition() : "";
        }
        return ImmutableMap.builder().put((Object)"conditionType", (Object)conditionType).put((Object)"condition", (Object)condition).build();
    }

    @ExceptionHandler(value={IllegalArgumentException.class, ServiceException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleBadRequests(Exception e) {
        log.error("", (Throwable)e);
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNotFullRightsException(NotFullRightsException e) {
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }

    @ConstructorProperties(value={"documentClassProtectionService", "documentProtectionService", "documentClassProtectionMapper", "exportService", "authorizationHelper", "messageHelper"})
    @Autowired
    public DocumentClassProtectionController(DocumentClassProtectionService documentClassProtectionService, DocumentProtectionService documentProtectionService, DocumentClassProtectionMapper documentClassProtectionMapper, ExportService exportService, AuthorizationHelper authorizationHelper, MessageHelperBean messageHelper) {
        this.documentClassProtectionService = documentClassProtectionService;
        this.documentProtectionService = documentProtectionService;
        this.documentClassProtectionMapper = documentClassProtectionMapper;
        this.exportService = exportService;
        this.authorizationHelper = authorizationHelper;
        this.messageHelper = messageHelper;
    }
}

