/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.scheduledtasks;

import com.google.common.collect.ImmutableMap;
import com.plusmpm.database.scheduledTasks.ScheduledTasksTable;
import com.plusmpm.database.scheduledTasks.dao.ScheduledTaskCategoryDAO;
import com.plusmpm.database.scheduledTasks.dao.ScheduledTasksTableDAO;
import com.plusmpm.util.scheduledTasks.AbstractPeriodicTask;
import com.plusmpm.util.scheduledTasks.ScheduledTasksManager;
import com.plusmpm.util.scheduledTasks.exception.TaskNotExecutingException;
import com.suncode.pwfl.administration.scheduledtask.info.ScheduledTaskInfoService;
import com.suncode.pwfl.administration.scheduledtask.info.exceptions.ScheduledTaskNotFoundException;
import com.suncode.pwfl.administration.scheduledtask.info.exceptions.ScheduledTaskStartException;
import com.suncode.pwfl.administration.scheduledtask.info.execution.ScheduledTaskExecution;
import com.suncode.pwfl.administration.scheduledtask.service.PeriodicTaskResolver;
import com.suncode.pwfl.administration.scheduledtask.service.ScheduledTaskService;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.audit.builder.AuditParamsBuilder;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.config.tomcat.ServerMode;
import com.suncode.pwfl.config.tomcat.TomcatService;
import com.suncode.pwfl.form.stereotype.Setter;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import com.suncode.pwfl.web.controller.api.scheduledtasks.ScheduledTaskDtoHelper;
import com.suncode.pwfl.web.controller.api.scheduledtasks.dto.ScheduledTaskDto;
import com.suncode.pwfl.web.controller.api.scheduledtasks.dto.ScheduledTaskSearchDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;
import org.hibernate.criterion.Order;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"scheduledtasks"})
public class ScheduledTaskController {
    private static final Logger log = LoggerFactory.getLogger(ScheduledTaskController.class);
    @Autowired
    private ScheduledTaskDtoHelper scheduledTaskDtoHelper;
    @Autowired
    private ScheduledTaskService scheduledTaskService;
    @Autowired
    private AuthorizationHelper authorizationHelper;
    @Autowired
    private PeriodicTaskResolver periodicTaskResolver;
    @Autowired
    private TomcatService tomcatService;
    @Autowired
    private TransactionWrapper transactionWrapper;
    @Autowired
    private ScheduledTaskInfoService scheduledTaskInfoService;

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<CountedResult<ScheduledTaskDto>> getScheduledTasks(ScheduledTaskSearchDto searchDto) {
        if (this.tomcatService.getTomcatInstanceParameters().getServerMode() == ServerMode.SLAVE) {
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        try {
            Long total;
            List tasks;
            this.authorizationHelper.assertFullAdministrationRights(() -> {});
            log.info("Pobieranie wszystkich zada\u0144 z kategorii id: " + searchDto.getCategory());
            Order order = this.getOrder(searchDto.getPropertyName(), searchDto.getDirection());
            if ("all".equalsIgnoreCase(searchDto.getCategory())) {
                tasks = ScheduledTasksTableDAO.getWithParameters((String)searchDto.getQuery(), (Boolean)searchDto.getActive(), (Boolean)searchDto.getProcessing(), (Order)order, (Integer)searchDto.getStart(), (Integer)searchDto.getLimit());
                total = ScheduledTasksTableDAO.countTask((String)searchDto.getQuery(), (Boolean)searchDto.getActive(), (Boolean)searchDto.getProcessing());
            } else {
                Long categoryId = StringUtils.isNotBlank((CharSequence)searchDto.getCategory()) ? Long.valueOf(searchDto.getCategory()) : null;
                tasks = ScheduledTaskCategoryDAO.getTasksWithParameters((Long)categoryId, (String)searchDto.getQuery(), (Boolean)searchDto.getActive(), (Boolean)searchDto.getProcessing(), (Order)order, (Integer)searchDto.getStart(), (Integer)searchDto.getLimit());
                total = ScheduledTaskCategoryDAO.countTaskWithParametr((Long)categoryId, (String)searchDto.getQuery(), (Boolean)searchDto.getActive(), (Boolean)searchDto.getProcessing());
            }
            List result = tasks.stream().map(this.scheduledTaskDtoHelper::entityToDto).collect(Collectors.toList());
            CountedResult resultDto = new CountedResult(total.longValue(), result);
            log.info("Znalezionych zada\u0144: " + resultDto.getTotal());
            return new ResponseEntity((Object)resultDto, HttpStatus.OK);
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"active"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<Map<String, Object>> changeActiveStatus(@RequestBody ChangeActiveStatusDto changeActiveDto) {
        if (this.tomcatService.getTomcatInstanceParameters().getServerMode() == ServerMode.SLAVE) {
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        long id = changeActiveDto.getId();
        boolean active = changeActiveDto.isActive();
        try {
            if (active) {
                AbstractPeriodicTask periodicTask = (AbstractPeriodicTask)TransactionWrapper.get().doInHibernateTransaction(session -> {
                    ScheduledTasksTable task = ScheduledTasksTableDAO.get((Session)session, (Long)id);
                    task.setIs_active(Boolean.valueOf(true));
                    return this.periodicTaskResolver.getInstance(task);
                });
                ScheduledTasksManager.getInstance().getScheduler().schedule(periodicTask);
            } else {
                TransactionWrapper.get().doInHibernateTransaction(session -> {
                    ScheduledTasksTable task = ScheduledTasksTableDAO.get((Session)session, (Long)id);
                    task.setIs_active(Boolean.valueOf(false));
                });
                ScheduledTasksManager.getInstance().getScheduler().delete(Long.valueOf(id));
            }
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            return new ResponseEntity((Object)ImmutableMap.of((Object)"success", (Object)false), HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)ImmutableMap.of((Object)"success", (Object)true), HttpStatus.OK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"{id}/execute"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<ExecuteTaskDto> execute(@PathVariable Long id, @RequestParam(required=false, defaultValue="NONE") AwaitScheduledTaskPhase awaitPhase, @RequestParam(required=false) Long timeoutSeconds) {
        if (this.tomcatService.getTomcatInstanceParameters().getServerMode() == ServerMode.SLAVE) {
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        ManualAuditBuilder auditBuilder = ManualAuditBuilder.getInstance().type(AuditTypes.AUDIT_MANUAL_RUN_SCHEDULED_TASK).username(UserContext.current().getUser().getUserName()).params(new AuditParamsBuilder().param("id", (Object)id).build()).success(false);
        try {
            this.authorizationHelper.assertFullAdministrationRights(() -> {});
            ExecuteTaskDto.ExecuteTaskDtoBuilder executeTaskDtoBuilder = ExecuteTaskDto.builder().message("OK").timeoutExceeded(false);
            if (awaitPhase != AwaitScheduledTaskPhase.NONE && (timeoutSeconds == null || timeoutSeconds < 0L)) {
                ResponseEntity responseEntity = new ResponseEntity((Object)executeTaskDtoBuilder.message("A positive timeoutSeconds parameter must be provided for scheduled task phase awaiting").build(), HttpStatus.BAD_REQUEST);
                return responseEntity;
            }
            ScheduledTaskExecution execution = this.scheduledTaskInfoService.executeTaskManually(id.longValue());
            switch (awaitPhase) {
                case START: {
                    boolean timeoutExceeded = !execution.awaitTaskStarted(Duration.ofSeconds(timeoutSeconds));
                    executeTaskDtoBuilder.timeoutExceeded(timeoutExceeded);
                    break;
                }
                case COMPLETION: {
                    boolean timeoutExceeded = !execution.awaitTaskCompleted(Duration.ofSeconds(timeoutSeconds));
                    executeTaskDtoBuilder.timeoutExceeded(timeoutExceeded);
                    break;
                }
            }
            auditBuilder.success(true);
            ResponseEntity responseEntity = new ResponseEntity((Object)executeTaskDtoBuilder.build(), HttpStatus.OK);
            return responseEntity;
        }
        catch (ScheduledTaskNotFoundException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            ResponseEntity responseEntity = new ResponseEntity((Object)ExecuteTaskDto.builder().message(e.getMessage()).timeoutExceeded(false).build(), HttpStatus.NOT_FOUND);
            return responseEntity;
        }
        catch (ScheduledTaskStartException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            ResponseEntity responseEntity = new ResponseEntity((Object)ExecuteTaskDto.builder().message(e.getMessage()).timeoutExceeded(false).build(), HttpStatus.BAD_REQUEST);
            return responseEntity;
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            ResponseEntity responseEntity = new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            return responseEntity;
        }
        finally {
            if (auditBuilder != null) {
                auditBuilder.build().log();
            }
        }
    }

    @RequestMapping(value={"invoke"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Map<String, Object>> invokeScheduledTaskAction(@RequestParam String action, @RequestParam Long id) {
        if (this.tomcatService.getTomcatInstanceParameters().getServerMode() == ServerMode.SLAVE) {
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        HashMap<String, Comparable<Boolean>> result = new HashMap<String, Comparable<Boolean>>();
        try {
            this.authorizationHelper.assertFullAdministrationRights(() -> {});
            switch (action) {
                case "cancel": {
                    boolean success = ScheduledTasksManager.getInstance().getExecutor().cancelTask((Object)id);
                    result.put("success", Boolean.valueOf(success));
                    break;
                }
                case "execute": {
                    boolean success = ScheduledTasksManager.getInstance().getExecutor().executeTask(id, 5L, TimeUnit.SECONDS);
                    if (success) {
                        Double progress = ScheduledTasksManager.getInstance().getExecutor().getTaskProgress((Object)id);
                        result.put("progress", progress);
                    }
                    result.put("success", Boolean.valueOf(success));
                    break;
                }
                case "remove": {
                    if (!ScheduledTasksManager.getInstance().getExecutor().isTaskRunning((Object)id).booleanValue()) {
                        this.scheduledTaskService.deleteScheduledTask(id);
                        result.put("success", Boolean.valueOf(true));
                        break;
                    }
                    result.put("success", Boolean.valueOf(false));
                    break;
                }
                case "awaitcompletion": {
                    boolean success = ScheduledTasksManager.getInstance().getExecutor().awaitCompletion(id, 28L, TimeUnit.SECONDS);
                    result.put("success", Boolean.valueOf(success));
                    break;
                }
                default: {
                    log.warn("Nieznana akcja: " + action);
                    return new ResponseEntity(HttpStatus.BAD_REQUEST);
                }
            }
            return new ResponseEntity(result, HttpStatus.OK);
        }
        catch (TaskNotExecutingException e) {
            log.info("Zadanie nie jest aktualnie wykonywane.");
            result.put("success", Boolean.valueOf(false));
            return new ResponseEntity(result, HttpStatus.OK);
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private Order getOrder(String propertyName, String direction) {
        String field = StringUtils.isBlank((CharSequence)propertyName) ? "name" : propertyName;
        switch (propertyName) {
            case "lastRun": {
                field = "last_run";
                break;
            }
            case "className": {
                field = "class_name";
                break;
            }
            case "methodName": {
                field = "method_name";
            }
        }
        if (Objects.equals(direction, "DESC")) {
            return Order.desc((String)field);
        }
        return Order.asc((String)field);
    }

    @Setter
    public static class ChangeActiveStatusDto {
        private long id;
        private boolean active;

        public long getId() {
            return this.id;
        }

        public boolean isActive() {
            return this.active;
        }

        public ChangeActiveStatusDto() {
        }

        @ConstructorProperties(value={"id", "active"})
        public ChangeActiveStatusDto(long id, boolean active) {
            this.id = id;
            this.active = active;
        }
    }

    public static class ExecuteTaskDto {
        private String message;
        private boolean timeoutExceeded;

        public static ExecuteTaskDtoBuilder builder() {
            return new ExecuteTaskDtoBuilder();
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isTimeoutExceeded() {
            return this.timeoutExceeded;
        }

        @ConstructorProperties(value={"message", "timeoutExceeded"})
        public ExecuteTaskDto(String message, boolean timeoutExceeded) {
            this.message = message;
            this.timeoutExceeded = timeoutExceeded;
        }

        public static class ExecuteTaskDtoBuilder {
            private String message;
            private boolean timeoutExceeded;

            ExecuteTaskDtoBuilder() {
            }

            public ExecuteTaskDtoBuilder message(String message) {
                this.message = message;
                return this;
            }

            public ExecuteTaskDtoBuilder timeoutExceeded(boolean timeoutExceeded) {
                this.timeoutExceeded = timeoutExceeded;
                return this;
            }

            public ExecuteTaskDto build() {
                return new ExecuteTaskDto(this.message, this.timeoutExceeded);
            }

            public String toString() {
                return "ScheduledTaskController.ExecuteTaskDto.ExecuteTaskDtoBuilder(message=" + this.message + ", timeoutExceeded=" + this.timeoutExceeded + ")";
            }
        }
    }

    public static enum AwaitScheduledTaskPhase {
        NONE,
        START,
        COMPLETION;

    }
}

