/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.scheduledtasks;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.plusmpm.database.scheduledTasks.ScheduledTasksParametersTable;
import com.plusmpm.database.scheduledTasks.ScheduledTasksTable;
import com.plusmpm.database.scheduledTasks.dao.ScheduledTasksTableDAO;
import com.plusmpm.util.scheduledTasks.AbstractPeriodicTask;
import com.plusmpm.util.scheduledTasks.ScheduledTasksManager;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskMethodDto;
import com.suncode.pwfl.administration.scheduledtask.parameter.ScheduledTaskParameterFinder;
import com.suncode.pwfl.administration.scheduledtask.service.PeriodicTaskResolver;
import com.suncode.pwfl.administration.scheduledtask.service.ScheduledTaskEntityMethodValidator;
import com.suncode.pwfl.administration.scheduledtask.service.ScheduledTaskHelper;
import com.suncode.pwfl.administration.scheduledtask.service.ScheduledTaskMethodFinder;
import com.suncode.pwfl.config.tomcat.ServerMode;
import com.suncode.pwfl.config.tomcat.TomcatService;
import com.suncode.pwfl.web.controller.api.scheduledtasks.ScheduledTaskParameterBuilder;
import com.suncode.pwfl.web.controller.api.scheduledtasks.dto.ParameterInfo;
import com.suncode.pwfl.web.controller.api.scheduledtasks.exception.ScheduledTaskConcurrentModificationException;
import com.suncode.pwfl.web.controller.api.scheduledtasks.exception.ScheduledTaskNotAvailableException;
import com.suncode.pwfl.web.controller.api.scheduledtasks.method.ScheduledTaskReceivedParametersValidator;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"scheduledtasks"})
public class EditScheduledTaskController {
    private static final Logger log = LoggerFactory.getLogger(EditScheduledTaskController.class);
    @Autowired
    private ScheduledTaskHelper scheduledTaskHelper;
    @Autowired
    private ScheduledTaskParameterFinder scheduledTaskParameterFinder;
    @Autowired
    private ScheduledTaskMethodFinder scheduledTaskMethodFinder;
    @Autowired
    private ScheduledTaskParameterBuilder scheduledTaskParameterBuilder;
    @Autowired
    private ScheduledTaskEntityMethodValidator scheduledTaskEntityMethodValidator;
    @Autowired
    private ScheduledTaskReceivedParametersValidator scheduledTaskReceivedParametersValidator;
    @Autowired
    private PeriodicTaskResolver periodicTaskResolver;
    @Autowired
    private AuthorizationHelper authorizationHelper;
    @Autowired
    private TomcatService tomcatService;
    private ObjectMapper objectMapper = new ObjectMapper();
    private TypeReference<LinkedList<ParameterInfo>> parameterInfoType = new TypeReference<LinkedList<ParameterInfo>>(){};

    @RequestMapping(value={"edit"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Map<String, Object>> editScheduledTask(@RequestParam Long id, @RequestParam String name, @RequestParam String description, @RequestParam String params, @RequestParam String nextRun, @RequestParam(required=false) String executeOnce, @RequestParam(required=false) Long periodValue, @RequestParam(required=false) String periodUnit, @RequestParam(required=false) String active, @RequestParam(required=false) String saveHistory) {
        if (this.tomcatService.getTomcatInstanceParameters().getServerMode() == ServerMode.SLAVE) {
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        log.info("Edytowanie zadania zaplanowanego...");
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(2);
        try {
            this.authorizationHelper.assertFullAdministrationRights(() -> {});
            ScheduledTasksTable task = ScheduledTasksTableDAO.getWithParameters((Long)id);
            if (BooleanUtils.isTrue((Boolean)task.getIs_processing())) {
                throw new ScheduledTaskConcurrentModificationException(String.format("Scheduled task with id %s is during execution - concurrent modification is not allowed.", id));
            }
            List dtoParamList = (List)this.objectMapper.readValue(params, this.parameterInfoType);
            ScheduledTaskMethodDto methodDto = (ScheduledTaskMethodDto)this.scheduledTaskMethodFinder.findScheduledTaskMethod(task).orElseThrow(() -> new ScheduledTaskNotAvailableException(String.format("Could not find method matching entity with id %d", id)));
            this.scheduledTaskReceivedParametersValidator.validateReceivedParametersAgainstMethod(dtoParamList, methodDto, false);
            this.scheduledTaskEntityMethodValidator.validateEntityParametersAgainstMethod(task, methodDto, false);
            SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date nextRunDate = dateFormatter.parse(nextRun);
            Long period = null;
            if (periodValue != null && periodUnit != null) {
                switch (periodUnit) {
                    case "minute": {
                        period = TimeUnit.MINUTES.toMillis(periodValue);
                        break;
                    }
                    case "hour": {
                        period = TimeUnit.HOURS.toMillis(periodValue);
                        break;
                    }
                    case "day": {
                        period = TimeUnit.DAYS.toMillis(periodValue);
                        break;
                    }
                    case "month": {
                        period = TimeUnit.DAYS.toMillis(periodValue) * 30L;
                    }
                }
            }
            boolean runOnce = StringUtils.equals((CharSequence)executeOnce, (CharSequence)"on");
            boolean isActive = StringUtils.equals((CharSequence)active, (CharSequence)"on");
            boolean logHistory = StringUtils.equals((CharSequence)saveHistory, (CharSequence)"on");
            task.setName(name);
            task.setDescription(description);
            task.setRun_once(Boolean.valueOf(runOnce));
            task.setIs_active(Boolean.valueOf(isActive));
            task.setPeriod_miliseconds(period);
            task.setSaveHistory(Boolean.valueOf(logHistory));
            task.setNext_run(nextRunDate);
            List<ScheduledTasksParametersTable> taskParametersDto = this.scheduledTaskParameterBuilder.buildTaskParameters(dtoParamList, task);
            for (ScheduledTasksParametersTable taskParameterDto : taskParametersDto) {
                this.setEntityParameter(task, taskParameterDto);
            }
            ScheduledTasksTableDAO.update((ScheduledTasksTable)task);
            if (task.getIs_active().booleanValue()) {
                AbstractPeriodicTask periodicTask = this.periodicTaskResolver.getInstance(task);
                ScheduledTasksManager.getInstance().getScheduler().schedule(periodicTask);
            } else {
                ScheduledTasksManager.getInstance().getScheduler().delete(task.getId());
            }
            log.info("Zadanie zaplanowane zosta\u0142o zaktualizowane.");
            result.put("success", true);
            return new ResponseEntity(result, HttpStatus.OK);
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            result.put("success", false);
            return new ResponseEntity(result, HttpStatus.OK);
        }
    }

    private void setEntityParameter(ScheduledTasksTable taskEntity, ScheduledTasksParametersTable taskParameterDto) {
        Optional foundParameterEntity = this.scheduledTaskParameterFinder.findInEntity(taskEntity).by(taskParameterDto);
        if (foundParameterEntity.isPresent()) {
            ScheduledTasksParametersTable parameterEntity = (ScheduledTasksParametersTable)foundParameterEntity.get();
            parameterEntity.setParameter_value(taskParameterDto.getParameter_value());
        } else {
            taskEntity.getScheduled_tasks_parameters().add(taskParameterDto);
        }
    }
}

