/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.favourites;

import com.suncode.plugin.dashboard.DashboardService;
import com.suncode.plugin.dashboard.Gadget;
import com.suncode.plugin.dashboard.SystemDashboardService;
import com.suncode.plugin.dashboard.gadget.properties.BooleanProperty;
import com.suncode.plugin.dashboard.gadget.properties.TextProperty;
import com.suncode.plugin.dashboard.web.support.GadgetControllerSupport;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.dashboard.support.UserContext;
import com.suncode.pwfl.favourites.FavouriteHandler;
import com.suncode.pwfl.favourites.FavouritesRegistry;
import com.suncode.pwfl.favourites.view.FavouritesRenderer;
import com.suncode.pwfl.favourites.view.support.TileDto;
import com.suncode.pwfl.web.ui.DivanteColor;
import com.suncode.pwfl.web.ui.DivanteIcon;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/favourites/gadget/tile"})
public class TileController
extends GadgetControllerSupport {
    @Autowired
    private FavouritesRegistry registry;
    @Autowired
    private DashboardService dashboardService;
    @Autowired
    private SystemDashboardService systemDashboardService;
    @Autowired
    private UserContext userContext;

    @RequestMapping(value={""})
    @ResponseBody
    public ResponseEntity<?> getTileDto(@RequestParam String id, @RequestParam(required=false) boolean system) {
        User user = this.userContext.getUser();
        Gadget gadget = system ? (Gadget)this.systemDashboardService.findGadgetForUser(user, id).get() : this.dashboardService.getGadget(Long.valueOf(id));
        TileDto tileDto = new TileDto();
        FavouriteHandler handler = this.registry.getHandler((String)((TextProperty)gadget.getProperty("type", TextProperty.class)).getValue());
        if (Objects.nonNull(handler)) {
            tileDto = TileDto.builder().type((String)((TextProperty)gadget.getProperty("type", TextProperty.class)).getValue()).name((String)((TextProperty)gadget.getProperty("name", TextProperty.class)).getValue()).counted((Boolean)((BooleanProperty)gadget.getProperty("counted", BooleanProperty.class)).getValue()).newWindow((Boolean)((BooleanProperty)gadget.getProperty("newWindow", BooleanProperty.class)).getValue()).parameter((String)((TextProperty)gadget.getProperty("parameter", TextProperty.class)).getValue()).hasCustomName(Boolean.TRUE.equals(((BooleanProperty)gadget.getProperty("hasCustomName", BooleanProperty.class)).getValue())).theme((String)((TextProperty)gadget.getProperty("theme", TextProperty.class)).getValue()).build();
            FavouritesRenderer renderer = handler.getTileRenderer(tileDto);
            Assert.notNull((Object)renderer, (String)"Could not render tile. Error message will appear.");
            if (renderer.shouldTileGadgetRender()) {
                String tileColor = (String)((TextProperty)gadget.getProperty("tileColor", TextProperty.class)).getValue();
                String icon = (String)((TextProperty)gadget.getProperty("icon", TextProperty.class)).getValue();
                DivanteColor divanteColor = StringUtils.isEmpty((CharSequence)tileColor) ? null : DivanteColor.fromString((String)tileColor);
                DivanteIcon divanteIcon = StringUtils.isEmpty((CharSequence)icon) ? null : DivanteIcon.fromString((String)icon);
                try {
                    tileDto.executeTileRenderer(renderer);
                    if (Objects.nonNull(divanteColor)) {
                        tileDto.setTileColor(divanteColor.getCode());
                    }
                    if (Objects.nonNull(divanteIcon)) {
                        tileDto.setIcon(divanteIcon.getCode());
                    }
                }
                catch (Exception e) {
                    this.logger.warn("Could not render tile [name:{}]. Nested Exception is", (Object)tileDto.getName(), (Object)e);
                }
            } else {
                return new ResponseEntity(HttpStatus.UNAUTHORIZED);
            }
        }
        return new ResponseEntity((Object)tileDto, HttpStatus.OK);
    }
}

