/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.certificates;

import com.google.common.collect.ImmutableMap;
import com.suncode.pwfl.administration.user.DomainService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.certificates.CertificateService;
import com.suncode.pwfl.certificates.exceptions.CertificateBaseException;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.util.Maps;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.controller.api.certificates.CertificateControllerHelper;
import com.suncode.pwfl.web.controller.api.certificates.dto.CertificateDto;
import com.suncode.pwfl.web.controller.api.certificates.dto.DomainInfoDto;
import com.suncode.pwfl.web.controller.api.certificates.dto.RenameAliasDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.web.util.JsonMessage;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/certificates"})
public class CertificateController {
    private static final Logger log = LoggerFactory.getLogger(CertificateController.class);
    @Autowired
    private CertificateService certificateService;
    @Autowired
    private CertificateControllerHelper helper;
    @Autowired
    private DomainService domainService;
    @Autowired
    private AuthorizationHelper authorizationHelper;
    @Autowired
    private MessageHelperBean messageHelper;

    @RequestMapping(method={RequestMethod.GET}, value={"restartRequired"})
    @ResponseBody
    public JsonMessage restartRequired() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        JsonMessage msg = new JsonMessage();
        msg.setData((Object)this.certificateService.isRestartRequired());
        return msg;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"ldap"})
    @ResponseBody
    public CountedResult<DomainInfoDto> getLDAPServers() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List domains = this.domainService.getDomainList();
        List domainInfoDtos = domains.stream().map(domain -> new DomainInfoDto(domain.getId(), domain.getDomainName())).collect(Collectors.toList());
        return new CountedResult((long)domainInfoDtos.size(), domainInfoDtos);
    }

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<CertificateDto> getCertificates() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        Map certificates = this.certificateService.getCertificates();
        List certificateDtos = certificates.entrySet().stream().map(Maps.entryFold(CertificateDto::new)).sorted(Comparator.comparing(CertificateDto::getAlias)).collect(Collectors.toList());
        return new CountedResult((long)certificates.size(), certificateDtos);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"extended"})
    @ResponseBody
    public CountedResult<CertificateDto> getCertificatesExtended(@RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false, defaultValue="alias") String orderBy, @RequestParam(required=false, defaultValue="ASC") SortDirection orderDirection) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.helper.getExtended(this.certificateService.getCertificates(), start, limit, orderBy, orderDirection);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"system"})
    @ResponseBody
    public CountedResult<CertificateDto> getSystemCertificates() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        Map certificates = this.certificateService.getSystemCertificates();
        List certificateDtos = certificates.entrySet().stream().map(Maps.entryFold(CertificateDto::new)).sorted(Comparator.comparing(CertificateDto::getAlias)).collect(Collectors.toList());
        return new CountedResult((long)certificates.size(), certificateDtos);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"system/extended"})
    @ResponseBody
    public CountedResult<CertificateDto> getSystemCertificatesExtended(@RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false, defaultValue="alias") String orderBy, @RequestParam(required=false, defaultValue="ASC") SortDirection orderDirection) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.helper.getExtended(this.certificateService.getSystemCertificates(), start, limit, orderBy, orderDirection);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"exportKeyStore"})
    @ResponseBody
    public void exportCertificatesKeyStore(HttpServletResponse response) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        Map certs = this.certificateService.getCertificates();
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=\"keystore.jks\"");
        this.certificateService.exportCertificatesToKeyStore(certs, (OutputStream)response.getOutputStream(), this.helper.EXPORT_KEYSTORE_PASSWORD);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"exportCert"})
    @ResponseBody
    public void exportCertificate(HttpServletResponse response, @RequestParam String alias) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        Certificate cert = this.certificateService.getCertificate(alias);
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"%s.pem\"", alias));
        this.certificateService.exportCertificateToStream(cert, (OutputStream)response.getOutputStream());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"system/exportCert"})
    @ResponseBody
    public void exportSystemCertificate(HttpServletResponse response, @RequestParam String alias) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        Certificate cert = this.certificateService.getSystemCertificate(alias);
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"%s.pem\"", alias));
        this.certificateService.exportCertificateToStream(cert, (OutputStream)response.getOutputStream());
    }

    @RequestMapping(method={RequestMethod.PUT})
    @ResponseBody
    public JsonMessage renameCertificateAlias(HttpServletRequest request, @RequestBody RenameAliasDto renameDto) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_CERTIFICATES_RENAMED).params((Map)ImmutableMap.of((Object)"certificate_old_alias", (Object)renameDto.getAlias(), (Object)"certificate_new_alias", (Object)renameDto.getNewAlias()));
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            this.certificateService.renameCertificate(renameDto.getAlias(), renameDto.getNewAlias());
        }
        catch (CertificateBaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            return new JsonMessage(false, MessageHelper.getMessage((String)e.getMessageKey()));
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            return new JsonMessage(false, MessageHelper.getMessage((String)"Blad_przy_zmianie_aliasu_certyfikatu"));
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new JsonMessage();
    }

    @RequestMapping(method={RequestMethod.DELETE})
    @ResponseBody
    public JsonMessage deleteCertificate(HttpServletRequest request, @RequestParam String alias) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_CERTIFICATES_REMOVED).params((Map)ImmutableMap.of((Object)"certificate_old_alias", (Object)alias));
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            this.certificateService.removeCertificate(alias);
        }
        catch (CertificateBaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            return new JsonMessage(false, MessageHelper.getMessage((String)e.getMessageKey()));
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            return new JsonMessage(false, MessageHelper.getMessage((String)"Blad_przy_usuwaniu_certyfikatu"));
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new JsonMessage();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"exportTable/{extension}"})
    public void exportCertificatesTable(HttpServletResponse response, @PathVariable String extension, @RequestParam(required=false, defaultValue="alias") String orderBy, @RequestParam(required=false, defaultValue="ASC") SortDirection orderDirection) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        this.helper.exportCertificatesDto(response, extension, MessageHelper.getMessage((String)"Certyfikaty_wlasne"), this.getCertificatesExtended(null, null, orderBy, orderDirection));
    }

    @RequestMapping(method={RequestMethod.GET}, value={"system/exportTable/{extension}"})
    public void exportSystemCertificatesTable(HttpServletResponse response, @PathVariable String extension, @RequestParam(required=false, defaultValue="alias") String orderBy, @RequestParam(required=false, defaultValue="ASC") SortDirection orderDirection) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        this.helper.exportCertificatesDto(response, extension, MessageHelper.getMessage((String)"Certyfikaty_systemowe"), this.getSystemCertificatesExtended(null, null, orderBy, orderDirection));
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public RestResult handleUnauthorizedRequests(NotFullRightsException e) {
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }
}

