/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.calendar;

import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.calendarShare.CalendarShareDto;
import com.suncode.pwfl.calendarShare.CalendarShareService;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.util.DtoComparator;
import com.suncode.pwfl.util.Paginator;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.support.ajax.RestResult;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"calendar"})
public class CalendarController {
    @Autowired
    private CalendarShareService calendarShareService;
    @Autowired
    private ExportService exportService;
    @Autowired
    private MessageHelperBean messageHelperBean;

    @RequestMapping(value={"shares"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<CalendarShareDto> getCalendarSharesForOwner(@RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false, defaultValue="isGroup") String sortBy, @RequestParam(required=false, defaultValue="DESC") SortDirection sortDirection) {
        List shares = this.calendarShareService.getCalendarSharesForOwner(UserContext.current().getUser().getUserName()).stream().sorted(DtoComparator.of(CalendarShareDto.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true)).collect(Collectors.toList());
        return Paginator.forAll(shares).viewPageByOffset(start, limit);
    }

    @RequestMapping(value={"shares/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public RestResult deleteCalendarShare(HttpServletRequest request, @PathVariable Long id) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_CALENDAR_SHARE);
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("shareId", id);
        auditBuilder.params(auditParams);
        Optional calendarShareOptional = this.calendarShareService.getCalendarShare(id);
        if (!calendarShareOptional.isPresent()) {
            auditBuilder.buildFailure(request);
            throw new ServiceException(this.messageHelperBean.getMessage("Udostepnienie_kalendarza_o_podanym_id_nie_istnieje"));
        }
        CalendarShareDto calendarShare = (CalendarShareDto)calendarShareOptional.get();
        auditParams.put("ownerId", calendarShare.getOwnerId());
        auditParams.put("shareUserId", calendarShare.getShareResourceId());
        auditParams.put("isGroup", calendarShare.getIsGroup());
        auditBuilder.params(auditParams);
        try {
            this.calendarShareService.deleteCalendarShare(id);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
        auditBuilder.buildSuccess(request);
        return new RestResult(true);
    }

    @RequestMapping(value={"shares"}, method={RequestMethod.POST})
    @ResponseBody
    public RestResult addCalendarShare(HttpServletRequest request, @RequestBody CalendarShareDto calendarShareDto) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_CALENDAR_SHARE);
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        String userName = UserContext.current().getUser().getUserName();
        if (calendarShareDto.getShareResourceId().trim().equals(userName)) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw new ServiceException(this.messageHelperBean.getMessage("Uzytkownik_nie_moze_sam_sobie_udostepnic_kalendarza"));
        }
        calendarShareDto.setOwnerId(userName);
        auditParams.put("ownerId", calendarShareDto.getOwnerId());
        auditParams.put("shareUserId", calendarShareDto.getShareResourceId());
        auditParams.put("isGroup", calendarShareDto.getIsGroup());
        try {
            Long id = this.calendarShareService.addCalendarShare(calendarShareDto);
            auditParams.put("shareId", id);
            auditBuilder.params(auditParams).buildSuccess(request);
            return new RestResult(true);
        }
        catch (Exception e) {
            auditBuilder.params(auditParams).buildFailure(request);
            throw e;
        }
    }

    @RequestMapping(value={"shares/export/{extension}"}, method={RequestMethod.GET})
    @ResponseBody
    public void exportCalendarShares(HttpServletResponse response, @PathVariable String extension, @RequestParam(required=false, defaultValue="isGroup") String sortBy, @RequestParam(required=false, defaultValue="DESC") SortDirection sortDirection) throws IOException {
        List<CalendarShareDto> shares = this.calendarShareService.getCalendarSharesForOwner(UserContext.current().getUser().getUserName()).stream().sorted(DtoComparator.of(CalendarShareDto.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true)).collect(Collectors.toList());
        List<ExportColumn> columns = Arrays.asList(this.buildExportColumn(this.messageHelperBean.getMessage("Grupa"), shares, calendarShareDto -> this.messageHelperBean.getMessage(calendarShareDto.getIsGroup().toString().toLowerCase())), this.buildExportColumn(this.messageHelperBean.getMessage("Uzytkownik_grupa"), shares, CalendarShareDto::getShareResourceId));
        ExportModel model = ExportModel.builder().title(this.messageHelperBean.getMessage("Udostepnienia_kalendarza")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    private ExportColumn buildExportColumn(String name, List<CalendarShareDto> data, Function<CalendarShareDto, String> supplier) {
        return ExportColumnBuilder.create().name(name).data(data).by(supplier).build();
    }

    @ExceptionHandler(value={ServiceException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleServiceException(ServiceException e) {
        return new RestResult(false, e.getMessage());
    }
}

