/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.user.security;

import com.suncode.pwfl.administration.user.security.captcha.service.CaptchaService;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"captcha"})
public class CaptchaController {
    @Autowired
    private CaptchaService captchaService;

    @RequestMapping(value={"{captchaId}"}, method={RequestMethod.GET})
    public void generateCaptcha(HttpServletResponse response, @PathVariable(value="captchaId") String captchaId) {
        byte[] byteImage = this.captchaService.getCaptcha(captchaId);
        response.setContentType("image/jpeg");
        ServletOutputStream output = response.getOutputStream();
        output.write(byteImage);
        output.close();
    }

    @ResponseBody
    @RequestMapping(value={"validate"}, method={RequestMethod.POST})
    public ResponseEntity<?> validateCaptcha(@RequestParam(value="captcha") String captcha, @RequestParam(value="uuid") String captchaUuid) {
        if (this.captchaService.validateCaptcha(captchaUuid, captcha)) {
            return new ResponseEntity(HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.NOT_ACCEPTABLE);
    }
}

