/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.user;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.plusmpm.database.DBManagement;
import com.plusmpm.util.Authorization;
import com.suncode.pwfl.administration.archive.DocumentClassProtectionService;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.administration.user.UserGroupFinder;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.administration.user.exception.GroupAlreadyExistException;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.database.DBUtils;
import com.suncode.pwfl.datasource.rest.SortDto;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import com.suncode.pwfl.util.CollatorInstance;
import com.suncode.pwfl.web.dto.administration.GroupDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.util.JsonMessage;
import com.suncode.pwfl.workflow.activity.ActivityRedirectionService;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/groups"})
public class UserGroupController {
    private static final Logger log = LoggerFactory.getLogger(UserGroupController.class);
    private final UserGroupFinder groupFinder;
    private final UserFinder userFinder;
    private final UserService userService;
    private final ActivityRedirectionService activityRedirectionService;
    private final AuthorizationHelper authorizationHelper;
    private final TransactionWrapper transactionWrapper;
    private final ExportService exportService;
    private final MessageHelperBean messageHelper;
    private final DocumentClassProtectionService documentClassProtectionService;

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"query"})
    public CountedResult<UserGroup> getGroupsByQuery(@RequestParam(required=false) String query, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false) String sortBy) {
        DetachedCriteria dc = DetachedCriteria.forClass(UserGroup.class);
        if (StringUtils.isNotBlank((CharSequence)query)) {
            dc.add(Restrictions.ilike((String)"name", (String)query, (MatchMode)MatchMode.START));
        }
        long total = this.groupFinder.count(dc);
        try {
            if (StringUtils.isNotBlank((CharSequence)sortBy)) {
                SortDto[] sorters = this.parseJson(sortBy);
                this.addOrders(sorters, dc);
            }
        }
        catch (Exception e) {
            log.error("Couldn't add order to group list - error while parsing json.");
        }
        dc.setProjection(null);
        List groups = this.groupFinder.findByCriteria(dc, start, limit);
        return new CountedResult(total, groups);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"isGroupInRedirections"})
    public boolean isGroupInRedirections(@RequestParam String group) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List redirections = this.activityRedirectionService.getRedirectionsToGroup(group);
        return redirections.size() > 0;
    }

    @ResponseBody
    @RequestMapping(value={"query/extended"})
    public CountedResult<GroupDto> queryExtended(@RequestParam(required=false, defaultValue="") String nameQuery, @RequestParam(required=false, defaultValue="") String descriptionQuery, @RequestParam Integer start, @RequestParam Integer limit, @RequestParam(required=false, defaultValue="name") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        long count = this.groupFinder.count(this.createCriteria(nameQuery, descriptionQuery));
        DetachedCriteria criteria = this.createCriteria(nameQuery, descriptionQuery);
        return new CountedResult(count, this.fetchGroups(start, limit, sortBy, sortDirection, criteria));
    }

    @ResponseBody
    @RequestMapping(value={"query/extended/ilike"})
    public CountedResult<GroupDto> queryExtendedIlike(@RequestParam(required=false, defaultValue="") String nameQuery, @RequestParam(required=false, defaultValue="") String descriptionQuery, @RequestParam Integer start, @RequestParam Integer limit, @RequestParam(required=false, defaultValue="name") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        long count = this.groupFinder.count(this.createIlikeCriteria(nameQuery, descriptionQuery));
        DetachedCriteria criteria = this.createIlikeCriteria(nameQuery, descriptionQuery);
        return new CountedResult(count, this.fetchGroups(start, limit, sortBy, sortDirection, criteria));
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST})
    public JsonMessage create(HttpServletRequest request, @RequestBody GroupDto groupDto) {
        AuditBuilder builder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_GROUP).params((Map)ImmutableMap.of((Object)"groupName", (Object)groupDto.getName(), (Object)"groupDescr", (Object)groupDto.getDescription()));
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)builder.buildFailure()));
        UserGroup group = new UserGroup(groupDto.getName());
        group.setDescription(groupDto.getDescription());
        try {
            this.userService.createGroup(group);
        }
        catch (GroupAlreadyExistException e) {
            request.setAttribute("audit", (Object)builder.buildFailure());
            return new JsonMessage(false, this.messageHelper.getMessage("Taka_grupa_juz_istnieje"));
        }
        request.setAttribute("audit", (Object)builder.buildSuccess());
        return new JsonMessage();
    }

    @ResponseBody
    @RequestMapping(value={"{groupId}"}, method={RequestMethod.DELETE})
    public JsonMessage delete(HttpServletRequest request, @PathVariable Long groupId) {
        UserGroup group = this.userService.getGroup(groupId, new String[0]);
        String groupName = group.getName();
        AuditBuilder builder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_GROUP).params((Map)ImmutableMap.of((Object)"groupId", (Object)groupName));
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)builder.buildFailure()));
        JsonMessage result = (JsonMessage)this.transactionWrapper.doInHibernateTransaction(session -> {
            try {
                boolean userInOnlyOneGroup = this.userFinder.findByGroup(groupName).stream().anyMatch(user -> user.getGroups().size() <= 1);
                if (userInOnlyOneGroup) {
                    request.setAttribute("audit", (Object)builder.buildFailure());
                    return new JsonMessage(false, this.messageHelper.getMessage("group.delete.warning.user_only_in_this_group"));
                }
                this.userService.deleteGroup(groupName);
                Authorization.deleteRight((Session)session, (String)"System", (String)groupName, (boolean)true, (String[])new String[0]);
                DBManagement dbm = new DBManagement();
                dbm.deleteUserCalendarShareByShareUserId(groupName, session);
                dbm.deleteReportProtectionByShareUserId(groupName, true, session);
                dbm.deleteUserSearchViewProtectionByShareUserId(groupName, true, session);
                dbm.deleteNotificationRecipientById("group", groupName, session);
                this.documentClassProtectionService.deleteDocumentClassProtectionForResource(groupName, true);
                return new JsonMessage();
            }
            catch (Exception ex) {
                request.setAttribute("audit", (Object)builder.buildFailure());
                throw new RuntimeException(ex);
            }
        });
        if (result.isSuccess()) {
            request.setAttribute("audit", (Object)builder.buildSuccess());
        }
        return result;
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.PUT})
    public JsonMessage update(HttpServletRequest request, @RequestBody GroupDto groupDto) {
        AuditBuilder builder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_GROUP).params((Map)ImmutableMap.of((Object)"groupName", (Object)groupDto.getName(), (Object)"groupDescr", (Object)groupDto.getDescription()));
        JsonMessage result = (JsonMessage)this.transactionWrapper.doInHibernateTransaction(session -> {
            try {
                UserGroup group = this.userService.getGroup(groupDto.getId(), new String[0]);
                String oldDescription = group.getDescription() == null ? "" : group.getDescription();
                String groupDescriptionChange = oldDescription + " > " + groupDto.getDescription();
                builder.params((Map)ImmutableMap.of((Object)"groupName", (Object)groupDto.getName(), (Object)"groupDescr", (Object)groupDescriptionChange));
                this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)builder.buildFailure()));
                group.setName(groupDto.getName());
                group.setDescription(groupDto.getDescription());
                this.userService.updateGroup(group);
                return new JsonMessage();
            }
            catch (Exception ex) {
                request.setAttribute("audit", (Object)builder.buildFailure());
                throw new RuntimeException(ex);
            }
        });
        request.setAttribute("audit", (Object)builder.buildSuccess());
        return result;
    }

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(value={"users/importFromGroup"}, method={RequestMethod.POST})
    public void importFromGroupToGroup(HttpServletRequest request, @RequestParam Long baseGroupId, Long targetGroupId) {
        String baseGroupName = ((UserGroup)this.groupFinder.get((Serializable)baseGroupId)).getName();
        String targetGroupName = ((UserGroup)this.groupFinder.get((Serializable)targetGroupId)).getName();
        AuditBuilder builder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_IMPORT_USERS_FROM_GROUP_TO_GROUP).params((Map)ImmutableMap.of((Object)"baseGroupName", (Object)baseGroupName, (Object)"targetGroupName", (Object)targetGroupName));
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)builder.buildFailure()));
        TransactionWrapper.get().doInHibernateTransaction(addUserSession -> {
            try {
                for (User user : ((UserGroup)this.groupFinder.get((Serializable)baseGroupId)).getUsers()) {
                    this.userService.addUserToGroup(user.getUserName(), targetGroupName);
                }
            }
            catch (Exception ex) {
                request.setAttribute("audit", (Object)builder.buildFailure());
                throw new RuntimeException(ex);
            }
        });
        request.setAttribute("audit", (Object)builder.buildSuccess());
    }

    @RequestMapping(value={"export/{extension}"})
    public void export(HttpServletResponse response, @PathVariable String extension, @RequestParam(required=false, defaultValue="") String nameQuery, @RequestParam(required=false, defaultValue="") String descriptionQuery, @RequestParam(required=false, defaultValue="name") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        DetachedCriteria criteria = this.createCriteria(nameQuery, descriptionQuery);
        List<GroupDto> groups = this.fetchGroups(0, Integer.MAX_VALUE, sortBy, sortDirection, criteria);
        List<ExportColumn> columns = Arrays.asList(ExportColumnBuilder.create().name(this.messageHelper.getMessage("Nazwa")).data(groups).by(GroupDto::getName).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Opis")).data(groups).by(GroupDto::getDescription).build());
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Grupy")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    @ResponseBody
    @RequestMapping(value={"user"})
    public List<GroupDto> getGroupsForUser(@RequestParam Long userId) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.userService.getUser(userId, new String[]{"groups"}).getGroups().stream().map(GroupDto::fromDomain).sorted(Comparator.comparing(GroupDto::getName, CollatorInstance.get())).collect(Collectors.toList());
    }

    private SortDto[] parseJson(String sortBy) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        return (SortDto[])objectMapper.readValue(sortBy, SortDto[].class);
    }

    private void addOrders(SortDto[] sorters, DetachedCriteria dc) {
        for (SortDto sorter : sorters) {
            if (sorter.getDirection().equalsIgnoreCase("DESC")) {
                dc.addOrder(Order.desc((String)sorter.getProperty()));
                continue;
            }
            dc.addOrder(Order.asc((String)sorter.getProperty()));
        }
    }

    private List<GroupDto> fetchGroups(Integer start, Integer limit, String sortBy, SortDirection sortDirection, DetachedCriteria criteria) {
        criteria.addOrder(sortDirection == SortDirection.ASC ? Order.asc((String)sortBy) : Order.desc((String)sortBy));
        return this.groupFinder.findByCriteria(criteria, start, limit).stream().map(GroupDto::fromDomain).collect(Collectors.toList());
    }

    private DetachedCriteria createIlikeCriteria(String nameQuery, String descriptionQuery) {
        DetachedCriteria criteria = DetachedCriteria.forClass(UserGroup.class);
        Conjunction and = Restrictions.conjunction();
        if (StringUtils.isNotBlank((CharSequence)nameQuery)) {
            and.add(Restrictions.ilike((String)"name", (String)nameQuery.trim(), (MatchMode)MatchMode.ANYWHERE));
        }
        if (StringUtils.isNotBlank((CharSequence)descriptionQuery)) {
            and.add(Restrictions.ilike((String)"description", (String)descriptionQuery.trim(), (MatchMode)MatchMode.ANYWHERE));
        }
        criteria.add((Criterion)and);
        return criteria;
    }

    private DetachedCriteria createCriteria(String nameQuery, String descriptionQuery) {
        DetachedCriteria criteria = DetachedCriteria.forClass(UserGroup.class);
        DBUtils.filtersFrom((Map)ImmutableMap.of((Object)"name", (Object)nameQuery, (Object)"description", (Object)descriptionQuery)).forEach(filter -> criteria.add(filter.buildCriterion()));
        return criteria;
    }

    @ConstructorProperties(value={"groupFinder", "userFinder", "userService", "activityRedirectionService", "authorizationHelper", "transactionWrapper", "exportService", "messageHelper", "documentClassProtectionService"})
    @Autowired
    public UserGroupController(UserGroupFinder groupFinder, UserFinder userFinder, UserService userService, ActivityRedirectionService activityRedirectionService, AuthorizationHelper authorizationHelper, TransactionWrapper transactionWrapper, ExportService exportService, MessageHelperBean messageHelper, DocumentClassProtectionService documentClassProtectionService) {
        this.groupFinder = groupFinder;
        this.userFinder = userFinder;
        this.userService = userService;
        this.activityRedirectionService = activityRedirectionService;
        this.authorizationHelper = authorizationHelper;
        this.transactionWrapper = transactionWrapper;
        this.exportService = exportService;
        this.messageHelper = messageHelper;
        this.documentClassProtectionService = documentClassProtectionService;
    }
}

