/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.email;

import com.google.common.collect.ImmutableMap;
import com.suncode.pwfl.administration.email.EmailMessage;
import com.suncode.pwfl.administration.email.EmailService;
import com.suncode.pwfl.administration.email.configuration.EmailConfiguration;
import com.suncode.pwfl.administration.email.configuration.EmailConfigurationService;
import com.suncode.pwfl.administration.email.oauth.connection.ConnectionRefreshException;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.translation.TranslationService;
import com.suncode.pwfl.translation.TranslatorScope;
import com.suncode.pwfl.web.dto.administration.email.EmailConfigurationDto;
import com.suncode.pwfl.web.dto.administration.email.TestResultDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/email/config"})
public class EmailConfigurationController {
    private static final Logger log = LoggerFactory.getLogger(EmailConfigurationController.class);
    @Autowired
    private EmailConfigurationService emailConfigurationService;
    @Autowired
    private AuthorizationHelper authorizationHelper;
    @Autowired
    private TranslationService translationService;
    @Autowired
    private EmailService emailService;

    @ResponseBody
    @RequestMapping(value={""}, method={RequestMethod.POST})
    public EmailConfigurationDto createNew(@RequestBody EmailConfigurationDto emailConfigurationDto, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_EMAIL_CONFIGURATION);
        auditBuilder.params((Map)this.emailConfigAuditParamsBuilder(emailConfigurationDto).build());
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            Long id = (Long)this.emailConfigurationService.save((Object)emailConfigurationDto.toEntity());
            if (emailConfigurationDto.isBufferSender()) {
                this.emailService.startTimer((EmailConfiguration)this.emailConfigurationService.get((Serializable)id));
            }
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return emailConfigurationDto;
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @ResponseBody
    @RequestMapping(value={""}, method={RequestMethod.GET})
    public List<EmailConfigurationDto> getAll() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.emailConfigurationService.getAll(new String[]{"oauth2Connection"}).stream().map(EmailConfigurationDto::new).collect(Collectors.toList());
    }

    @ResponseBody
    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<EmailConfigurationDto> getById(@PathVariable long id) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        EmailConfiguration emailConfiguration = (EmailConfiguration)this.emailConfigurationService.get((Serializable)Long.valueOf(id), new String[]{"oauth2Connection"});
        if (emailConfiguration == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)new EmailConfigurationDto(emailConfiguration), HttpStatus.OK);
    }

    @ResponseBody
    @RequestMapping(value={""}, method={RequestMethod.PATCH})
    public void update(@RequestBody EmailConfigurationDto emailConfigurationDto, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_EMAIL_CONFIGURATION);
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            EmailConfiguration emailConfiguration = (EmailConfiguration)this.emailConfigurationService.get((Serializable)emailConfigurationDto.getId(), new String[]{"oauth2Connection"});
            auditBuilder.params((Map)this.emailConfigChangeAuditParamsBuilder(emailConfiguration, emailConfigurationDto).build());
            this.emailConfigurationService.update((Object)emailConfigurationDto.toEntity());
            if (emailConfiguration.getBufferedSender().booleanValue() != emailConfigurationDto.isBufferSender() || emailConfiguration.getPeriod().intValue() != emailConfigurationDto.getPeriod()) {
                EmailConfiguration updatedEmailConfiguration = (EmailConfiguration)this.emailConfigurationService.get((Serializable)emailConfigurationDto.getId());
                if (emailConfigurationDto.isBufferSender()) {
                    this.emailService.startTimer(updatedEmailConfiguration);
                } else {
                    this.emailService.stopTimer(updatedEmailConfiguration);
                }
            }
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
    }

    @ResponseBody
    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<?> delete(@PathVariable Long id, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_EMAIL_CONFIGURATION);
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        auditBuilder.params((Map)ImmutableMap.of((Object)"EMAIL_CONFIGURATION_ID", (Object)id));
        try {
            EmailConfiguration emailConfiguration = (EmailConfiguration)this.emailConfigurationService.get((Serializable)id);
            if (emailConfiguration.getDefaultConfiguration().booleanValue()) {
                request.setAttribute("audit", (Object)auditBuilder.buildFailure());
                return new ResponseEntity(HttpStatus.BAD_REQUEST);
            }
            this.emailService.stopTimer(emailConfiguration);
            this.emailConfigurationService.delete((Object)emailConfiguration);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new ResponseEntity(HttpStatus.OK);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @ResponseBody
    @RequestMapping(value={"test"}, method={RequestMethod.POST})
    public TestResultDto test(@RequestBody EmailConfigurationDto emailConfigurationDto, @RequestParam String sendTo, @RequestParam String subject, @RequestParam String content) {
        String errorMessage = null;
        try {
            EmailMessage emailMessage = EmailMessage.builder().recipient(sendTo).subject(subject).content(content).isHtml(false).test(true).build();
            this.emailService.send(emailMessage, emailConfigurationDto.toEntity());
        }
        catch (ConnectionRefreshException connectionRefreshException) {
            errorMessage = this.translationService.translate("oauth_refresh_error", TranslatorScope.SERVER);
            log.error("B\u0142\u0105d podczas testowania konfiguracji email", (Throwable)connectionRefreshException);
        }
        catch (Exception e) {
            errorMessage = this.translationService.translate("email_default_error_message", TranslatorScope.SERVER);
            log.error("B\u0142\u0105d podczas testowania konfiguracji email", (Throwable)e);
        }
        return new TestResultDto(errorMessage);
    }

    private ImmutableMap.Builder<String, Object> emailConfigAuditParamsBuilder(EmailConfigurationDto emailConfigurationDto) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"EMAIL_CONFIGURATION_ID", (Object)Objects.toString(emailConfigurationDto.getId(), "")).put((Object)"EMAIL_CONFIGURATION_NAME", (Object)Objects.toString(emailConfigurationDto.getName(), "")).put((Object)"EMAIL_CONFIGURATION_EMAIL", (Object)Objects.toString(emailConfigurationDto.getEmail(), "")).put((Object)"EMAIL_CONFIGURATION_DEFAULT_CONFIGURATION", (Object)Objects.toString(emailConfigurationDto.isDefaultConfiguration(), "")).put((Object)"EMAIL_CONFIGURATION_MAIL_SERVER", (Object)Objects.toString(emailConfigurationDto.getMailServer(), "")).put((Object)"EMAIL_CONFIGURATION_SMTP_MAIL_SERVER", (Object)Objects.toString(emailConfigurationDto.getSmtpMailServer(), "")).put((Object)"EMAIL_CONFIGURATION_SMTP_PORT_NUMBER", (Object)Objects.toString(emailConfigurationDto.getSmtpPortNumber(), "")).put((Object)"EMAIL_CONFIGURATION_SOURCE_ADDRESS", (Object)Objects.toString(emailConfigurationDto.getSourceAddress(), "")).put((Object)"EMAIL_CONFIGURATION_TIMEOUT", (Object)Objects.toString(emailConfigurationDto.getTimeout(), "")).put((Object)"EMAIL_CONFIGURATION_MAIL_USER", (Object)Objects.toString(emailConfigurationDto.getMailUser(), "")).put((Object)"EMAIL_CONFIGURATION_USE_SSL", (Object)Objects.toString(emailConfigurationDto.isUseSSL(), "")).put((Object)"EMAIL_CONFIGURATION_USE_STARTTLS", (Object)Objects.toString(emailConfigurationDto.isUseStartTLS(), "")).put((Object)"EMAIL_CONFIGURATION_SMTP_USER", (Object)Objects.toString(emailConfigurationDto.getSmtpUser(), "")).put((Object)"EMAIL_CONFIGURATION_DEBUG", (Object)Objects.toString(emailConfigurationDto.isDebug(), "")).put((Object)"EMAIL_CONFIGURATION_EMAIL_AUTHENTICATION_METHOD", (Object)Objects.toString(emailConfigurationDto.getEmailAuthenticationMethod(), "")).put((Object)"EMAIL_CONFIGURATION_BUFFERED_SENDER", (Object)Objects.toString(emailConfigurationDto.isBufferSender(), "")).put((Object)"EMAIL_CONFIGURATION_MAX_ATTEMPTS", (Object)Objects.toString(emailConfigurationDto.getMaxAttempts(), "")).put((Object)"EMAIL_CONFIGURATION_PERIOD", (Object)Objects.toString(emailConfigurationDto.getPeriod(), "")).put((Object)"EMAIL_CONFIGURATION_TRY_AFTER", (Object)Objects.toString(emailConfigurationDto.getTryAfter(), "")).put((Object)"EMAIL_CONFIGURATION_SEND_COPY", (Object)Objects.toString(emailConfigurationDto.getSendCopy(), "")).put((Object)"EMAIL_CONFIGURATION_SEND_COPY_RECIPIENTS", (Object)Objects.toString(emailConfigurationDto.getSendCopyRecipients(), "")).put((Object)"EMAIL_CONFIGURATION_SEND_COPY_RECIPIENTS_TYPE", (Object)Objects.toString(emailConfigurationDto.getSendCopyRecipientsType(), ""));
        if (emailConfigurationDto.getOauth2Connection() != null) {
            builder.put((Object)"OAUTH2_CONNECTION_ID", (Object)Objects.toString(emailConfigurationDto.getOauth2Connection().getId(), ""));
        }
        return builder;
    }

    private ImmutableMap.Builder<String, Object> emailConfigChangeAuditParamsBuilder(EmailConfiguration oldConfiguration, EmailConfigurationDto newConfiguration) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"EMAIL_CONFIGURATION_ID", (Object)this.generateChangeString(oldConfiguration.getId(), newConfiguration.getId())).put((Object)"EMAIL_CONFIGURATION_NAME", (Object)this.generateChangeString(oldConfiguration.getName(), newConfiguration.getName())).put((Object)"EMAIL_CONFIGURATION_EMAIL", (Object)this.generateChangeString(oldConfiguration.getEmail(), newConfiguration.getEmail())).put((Object)"EMAIL_CONFIGURATION_DEFAULT_CONFIGURATION", (Object)this.generateChangeString(oldConfiguration.getDefaultConfiguration(), newConfiguration.isDefaultConfiguration())).put((Object)"EMAIL_CONFIGURATION_MAIL_SERVER", (Object)this.generateChangeString(oldConfiguration.getMailServer(), newConfiguration.getMailServer())).put((Object)"EMAIL_CONFIGURATION_SMTP_MAIL_SERVER", (Object)this.generateChangeString(oldConfiguration.getSmtpMailServer(), newConfiguration.getSmtpMailServer())).put((Object)"EMAIL_CONFIGURATION_SMTP_PORT_NUMBER", (Object)this.generateChangeString(oldConfiguration.getSmtpPortNumber(), newConfiguration.getSmtpPortNumber())).put((Object)"EMAIL_CONFIGURATION_SOURCE_ADDRESS", (Object)this.generateChangeString(oldConfiguration.getSourceAddress(), newConfiguration.getSourceAddress())).put((Object)"EMAIL_CONFIGURATION_TIMEOUT", (Object)this.generateChangeString(oldConfiguration.getTimeout(), newConfiguration.getTimeout())).put((Object)"EMAIL_CONFIGURATION_MAIL_USER", (Object)this.generateChangeString(oldConfiguration.getMailServer(), newConfiguration.getMailServer())).put((Object)"EMAIL_CONFIGURATION_USE_SSL", (Object)this.generateChangeString(oldConfiguration.getUseSSL(), newConfiguration.isUseSSL())).put((Object)"EMAIL_CONFIGURATION_USE_STARTTLS", (Object)this.generateChangeString(oldConfiguration.getUseStartTLS(), newConfiguration.isUseStartTLS())).put((Object)"EMAIL_CONFIGURATION_SMTP_USER", (Object)this.generateChangeString(oldConfiguration.getSmtpUser(), newConfiguration.getSmtpUser())).put((Object)"EMAIL_CONFIGURATION_DEBUG", (Object)this.generateChangeString(oldConfiguration.getDebug(), newConfiguration.isDebug())).put((Object)"EMAIL_CONFIGURATION_EMAIL_AUTHENTICATION_METHOD", (Object)this.generateChangeString(oldConfiguration.getEmailAuthenticationMethod(), newConfiguration.getEmailAuthenticationMethod())).put((Object)"EMAIL_CONFIGURATION_BUFFERED_SENDER", (Object)this.generateChangeString(oldConfiguration.getBufferedSender(), newConfiguration.isBufferSender())).put((Object)"EMAIL_CONFIGURATION_MAX_ATTEMPTS", (Object)this.generateChangeString(oldConfiguration.getMaxAttempts(), newConfiguration.getMaxAttempts())).put((Object)"EMAIL_CONFIGURATION_PERIOD", (Object)this.generateChangeString(oldConfiguration.getPeriod(), newConfiguration.getPeriod())).put((Object)"EMAIL_CONFIGURATION_TRY_AFTER", (Object)this.generateChangeString(oldConfiguration.getTryAfter(), newConfiguration.getTryAfter())).put((Object)"EMAIL_CONFIGURATION_SEND_COPY", (Object)this.generateChangeString(oldConfiguration.getSendCopy(), newConfiguration.getSendCopy())).put((Object)"EMAIL_CONFIGURATION_SEND_COPY_RECIPIENTS", (Object)this.generateChangeString(oldConfiguration.getSendCopyRecipients(), newConfiguration.getSendCopyRecipients())).put((Object)"EMAIL_CONFIGURATION_SEND_COPY_RECIPIENTS_TYPE", (Object)this.generateChangeString(oldConfiguration.getSendCopyRecipientsType(), newConfiguration.getSendCopyRecipientsType()));
        Long oldConnectionId = oldConfiguration.getOauth2Connection() != null ? oldConfiguration.getOauth2Connection().getId() : null;
        Long newConnectionId = newConfiguration.getOauth2Connection() != null ? newConfiguration.getOauth2Connection().getId() : null;
        builder.put((Object)"OAUTH2_CONNECTION_ID", (Object)this.generateChangeString(oldConnectionId, newConnectionId));
        return builder;
    }

    private String generateChangeString(Object oldValue, Object newValue) {
        String oldValueString = Objects.toString(oldValue, "");
        String newValueString = Objects.toString(newValue, "");
        return oldValueString + ";" + newValueString;
    }
}

