/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.datasources;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.suncode.pwfl.component.exception.InvalidComponentException;
import com.suncode.pwfl.datasource.DataSourceCacheExpiredException;
import com.suncode.pwfl.datasource.DataSourceDeclarationDto;
import com.suncode.pwfl.datasource.DataSourceDefinitionDto;
import com.suncode.pwfl.datasource.DataSourceDto;
import com.suncode.pwfl.datasource.DataSourceInstance;
import com.suncode.pwfl.datasource.DataSourceOperation;
import com.suncode.pwfl.datasource.DataSourceService;
import com.suncode.pwfl.datasource.DataSourceValidateException;
import com.suncode.pwfl.datasource.InvocableDataSource;
import com.suncode.pwfl.datasource.TemporaryDataSourceExecutor;
import com.suncode.pwfl.datasource.dao.DataSourceDeclaration;
import com.suncode.pwfl.datasource.declaration.DataSourceReader;
import com.suncode.pwfl.datasource.rest.CountedResultDto;
import com.suncode.pwfl.datasource.rest.DataSourceExportDto;
import com.suncode.pwfl.datasource.rest.DataSourceTree;
import com.suncode.pwfl.datasource.rest.DataSourceTypeDto;
import com.suncode.pwfl.datasource.rest.SortDto;
import com.suncode.pwfl.datasource.rest.TemporaryDataSource;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.FilterOperator;
import com.suncode.pwfl.search.LogicOperator;
import com.suncode.pwfl.search.Pagination;
import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.search.hibernate.GroupHibernateFilter;
import com.suncode.pwfl.search.hibernate.HibernateFilter;
import com.suncode.pwfl.search.hibernate.SimpleHibernateFilter;
import com.suncode.pwfl.util.PaginatedList;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.ajax.EntityRestResult;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.web.support.io.DownloadResource;
import com.suncode.pwfl.workflow.component.WorkflowComponentRegistry;
import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/datasources"})
public class DataSourceController {
    private static final Logger log = LoggerFactory.getLogger(DataSourceController.class);
    private final WorkflowComponentRegistry registry;
    private final DataSourceService dataSourceService;
    private final DataSourceReader reader;
    private final TemporaryDataSourceExecutor temporaryDataSourceExecutor;
    private final MessageHelperBean messageHelper;
    private final AuthorizationHelper authorizationHelper;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private static final ConcurrentMap<UUID, InputStream> oneTimeFiles = new ConcurrentHashMap<UUID, InputStream>();

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<DataSourceDeclarationDto> getDataSources(@RequestParam(value="operations", required=false) List<String> rawOperations, @RequestParam(required=false) String query, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, SortDto sort) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        Sorter sorter = sort.getSorter();
        if (sorter == null) {
            sorter = new Sorter("name");
        }
        GroupHibernateFilter filters = new GroupHibernateFilter(LogicOperator.AND);
        if (!CollectionUtils.isEmpty(rawOperations)) {
            List operations = rawOperations.stream().map(operation -> DataSourceOperation.valueOf((String)operation.toUpperCase())).collect(Collectors.toList());
            GroupHibernateFilter operationsFilter = new GroupHibernateFilter(LogicOperator.OR);
            operationsFilter.addFilter((HibernateFilter)new SimpleHibernateFilter("operation", (Object)FilterOperator.ISNULL));
            operationsFilter.addFilter((HibernateFilter)new SimpleHibernateFilter("operation", operations, FilterOperator.IN));
            filters.addFilter((HibernateFilter)operationsFilter);
        }
        if (StringUtils.isNotBlank((CharSequence)query)) {
            GroupHibernateFilter queryFilters = new GroupHibernateFilter(LogicOperator.OR);
            queryFilters.addFilter((HibernateFilter)new SimpleHibernateFilter("id", (Object)("%" + query + "%"), FilterOperator.ILIKE));
            queryFilters.addFilter((HibernateFilter)new SimpleHibernateFilter("name", (Object)("%" + query + "%"), FilterOperator.ILIKE));
            queryFilters.addFilter((HibernateFilter)new SimpleHibernateFilter("description", (Object)query, FilterOperator.ILIKE));
            filters.addFilter((HibernateFilter)queryFilters);
        }
        CountedResult declarations = this.dataSourceService.getDeclarations((HibernateFilter)filters, Pagination.create((Sorter)sorter, (Integer)0, (Integer)0));
        List dtos = declarations.getData().stream().filter(declaration -> {
            InvocableDataSource dataSource = this.registry.getDataSource(declaration.getType());
            if (dataSource == null) {
                return false;
            }
            if (declaration.getOperation() != null) {
                return true;
            }
            if (CollectionUtils.isEmpty((Collection)dataSource.getOperations()) || CollectionUtils.isEmpty((Collection)rawOperations)) {
                return true;
            }
            for (String operation : rawOperations) {
                if (!dataSource.getOperations().contains(DataSourceOperation.valueOf((String)operation.toUpperCase()))) continue;
                return true;
            }
            return false;
        }).map(DataSourceDeclarationDto::new).collect(Collectors.toList());
        return new CountedResult((long)dtos.size(), new PaginatedList(dtos, limit).getRange(start));
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.GET})
    @Transactional
    @ResponseBody
    public DataSourceDto getDataSource(@PathVariable String id) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        DataSourceDeclaration declaration = this.dataSourceService.getDeclaration(id);
        DataSourceInstance instance = this.dataSourceService.getDataSource(id);
        return new DataSourceDto(new DataSourceDeclarationDto(declaration), instance.getInputParameters(), instance.getOutputParameters());
    }

    @RequestMapping(value={"tree"}, method={RequestMethod.GET})
    @ResponseBody
    public DataSourceTree getDataSources() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List components = this.registry.getDataSources();
        List declarations = this.dataSourceService.getDeclarations();
        List dtos = declarations.stream().filter(declaration -> components.stream().anyMatch(component -> component.getId().equals(declaration.getType()))).map(DataSourceDeclarationDto::new).collect(Collectors.toList());
        return new DataSourceTree(dtos, this.registry);
    }

    @RequestMapping(value={"declaration/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public DataSourceDeclarationDto read(@PathVariable String id) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return new DataSourceDeclarationDto(this.dataSourceService.getDeclaration(id));
    }

    @RequestMapping(value={"declaration/create"}, method={RequestMethod.POST})
    @ResponseBody
    public RestResult create(String form) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        DataSourceDeclaration dataSourcedeclaration = this.reader.readDataSource(form);
        String id = dataSourcedeclaration.getId();
        if (this.registry.getDataSource(dataSourcedeclaration.getType()) == null) {
            return new RestResult(false, this.messageHelper.getMessage("datasources-type-notexists", new Object[]{dataSourcedeclaration.getType()}));
        }
        if (this.dataSourceExists(id)) {
            return new RestResult(false, this.messageHelper.getMessage("Zrodlo_danych_istnieje", new Object[]{id}));
        }
        try {
            this.dataSourceService.addDeclaration(dataSourcedeclaration);
        }
        catch (DataSourceValidateException e) {
            return new RestResult(false, e.getMessage());
        }
        return new RestResult(true, this.messageHelper.getMessage("Pomyslnie_utworzono_zrodlo_danych"));
    }

    private boolean dataSourceExists(String id) {
        return this.dataSourceService.getDeclaration(id) != null;
    }

    @RequestMapping(value={"declaration/update"}, method={RequestMethod.POST})
    @ResponseBody
    public RestResult save(String form) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        DataSourceDeclaration declarationToSave = this.reader.readDataSource(form);
        try {
            this.dataSourceService.updateDeclaration(declarationToSave);
        }
        catch (DataSourceValidateException e) {
            return new RestResult(false, e.getMessage());
        }
        return new RestResult(true, this.messageHelper.getMessage("Pomyslnie_zapisano_zrodlo_danych"));
    }

    @RequestMapping(value={"declaration/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void delete(@PathVariable String id) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        this.dataSourceService.removeDeclaration(this.dataSourceService.getDeclaration(id));
    }

    @RequestMapping(value={"definitions"}, method={RequestMethod.GET})
    @ResponseBody
    public List<DataSourceTypeDto> getTypes(@RequestParam(required=false) String query, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List components = this.registry.getDataSources().stream().filter(component -> !component.isDeprecated() && this.isDataSourceMatchesQuery((InvocableDataSource)component, query)).sorted((c1, c2) -> c1.getName().compareToIgnoreCase(c2.getName())).collect(Collectors.toList());
        return new PaginatedList(components.stream().map(dataSource -> new DataSourceTypeDto(dataSource.getId(), dataSource.getName(), dataSource.getDescription())).collect(Collectors.toList()), limit).getRange(start);
    }

    private boolean isDataSourceMatchesQuery(InvocableDataSource dataSource, String query) {
        if (StringUtils.isBlank((CharSequence)query)) {
            return true;
        }
        if (dataSource.getId().toLowerCase().contains(query.toLowerCase())) {
            return true;
        }
        if (dataSource.getName().toLowerCase().contains(query.toLowerCase())) {
            return true;
        }
        return dataSource.getDescription().toLowerCase().contains(query.toLowerCase());
    }

    @RequestMapping(value={"definition/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public DataSourceDefinitionDto getType(@PathVariable String id) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        InvocableDataSource component = this.registry.getDataSource(id);
        if (component == null) {
            return null;
        }
        return new DataSourceDefinitionDto(component);
    }

    @RequestMapping(value={"declarations/export/all"}, method={RequestMethod.POST})
    @Transactional
    @ResponseBody
    public String exportDeclarations() throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        HashSet declarationsDto = Sets.newHashSet();
        this.dataSourceService.getDeclarations().forEach(declaration -> declarationsDto.add(new DataSourceDeclarationDto(declaration)));
        return this.exportDeclarationsToStream(declarationsDto);
    }

    @RequestMapping(value={"declarations/export"}, method={RequestMethod.POST})
    @Transactional
    @ResponseBody
    public String exportDeclarations(@RequestBody List<DataSourceExportDto> exportResources) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        HashSet declarationsDto = Sets.newHashSet();
        exportResources.forEach(resource -> {
            if (resource.isDefinition()) {
                this.dataSourceService.getDeclarations(resource.getId()).forEach(declaration -> declarationsDto.add(new DataSourceDeclarationDto(declaration)));
            } else {
                DataSourceDeclaration declaration2 = this.dataSourceService.getDeclaration(resource.getId());
                if (declaration2 != null) {
                    declarationsDto.add(new DataSourceDeclarationDto(declaration2));
                }
            }
        });
        return this.exportDeclarationsToStream(declarationsDto);
    }

    private String exportDeclarationsToStream(Set<DataSourceDeclarationDto> declarations) throws JsonProcessingException {
        ByteArrayInputStream is = new ByteArrayInputStream(this.objectMapper.writeValueAsBytes(declarations));
        UUID id = UUID.randomUUID();
        oneTimeFiles.put(id, is);
        return id.toString();
    }

    @RequestMapping(value={"declarations/download/{uuid}"}, method={RequestMethod.GET})
    @ResponseBody
    public DownloadResource download(@PathVariable String uuid) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        UUID id = UUID.fromString(uuid);
        InputStream is = (InputStream)oneTimeFiles.remove(id);
        if (is == null) {
            throw new HttpServerErrorException(HttpStatus.NOT_FOUND);
        }
        return new DownloadResource("datasources.json", (long)is.available(), is);
    }

    @RequestMapping(value={"declarations/import"}, method={RequestMethod.POST}, produces={"text/html;charset=UTF-8"})
    @Transactional
    @ResponseBody
    public String importDeclarations(@RequestParam(value="file") MultipartFile file, @RequestParam(value="overwrite", required=false) boolean overwrite) throws JsonProcessingException {
        String message;
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        boolean success = true;
        try {
            String json = IOUtils.toString((InputStream)file.getInputStream(), (String)StandardCharsets.UTF_8.name());
            List declarations = this.reader.readDataSources(json);
            log.info("Read {} datasources from file", (Object)declarations.size());
            AtomicInteger numberOfImportedSources = new AtomicInteger(0);
            AtomicInteger numberOfOverwrittenSources = new AtomicInteger(0);
            declarations.forEach(declaration -> {
                log.info("Try to import datasource [{}]", (Object)declaration.getId());
                if (this.registry.getDataSource(declaration.getType()) != null) {
                    boolean dataSourceExists = this.dataSourceExists(declaration.getId());
                    if (!dataSourceExists) {
                        this.dataSourceService.addDeclaration(declaration);
                        numberOfImportedSources.incrementAndGet();
                        log.info("Datasource [{}] was imported.", (Object)declaration.getId());
                    } else if (overwrite) {
                        this.dataSourceService.updateDeclaration(declaration);
                        numberOfOverwrittenSources.incrementAndGet();
                        log.info("Datasource [{}] was overwritten.", (Object)declaration.getId());
                    } else {
                        log.info("Datasource [{}] has already been added. Skip.", (Object)declaration.getId());
                    }
                } else {
                    log.info("Datasource of type [{}] is not registered. Cannot  add declaration [{}].", (Object)declaration.getType(), (Object)declaration.getId());
                }
            });
            log.info("{} datasources was imported.", (Object)numberOfImportedSources.get());
            message = this.messageHelper.getMessage("datasources-import-success", new Object[]{numberOfImportedSources.get()});
            if (overwrite) {
                log.info("{} datasources was overwritten.", (Object)numberOfOverwrittenSources.get());
                message = message + "[br]" + this.messageHelper.getMessage("datasources-overwrite-success", new Object[]{numberOfOverwrittenSources.get()});
            }
        }
        catch (InvalidComponentException | IOException e) {
            success = false;
            message = this.messageHelper.getMessage("datasources-import-invalid-file");
            log.error(e.getMessage(), e);
        }
        return this.objectMapper.writeValueAsString((Object)new RestResult(success, message));
    }

    @RequestMapping(value={"temporary/create"}, method={RequestMethod.POST})
    @ResponseBody
    public EntityRestResult<TemporaryDataSource> cacheAndGetParameters(@RequestParam String form) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        try {
            DataSourceDeclaration declaration = this.reader.readDataSource(form);
            EntityRestResult result = new EntityRestResult(true);
            result.setEntity((Object)this.temporaryDataSourceExecutor.executeDataSource(declaration));
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new EntityRestResult(false, this.messageHelper.getMessage("datasources-execute-exception"));
        }
    }

    @RequestMapping(value={"temporary/{uuid}/{operation}"}, method={RequestMethod.POST})
    @ResponseBody
    public RestResult executeDataSourceModification(@PathVariable String uuid, @PathVariable String operation, @RequestBody MultiValueMap<String, String> parameters) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        String message = "";
        try {
            this.temporaryDataSourceExecutor.executeDataSourceModification(uuid, DataSourceOperation.valueOf((String)operation.toUpperCase()), parameters.toSingleValueMap());
            return new RestResult(true, message);
        }
        catch (DataSourceCacheExpiredException e) {
            message = this.messageHelper.getMessage("datasources-cache-expired");
            log.info(e.getMessage());
        }
        catch (Exception e) {
            message = this.messageHelper.getMessage("Nieznany_blad") + "<br>" + e.getMessage();
            log.error(e.getMessage(), (Throwable)e);
        }
        return new RestResult(false, message);
    }

    @RequestMapping(value={"temporary/{uuid}/data"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResultDto<Map<String, Object>> getDataSourceData(@PathVariable String uuid, @RequestParam Integer start, @RequestParam Integer limit, SortDto sort) {
        if (sort.getProperty() == null) {
            return new CountedResultDto(0L, (List)Lists.newArrayList(), false, this.messageHelper.getMessage("Brak_zdefiniowanych_parametrow_wyjsciowych"));
        }
        String message = "";
        try {
            CountedResult result = this.temporaryDataSourceExecutor.getDataSourceData(uuid, Pagination.create((Sorter)sort.getSorter(), (Integer)start, (Integer)limit));
            return new CountedResultDto(result.getTotal(), result.getData(), true, message);
        }
        catch (DataSourceCacheExpiredException e) {
            message = this.messageHelper.getMessage("datasources-cache-expired");
            log.info(e.getMessage());
        }
        catch (Exception e) {
            message = this.messageHelper.getMessage("Nieznany_blad") + "<br>" + e.getMessage();
            log.error(e.getMessage(), (Throwable)e);
        }
        return new CountedResultDto(0L, (List)Lists.newArrayList(), false, message);
    }

    @RequestMapping(value={"temporary/{uuid}/remove"}, method={RequestMethod.DELETE})
    @ResponseBody
    public RestResult removeTemporarySourceData(@PathVariable String uuid) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        this.temporaryDataSourceExecutor.removeDataSource(uuid);
        return new RestResult(true, "");
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNotFullRightsException(NotFullRightsException e) {
        log.info(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }

    @ConstructorProperties(value={"registry", "dataSourceService", "reader", "temporaryDataSourceExecutor", "messageHelper", "authorizationHelper"})
    @Autowired
    public DataSourceController(WorkflowComponentRegistry registry, DataSourceService dataSourceService, DataSourceReader reader, TemporaryDataSourceExecutor temporaryDataSourceExecutor, MessageHelperBean messageHelper, AuthorizationHelper authorizationHelper) {
        this.registry = registry;
        this.dataSourceService = dataSourceService;
        this.reader = reader;
        this.temporaryDataSourceExecutor = temporaryDataSourceExecutor;
        this.messageHelper = messageHelper;
        this.authorizationHelper = authorizationHelper;
    }
}

