/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.i18n.I18N;
import com.plusmpm.i18n.I18Nxpdl;
import com.plusmpm.struts.action.AdvanceProcessSearchAction;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.Tools;
import com.suncode.pwfl.audit.AuditWrapper;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbortActivityAction
extends Action {
    private static final Logger log = LoggerFactory.getLogger(AbortActivityAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        log.info("******************************AbortActivityAction********************");
        HttpSession session = request.getSession(false);
        I18N oMessage = new I18N(request);
        String processId = "";
        String procDefId = "";
        String processName = "";
        String packageId = "";
        String activityId = "";
        String activityName = "";
        HashMap<String, Object> activityAuditParams = new HashMap<String, Object>();
        try {
            String rightLevel;
            String userName = (String)session.getAttribute("username");
            if (session == null || userName == null) {
                return mapping.findForward("welcome");
            }
            processId = request.getParameter("ProcessId");
            activityId = request.getParameter("ActivityId");
            activityAuditParams.put("ProcessId", processId);
            activityAuditParams.put("ActivityId", activityId);
            ActivityService activityService = ServiceFactory.getActivityService();
            ProcessService processService = ServiceFactory.getProcessService();
            Activity activity = activityService.getActivity(processId, activityId, new String[0]);
            I18Nxpdl xpdl = new I18Nxpdl(request);
            Process process = processService.getProcess(processId, new String[]{"processDefinition"});
            procDefId = process.getProcessDefinition().getProcessDefinitionId();
            packageId = process.getProcessDefinition().getPackageId();
            activityName = activity.getName();
            processName = process.getRawName();
            String realProcessName = Tools.getProcessName((I18Nxpdl)xpdl, (String)processName, (String)procDefId);
            List openedActivities = FinderFactory.getActivityFinder().findOpenedActivities(processId);
            if (openedActivities.size() == 1 && ((Activity)openedActivities.get(0)).getActivityId().equals(activityId) && Authorization.checkRight((String)(rightLevel = RightTreeBuilder.builder().system().workflow().processes().delete().custom((Object)procDefId).build()), (String)userName, (boolean)false, (boolean)false) != 0) {
                log.info("Nie mo\u017cna anulowa\u0107 procesu z powodu braku uprawnie\u0144 u\u017cytkownika");
                String message = MessageHelper.getMessage((String)"Brak_uprawnien_aby_anulowac_proces");
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("ERROR_MESSAGE", message);
                params.put("processId", processId);
                params.put("package_name", packageId);
                params.put("processDefId", procDefId);
                params.put("process_name", processName);
                AuditWrapper auditWrapper = this.buildProcessAbortAudit(false, params);
                return this.getActionForwardUnsuccessful(mapping, form, request, response, session, message, auditWrapper);
            }
            activityService.abort(processId, activityId);
            session.setAttribute("processaction", (Object)"success");
            session.setAttribute("message", (Object)("" + oMessage.getString("Zadanie") + " " + activityName + " " + oMessage.getString("z_procesu") + " " + realProcessName + " " + oMessage.getString("zostalo_anulowane") + ""));
            request.setAttribute("auditSuccess", (Object)true);
            request.setAttribute("audit", (Object)this.buildActivityAbortAudit(true, activityAuditParams));
        }
        catch (Exception e) {
            log.warn("Exception:" + e.getLocalizedMessage());
            String message = oMessage.getString("Blad_anulowania_zadania") + " " + activityName + ". " + oMessage.getString("Przyczyna") + ":" + e.getLocalizedMessage();
            session.setAttribute("message", (Object)message);
            AuditWrapper auditWrapper = this.buildActivityAbortAudit(false, activityAuditParams);
            return this.getActionForwardUnsuccessful(mapping, form, request, response, session, message, auditWrapper);
        }
        AdvanceProcessSearchAction advanceProcessSearchAction = new AdvanceProcessSearchAction();
        return advanceProcessSearchAction.execute(mapping, form, request, response);
    }

    private ActionForward getActionForwardUnsuccessful(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, HttpSession session, String message, AuditWrapper auditWrapper) {
        session.setAttribute("processaction", (Object)"error");
        session.setAttribute("message", (Object)message);
        request.setAttribute("audit", (Object)auditWrapper);
        AdvanceProcessSearchAction advanceProcessSearchAction = new AdvanceProcessSearchAction();
        return advanceProcessSearchAction.execute(mapping, form, request, response);
    }

    private AuditWrapper buildActivityAbortAudit(boolean success, Map<String, Object> params) {
        return AuditBuilder.getInstance().type(AuditTypes.AUDIT_ABORT_ACTIVITY).success(success).params(params).build();
    }

    private AuditWrapper buildProcessAbortAudit(boolean success, Map<String, Object> params) {
        return AuditBuilder.getInstance().type(AuditTypes.AUDIT_ABORT_PROCESS).success(success).params(params).build();
    }
}

