/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.customChanges;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import liquibase.change.custom.CustomSqlChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;

public class UpdateNullIndexOrderIdChange
implements CustomSqlChange {
    public SqlStatement[] generateStatements(Database database) {
        return this.generateUpdateStatements((JdbcConnection)database.getConnection());
    }

    private SqlStatement[] generateUpdateStatements(JdbcConnection connection) throws DatabaseException, SQLException {
        String maxIndexOrderIdByDocClassQuery = "select docclassid, max(indexorderid) as max from pm_indecies group by docclassid";
        String rowsWithNullIndexOrderIdQuery = "select id, docclassid from pm_indecies where indexorderid is null";
        PreparedStatement maxIndexOrderIdByDocClassStatement = connection.prepareStatement(maxIndexOrderIdByDocClassQuery);
        ResultSet maxIndexOrderIdByDocClassResultSet = maxIndexOrderIdByDocClassStatement.executeQuery();
        PreparedStatement rowsWithNullIndexOrderIdStatement = connection.prepareStatement(rowsWithNullIndexOrderIdQuery);
        ResultSet rowsWithNullIndexOrderId = rowsWithNullIndexOrderIdStatement.executeQuery();
        HashMap<Integer, Integer> maxIndexOrderIdByDocClass = new HashMap<Integer, Integer>();
        while (maxIndexOrderIdByDocClassResultSet.next()) {
            maxIndexOrderIdByDocClass.put(maxIndexOrderIdByDocClassResultSet.getInt("docclassid"), maxIndexOrderIdByDocClassResultSet.getInt("max"));
        }
        ArrayList<RawSqlStatement> statements = new ArrayList<RawSqlStatement>();
        while (rowsWithNullIndexOrderId.next()) {
            Integer docClassId = rowsWithNullIndexOrderId.getInt("docclassid");
            Integer id = rowsWithNullIndexOrderId.getInt("id");
            Integer max = (Integer)maxIndexOrderIdByDocClass.get(docClassId) + 1;
            maxIndexOrderIdByDocClass.put(docClassId, max);
            statements.add(new RawSqlStatement("UPDATE pm_indecies SET indexorderid = " + max + "where id = " + id));
        }
        return statements.toArray(new SqlStatement[0]);
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }
}

