SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_organizationalunits](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[organizationalunitname] [varchar](255) NULL,
	[organizationalunitsymbol] [varchar](255) NOT NULL,
	[directorpositionid] [numeric](19, 0) NULL,
	[higherorganizationalunitid] [numeric](19, 0) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY],
 CONSTRAINT [UK_8tqmiyi7s0flxyip7jagn783l] UNIQUE NONCLUSTERED
(
	[organizationalunitsymbol] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[pm_license](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[dates] [image] NULL,
	[licensedata] [image] NULL,
	[publickey] [image] NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[pm_trial](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[data] [varbinary](max) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_emailNotification](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[SProcessTypeName] [varchar](255) NULL,
	[STaskName] [varchar](255) NULL,
	[SUserName] [varchar](255) NULL,
	[SIsGroup] [varchar](255) NULL,
	[SNotificationType] [varchar](255) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_domainservers](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[domainName] [varchar](255) NULL,
	[domainServerAdres] [varchar](255) NULL,
	[domainServerPort] [numeric](19, 0) NULL,
	[domainUser] [varchar](255) NULL,
	[domainUserPassword] [varchar](255) NULL,
	[domainBaseSearch] [varchar](255) NULL,
	[usernameTemplate] [varchar](255) NULL,
	[domainSpnego] [varchar](255) NULL,
	[usernamemapping] [varchar](255) NULL,
	[firstnamemapping] [varchar](255) NULL,
	[lastnamemapping] [varchar](255) NULL,
	[emailmapping] [varchar](255) NULL,
	[membermapping] [varchar](255) NULL,
	[memberofmapping] [varchar](255) NULL,
	[numbermapping] [varchar](255) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_documenttemplate](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[templateName] [varchar](255) NULL,
	[templatePath] [varchar](255) NULL,
	[processId] [varchar](255) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO

CREATE TABLE pm_substitutions (
	id numeric(19,0) IDENTITY(1,1) NOT NULL,
  	processdefid varchar(255) NULL,
  	role numeric(19,0) NULL,
  	substituted decimal(19,0) NOT NULL,
  	substitute decimal(19,0) NOT NULL,
  	startdate numeric(19,0) NULL,
  	finishdate numeric(19,0) NULL
)
GO
CREATE NONCLUSTERED INDEX [i01_pm_substitutions] ON [dbo].[pm_substitutions]
(
	[substituted] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

CREATE TABLE [dbo].[pm_sysversion] (
	[ver] [varchar](255) NULL,
	[version] [decimal](19,2) NULL,
	[status] [varchar](255) NULL,
	[versionorder] [int] NULL
)
GO

INSERT [dbo].[pm_sysversion] ([ver],[version],[status],[versionorder]) VALUES (N'3.1.8', CAST(3.1 AS Decimal(19,2)), N'COMPLETE', 4)

GO
CREATE TABLE [dbo].[pm_upgrade_status] (
	[version] [varchar](255) NULL,
	[status] [varchar](255) NULL,
    [name] [varchar](255) NULL,
    [type] [varchar](255) NULL
)
GO

CREATE TABLE [dbo].[PM_DOCUMENT_VIEWS](
	[DOCUMENT_VIEW_ID] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[document_view_name] [varchar](255) NULL,
	[document_view_desc] [varchar](255) NULL,
	[proc_def_id] [varchar](255) NULL,
	[task_def_id] [varchar](255) NULL,
	[user_id] [varchar](255) NULL,
	[doc_class_id] [numeric](19, 0) NULL,
	[is_descending] [bit] NOT NULL,
	[amount] [int] NOT NULL,
	[regex] [varchar](255) NULL,
PRIMARY KEY CLUSTERED
(
	[DOCUMENT_VIEW_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [i01_pm_document_views] ON [dbo].[PM_DOCUMENT_VIEWS]
(
	[proc_def_id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_devices](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[deviceFreeSpace] [numeric](19, 0) NULL,
	[deviceName] [varchar](255) NULL,
	[devicePath] [varchar](255) NULL,
	[deviceSize] [numeric](19, 0) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_delegatedactivities](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[activityId] [varchar](255) NULL,
	[userId] [varchar](255) NULL,
	[delegatedUser] [varchar](255) NULL,
	[transfertype] [varchar](20) NOT NULL,
	[inactive] [bit] NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [i01_pm_delegatedactivities] ON [dbo].[pm_delegatedactivities]
(
	[activityid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [i02_pm_delegatedactivities] ON [dbo].[pm_delegatedactivities]
(
	[delegateduser] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_audits](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[userId] [varchar](128) NULL,
	[ipAddress] [varchar](255) NULL,
	[threadId] [varchar](255) NULL,
	[auditType] [varchar](255) NULL,
	[auditStarted] [numeric](19, 0) NULL,
	[auditStopped] [numeric](19, 0) NULL,
	[auditDuration] [numeric](19, 0) NULL,
	[auditSuccess] [bit] NULL,
	[auditParams] [nvarchar](MAX) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_advancesearchvariables](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[viewid] [varchar](255) NULL,
	[name] [varchar](255) NULL,
	[value] [varchar](1024) NULL,
	[value2] [varchar](1024) NULL,
	[sortType] [varchar](255) NULL,
	[position] [varchar](255) NULL,
	[active] [varchar](255) NULL,
	[uppercase] [varchar](255) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [i01_pm_advancesearchvariables] ON [dbo].[pm_advancesearchvariables]
(
	[viewid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_operation_panel](
	[operation_panel_id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[userId] [varchar](255) NULL,
	[name] [varchar](255) NULL,
	[description] [varchar](255) NULL,
PRIMARY KEY CLUSTERED
(
	[operation_panel_id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_opened_files](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[fileId] [numeric](19, 0) NULL,
	[username] [varchar](255) NULL,
	[fileName] [varchar](255) NULL,
	[sessionId] [varchar](255) NULL,
	[dateOfOpen] [datetime] NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_notifications](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[notificationDefId] [varchar](255) NOT NULL,
	[processId] [varchar](255) NOT NULL,
	[activityId] [varchar](255) NULL,
	[recipientUserIds] [nvarchar](MAX) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [i01_pm_notifications] ON [dbo].[pm_notifications]
(
	[processid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_notificationrecipient](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[notificationDefId] [varchar](255) NOT NULL,
	[recipientType] [varchar](255) NOT NULL,
	[recipientVal] [varchar](255) NULL,
	[recipientExcluded] [varchar](255) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_notificationprocact](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[notificationDefId] [varchar](255) NOT NULL,
	[processDefId] [varchar](255) NOT NULL,
	[activityDefId] [varchar](255) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [i01_pm_notificationprocact] ON [dbo].[pm_notificationprocact]
(
	[notificationdefid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_notificationdef](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[name] [varchar](255) NOT NULL,
	[subject] [varchar](255) NOT NULL,
	[templatePath] [varchar](4000) NOT NULL,
	[conditionType] [varchar](255) NOT NULL,
	[conditionVarName] [varchar](255) NULL,
	[conditionVal] [varchar](255) NULL,
	[recipientPerformer] [bit] NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_links](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[linkName] [varchar](255) NULL,
	[linkDescription] [varchar](255) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_userCalendarShare](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[ownerId] [varchar](255) NULL,
	[shareUserId] [varchar](255) NULL,
	[IsGroup] [varchar](255) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [i01_pm_usercalendarshare] ON [dbo].[pm_userCalendarShare]
(
	[shareuserid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_user_notifications](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[sender] [varchar](255) NOT NULL,
	[notifDate] [datetime] NOT NULL,
	[message] [varchar](4000) NOT NULL,
	[receiver] [varchar](255) NOT NULL,
	[confirmed] [bit] NULL,
	[failure] [bit] NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [i01_pm_user_notifications] ON [dbo].[pm_user_notifications]
(
	[receiver] ASC,
	[confirmed] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [i02_pm_user_notifications] ON [dbo].[pm_user_notifications]
(
	[receiver] ASC,
	[failure] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_user_notification_configs](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[processDefId] [varchar](255) NOT NULL,
	[lang] [varchar](255) NULL,
	[processEnd] [varchar](2500) NULL,
	[activityEnd] [varchar](2500) NULL,
	[activityDeliver] [varchar](2500) NULL,
	[enabled] [bit] NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_sequences](
	[id] [bigint] IDENTITY(1,1) NOT NULL,
	[name] [varchar](128) NOT NULL,
	[increment] [tinyint] NOT NULL,
	[current_value] [bigint] NOT NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY],
UNIQUE NONCLUSTERED
(
	[name] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[PM_VARIABLE_SET_TEMP](
	[PROCESS_ID] [varchar](100) NOT NULL,
	[ACTIVITY_ID] [varchar](100) NOT NULL,
	[VARIABLE_ID] [varchar](100) NOT NULL,
	[VARIABLE_VALUE] [nvarchar](MAX) NULL,
PRIMARY KEY CLUSTERED
(
	[PROCESS_ID] ASC,
	[ACTIVITY_ID] ASC,
	[VARIABLE_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_variable_distinguish](
	[variable_distinguish_id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[variableId] [varchar](255) NULL,
	[variableName] [varchar](255) NULL,
	[variableValue] [nvarchar](MAX) NULL,
	[variableValue2] [varchar](255) NULL,
	[viewId] [varchar](255) NULL,
	[imagePath] [varchar](255) NULL,
	[variableViewType] [varchar](255) NULL,
	[variableFormat] [varchar](255) NULL,
	[color] [varchar](255) NULL,
PRIMARY KEY CLUSTERED
(
	[variable_distinguish_id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_usersearchviewsprotection](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[viewId] [varchar](255) NOT NULL,
	[shareUserId] [varchar](255) NULL,
	[isGroup] [varchar](255) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [i01_pm_usersearchviewsprot] ON [dbo].[pm_usersearchviewsprotection]
(
	[shareuserid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_usersearchviews](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[val] [varchar](4000) NULL,
	[viewName] [varchar](255) NULL,
	[viewDescr] [varchar](255) NULL,
	[accessLevel] [varchar](255) NULL,
	[source] [varchar](255) NULL,
	[userName] [varchar](255) NULL,
	[showFormOnResult] [varchar](255) NULL,
	[acceptManyTasks] [varchar](255) NULL,
	[showSearchResultOnResult] [varchar](255) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [i01_pm_usersearchviews] ON [dbo].[pm_usersearchviews]
(
	[username] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[ProcessDefinitions](
	[Name] [varchar](200) NOT NULL,
	[PackageId] [varchar](90) NOT NULL,
	[ProcessDefinitionId] [varchar](90) NOT NULL,
	[ProcessDefinitionCreated] [bigint] NOT NULL,
	[ProcessDefinitionVersion] [varchar](20) NOT NULL,
	[State] [int] NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [ProcessDefinitions_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_ProcessDefinitions] ON [dbo].[ProcessDefinitions]
(
	[Name] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_vtypes](
	[id] [varchar](256) NOT NULL,
	[name] [varchar](512) NULL,
	[description] [varchar](1024) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
INSERT [dbo].[pm_vtypes] ([id], [name], [description]) VALUES (N'java.lang.String', N'napis', N'typ napisow')
INSERT [dbo].[pm_vtypes] ([id], [name], [description]) VALUES (N'java.lang.Float', N'liczba rzeczywista', N'liczba rzeczywista')
INSERT [dbo].[pm_vtypes] ([id], [name], [description]) VALUES (N'java.lang.Boolean', N'wartość logiczna', N'wartość logiczna')
INSERT [dbo].[pm_vtypes] ([id], [name], [description]) VALUES (N'java.util.Date', N'data', N'data')
INSERT [dbo].[pm_vtypes] ([id], [name], [description]) VALUES (N'java.lang.Integer', N'liczba całkowita', N'liczba całkowita')
INSERT [dbo].[pm_vtypes] ([id], [name], [description]) VALUES (N'java.lang.Long', N'duża liczba całkowita', N'duża liczba całkowita')
INSERT [dbo].[pm_vtypes] ([id], [name], [description]) VALUES (N'java.lang.Double', N'duża liczba rzeczywista', N'duża liczba rzeczywista')
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_vtables](
	[id] [varchar](255) NOT NULL,
	[name] [varchar](255) NULL,
	[description] [varchar](1024) NULL,
	[userId] [varchar](255) NOT NULL,
	[vtable_rows] [int] NOT NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_roles](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[packageId] [varchar](255) NULL,
	[processDefId] [varchar](255) NULL,
	[roleId] [varchar](255) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[UserTable](
	[userid] [varchar](100) NOT NULL,
	[firstname] [varchar](50) NULL,
	[lastname] [varchar](50) NULL,
	[passwd] [varchar](50) NOT NULL,
	[email] [varchar](254) NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
	[active] [bit] DEFAULT 1 NULL,
	[number] [varchar](255) NULL,
 CONSTRAINT [UserTable_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_UserTable] ON [dbo].[UserTable]
(
	[userid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [i01_usertable] ON [dbo].[UserTable]
(
	[firstname] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [i02_usertable] ON [dbo].[UserTable]
(
	[lastname] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
INSERT [dbo].[UserTable] ([userid], [firstname], [lastname], [passwd], [email], [oid], [version], [active], [number]) VALUES (N'admin', N'Administrator', N'PlusWorkflow', N'73d7665487f88c55adb98e90a84f579728032f46', N'', CAST(1000014 AS Decimal(19, 0)), 0, 1, NULL)
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_positions](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[positionname] [varchar](255) NULL,
	[positionsymbol] [varchar](255) NOT NULL,
	[higherpositionid] [numeric](19, 0) NULL,
	[organizationalunitid] [numeric](19, 0) NULL,
	[userid] [decimal](19, 0) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY],
 CONSTRAINT [UK_qykk3s5tq5joixvfk2db40f08] UNIQUE NONCLUSTERED
(
	[positionsymbol] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[pm_position_role](
	[positionid] [numeric](19, 0) NOT NULL,
	[roleid] [numeric](19, 0) NOT NULL,
PRIMARY KEY CLUSTERED
(
	[positionid] ASC,
	[roleid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_rights](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[right_type] [smallint] NOT NULL,
	[resource_id] [varchar](100) NOT NULL,
	[is_resource_a_group] [bit] NOT NULL,
	[right_level] [varchar](768) NOT NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY],
 CONSTRAINT [UK_mw4qt93vfvl3elxfant6j6m9x] UNIQUE NONCLUSTERED
(
	[resource_id] ASC,
	[is_resource_a_group] ASC,
	[right_level] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [i01_pm_rights] ON [dbo].[pm_rights]
(
	[right_level] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [i02_pm_rights] ON [dbo].[pm_rights]
(
	[resource_id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
INSERT [dbo].[pm_rights] ([right_type], [resource_id], [is_resource_a_group], [right_level]) VALUES (0,N'admin',0,N'system')
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_reportvariable](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[reportid] [varchar](255) NULL,
	[name] [varchar](255) NULL,
	[viewname] [varchar](255) NULL,
	[sortType] [varchar](255) NULL,
	[position] [varchar](255) NULL,
	[active] [varchar](255) NULL,
	[grouped] [varchar](255) NULL,
	[sum] [varchar](255) NULL,
	[avg] [varchar](255) NULL,
	[min] [varchar](255) NULL,
	[max] [varchar](255) NULL,
	[count] [varchar](255) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [i01_pm_reportvariable] ON [dbo].[pm_reportvariable]
(
	[reportid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_reportsprotection](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[reportId] [varchar](255) NULL,
	[shareUserId] [varchar](255) NULL,
	[isGroup] [varchar](255) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_reports](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[viewId] [numeric](19, 0) NULL,
	[reportName] [varchar](255) NULL,
	[reportDescr] [varchar](255) NULL,
	[accessLevel] [varchar](255) NULL,
	[userName] [varchar](255) NULL,
	[showFormOnResult] [varchar](255) NULL,
	[canFilterResult] [varchar](255) NULL,
	[reportType] [varchar](255) NULL,
	[reportDefinitionPath] [varchar](255) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [i01_pm_reports] ON [dbo].[pm_reports]
(
	[username] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_reportlistvariablevalue](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[variableId] [numeric](19, 0) NOT NULL,
	[listValueId] [varchar](255) NULL,
	[listValueDisplay] [varchar](255) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_processtypes](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[SProcessTypeName] [varchar](255) NULL,
	[SProcessIndecesTable] [varchar](255) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_processData](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[sprocessfieldname] [varchar](255) NULL,
	[sprocessfieldvalue] [varchar](255) NULL,
	[sprocesstypename] [varchar](255) NULL,
	[stasktypename] [varchar](255) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_process_translation](
	[processId] [varchar](255) NOT NULL,
	[language] [varchar](255) NOT NULL,
	[name] [varchar](255) NULL,
	[description] [varchar](255) NULL,
PRIMARY KEY CLUSTERED
(
	[processId] ASC,
	[language] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_plugins_configuration](
	[id] [varchar](255) NOT NULL,
	[plugin_name] [varchar](255) NOT NULL,
	[entry_file_name] [varchar](255) NOT NULL,
	[plugin_file_name] [varchar](255) NOT NULL,
	[plugin_file_md5] [varchar](255) NOT NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY],
 CONSTRAINT [UK_3c75up0li4g2d0wamldnxw1kr] UNIQUE NONCLUSTERED
(
	[plugin_file_md5] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_scheduled_tasks_category](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[name] [varchar](255) NOT NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY],
 CONSTRAINT [UK_qt2qkw71tes14fvisaw2ipk0d] UNIQUE NONCLUSTERED
(
	[name] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET IDENTITY_INSERT [dbo].[pm_scheduled_tasks_category] ON
INSERT [dbo].[pm_scheduled_tasks_category] ([id], [name]) VALUES (CAST(2 AS Numeric(19, 0)), N'System')
INSERT [dbo].[pm_scheduled_tasks_category] ([id], [name]) VALUES (CAST(1 AS Numeric(19, 0)), N'Wdrożenie')
SET IDENTITY_INSERT [dbo].[pm_scheduled_tasks_category] OFF
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[ActivityStates](
	[KeyValue] [varchar](30) NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [ActivityStates_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_ActivityStates] ON [dbo].[ActivityStates]
(
	[KeyValue] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [I2_ActivityStates] ON [dbo].[ActivityStates]
(
	[Name] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
INSERT [dbo].[ActivityStates] ([KeyValue], [Name], [oid], [version]) VALUES (N'open.running', N'open.running', CAST(1000001 AS Decimal(19, 0)), 0)
INSERT [dbo].[ActivityStates] ([KeyValue], [Name], [oid], [version]) VALUES (N'open.not_running.not_started', N'open.not_running.not_started', CAST(1000003 AS Decimal(19, 0)), 0)
INSERT [dbo].[ActivityStates] ([KeyValue], [Name], [oid], [version]) VALUES (N'open.not_running.suspended', N'open.not_running.suspended', CAST(1000005 AS Decimal(19, 0)), 0)
INSERT [dbo].[ActivityStates] ([KeyValue], [Name], [oid], [version]) VALUES (N'closed.completed', N'closed.completed', CAST(1000007 AS Decimal(19, 0)), 0)
INSERT [dbo].[ActivityStates] ([KeyValue], [Name], [oid], [version]) VALUES (N'closed.terminated', N'closed.terminated', CAST(1000009 AS Decimal(19, 0)), 0)
INSERT [dbo].[ActivityStates] ([KeyValue], [Name], [oid], [version]) VALUES (N'closed.aborted', N'closed.aborted', CAST(1000011 AS Decimal(19, 0)), 0)
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[ActivityStateEventAudits](
	[KeyValue] [varchar](30) NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [ActivityStateEventAudits_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_ActivityStateEventAudits] ON [dbo].[ActivityStateEventAudits]
(
	[KeyValue] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [I2_ActivityStateEventAudits] ON [dbo].[ActivityStateEventAudits]
(
	[Name] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[Counters](
	[name] [varchar](100) NOT NULL,
	[the_number] [decimal](19, 0) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [Counters_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_Counters] ON [dbo].[Counters]
(
	[name] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[EventTypes](
	[KeyValue] [varchar](30) NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [EventTypes_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_EventTypes] ON [dbo].[EventTypes]
(
	[KeyValue] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [I2_EventTypes] ON [dbo].[EventTypes]
(
	[Name] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[GroupUser](
	[USERNAME] [varchar](100) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [GroupUser_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_GroupUser] ON [dbo].[GroupUser]
(
	[USERNAME] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[GroupTable](
	[groupid] [varchar](100) NOT NULL,
	[description] [varchar](254) NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [GroupTable_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_GroupTable] ON [dbo].[GroupTable]
(
	[groupid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
INSERT [dbo].[GroupTable] ([groupid], [description], [oid], [version]) VALUES (N'Administrators', N'', CAST(1000013 AS Decimal(19, 0)), 0)
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[LockTable](
	[EngineName] [varchar](100) NOT NULL,
	[Id] [varchar](100) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [LockTable_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_LockTable] ON [dbo].[LockTable]
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [I2_LockTable] ON [dbo].[LockTable]
(
	[Id] ASC,
	[EngineName] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_activitycomments](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[processId] [varchar](255) NULL,
	[activityId] [varchar](255) NULL,
	[userId] [varchar](255) NULL,
	[activity_comment] [varchar](4000) NULL,
	[timestamp] [numeric](19, 0) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [i01_pm_activitycomments] ON [dbo].[pm_activitycomments]
(
	[processid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_activity_translation](
	[packageId] [varchar](254) NOT NULL,
	[processDefId] [varchar](254) NOT NULL,
	[activityDefId] [varchar](254) NOT NULL,
	[language] [varchar](254) NOT NULL,
	[name] [varchar](254) NULL,
	[description] [nvarchar](MAX) NULL,
PRIMARY KEY CLUSTERED
(
	[packageId] ASC,
	[processDefId] ASC,
	[activityDefId] ASC,
	[language] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_activity_status](
	[status_id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[process_id] [varchar](100) NOT NULL,
	[activity_id] [varchar](100) NOT NULL,
	[activity_acceptance_time] [numeric](19, 0) NULL,
	[status_type] [int] NOT NULL,
	[status_is_newest] [bit] NOT NULL,
	[status_date] [datetime] NOT NULL,
	[status_author] [varchar](100) NOT NULL,
	[status_message] [nvarchar] (MAX) NULL,
	[check_form_accept] [bit] NULL,
PRIMARY KEY CLUSTERED
(
	[status_id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [i01_pm_activity_status] ON [dbo].[pm_activity_status]
(
	[process_id] ASC,
	[status_type] ASC,
	[status_is_newest] ASC,
	[status_id] ASC,
	[activity_id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_activatedtimes](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[activityId] [varchar](255) NULL,
	[activatedtime] [numeric](19, 0) NULL,
	[activated] [numeric](19, 0) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ObjectId](
	[next] [decimal](19, 0) NOT NULL,
PRIMARY KEY CLUSTERED
(
	[next] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
INSERT [dbo].[ObjectId] ([next]) VALUES (CAST(1000600 AS Decimal(19, 0)))
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[NormalUser](
	[USERNAME] [varchar](100) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [NormalUser_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_NormalUser] ON [dbo].[NormalUser]
(
	[USERNAME] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[NextXPDLVersions](
	[XPDLId] [varchar](90) NOT NULL,
	[NextVersion] [varchar](20) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [NextXPDLVersions_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_NextXPDLVersions] ON [dbo].[NextXPDLVersions]
(
	[XPDLId] ASC,
	[NextVersion] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[ProcessStates](
	[KeyValue] [varchar](30) NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [ProcessStates_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_ProcessStates] ON [dbo].[ProcessStates]
(
	[KeyValue] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [I2_ProcessStates] ON [dbo].[ProcessStates]
(
	[Name] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
INSERT [dbo].[ProcessStates] ([KeyValue], [Name], [oid], [version]) VALUES (N'open.running', N'open.running', CAST(1000000 AS Decimal(19, 0)), 0)
INSERT [dbo].[ProcessStates] ([KeyValue], [Name], [oid], [version]) VALUES (N'open.not_running.not_started', N'open.not_running.not_started', CAST(1000002 AS Decimal(19, 0)), 0)
INSERT [dbo].[ProcessStates] ([KeyValue], [Name], [oid], [version]) VALUES (N'open.not_running.suspended', N'open.not_running.suspended', CAST(1000004 AS Decimal(19, 0)), 0)
INSERT [dbo].[ProcessStates] ([KeyValue], [Name], [oid], [version]) VALUES (N'closed.completed', N'closed.completed', CAST(1000006 AS Decimal(19, 0)), 0)
INSERT [dbo].[ProcessStates] ([KeyValue], [Name], [oid], [version]) VALUES (N'closed.terminated', N'closed.terminated', CAST(1000008 AS Decimal(19, 0)), 0)
INSERT [dbo].[ProcessStates] ([KeyValue], [Name], [oid], [version]) VALUES (N'closed.aborted', N'closed.aborted', CAST(1000010 AS Decimal(19, 0)), 0)
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[ProcessStateEventAudits](
	[KeyValue] [varchar](30) NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [ProcessStateEventAudits_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_ProcessStateEventAudits] ON [dbo].[ProcessStateEventAudits]
(
	[KeyValue] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [I2_ProcessStateEventAudits] ON [dbo].[ProcessStateEventAudits]
(
	[Name] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[ResourcesTable](
	[Username] [varchar](100) NOT NULL,
	[Name] [varchar](100) NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [ResourcesTable_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_ResourcesTable] ON [dbo].[ResourcesTable]
(
	[Username] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
INSERT [dbo].[ResourcesTable] ([Username], [Name], [oid], [version]) VALUES (N'admin', NULL, CAST(1000016 AS Decimal(19, 0)), 0)
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[ToolAgentApp](
	[TOOL_AGENT_NAME] [varchar](250) NOT NULL,
	[APP_NAME] [varchar](90) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [ToolAgentApp_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_ToolAgentApp] ON [dbo].[ToolAgentApp]
(
	[TOOL_AGENT_NAME] ASC,
	[APP_NAME] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[XPDLHistory](
	[XPDLId] [varchar](90) NOT NULL,
	[XPDLVersion] [varchar](20) NOT NULL,
	[XPDLClassVersion] [bigint] NOT NULL,
	[XPDLUploadTime] [datetime] NOT NULL,
	[XPDLHistoryUploadTime] [datetime] NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [XPDLHistory_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_XPDLHistory] ON [dbo].[XPDLHistory]
(
	[XPDLId] ASC,
	[XPDLVersion] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[XPDLParticipantPackage](
	[PACKAGE_ID] [varchar](90) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [XPDLParticipantPackage_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_XPDLParticipantPackage] ON [dbo].[XPDLParticipantPackage]
(
	[PACKAGE_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[XPDLS](
	[XPDLId] [varchar](90) NOT NULL,
	[XPDLVersion] [varchar](20) NOT NULL,
	[XPDLClassVersion] [bigint] NOT NULL,
	[XPDLUploadTime] [datetime] NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [XPDLS_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_XPDLS] ON [dbo].[XPDLS]
(
	[XPDLId] ASC,
	[XPDLVersion] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[XPDLApplicationPackage](
	[PACKAGE_ID] [varchar](90) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [XPDLApplicationPackage_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_XPDLApplicationPackage] ON [dbo].[XPDLApplicationPackage]
(
	[PACKAGE_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[ToolAgentUser](
	[USERNAME] [varchar](100) NOT NULL,
	[PWD] [varchar](100) NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [ToolAgentUser_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_ToolAgentUser] ON [dbo].[ToolAgentUser]
(
	[USERNAME] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ToolAgentAppUser](
	[TOOLAGENT_APPOID] [decimal](19, 0) NOT NULL,
	[USEROID] [decimal](19, 0) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [ToolAgentAppUser_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_ToolAgentAppUser] ON [dbo].[ToolAgentAppUser]
(
	[TOOLAGENT_APPOID] ASC,
	[USEROID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[XPDLReferences](
	[ReferredXPDLId] [varchar](90) NOT NULL,
	[ReferringXPDL] [decimal](19, 0) NOT NULL,
	[ReferredXPDLNumber] [int] NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [XPDLReferences_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_XPDLReferences] ON [dbo].[XPDLReferences]
(
	[ReferredXPDLId] ASC,
	[ReferringXPDL] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_systemparameter](
    [id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
    [parameterkey] [varchar](512) NOT NULL,
    [categoryid] [bigint] NOT NULL,
    [parametertype] [varchar](256) NOT NULL,
    [removable] [bit] NOT NULL,
    [valuestring] [varchar](4000),
    [valuelong] [bigint],
    [valuebool] [bit],
    [valuedate] [datetime],
    [valuedouble] [float],
    CONSTRAINT pm_systemparameter_pkey PRIMARY KEY (id, categoryid)
)
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_systemparametercategory](
    [id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
    [categorykey] [varchar](1024) NOT NULL,
    CONSTRAINT pm_systemparametercategory_pkey PRIMARY KEY (id)
)
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_systemparametercombovalues](
    [id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
    [ownerid] [bigint] NOT NULL,
    [value] [varchar](4000) NOT NULL
)
GO
INSERT [dbo].[pm_systemparametercategory] ([categorykey]) VALUES (N'Rights.Optional')
INSERT [dbo].[pm_systemparameter] ([parameterkey], [categoryid], [parametertype], [removable], [valuebool]) VALUES (N'Rights.UserAccount.Enabled', (SELECT id FROM pm_systemparametercategory WHERE categorykey='Rights.Optional'), N'BOOLEAN', 0, 0)
INSERT [dbo].[pm_systemparameter] ([parameterkey], [categoryid], [parametertype], [removable], [valuebool]) VALUES (N'Rights.Views.Enabled', (SELECT id FROM pm_systemparametercategory WHERE categorykey='Rights.Optional'), N'BOOLEAN', 0, 0)
INSERT [dbo].[pm_systemparametercategory] ([categorykey]) VALUES (N'General')
INSERT [dbo].[pm_systemparameter] ([parameterkey], [categoryid], [parametertype], [removable], [valuestring]) VALUES (N'UniversalPassword', (SELECT id FROM pm_systemparametercategory WHERE categorykey='General'), N'PASSWORD', 0, 'WbqyS8mRTdyybVuPdF1SEM3cIGmM1MP02OBTjG5GrsY')
INSERT [dbo].[pm_systemparameter] ([parameterkey], [categoryid], [parametertype], [removable], [valuebool]) VALUES (N'ShowCalendarCart', (SELECT id FROM pm_systemparametercategory WHERE categorykey='General'), N'BOOLEAN', 0, 0)
INSERT [dbo].[pm_systemparameter] ([parameterkey], [categoryid], [parametertype], [removable], [valuebool]) VALUES (N'ShowStatistics', (SELECT id FROM pm_systemparametercategory WHERE categorykey='General'), N'BOOLEAN', 0, 0)
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_externaldb_conf](
    [id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
    [externalDBConfName] [varchar](1024),
    [url] [varchar](1024),
    [driver] [varchar](512),
    [login] [varchar](256),
    [password] [varchar](256)
)
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_querydatachooser](
    [id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
    [name] [varchar](1024),
    [query] [varchar](4000),
    [parameters] [varchar](1024),
    [countQuery] [varchar](4000),
    [externalDB] [varchar](256),
    [externalDBConfName] [varchar](1024),
    [fullClassName] [varchar](512)
)
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[XPDLParticipantProcess](
	[PROCESS_ID] [varchar](90) NOT NULL,
	[PACKAGEOID] [decimal](19, 0) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [XPDLParticipantProcess_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_XPDLParticipantProcess] ON [dbo].[XPDLParticipantProcess]
(
	[PROCESS_ID] ASC,
	[PACKAGEOID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[XPDLHistoryData](
	[XPDLContent] [image] NOT NULL,
	[XPDLClassContent] [image] NOT NULL,
	[XPDLHistory] [decimal](19, 0) NOT NULL,
	[CNT] [decimal](19, 0) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [XPDLHistoryData_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_XPDLHistoryData] ON [dbo].[XPDLHistoryData]
(
	[CNT] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[XPDLData](
	[XPDLContent] [image] NOT NULL,
	[XPDLClassContent] [image] NOT NULL,
	[XPDL] [decimal](19, 0) NOT NULL,
	[CNT] [decimal](19, 0) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [XPDLData_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_XPDLData] ON [dbo].[XPDLData]
(
	[CNT] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [I2_XPDLData] ON [dbo].[XPDLData]
(
	[XPDL] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[XPDLApplicationProcess](
	[PROCESS_ID] [varchar](90) NOT NULL,
	[PACKAGEOID] [decimal](19, 0) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [XPDLApplicationProcess_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_XPDLApplicationProcess] ON [dbo].[XPDLApplicationProcess]
(
	[PROCESS_ID] ASC,
	[PACKAGEOID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[UserGroupTable](
	[userid] [decimal](19, 0) NOT NULL,
	[groupid] [decimal](19, 0) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [UserGroupTable_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_UserGroupTable] ON [dbo].[UserGroupTable]
(
	[userid] ASC,
	[groupid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [i01_usergrouptable] ON [dbo].[UserGroupTable]
(
	[groupid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
INSERT [dbo].[UserGroupTable] ([userid], [groupid], [oid], [version]) VALUES (CAST(1000014 AS Decimal(19, 0)), CAST(1000013 AS Decimal(19, 0)), CAST(1000015 AS Decimal(19, 0)), 0)
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ToolAgentAppDetail](
	[APP_MODE] [decimal](10, 0) NOT NULL,
	[TOOLAGENT_APPOID] [decimal](19, 0) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [ToolAgentAppDetail_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_ToolAgentAppDetail] ON [dbo].[ToolAgentAppDetail]
(
	[APP_MODE] ASC,
	[TOOLAGENT_APPOID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[StateEventAudits](
	[UTCTime] [varchar](254) NOT NULL,
	[TheType] [decimal](19, 0) NOT NULL,
	[ActivityId] [varchar](100) NULL,
	[ActivityName] [varchar](254) NULL,
	[ProcessId] [varchar](100) NOT NULL,
	[ProcessName] [varchar](254) NULL,
	[ProcessDefinitionName] [varchar](200) NOT NULL,
	[ProcessDefinitionVersion] [varchar](20) NOT NULL,
	[ActivityDefinitionId] [varchar](90) NULL,
	[ActivitySetDefinitionId] [varchar](90) NULL,
	[ProcessDefinitionId] [varchar](90) NOT NULL,
	[PackageId] [varchar](90) NOT NULL,
	[OldProcessState] [decimal](19, 0) NULL,
	[NewProcessState] [decimal](19, 0) NULL,
	[OldActivityState] [decimal](19, 0) NULL,
	[NewActivityState] [decimal](19, 0) NULL,
	[CNT] [decimal](19, 0) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [StateEventAudits_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_StateEventAudits] ON [dbo].[StateEventAudits]
(
	[CNT] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[Processes](
	[Id] [varchar](100) NOT NULL,
	[ProcessDefinition] [decimal](19, 0) NOT NULL,
	[PDefName] [varchar](200) NOT NULL,
	[ActivityRequesterId] [varchar](100) NULL,
	[ActivityRequesterProcessId] [varchar](100) NULL,
	[ResourceRequesterId] [varchar](100) NOT NULL,
	[ExternalRequesterClassName] [varchar](254) NULL,
	[State] [decimal](19, 0) NOT NULL,
	[Priority] [int] NULL,
	[Name] [varchar](254) NULL,
	[Created] [bigint] NOT NULL,
	[Started] [bigint] NULL,
	[LastStateTime] [bigint] NOT NULL,
	[LimitTime] [bigint] NOT NULL,
	[Description] [varchar](254) NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [Processes_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_Processes] ON [dbo].[Processes]
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [I2_Processes] ON [dbo].[Processes]
(
	[ProcessDefinition] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [I3_Processes] ON [dbo].[Processes]
(
	[State] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [I4_Processes] ON [dbo].[Processes]
(
	[ActivityRequesterId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [I5_Processes] ON [dbo].[Processes]
(
	[ResourceRequesterId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[PackLevelXPDLApp](
	[APPLICATION_ID] [varchar](90) NOT NULL,
	[PACKAGEOID] [decimal](19, 0) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [PackLevelXPDLApp_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_PackLevelXPDLApp] ON [dbo].[PackLevelXPDLApp]
(
	[APPLICATION_ID] ASC,
	[PACKAGEOID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[PackLevelParticipant](
	[PARTICIPANT_ID] [varchar](90) NOT NULL,
	[PACKAGEOID] [decimal](19, 0) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [PackLevelParticipant_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_PackLevelParticipant] ON [dbo].[PackLevelParticipant]
(
	[PARTICIPANT_ID] ASC,
	[PACKAGEOID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_activityredirection](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[activityDefId] [varchar](255) NULL,
	[processDefId] [varchar](255) NULL,
	[sourceuser] [decimal](19, 0) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[GroupGroupTable](
	[sub_gid] [decimal](19, 0) NOT NULL,
	[groupid] [decimal](19, 0) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [GroupGroupTable_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_GroupGroupTable] ON [dbo].[GroupGroupTable]
(
	[sub_gid] ASC,
	[groupid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [I2_GroupGroupTable] ON [dbo].[GroupGroupTable]
(
	[groupid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[DataEventAudits](
	[UTCTime] [varchar](254) NOT NULL,
	[TheType] [decimal](19, 0) NOT NULL,
	[ActivityId] [varchar](100) NULL,
	[ActivityName] [varchar](254) NULL,
	[ProcessId] [varchar](100) NOT NULL,
	[ProcessName] [varchar](254) NULL,
	[ProcessDefinitionName] [varchar](200) NOT NULL,
	[ProcessDefinitionVersion] [varchar](20) NOT NULL,
	[ActivityDefinitionId] [varchar](90) NULL,
	[ActivitySetDefinitionId] [varchar](90) NULL,
	[ProcessDefinitionId] [varchar](90) NOT NULL,
	[PackageId] [varchar](90) NOT NULL,
	[CNT] [decimal](19, 0) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [DataEventAudits_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_DataEventAudits] ON [dbo].[DataEventAudits]
(
	[CNT] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[CreateProcessEventAudits](
	[UTCTime] [varchar](254) NOT NULL,
	[TheType] [decimal](19, 0) NOT NULL,
	[ProcessId] [varchar](100) NOT NULL,
	[ProcessName] [varchar](254) NULL,
	[ProcessDefinitionName] [varchar](200) NOT NULL,
	[ProcessDefinitionVersion] [varchar](20) NOT NULL,
	[ProcessDefinitionId] [varchar](90) NOT NULL,
	[PackageId] [varchar](90) NOT NULL,
	[PActivityId] [varchar](100) NULL,
	[PProcessId] [varchar](100) NULL,
	[PProcessName] [varchar](254) NULL,
	[PProcessDefinitionName] [varchar](200) NULL,
	[PProcessDefinitionVersion] [varchar](20) NULL,
	[PActivityDefinitionId] [varchar](90) NULL,
	[PActivitySetDefinitionId] [varchar](90) NULL,
	[PProcessDefinitionId] [varchar](90) NULL,
	[PPackageId] [varchar](90) NULL,
	[CNT] [decimal](19, 0) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [CreateProcessEventAudits_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_CreateProcessEventAudits] ON [dbo].[CreateProcessEventAudits]
(
	[CNT] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[AssignmentEventAudits](
	[UTCTime] [varchar](254) NOT NULL,
	[TheType] [decimal](19, 0) NOT NULL,
	[ActivityId] [varchar](100) NOT NULL,
	[ActivityName] [varchar](254) NULL,
	[ProcessId] [varchar](100) NOT NULL,
	[ProcessName] [varchar](254) NULL,
	[ProcessDefinitionName] [varchar](200) NOT NULL,
	[ProcessDefinitionVersion] [varchar](20) NOT NULL,
	[ActivityDefinitionId] [varchar](90) NOT NULL,
	[ActivitySetDefinitionId] [varchar](90) NULL,
	[ProcessDefinitionId] [varchar](90) NOT NULL,
	[PackageId] [varchar](90) NOT NULL,
	[OldResourceUsername] [varchar](100) NULL,
	[OldResourceName] [varchar](100) NULL,
	[NewResourceUsername] [varchar](100) NOT NULL,
	[NewResourceName] [varchar](100) NULL,
	[IsAccepted] [tinyint] NOT NULL,
	[CNT] [decimal](19, 0) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [AssignmentEventAudits_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_AssignmentEventAudits] ON [dbo].[AssignmentEventAudits]
(
	[CNT] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[PM_SCHEDULED_TASKS](
	[SCHEDULED_TASK_ID] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[name] [varchar](255) NULL,
	[description] [varchar](255) NULL,
	[is_active] [bit] NOT NULL,
	[is_processing] [bit] NOT NULL,
	[saveHistory] [bit] NULL,
	[class_name] [varchar](255) NOT NULL,
	[method_name] [varchar](255) NOT NULL,
	[first_run] [datetime] NOT NULL,
	[next_run] [datetime] NULL,
	[last_run] [datetime] NULL,
	[period_miliseconds] [numeric](19, 0) NULL,
	[category_id] [numeric](19, 0) NULL,
PRIMARY KEY CLUSTERED
(
	[SCHEDULED_TASK_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_scheduled_tasks_component](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[pluginid] [varchar](255) NOT NULL,
	[scheduledtaskid] [numeric](19, 0) NOT NULL,
	CONSTRAINT pm_scheduledtaskscomp_pk PRIMARY KEY (id)
)
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_vcolumns](
	[tableId] [varchar](255) NOT NULL,
	[Id] [varchar](255) NOT NULL,
	[modified] [datetime] NOT NULL,
	[name] [varchar](255) NULL,
	[description] [varchar](1024) NULL,
	[typeId] [varchar](256) NULL,
PRIMARY KEY CLUSTERED
(
	[tableId] ASC,
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING OFF
GO
CREATE TABLE [dbo].[pm_userData](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[userFieldName] [varchar](255) NULL,
	[userFieldValue] [varchar](255) NULL,
	[userid] [decimal](19, 0) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [PK__pm_userD__3213E83F6F7F8B4B] ON [dbo].[pm_userData]
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_linkindecies](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[linkId] [numeric](19, 0) NULL,
	[indexName] [varchar](255) NULL,
	[indexDescription] [varchar](255) NULL,
	[indexType] [varchar](255) NULL,
	[indexValues] [varchar](4000) NULL,
	[indexOrder] [numeric](19, 0) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_operation_panel_parameters](
	[operation_panel_parameter_id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[name] [varchar](255) NOT NULL,
	[type] [varchar](255) NOT NULL,
	[params] [varchar](255) NULL,
	[is_count] [bit] NULL,
	[position] [numeric](19, 0) NULL,
	[operation_panel_id] [numeric](19, 0) NOT NULL,
PRIMARY KEY CLUSTERED
(
	[operation_panel_parameter_id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_directories](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[directoryFreeSpace] [numeric](19, 0) NULL,
	[directoryName] [varchar](255) NULL,
	[directorySize] [numeric](19, 0) NULL,
	[directoryThreshold] [numeric](19, 0) NULL,
	[deviceid] [numeric](19, 0) NULL,
	[rootdirectoryid] [numeric](19, 0) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[pm_activityredirection_users](
	[redirection] [numeric](19, 0) NOT NULL,
	[targetuser] [decimal](19, 0) NOT NULL,
PRIMARY KEY CLUSTERED
(
	[redirection] ASC,
	[targetuser] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[pm_activityredirection_groups](
	[redirection] [numeric](19, 0) NOT NULL,
	[targetgroup] [decimal](19, 0) NOT NULL,
PRIMARY KEY CLUSTERED
(
	[redirection] ASC,
	[targetgroup] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_docclasses](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[docClassName] [varchar](255) NOT NULL,
	[docClassDescription] [varchar](255) NULL,
	[docClassExpiretionDate] [varchar](255) NULL,
	[docClassExpiretionType] [varchar](255) NULL,
	[docClassDirectoryId] [numeric](19, 0) NULL,
	[docClassEncoding] [varchar](255) NULL,
	[docClassCompressing] [varchar](255) NULL,
	[docClassFTSServerId] [numeric](19, 0) NULL,
	[cipherAlgorithm] [varchar](255) NULL,
	[keyLength] [numeric](19, 0) NULL,
	[docClassOrderId] [numeric](19, 0) NULL,
	[docClassIndexPath] [varchar](255) NULL,
	[docClassIndex] [varchar](255) NULL,
	[maxfilesize] [bigint] NULL,
	[logicalconn] [varchar](255) DEFAULT 'AND'
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY],
 CONSTRAINT [UK_cn0lf0l2yuh5uwvpi86bl1dsr] UNIQUE NONCLUSTERED
(
	[docClassName] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_docclassprotection](
	[docclassid] [bigint] NOT NULL,
    [isgroup] [bit] NOT NULL,
    [resourceid] [varchar](255) NOT NULL,
    [logicalconnection] [varchar](50),
    CONSTRAINT pm_docclassprotection_pkey PRIMARY KEY (docclassid, isgroup, resourceid)
)
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[PM_SCHEDULED_TASKS_PARAMETERS](
	[SCHEDULED_TASK_PARAMETER_ID] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[parameter_type] [varchar](255) NOT NULL,
	[parameter_value] [varchar](255) NOT NULL,
	[parameter_position] [int] NOT NULL,
	[SCHEDULED_TASK_ID] [numeric](19, 0) NOT NULL,
PRIMARY KEY CLUSTERED
(
	[SCHEDULED_TASK_PARAMETER_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_scheduled_tasks_history](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[startDate] [datetime] NOT NULL,
	[finishDate] [datetime] NULL,
	[success] [bit] NOT NULL,
	[result] [varchar](1000) NULL,
	[taskId] [numeric](19, 0) NOT NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[ProcessDataWOB](
	[Process] [decimal](19, 0) NOT NULL,
	[VariableDefinitionId] [varchar](100) NOT NULL,
	[VariableType] [int] NOT NULL,
	[VariableValueVCHAR] [varchar](4000) NULL,
	[VariableValueDBL] [float] NULL,
	[VariableValueLONG] [bigint] NULL,
	[VariableValueDATE] [datetime] NULL,
	[VariableValueBOOL] [tinyint] NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [ProcessDataWOB_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_ProcessDataWOB] ON [dbo].[ProcessDataWOB]
(
	[Process] ASC,
	[VariableDefinitionId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[Activities](
	[Id] [varchar](100) NOT NULL,
	[ActivitySetDefinitionId] [varchar](90) NULL,
	[ActivityDefinitionId] [varchar](90) NOT NULL,
	[Process] [decimal](19, 0) NOT NULL,
	[TheResource] [decimal](19, 0) NULL,
	[PDefName] [varchar](200) NOT NULL,
	[ProcessId] [varchar](200) NOT NULL,
	[ResourceId] [varchar](100) NULL,
	[State] [decimal](19, 0) NOT NULL,
	[BlockActivityId] [varchar](100) NULL,
	[Performer] [varchar](100) NULL,
	[IsPerformerAsynchronous] [tinyint] NULL,
	[Priority] [int] NULL,
	[Name] [varchar](254) NULL,
	[Activated] [bigint] NOT NULL,
	[Accepted] [bigint] NULL,
	[LastStateTime] [bigint] NOT NULL,
	[LimitTime] [bigint] NOT NULL,
	[Description] [varchar](254) NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [Activities_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_Activities] ON [dbo].[Activities]
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [I2_Activities] ON [dbo].[Activities]
(
	[Process] ASC,
	[ActivitySetDefinitionId] ASC,
	[ActivityDefinitionId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [I3_Activities] ON [dbo].[Activities]
(
	[Process] ASC,
	[State] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[GroupUserPackLevelParticipant](
	[PARTICIPANTOID] [decimal](19, 0) NOT NULL,
	[USEROID] [decimal](19, 0) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [GroupUserPackLevelParticipant_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_GroupUserPackLevelParticipant] ON [dbo].[GroupUserPackLevelParticipant]
(
	[PARTICIPANTOID] ASC,
	[USEROID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[OldEventAuditData](
	[DataEventAudit] [decimal](19, 0) NOT NULL,
	[VariableDefinitionId] [varchar](100) NOT NULL,
	[VariableType] [int] NOT NULL,
	[VariableValue] [image] NULL,
	[VariableValueVCHAR] [varchar](4000) NULL,
	[VariableValueDBL] [float] NULL,
	[VariableValueLONG] [bigint] NULL,
	[VariableValueDATE] [datetime] NULL,
	[VariableValueBOOL] [tinyint] NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [OldEventAuditData_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_OldEventAuditData] ON [dbo].[OldEventAuditData]
(
	[DataEventAudit] ASC,
	[VariableDefinitionId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[NewEventAuditData](
	[DataEventAudit] [decimal](19, 0) NOT NULL,
	[VariableDefinitionId] [varchar](100) NOT NULL,
	[VariableType] [int] NOT NULL,
	[VariableValue] [image] NULL,
	[VariableValueVCHAR] [varchar](4000) NULL,
	[VariableValueDBL] [float] NULL,
	[VariableValueLONG] [bigint] NULL,
	[VariableValueDATE] [datetime] NULL,
	[VariableValueBOOL] [tinyint] NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [NewEventAuditData_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_NewEventAuditData] ON [dbo].[NewEventAuditData]
(
	[DataEventAudit] ASC,
	[VariableDefinitionId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PackLevelXPDLAppToolAgentApp](
	[XPDL_APPOID] [decimal](19, 0) NOT NULL,
	[TOOLAGENTOID] [decimal](19, 0) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [PackLevelXPDLAppToolAgentApp_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_PackLevelXPDLAppToolAgentApp] ON [dbo].[PackLevelXPDLAppToolAgentApp]
(
	[XPDL_APPOID] ASC,
	[TOOLAGENTOID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PackLevelXPDLAppTAAppUser](
	[XPDL_APPOID] [decimal](19, 0) NOT NULL,
	[TOOLAGENTOID] [decimal](19, 0) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [PackLevelXPDLAppTAAppUser_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_PackLevelXPDLAppTAAppUser] ON [dbo].[PackLevelXPDLAppTAAppUser]
(
	[XPDL_APPOID] ASC,
	[TOOLAGENTOID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[NewEventAuditDataWOB](
	[DataEventAudit] [decimal](19, 0) NOT NULL,
	[VariableDefinitionId] [varchar](100) NOT NULL,
	[VariableType] [int] NOT NULL,
	[VariableValueVCHAR] [varchar](4000) NULL,
	[VariableValueDBL] [float] NULL,
	[VariableValueLONG] [bigint] NULL,
	[VariableValueDATE] [datetime] NULL,
	[VariableValueBOOL] [tinyint] NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [NewEventAuditDataWOB_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_NewEventAuditDataWOB] ON [dbo].[NewEventAuditDataWOB]
(
	[DataEventAudit] ASC,
	[VariableDefinitionId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[OldEventAuditDataWOB](
	[DataEventAudit] [decimal](19, 0) NOT NULL,
	[VariableDefinitionId] [varchar](100) NOT NULL,
	[VariableType] [int] NOT NULL,
	[VariableValueVCHAR] [varchar](4000) NULL,
	[VariableValueDBL] [float] NULL,
	[VariableValueLONG] [bigint] NULL,
	[VariableValueDATE] [datetime] NULL,
	[VariableValueBOOL] [tinyint] NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [OldEventAuditDataWOB_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_OldEventAuditDataWOB] ON [dbo].[OldEventAuditDataWOB]
(
	[DataEventAudit] ASC,
	[VariableDefinitionId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[UserPackLevelParticipant](
	[PARTICIPANTOID] [decimal](19, 0) NOT NULL,
	[USEROID] [decimal](19, 0) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [UserPackLevelParticipant_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_UserPackLevelParticipant] ON [dbo].[UserPackLevelParticipant]
(
	[PARTICIPANTOID] ASC,
	[USEROID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[ProcLevelXPDLApp](
	[APPLICATION_ID] [varchar](90) NOT NULL,
	[PROCESSOID] [decimal](19, 0) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [ProcLevelXPDLApp_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_ProcLevelXPDLApp] ON [dbo].[ProcLevelXPDLApp]
(
	[APPLICATION_ID] ASC,
	[PROCESSOID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[ProcLevelParticipant](
	[PARTICIPANT_ID] [varchar](90) NOT NULL,
	[PROCESSOID] [decimal](19, 0) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [ProcLevelParticipant_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_ProcLevelParticipant] ON [dbo].[ProcLevelParticipant]
(
	[PARTICIPANT_ID] ASC,
	[PROCESSOID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PackLevelXPDLAppTAAppDetail](
	[XPDL_APPOID] [decimal](19, 0) NOT NULL,
	[TOOLAGENTOID] [decimal](19, 0) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [PackLevelXPDLAppTAAppDetail_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_PackLevelXPDLAppTAAppDetail] ON [dbo].[PackLevelXPDLAppTAAppDetail]
(
	[XPDL_APPOID] ASC,
	[TOOLAGENTOID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[ProcessData](
	[Process] [decimal](19, 0) NOT NULL,
	[VariableDefinitionId] [varchar](100) NOT NULL,
	[VariableType] [int] NOT NULL,
	[VariableValue] [image] NULL,
	[VariableValueVCHAR] [varchar](4000) NULL,
	[VariableValueDBL] [float] NULL,
	[VariableValueLONG] [bigint] NULL,
	[VariableValueDATE] [datetime] NULL,
	[VariableValueBOOL] [tinyint] NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [ProcessData_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_ProcessData] ON [dbo].[ProcessData]
(
	[Process] ASC,
	[VariableDefinitionId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_vvalues](
	[tableId] [varchar](255) NOT NULL,
	[columnId] [varchar](255) NOT NULL,
	[vvalue_rowId] [int] NOT NULL,
	[modified] [datetime] NOT NULL,
	[cellValue] [varchar](1024) NULL,
	[userId] [varchar](255) NOT NULL,
PRIMARY KEY CLUSTERED
(
	[tableId] ASC,
	[columnId] ASC,
	[vvalue_rowId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ToolAgentAppDetailUser](
	[TOOLAGENT_APPOID] [decimal](19, 0) NOT NULL,
	[USEROID] [decimal](19, 0) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [ToolAgentAppDetailUser_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_ToolAgentAppDetailUser] ON [dbo].[ToolAgentAppDetailUser]
(
	[TOOLAGENT_APPOID] ASC,
	[USEROID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[UserProcLevelParticipant](
	[PARTICIPANTOID] [decimal](19, 0) NOT NULL,
	[USEROID] [decimal](19, 0) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [UserProcLevelParticipant_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_UserProcLevelParticipant] ON [dbo].[UserProcLevelParticipant]
(
	[PARTICIPANTOID] ASC,
	[USEROID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ProcLevelXPDLAppToolAgentApp](
	[XPDL_APPOID] [decimal](19, 0) NOT NULL,
	[TOOLAGENTOID] [decimal](19, 0) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [ProcLevelXPDLAppToolAgentApp_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_ProcLevelXPDLAppToolAgentApp] ON [dbo].[ProcLevelXPDLAppToolAgentApp]
(
	[XPDL_APPOID] ASC,
	[TOOLAGENTOID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ProcLevelXPDLAppTAAppUser](
	[XPDL_APPOID] [decimal](19, 0) NOT NULL,
	[TOOLAGENTOID] [decimal](19, 0) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [ProcLevelXPDLAppTAAppUser_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_ProcLevelXPDLAppTAAppUser] ON [dbo].[ProcLevelXPDLAppTAAppUser]
(
	[XPDL_APPOID] ASC,
	[TOOLAGENTOID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ProcLevelXPDLAppTAAppDetailUsr](
	[XPDL_APPOID] [decimal](19, 0) NOT NULL,
	[TOOLAGENTOID] [decimal](19, 0) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [ProcLevelXPDLAppTAAppDetailUsr_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_ProcLevelXPDLAppTAAppDetailUsr] ON [dbo].[ProcLevelXPDLAppTAAppDetailUsr]
(
	[XPDL_APPOID] ASC,
	[TOOLAGENTOID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ProcLevelXPDLAppTAAppDetail](
	[XPDL_APPOID] [decimal](19, 0) NOT NULL,
	[TOOLAGENTOID] [decimal](19, 0) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [ProcLevelXPDLAppTAAppDetail_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_ProcLevelXPDLAppTAAppDetail] ON [dbo].[ProcLevelXPDLAppTAAppDetail]
(
	[XPDL_APPOID] ASC,
	[TOOLAGENTOID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[ProcessRequesters](
	[Id] [varchar](100) NOT NULL,
	[ActivityRequester] [decimal](19, 0) NULL,
	[ResourceRequester] [decimal](19, 0) NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [ProcessRequesters_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_ProcessRequesters] ON [dbo].[ProcessRequesters]
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [I2_ProcessRequesters] ON [dbo].[ProcessRequesters]
(
	[ActivityRequester] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [I3_ProcessRequesters] ON [dbo].[ProcessRequesters]
(
	[ResourceRequester] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[OldEventAuditDataBLOBs](
	[OldEventAuditDataWOB] [decimal](19, 0) NOT NULL,
	[VariableValue] [image] NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [OldEventAuditDataBLOBs_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_OldEventAuditDataBLOBs] ON [dbo].[OldEventAuditDataBLOBs]
(
	[OldEventAuditDataWOB] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[NewEventAuditDataBLOBs](
	[NewEventAuditDataWOB] [decimal](19, 0) NOT NULL,
	[VariableValue] [image] NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [NewEventAuditDataBLOBs_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_NewEventAuditDataBLOBs] ON [dbo].[NewEventAuditDataBLOBs]
(
	[NewEventAuditDataWOB] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PackLevelXPDLAppTAAppDetailUsr](
	[XPDL_APPOID] [decimal](19, 0) NOT NULL,
	[TOOLAGENTOID] [decimal](19, 0) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [PackLevelXPDLAppTAAppDetailUsr_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_PackLevelXPDLAppTAAppDetailUsr] ON [dbo].[PackLevelXPDLAppTAAppDetailUsr]
(
	[XPDL_APPOID] ASC,
	[TOOLAGENTOID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[GroupUserProcLevelParticipant](
	[PARTICIPANTOID] [decimal](19, 0) NOT NULL,
	[USEROID] [decimal](19, 0) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [GroupUserProcLevelParticipant_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_GroupUserProcLevelParticipant] ON [dbo].[GroupUserProcLevelParticipant]
(
	[PARTICIPANTOID] ASC,
	[USEROID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[ActivityData](
	[Activity] [decimal](19, 0) NOT NULL,
	[VariableDefinitionId] [varchar](100) NOT NULL,
	[VariableType] [int] NOT NULL,
	[VariableValue] [image] NULL,
	[VariableValueVCHAR] [varchar](4000) NULL,
	[VariableValueDBL] [float] NULL,
	[VariableValueLONG] [bigint] NULL,
	[VariableValueDATE] [datetime] NULL,
	[VariableValueBOOL] [tinyint] NULL,
	[IsResult] [tinyint] NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [ActivityData_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_ActivityData] ON [dbo].[ActivityData]
(
	[Activity] ASC,
	[VariableDefinitionId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_actions](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[docclassId] [numeric](19, 0) NULL,
	[actionName] [varchar](255) NULL,
	[actionSource] [varchar](255) NULL,
	[actionType] [varchar](255) NULL,
	[actionValue] [varchar](255) NULL,
	[actionValue2] [varchar](4000) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[Deadlines](
	[Process] [decimal](19, 0) NOT NULL,
	[Activity] [decimal](19, 0) NOT NULL,
	[CNT] [decimal](19, 0) NOT NULL,
	[TimeLimit] [bigint] NOT NULL,
	[ExceptionName] [varchar](100) NOT NULL,
	[IsSynchronous] [tinyint] NOT NULL,
	[IsExecuted] [tinyint] NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [Deadlines_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_Deadlines] ON [dbo].[Deadlines]
(
	[CNT] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [I2_Deadlines] ON [dbo].[Deadlines]
(
	[Process] ASC,
	[TimeLimit] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [I3_Deadlines] ON [dbo].[Deadlines]
(
	[Activity] ASC,
	[TimeLimit] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [i01_deadlines] ON [dbo].[Deadlines]
(
	[process] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [i02_deadlines] ON [dbo].[Deadlines]
(
	[activity] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[AssignmentsTable](
	[Activity] [decimal](19, 0) NOT NULL,
	[TheResource] [decimal](19, 0) NOT NULL,
	[ActivityId] [varchar](100) NOT NULL,
	[ActivityProcessId] [varchar](100) NOT NULL,
	[ActivityProcessDefName] [varchar](200) NOT NULL,
	[ResourceId] [varchar](100) NOT NULL,
	[IsAccepted] [tinyint] NOT NULL,
	[IsValid] [tinyint] NOT NULL,
	[CNT] [decimal](19, 0) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [AssignmentsTable_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_AssignmentsTable] ON [dbo].[AssignmentsTable]
(
	[CNT] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [I2_AssignmentsTable] ON [dbo].[AssignmentsTable]
(
	[Activity] ASC,
	[TheResource] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [I3_AssignmentsTable] ON [dbo].[AssignmentsTable]
(
	[TheResource] ASC,
	[IsValid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [I4_AssignmentsTable] ON [dbo].[AssignmentsTable]
(
	[ActivityId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [I5_AssignmentsTable] ON [dbo].[AssignmentsTable]
(
	[ResourceId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[AndJoinTable](
	[Process] [decimal](19, 0) NOT NULL,
	[ActivitySetDefinitionId] [varchar](90) NULL,
	[ActivityDefinitionId] [varchar](90) NOT NULL,
	[Activity] [decimal](19, 0) NOT NULL,
	[CNT] [decimal](19, 0) NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [AndJoinTable_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_AndJoinTable] ON [dbo].[AndJoinTable]
(
	[CNT] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [I2_AndJoinTable] ON [dbo].[AndJoinTable]
(
	[Process] ASC,
	[ActivitySetDefinitionId] ASC,
	[ActivityDefinitionId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [I3_AndJoinTable] ON [dbo].[AndJoinTable]
(
	[Activity] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[ActivityDataWOB](
	[Activity] [decimal](19, 0) NOT NULL,
	[VariableDefinitionId] [varchar](100) NOT NULL,
	[VariableType] [int] NOT NULL,
	[VariableValueVCHAR] [varchar](4000) NULL,
	[VariableValueDBL] [float] NULL,
	[VariableValueLONG] [bigint] NULL,
	[VariableValueDATE] [datetime] NULL,
	[VariableValueBOOL] [tinyint] NULL,
	[IsResult] [tinyint] NOT NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [ActivityDataWOB_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_ActivityDataWOB] ON [dbo].[ActivityDataWOB]
(
	[Activity] ASC,
	[VariableDefinitionId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ProcessDataBLOBs](
	[ProcessDataWOB] [decimal](19, 0) NOT NULL,
	[VariableValue] [image] NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [ProcessDataBLOBs_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_ProcessDataBLOBs] ON [dbo].[ProcessDataBLOBs]
(
	[ProcessDataWOB] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_docclassconditionprotection](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[condition] [varchar](255) NULL,
	[conditionType] [varchar](255) NULL,
	[isGroup] [bit] NOT NULL,
	[protector] [varchar](255) NULL,
	[userId] [varchar](255) NULL,
	[docclassid] [numeric](19, 0) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [i01_pm_docclassconditionprot] ON [dbo].[pm_docclassconditionprotection]
(
	[docclassid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [i02_pm_docclassconditionprot] ON [dbo].[pm_docclassconditionprotection]
(
	[userid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_indecies](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[docclassId] [numeric](19, 0) NULL,
	[indexName] [varchar](255) NULL,
	[indexDescription] [varchar](255) NULL,
	[indexType] [varchar](255) NULL,
	[indexValues] [varchar](4000) NULL,
	[indexOrderId] [numeric](19, 0) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [i01_pm_indecies] ON [dbo].[pm_indecies]
(
	[docclassid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_files](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[file_date] [datetime] NULL,
	[name] [varchar](255) NULL,
	[org_name] [varchar](255) NULL,
	[path] [varchar](255) NULL,
	[uploader] [varchar](255) NULL,
	[description] [varchar](255) NULL,
	[file_size] [numeric](19, 0) NULL,
	[compressed] [varchar](255) NULL,
	[encrypted] [varchar](255) NULL,
	[cipherAlgorithm] [varchar](255) NULL,
	[cipherkey] [varchar](255) NULL,
	[docclassid] [numeric](19, 0) NOT NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[pm_linkconnection](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[linkId] [numeric](19, 0) NULL,
	[linkIndexId] [numeric](19, 0) NULL,
	[docClassId] [numeric](19, 0) NULL,
	[indexId] [numeric](19, 0) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[pm_file_versions](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[fileid] [numeric](19, 0) NOT NULL,
	[parent_fileid] [numeric](19, 0) NULL,
	[checkout_date] [datetime] NULL,
	[checkin_date] [datetime] NULL,
	[checkout_user] [varchar](255) NULL,
	[state] [varchar](255) NULL,
	[file_comment] [varchar](255) NULL,
	[replace_date] [datetime] NULL,
	[version] [numeric](19, 0) NULL,
	[newest_fileid] [numeric](19, 0) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY],
 CONSTRAINT [UK_5g95e5rtev82dsy4ei5qtnde2] UNIQUE NONCLUSTERED
(
	[fileid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [i01_pm_file_versions] ON [dbo].[pm_file_versions]
(
	[newest_fileid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ActivityDataBLOBs](
	[ActivityDataWOB] [decimal](19, 0) NOT NULL,
	[VariableValue] [image] NULL,
	[oid] [decimal](19, 0) NOT NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [ActivityDataBLOBs_oid] PRIMARY KEY CLUSTERED
(
	[oid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [I1_ActivityDataBLOBs] ON [dbo].[ActivityDataBLOBs]
(
	[ActivityDataWOB] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[pm_activity_document](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[date] [datetime] NOT NULL,
	[activity] [decimal](19, 0) NULL,
	[fileid] [numeric](19, 0) NOT NULL,
	[process] [decimal](19, 0) NOT NULL,
	[userid] [decimal](19, 0) NOT NULL,
	[version] [numeric](19, 0) NOT NULL,
	[addedhere] bit NOT NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [i01_pm_activity_document] ON [dbo].[pm_activity_document]
(
	[process] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [i02_pm_activity_document] ON [dbo].[pm_activity_document]
(
	[activity] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [i03_pm_activity_document] ON [dbo].[pm_activity_document]
(
	[fileid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [i04_pm_activity_document] ON [dbo].[pm_activity_document]
(
	[userid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_i01_usertable', N'plusworkflow', 1482230592284, N'EXECUTED', '', N'3.1.32')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_i02_usertable', N'plusworkflow', 1482230592300, N'EXECUTED', '', N'3.1.32')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_i01_pm_file_versions', N'plusworkflow', 1482230592315, N'EXECUTED', '', N'3.1.32')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_i01_pm_substitutions', N'plusworkflow', 1482230592329, N'EXECUTED', '', N'3.1.32')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_i01_pm_notificationprocact', N'plusworkflow', 1482230592343, N'EXECUTED', '', N'3.1.32')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_i01_pm_usersearchviewsprotection', N'plusworkflow', 1482230592357, N'EXECUTED', '', N'3.1.32')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_i01_pm_usersearchviews', N'plusworkflow', 1482230592372, N'EXECUTED', '', N'3.1.32')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_i01_pm_advancesearchvariables', N'plusworkflow', 1482230592386, N'EXECUTED', '', N'3.1.32')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_i01_pm_reportvariable', N'plusworkflow', 1482230592399, N'EXECUTED', '', N'3.1.32')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_i01_pm_reports', N'plusworkflow', 1482230592413, N'EXECUTED', '', N'3.1.32')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_i01_pm_rights', N'plusworkflow', 1482230592427, N'EXECUTED', '', N'3.1.32')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_i02_pm_rights', N'plusworkflow', 1482230592441, N'EXECUTED', '', N'3.1.32')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_i01_pm_indecies', N'plusworkflow', 1482230592453, N'EXECUTED', '', N'3.1.32')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_i01_pm_notifications', N'plusworkflow', 1482230592465, N'EXECUTED', '', N'3.1.32')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_i01_deadlines', N'plusworkflow', 1482230592478, N'EXECUTED', '', N'3.1.32')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_i02_deadlines', N'plusworkflow', 1482230592491, N'EXECUTED', '', N'3.1.32')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_i01_usergrouptable', N'plusworkflow', 1482230592503, N'EXECUTED', '', N'3.1.32')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_i01_pm_activity_document', N'plusworkflow', 1482230592515, N'EXECUTED', '', N'3.1.32')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_i02_pm_activity_document', N'plusworkflow', 1482230592526, N'EXECUTED', '', N'3.1.32')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_i03_pm_activity_document', N'plusworkflow', 1482230592538, N'EXECUTED', '', N'3.1.32')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_i04_pm_activity_document', N'plusworkflow', 1482230592551, N'EXECUTED', '', N'3.1.32')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_i01_pm_activitycomments', N'plusworkflow', 1482230592562, N'EXECUTED', '', N'3.1.32')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_i01_pm_delegatedactivities', N'plusworkflow', 1482230592574, N'EXECUTED', '', N'3.1.32')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_i02_pm_delegatedactivities', N'plusworkflow', 1482230592586, N'EXECUTED', '', N'3.1.32')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_i01_pm_docclassconditionprotection', N'plusworkflow', 1482230592597, N'EXECUTED', '', N'3.1.32')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_i02_pm_docclassconditionprotection', N'plusworkflow', 1482230592609, N'EXECUTED', '', N'3.1.32')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_i01_pm_activity_status', N'plusworkflow', 1482230592620, N'EXECUTED', '', N'3.1.32')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_i01_pm_document_views', N'plusworkflow', 1482230592632, N'EXECUTED', '', N'3.1.32')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_i01_pm_user_notifications', N'plusworkflow', 1482230592643, N'EXECUTED', '', N'3.1.32')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_i02_pm_user_notifications', N'plusworkflow', 1482230592655, N'EXECUTED', '', N'3.1.32')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_i01_pm_usercalendarshare', N'plusworkflow', 1482230592667, N'EXECUTED', '', N'3.1.32')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_max_file_size', N'plusworkflow', 1482230592672, N'EXECUTED', '', N'3.1.39')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_docclass_protection', N'plusworkflow', 1482230592673, N'EXECUTED', '', N'3.1.67')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_pm_systemparameter', N'plusworkflow', 1482230592674, N'EXECUTED', '', N'3.2.0')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_pm_systemparametercategory', N'plusworkflow', 1482230592675, N'EXECUTED', '', N'3.2.0')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_pm_systemparametercombovalues', N'plusworkflow', 1482230592676, N'EXECUTED', '', N'3.2.0')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'insert_Rights.Optional_category', N'plusworkflow', 1482230592677, N'EXECUTED', '', N'3.2.0')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'insert_Rights.Views.Enabled_param', N'plusworkflow', 1482230592678, N'EXECUTED', '', N'3.2.0')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'insert_Rights.UserAccount.Enabled_param', N'plusworkflow', 1482230592679, N'EXECUTED', '', N'3.2.0')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'insert_General_category', N'plusworkflow', 1482230592680, N'EXECUTED', '', N'3.2.0')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'insert_UniversalPassword_param', N'plusworkflow', 1482230592681, N'EXECUTED', '', N'3.2.0')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_domain_server_mapping_columns', N'plusworkflow', 1482230592682, N'EXECUTED', '', N'3.2.2')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'change_number_to_long_parameters', N'plusworkflow', 1482230592683, N'EXECUTED', '', N'3.2.6')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_valuedouble_column', N'plusworkflow', 1482230592683, N'EXECUTED', '', N'3.2.6')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_pm_scheduled_tasks_component', N'plusworkflow', 1482230592684, N'EXECUTED', '', N'3.2.12')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'create_sequence_pm_scheduledtaskscomp_seq', N'plusworkflow', 1482230592685, N'EXECUTED', '', N'3.2.12')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'create_pm_trial', N'plusworkflow', 1482230592686, N'EXECUTED', '', N'3.2.15')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'create_pm_trial_id_seq', N'plusworkflow', 1482230592687, N'EXECUTED', '', N'3.2.15')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'create_pm_externaldb_conf', N'plusworkflow', 1482230592687, N'EXECUTED', '', N'3.2.20')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'create_externaldbconf_id_seq', N'plusworkflow', 1482230592687, N'EXECUTED', '', N'3.2.20')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'change_pm_querydatachooser_query', N'plusworkflow', 1482230592687, N'EXECUTED', '', N'3.2.20')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'change_pm_querydatachooser_countquery', N'plusworkflow', 1482230592687, N'EXECUTED', '', N'3.2.20')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'create_pm_querydatachooser', N'plusworkflow', 1482230592687, N'EXECUTED', '', N'3.2.20')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'create_querydatachooser_id_seq', N'plusworkflow', 1482230592687, N'EXECUTED', '', N'3.2.20')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'insert_ShowCalendarCart_param', N'plusworkflow', 1482230592687, N'EXECUTED', '', N'3.2.31')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'add_cascadeOnDelete_pm_failedloggingregister', N'plusworkflow', 1482230592687, N'EXECUTED', '', N'3.2.45')
INSERT [dbo].[db_changelog] ([id], [project], [change_date], [change_result], [message], [version]) VALUES (N'insert_ShowStatistics_param', N'plusworkflow', 1482230592687, N'EXECUTED', '', N'4.0.0')

GO
ALTER TABLE [dbo].[pm_sequences] ADD  DEFAULT ((1)) FOR [increment]
GO
ALTER TABLE [dbo].[pm_sequences] ADD  DEFAULT ((1)) FOR [current_value]
GO
ALTER TABLE [dbo].[Activities]  WITH CHECK ADD  CONSTRAINT [Activities_Process] FOREIGN KEY([Process])
REFERENCES [dbo].[Processes] ([oid])
GO
ALTER TABLE [dbo].[Activities] CHECK CONSTRAINT [Activities_Process]
GO
ALTER TABLE [dbo].[Activities]  WITH CHECK ADD  CONSTRAINT [Activities_State] FOREIGN KEY([State])
REFERENCES [dbo].[ActivityStates] ([oid])
GO
ALTER TABLE [dbo].[Activities] CHECK CONSTRAINT [Activities_State]
GO
ALTER TABLE [dbo].[Activities]  WITH CHECK ADD  CONSTRAINT [Activities_TheResource] FOREIGN KEY([TheResource])
REFERENCES [dbo].[ResourcesTable] ([oid])
GO
ALTER TABLE [dbo].[Activities] CHECK CONSTRAINT [Activities_TheResource]
GO
ALTER TABLE [dbo].[ActivityData]  WITH CHECK ADD  CONSTRAINT [ActivityData_Activity] FOREIGN KEY([Activity])
REFERENCES [dbo].[Activities] ([oid])
GO
ALTER TABLE [dbo].[ActivityData] CHECK CONSTRAINT [ActivityData_Activity]
GO
ALTER TABLE [dbo].[ActivityDataBLOBs]  WITH CHECK ADD  CONSTRAINT [ActivityDataBLOBs_ActivityDataWOB] FOREIGN KEY([ActivityDataWOB])
REFERENCES [dbo].[ActivityDataWOB] ([oid])
GO
ALTER TABLE [dbo].[ActivityDataBLOBs] CHECK CONSTRAINT [ActivityDataBLOBs_ActivityDataWOB]
GO
ALTER TABLE [dbo].[ActivityDataWOB]  WITH CHECK ADD  CONSTRAINT [ActivityDataWOB_Activity] FOREIGN KEY([Activity])
REFERENCES [dbo].[Activities] ([oid])
GO
ALTER TABLE [dbo].[ActivityDataWOB] CHECK CONSTRAINT [ActivityDataWOB_Activity]
GO
ALTER TABLE [dbo].[AndJoinTable]  WITH CHECK ADD  CONSTRAINT [AndJoinTable_Activity] FOREIGN KEY([Activity])
REFERENCES [dbo].[Activities] ([oid])
GO
ALTER TABLE [dbo].[AndJoinTable] CHECK CONSTRAINT [AndJoinTable_Activity]
GO
ALTER TABLE [dbo].[AndJoinTable]  WITH CHECK ADD  CONSTRAINT [AndJoinTable_Process] FOREIGN KEY([Process])
REFERENCES [dbo].[Processes] ([oid])
GO
ALTER TABLE [dbo].[AndJoinTable] CHECK CONSTRAINT [AndJoinTable_Process]
GO
ALTER TABLE [dbo].[AssignmentEventAudits]  WITH CHECK ADD  CONSTRAINT [AssignmentEventAudits_TheType] FOREIGN KEY([TheType])
REFERENCES [dbo].[EventTypes] ([oid])
GO
ALTER TABLE [dbo].[AssignmentEventAudits] CHECK CONSTRAINT [AssignmentEventAudits_TheType]
GO
ALTER TABLE [dbo].[AssignmentsTable]  WITH CHECK ADD  CONSTRAINT [AssignmentsTable_Activity] FOREIGN KEY([Activity])
REFERENCES [dbo].[Activities] ([oid])
GO
ALTER TABLE [dbo].[AssignmentsTable] CHECK CONSTRAINT [AssignmentsTable_Activity]
GO
ALTER TABLE [dbo].[AssignmentsTable]  WITH CHECK ADD  CONSTRAINT [AssignmentsTable_TheResource] FOREIGN KEY([TheResource])
REFERENCES [dbo].[ResourcesTable] ([oid])
GO
ALTER TABLE [dbo].[AssignmentsTable] CHECK CONSTRAINT [AssignmentsTable_TheResource]
GO
ALTER TABLE [dbo].[CreateProcessEventAudits]  WITH CHECK ADD  CONSTRAINT [CreateProcessEventAudits_TheType] FOREIGN KEY([TheType])
REFERENCES [dbo].[EventTypes] ([oid])
GO
ALTER TABLE [dbo].[CreateProcessEventAudits] CHECK CONSTRAINT [CreateProcessEventAudits_TheType]
GO
ALTER TABLE [dbo].[DataEventAudits]  WITH CHECK ADD  CONSTRAINT [DataEventAudits_TheType] FOREIGN KEY([TheType])
REFERENCES [dbo].[EventTypes] ([oid])
GO
ALTER TABLE [dbo].[DataEventAudits] CHECK CONSTRAINT [DataEventAudits_TheType]
GO
ALTER TABLE [dbo].[Deadlines]  WITH CHECK ADD  CONSTRAINT [Deadlines_Activity] FOREIGN KEY([Activity])
REFERENCES [dbo].[Activities] ([oid])
GO
ALTER TABLE [dbo].[Deadlines] CHECK CONSTRAINT [Deadlines_Activity]
GO
ALTER TABLE [dbo].[Deadlines]  WITH CHECK ADD  CONSTRAINT [Deadlines_Process] FOREIGN KEY([Process])
REFERENCES [dbo].[Processes] ([oid])
GO
ALTER TABLE [dbo].[Deadlines] CHECK CONSTRAINT [Deadlines_Process]
GO
ALTER TABLE [dbo].[GroupGroupTable]  WITH CHECK ADD  CONSTRAINT [GroupGroupTable_groupid] FOREIGN KEY([groupid])
REFERENCES [dbo].[GroupTable] ([oid])
GO
ALTER TABLE [dbo].[GroupGroupTable] CHECK CONSTRAINT [GroupGroupTable_groupid]
GO
ALTER TABLE [dbo].[GroupGroupTable]  WITH CHECK ADD  CONSTRAINT [GroupGroupTable_sub_gid] FOREIGN KEY([sub_gid])
REFERENCES [dbo].[GroupTable] ([oid])
GO
ALTER TABLE [dbo].[GroupGroupTable] CHECK CONSTRAINT [GroupGroupTable_sub_gid]
GO
ALTER TABLE [dbo].[GroupUserPackLevelParticipant]  WITH CHECK ADD  CONSTRAINT [GroupUserPackLevelParticipant_PARTICIPANTOID] FOREIGN KEY([PARTICIPANTOID])
REFERENCES [dbo].[PackLevelParticipant] ([oid])
GO
ALTER TABLE [dbo].[GroupUserPackLevelParticipant] CHECK CONSTRAINT [GroupUserPackLevelParticipant_PARTICIPANTOID]
GO
ALTER TABLE [dbo].[GroupUserPackLevelParticipant]  WITH CHECK ADD  CONSTRAINT [GroupUserPackLevelParticipant_USEROID] FOREIGN KEY([USEROID])
REFERENCES [dbo].[GroupUser] ([oid])
GO
ALTER TABLE [dbo].[GroupUserPackLevelParticipant] CHECK CONSTRAINT [GroupUserPackLevelParticipant_USEROID]
GO
ALTER TABLE [dbo].[GroupUserProcLevelParticipant]  WITH CHECK ADD  CONSTRAINT [GroupUserProcLevelParticipant_PARTICIPANTOID] FOREIGN KEY([PARTICIPANTOID])
REFERENCES [dbo].[ProcLevelParticipant] ([oid])
GO
ALTER TABLE [dbo].[GroupUserProcLevelParticipant] CHECK CONSTRAINT [GroupUserProcLevelParticipant_PARTICIPANTOID]
GO
ALTER TABLE [dbo].[GroupUserProcLevelParticipant]  WITH CHECK ADD  CONSTRAINT [GroupUserProcLevelParticipant_USEROID] FOREIGN KEY([USEROID])
REFERENCES [dbo].[GroupUser] ([oid])
GO
ALTER TABLE [dbo].[GroupUserProcLevelParticipant] CHECK CONSTRAINT [GroupUserProcLevelParticipant_USEROID]
GO
ALTER TABLE [dbo].[NewEventAuditData]  WITH CHECK ADD  CONSTRAINT [NewEventAuditData_DataEventAudit] FOREIGN KEY([DataEventAudit])
REFERENCES [dbo].[DataEventAudits] ([oid])
GO
ALTER TABLE [dbo].[NewEventAuditData] CHECK CONSTRAINT [NewEventAuditData_DataEventAudit]
GO
ALTER TABLE [dbo].[NewEventAuditDataBLOBs]  WITH CHECK ADD  CONSTRAINT [NewEventAuditDataBLOBs_NewEventAuditDataWOB] FOREIGN KEY([NewEventAuditDataWOB])
REFERENCES [dbo].[NewEventAuditDataWOB] ([oid])
GO
ALTER TABLE [dbo].[NewEventAuditDataBLOBs] CHECK CONSTRAINT [NewEventAuditDataBLOBs_NewEventAuditDataWOB]
GO
ALTER TABLE [dbo].[NewEventAuditDataWOB]  WITH CHECK ADD  CONSTRAINT [NewEventAuditDataWOB_DataEventAudit] FOREIGN KEY([DataEventAudit])
REFERENCES [dbo].[DataEventAudits] ([oid])
GO
ALTER TABLE [dbo].[NewEventAuditDataWOB] CHECK CONSTRAINT [NewEventAuditDataWOB_DataEventAudit]
GO
ALTER TABLE [dbo].[OldEventAuditData]  WITH CHECK ADD  CONSTRAINT [OldEventAuditData_DataEventAudit] FOREIGN KEY([DataEventAudit])
REFERENCES [dbo].[DataEventAudits] ([oid])
GO
ALTER TABLE [dbo].[OldEventAuditData] CHECK CONSTRAINT [OldEventAuditData_DataEventAudit]
GO
ALTER TABLE [dbo].[OldEventAuditDataBLOBs]  WITH CHECK ADD  CONSTRAINT [OldEventAuditDataBLOBs_OldEventAuditDataWOB] FOREIGN KEY([OldEventAuditDataWOB])
REFERENCES [dbo].[OldEventAuditDataWOB] ([oid])
GO
ALTER TABLE [dbo].[OldEventAuditDataBLOBs] CHECK CONSTRAINT [OldEventAuditDataBLOBs_OldEventAuditDataWOB]
GO
ALTER TABLE [dbo].[OldEventAuditDataWOB]  WITH CHECK ADD  CONSTRAINT [OldEventAuditDataWOB_DataEventAudit] FOREIGN KEY([DataEventAudit])
REFERENCES [dbo].[DataEventAudits] ([oid])
GO
ALTER TABLE [dbo].[OldEventAuditDataWOB] CHECK CONSTRAINT [OldEventAuditDataWOB_DataEventAudit]
GO
ALTER TABLE [dbo].[PackLevelParticipant]  WITH CHECK ADD  CONSTRAINT [PackLevelParticipant_PACKAGEOID] FOREIGN KEY([PACKAGEOID])
REFERENCES [dbo].[XPDLParticipantPackage] ([oid])
GO
ALTER TABLE [dbo].[PackLevelParticipant] CHECK CONSTRAINT [PackLevelParticipant_PACKAGEOID]
GO
ALTER TABLE [dbo].[PackLevelXPDLApp]  WITH CHECK ADD  CONSTRAINT [PackLevelXPDLApp_PACKAGEOID] FOREIGN KEY([PACKAGEOID])
REFERENCES [dbo].[XPDLApplicationPackage] ([oid])
GO
ALTER TABLE [dbo].[PackLevelXPDLApp] CHECK CONSTRAINT [PackLevelXPDLApp_PACKAGEOID]
GO
ALTER TABLE [dbo].[PackLevelXPDLAppTAAppDetail]  WITH CHECK ADD  CONSTRAINT [PackLevelXPDLAppTAAppDetail_TOOLAGENTOID] FOREIGN KEY([TOOLAGENTOID])
REFERENCES [dbo].[ToolAgentAppDetail] ([oid])
GO
ALTER TABLE [dbo].[PackLevelXPDLAppTAAppDetail] CHECK CONSTRAINT [PackLevelXPDLAppTAAppDetail_TOOLAGENTOID]
GO
ALTER TABLE [dbo].[PackLevelXPDLAppTAAppDetail]  WITH CHECK ADD  CONSTRAINT [PackLevelXPDLAppTAAppDetail_XPDL_APPOID] FOREIGN KEY([XPDL_APPOID])
REFERENCES [dbo].[PackLevelXPDLApp] ([oid])
GO
ALTER TABLE [dbo].[PackLevelXPDLAppTAAppDetail] CHECK CONSTRAINT [PackLevelXPDLAppTAAppDetail_XPDL_APPOID]
GO
ALTER TABLE [dbo].[PackLevelXPDLAppTAAppDetailUsr]  WITH CHECK ADD  CONSTRAINT [PackLevelXPDLAppTAAppDetailUsr_TOOLAGENTOID] FOREIGN KEY([TOOLAGENTOID])
REFERENCES [dbo].[ToolAgentAppDetailUser] ([oid])
GO
ALTER TABLE [dbo].[PackLevelXPDLAppTAAppDetailUsr] CHECK CONSTRAINT [PackLevelXPDLAppTAAppDetailUsr_TOOLAGENTOID]
GO
ALTER TABLE [dbo].[PackLevelXPDLAppTAAppDetailUsr]  WITH CHECK ADD  CONSTRAINT [PackLevelXPDLAppTAAppDetailUsr_XPDL_APPOID] FOREIGN KEY([XPDL_APPOID])
REFERENCES [dbo].[PackLevelXPDLApp] ([oid])
GO
ALTER TABLE [dbo].[PackLevelXPDLAppTAAppDetailUsr] CHECK CONSTRAINT [PackLevelXPDLAppTAAppDetailUsr_XPDL_APPOID]
GO
ALTER TABLE [dbo].[PackLevelXPDLAppTAAppUser]  WITH CHECK ADD  CONSTRAINT [PackLevelXPDLAppTAAppUser_TOOLAGENTOID] FOREIGN KEY([TOOLAGENTOID])
REFERENCES [dbo].[ToolAgentAppUser] ([oid])
GO
ALTER TABLE [dbo].[PackLevelXPDLAppTAAppUser] CHECK CONSTRAINT [PackLevelXPDLAppTAAppUser_TOOLAGENTOID]
GO
ALTER TABLE [dbo].[PackLevelXPDLAppTAAppUser]  WITH CHECK ADD  CONSTRAINT [PackLevelXPDLAppTAAppUser_XPDL_APPOID] FOREIGN KEY([XPDL_APPOID])
REFERENCES [dbo].[PackLevelXPDLApp] ([oid])
GO
ALTER TABLE [dbo].[PackLevelXPDLAppTAAppUser] CHECK CONSTRAINT [PackLevelXPDLAppTAAppUser_XPDL_APPOID]
GO
ALTER TABLE [dbo].[PackLevelXPDLAppToolAgentApp]  WITH CHECK ADD  CONSTRAINT [PackLevelXPDLAppToolAgentApp_TOOLAGENTOID] FOREIGN KEY([TOOLAGENTOID])
REFERENCES [dbo].[ToolAgentApp] ([oid])
GO
ALTER TABLE [dbo].[PackLevelXPDLAppToolAgentApp] CHECK CONSTRAINT [PackLevelXPDLAppToolAgentApp_TOOLAGENTOID]
GO
ALTER TABLE [dbo].[PackLevelXPDLAppToolAgentApp]  WITH CHECK ADD  CONSTRAINT [PackLevelXPDLAppToolAgentApp_XPDL_APPOID] FOREIGN KEY([XPDL_APPOID])
REFERENCES [dbo].[PackLevelXPDLApp] ([oid])
GO
ALTER TABLE [dbo].[PackLevelXPDLAppToolAgentApp] CHECK CONSTRAINT [PackLevelXPDLAppToolAgentApp_XPDL_APPOID]
GO
ALTER TABLE [dbo].[pm_actions]  WITH CHECK ADD  CONSTRAINT [FK_j8bphk6d8hqc438jvbpgllvk6] FOREIGN KEY([docclassId])
REFERENCES [dbo].[pm_docclasses] ([id])
GO
ALTER TABLE [dbo].[pm_actions] CHECK CONSTRAINT [FK_j8bphk6d8hqc438jvbpgllvk6]
GO
ALTER TABLE [dbo].[pm_activity_document]  WITH CHECK ADD  CONSTRAINT [FK_42wvrbsw0yf0j8hpskcq3096w] FOREIGN KEY([process])
REFERENCES [dbo].[Processes] ([oid])
GO
ALTER TABLE [dbo].[pm_activity_document] CHECK CONSTRAINT [FK_42wvrbsw0yf0j8hpskcq3096w]
GO
ALTER TABLE [dbo].[pm_activity_document]  WITH CHECK ADD  CONSTRAINT [FK_6fbx8827lmfvdpb1g0jcwmnnv] FOREIGN KEY([fileid])
REFERENCES [dbo].[pm_files] ([id])
GO
ALTER TABLE [dbo].[pm_activity_document] CHECK CONSTRAINT [FK_6fbx8827lmfvdpb1g0jcwmnnv]
GO
ALTER TABLE [dbo].[pm_activity_document]  WITH CHECK ADD  CONSTRAINT [FK_7o8aehfv9sn3slvt92lt9qtkm] FOREIGN KEY([version])
REFERENCES [dbo].[pm_file_versions] ([id])
GO
ALTER TABLE [dbo].[pm_activity_document] CHECK CONSTRAINT [FK_7o8aehfv9sn3slvt92lt9qtkm]
GO
ALTER TABLE [dbo].[pm_activity_document]  WITH CHECK ADD  CONSTRAINT [FK_92assdyl6qajmngosujr2xhnh] FOREIGN KEY([activity])
REFERENCES [dbo].[Activities] ([oid]) ON DELETE CASCADE
GO
ALTER TABLE [dbo].[pm_activity_document] CHECK CONSTRAINT [FK_92assdyl6qajmngosujr2xhnh]
GO
ALTER TABLE [dbo].[pm_activity_document]  WITH CHECK ADD  CONSTRAINT [FK_jdwg9tbe9xdwxc3bhffdaps86] FOREIGN KEY([userid])
REFERENCES [dbo].[UserTable] ([oid])
GO
ALTER TABLE [dbo].[pm_activity_document] CHECK CONSTRAINT [FK_jdwg9tbe9xdwxc3bhffdaps86]
GO
ALTER TABLE [dbo].[pm_activityredirection]  WITH CHECK ADD  CONSTRAINT [FK_o6u7qnmff1au8nd9psbq0s6ws] FOREIGN KEY([sourceuser])
REFERENCES [dbo].[UserTable] ([oid])
GO
ALTER TABLE [dbo].[pm_activityredirection] CHECK CONSTRAINT [FK_o6u7qnmff1au8nd9psbq0s6ws]
GO
ALTER TABLE [dbo].[pm_activityredirection_groups]  WITH CHECK ADD  CONSTRAINT [FK_6vwltofsq2485ghw20xfcld9m] FOREIGN KEY([targetgroup])
REFERENCES [dbo].[GroupTable] ([oid])
GO
ALTER TABLE [dbo].[pm_activityredirection_groups] CHECK CONSTRAINT [FK_6vwltofsq2485ghw20xfcld9m]
GO
ALTER TABLE [dbo].[pm_activityredirection_groups]  WITH CHECK ADD  CONSTRAINT [FK_efysd6mgps4uhj882y2wjv6cb] FOREIGN KEY([redirection])
REFERENCES [dbo].[pm_activityredirection] ([id])
GO
ALTER TABLE [dbo].[pm_activityredirection_groups] CHECK CONSTRAINT [FK_efysd6mgps4uhj882y2wjv6cb]
GO
ALTER TABLE [dbo].[pm_activityredirection_users]  WITH CHECK ADD  CONSTRAINT [FK_7r86w89tl7e93v6m6x0atsa56] FOREIGN KEY([targetuser])
REFERENCES [dbo].[UserTable] ([oid])
GO
ALTER TABLE [dbo].[pm_activityredirection_users] CHECK CONSTRAINT [FK_7r86w89tl7e93v6m6x0atsa56]
GO
ALTER TABLE [dbo].[pm_activityredirection_users]  WITH CHECK ADD  CONSTRAINT [FK_jgo839lt6w4ni79g6vjelk6q8] FOREIGN KEY([redirection])
REFERENCES [dbo].[pm_activityredirection] ([id])
GO
ALTER TABLE [dbo].[pm_activityredirection_users] CHECK CONSTRAINT [FK_jgo839lt6w4ni79g6vjelk6q8]
GO
ALTER TABLE [dbo].[pm_directories]  WITH CHECK ADD  CONSTRAINT [FK_18u81p51ns1c6mcjvki6pj13c] FOREIGN KEY([rootdirectoryid])
REFERENCES [dbo].[pm_directories] ([id])
GO
ALTER TABLE [dbo].[pm_directories] CHECK CONSTRAINT [FK_18u81p51ns1c6mcjvki6pj13c]
GO
ALTER TABLE [dbo].[pm_directories]  WITH CHECK ADD  CONSTRAINT [FK_85oxbewnwauq6f84ayc8yu26h] FOREIGN KEY([deviceid])
REFERENCES [dbo].[pm_devices] ([id])
GO
ALTER TABLE [dbo].[pm_directories] CHECK CONSTRAINT [FK_85oxbewnwauq6f84ayc8yu26h]
GO
ALTER TABLE [dbo].[pm_docclassconditionprotection]  WITH CHECK ADD  CONSTRAINT [FK_i5ccqelqaxr6ihgg61gcx0uct] FOREIGN KEY([docclassid])
REFERENCES [dbo].[pm_docclasses] ([id])
GO
ALTER TABLE [dbo].[pm_docclassconditionprotection] CHECK CONSTRAINT [FK_i5ccqelqaxr6ihgg61gcx0uct]
GO
ALTER TABLE [dbo].[pm_docclasses]  WITH CHECK ADD  CONSTRAINT [FK_6lgibe4cj428mahvpatn5sxom] FOREIGN KEY([docClassDirectoryId])
REFERENCES [dbo].[pm_directories] ([id])
GO
ALTER TABLE [dbo].[pm_docclasses] CHECK CONSTRAINT [FK_6lgibe4cj428mahvpatn5sxom]
GO
ALTER TABLE [dbo].[pm_file_versions]  WITH CHECK ADD  CONSTRAINT [FK_5g95e5rtev82dsy4ei5qtnde2] FOREIGN KEY([fileid])
REFERENCES [dbo].[pm_files] ([id])
GO
ALTER TABLE [dbo].[pm_file_versions] CHECK CONSTRAINT [FK_5g95e5rtev82dsy4ei5qtnde2]
GO
ALTER TABLE [dbo].[pm_file_versions]  WITH CHECK ADD  CONSTRAINT [FK_72tlby59e4nyq7n67l22cd1jv] FOREIGN KEY([newest_fileid])
REFERENCES [dbo].[pm_files] ([id])
GO
ALTER TABLE [dbo].[pm_file_versions] CHECK CONSTRAINT [FK_72tlby59e4nyq7n67l22cd1jv]
GO
ALTER TABLE [dbo].[pm_file_versions]  WITH CHECK ADD  CONSTRAINT [FK_sotkpbhytpgxqcme4613or9el] FOREIGN KEY([parent_fileid])
REFERENCES [dbo].[pm_files] ([id])
GO
ALTER TABLE [dbo].[pm_file_versions] CHECK CONSTRAINT [FK_sotkpbhytpgxqcme4613or9el]
GO
ALTER TABLE [dbo].[pm_files]  WITH CHECK ADD  CONSTRAINT [FK_iybhe442i7rmbmsh9sai36akj] FOREIGN KEY([docclassid])
REFERENCES [dbo].[pm_docclasses] ([id])
GO
ALTER TABLE [dbo].[pm_files] CHECK CONSTRAINT [FK_iybhe442i7rmbmsh9sai36akj]
GO
ALTER TABLE [dbo].[pm_indecies]  WITH CHECK ADD  CONSTRAINT [FK_l71m7jduokeqbp05note87lk9] FOREIGN KEY([docclassId])
REFERENCES [dbo].[pm_docclasses] ([id])
GO
ALTER TABLE [dbo].[pm_indecies] CHECK CONSTRAINT [FK_l71m7jduokeqbp05note87lk9]
GO
ALTER TABLE [dbo].[pm_linkconnection]  WITH CHECK ADD  CONSTRAINT [FK_3afp7q3tabn0clet0ohtehje1] FOREIGN KEY([docClassId])
REFERENCES [dbo].[pm_docclasses] ([id])
GO
ALTER TABLE [dbo].[pm_linkconnection] CHECK CONSTRAINT [FK_3afp7q3tabn0clet0ohtehje1]
GO
ALTER TABLE [dbo].[pm_linkconnection]  WITH CHECK ADD  CONSTRAINT [FK_ahqo7ih2hag0yc9tqy0avj8q5] FOREIGN KEY([linkId])
REFERENCES [dbo].[pm_links] ([id])
GO
ALTER TABLE [dbo].[pm_linkconnection] CHECK CONSTRAINT [FK_ahqo7ih2hag0yc9tqy0avj8q5]
GO
ALTER TABLE [dbo].[pm_linkconnection]  WITH CHECK ADD  CONSTRAINT [FK_d5xsfymb2ea989yosrr7k9tcm] FOREIGN KEY([indexId])
REFERENCES [dbo].[pm_indecies] ([id])
GO
ALTER TABLE [dbo].[pm_linkconnection] CHECK CONSTRAINT [FK_d5xsfymb2ea989yosrr7k9tcm]
GO
ALTER TABLE [dbo].[pm_linkconnection]  WITH CHECK ADD  CONSTRAINT [FK_fcprtpga9kxi2vk1p1f9w9tgu] FOREIGN KEY([linkIndexId])
REFERENCES [dbo].[pm_linkindecies] ([id])
GO
ALTER TABLE [dbo].[pm_linkconnection] CHECK CONSTRAINT [FK_fcprtpga9kxi2vk1p1f9w9tgu]
GO
ALTER TABLE [dbo].[pm_linkindecies]  WITH CHECK ADD  CONSTRAINT [FK_nu4ajavo7g1ugnavuirso0o0c] FOREIGN KEY([linkId])
REFERENCES [dbo].[pm_links] ([id])
GO
ALTER TABLE [dbo].[pm_linkindecies] CHECK CONSTRAINT [FK_nu4ajavo7g1ugnavuirso0o0c]
GO
ALTER TABLE [dbo].[pm_operation_panel_parameters]  WITH CHECK ADD  CONSTRAINT [FK_1aga3412yhj9ju42eijrg5v90] FOREIGN KEY([operation_panel_id])
REFERENCES [dbo].[pm_operation_panel] ([operation_panel_id])
GO
ALTER TABLE [dbo].[pm_operation_panel_parameters] CHECK CONSTRAINT [FK_1aga3412yhj9ju42eijrg5v90]
GO
ALTER TABLE [dbo].[pm_organizationalunits]  WITH CHECK ADD  CONSTRAINT [FK_9amgdap6ghg0jpnlt2f3ynovb] FOREIGN KEY([higherorganizationalunitid])
REFERENCES [dbo].[pm_organizationalunits] ([id])
GO
ALTER TABLE [dbo].[pm_organizationalunits] CHECK CONSTRAINT [FK_9amgdap6ghg0jpnlt2f3ynovb]
GO
ALTER TABLE [dbo].[pm_organizationalunits]  WITH CHECK ADD  CONSTRAINT [FK_oj19eykqyp025v0iu7t56kifo] FOREIGN KEY([directorpositionid])
REFERENCES [dbo].[pm_positions] ([id])
GO
ALTER TABLE [dbo].[pm_organizationalunits] CHECK CONSTRAINT [FK_oj19eykqyp025v0iu7t56kifo]
GO
ALTER TABLE [dbo].[pm_position_role]  WITH CHECK ADD  CONSTRAINT [FK_1iptjpwgfmo8wsvs95sb9uq0] FOREIGN KEY([roleid])
REFERENCES [dbo].[pm_roles] ([id])
GO
ALTER TABLE [dbo].[pm_position_role] CHECK CONSTRAINT [FK_1iptjpwgfmo8wsvs95sb9uq0]
GO
ALTER TABLE [dbo].[pm_position_role]  WITH CHECK ADD  CONSTRAINT [FK_px59cjc90bscbjbuijd2g6e6u] FOREIGN KEY([positionid])
REFERENCES [dbo].[pm_positions] ([id])
GO
ALTER TABLE [dbo].[pm_position_role] CHECK CONSTRAINT [FK_px59cjc90bscbjbuijd2g6e6u]
GO
ALTER TABLE [dbo].[pm_positions]  WITH CHECK ADD  CONSTRAINT [FK_3u1i14xg7c20gxv5t0q81rilt] FOREIGN KEY([higherpositionid])
REFERENCES [dbo].[pm_positions] ([id])
GO
ALTER TABLE [dbo].[pm_positions] CHECK CONSTRAINT [FK_3u1i14xg7c20gxv5t0q81rilt]
GO
ALTER TABLE [dbo].[pm_positions]  WITH CHECK ADD  CONSTRAINT [FK_9ta5vw7g06heaw17javv38mnq] FOREIGN KEY([userid])
REFERENCES [dbo].[UserTable] ([oid])
GO
ALTER TABLE [dbo].[pm_positions] CHECK CONSTRAINT [FK_9ta5vw7g06heaw17javv38mnq]
GO
ALTER TABLE [dbo].[pm_positions]  WITH CHECK ADD  CONSTRAINT [FK_l5dl4jfne63rytsx0ua7a851e] FOREIGN KEY([organizationalunitid])
REFERENCES [dbo].[pm_organizationalunits] ([id])
GO
ALTER TABLE [dbo].[pm_positions] CHECK CONSTRAINT [FK_l5dl4jfne63rytsx0ua7a851e]
GO
ALTER TABLE [dbo].[PM_SCHEDULED_TASKS]  WITH CHECK ADD  CONSTRAINT [FK_b29cpxijg24tebqpd7lsxljvm] FOREIGN KEY([category_id])
REFERENCES [dbo].[pm_scheduled_tasks_category] ([id])
GO
ALTER TABLE [dbo].[PM_SCHEDULED_TASKS] CHECK CONSTRAINT [FK_b29cpxijg24tebqpd7lsxljvm]
GO
ALTER TABLE [dbo].[pm_scheduled_tasks_history]  WITH CHECK ADD  CONSTRAINT [FK_7rhytf8lrqhl8345f35e3w76e] FOREIGN KEY([taskId])
REFERENCES [dbo].[PM_SCHEDULED_TASKS] ([SCHEDULED_TASK_ID])
GO
ALTER TABLE [dbo].[pm_scheduled_tasks_history] CHECK CONSTRAINT [FK_7rhytf8lrqhl8345f35e3w76e]
GO
ALTER TABLE [dbo].[PM_SCHEDULED_TASKS_PARAMETERS]  WITH CHECK ADD  CONSTRAINT [FK_g1xsebbfruf71fhtvv5thfr3e] FOREIGN KEY([SCHEDULED_TASK_ID])
REFERENCES [dbo].[PM_SCHEDULED_TASKS] ([SCHEDULED_TASK_ID])
GO
ALTER TABLE [dbo].[PM_SCHEDULED_TASKS_PARAMETERS] CHECK CONSTRAINT [FK_g1xsebbfruf71fhtvv5thfr3e]
GO
ALTER TABLE [dbo].[pm_userData]  WITH CHECK ADD  CONSTRAINT [FK_21dcy78o0padsbbhb9i3dvokl] FOREIGN KEY([userid])
REFERENCES [dbo].[UserTable] ([oid])
GO
ALTER TABLE [dbo].[pm_userData] CHECK CONSTRAINT [FK_21dcy78o0padsbbhb9i3dvokl]
GO
ALTER TABLE [dbo].[pm_vcolumns]  WITH CHECK ADD  CONSTRAINT [FK_8sdy1k5rj0hrrjbtfplgf4jpl] FOREIGN KEY([typeId])
REFERENCES [dbo].[pm_vtypes] ([id])
GO
ALTER TABLE [dbo].[pm_vcolumns] CHECK CONSTRAINT [FK_8sdy1k5rj0hrrjbtfplgf4jpl]
GO
ALTER TABLE [dbo].[pm_vcolumns]  WITH CHECK ADD  CONSTRAINT [FK_lx10ip15rm7v0f0t886pjdm19] FOREIGN KEY([tableId])
REFERENCES [dbo].[pm_vtables] ([id])
GO
ALTER TABLE [dbo].[pm_vcolumns] CHECK CONSTRAINT [FK_lx10ip15rm7v0f0t886pjdm19]
GO
ALTER TABLE [dbo].[pm_vvalues]  WITH CHECK ADD  CONSTRAINT [FK_ps2iw5fj2havs4r2h3ae96oup] FOREIGN KEY([tableId], [columnId])
REFERENCES [dbo].[pm_vcolumns] ([tableId], [Id])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[pm_vvalues] CHECK CONSTRAINT [FK_ps2iw5fj2havs4r2h3ae96oup]
GO
ALTER TABLE [dbo].[ProcessData]  WITH CHECK ADD  CONSTRAINT [ProcessData_Process] FOREIGN KEY([Process])
REFERENCES [dbo].[Processes] ([oid])
GO
ALTER TABLE [dbo].[ProcessData] CHECK CONSTRAINT [ProcessData_Process]
GO
ALTER TABLE [dbo].[ProcessDataBLOBs]  WITH CHECK ADD  CONSTRAINT [ProcessDataBLOBs_ProcessDataWOB] FOREIGN KEY([ProcessDataWOB])
REFERENCES [dbo].[ProcessDataWOB] ([oid])
GO
ALTER TABLE [dbo].[ProcessDataBLOBs] CHECK CONSTRAINT [ProcessDataBLOBs_ProcessDataWOB]
GO
ALTER TABLE [dbo].[ProcessDataWOB]  WITH CHECK ADD  CONSTRAINT [ProcessDataWOB_Process] FOREIGN KEY([Process])
REFERENCES [dbo].[Processes] ([oid])
GO
ALTER TABLE [dbo].[ProcessDataWOB] CHECK CONSTRAINT [ProcessDataWOB_Process]
GO
ALTER TABLE [dbo].[Processes]  WITH CHECK ADD  CONSTRAINT [Processes_ProcessDefinition] FOREIGN KEY([ProcessDefinition])
REFERENCES [dbo].[ProcessDefinitions] ([oid])
GO
ALTER TABLE [dbo].[Processes] CHECK CONSTRAINT [Processes_ProcessDefinition]
GO
ALTER TABLE [dbo].[Processes]  WITH CHECK ADD  CONSTRAINT [Processes_State] FOREIGN KEY([State])
REFERENCES [dbo].[ProcessStates] ([oid])
GO
ALTER TABLE [dbo].[Processes] CHECK CONSTRAINT [Processes_State]
GO
ALTER TABLE [dbo].[ProcessRequesters]  WITH CHECK ADD  CONSTRAINT [ProcessRequesters_ActivityRequester] FOREIGN KEY([ActivityRequester])
REFERENCES [dbo].[Activities] ([oid])
GO
ALTER TABLE [dbo].[ProcessRequesters] CHECK CONSTRAINT [ProcessRequesters_ActivityRequester]
GO
ALTER TABLE [dbo].[ProcessRequesters]  WITH CHECK ADD  CONSTRAINT [ProcessRequesters_ResourceRequester] FOREIGN KEY([ResourceRequester])
REFERENCES [dbo].[ResourcesTable] ([oid])
GO
ALTER TABLE [dbo].[ProcessRequesters] CHECK CONSTRAINT [ProcessRequesters_ResourceRequester]
GO
ALTER TABLE [dbo].[ProcLevelParticipant]  WITH CHECK ADD  CONSTRAINT [ProcLevelParticipant_PROCESSOID] FOREIGN KEY([PROCESSOID])
REFERENCES [dbo].[XPDLParticipantProcess] ([oid])
GO
ALTER TABLE [dbo].[ProcLevelParticipant] CHECK CONSTRAINT [ProcLevelParticipant_PROCESSOID]
GO
ALTER TABLE [dbo].[ProcLevelXPDLApp]  WITH CHECK ADD  CONSTRAINT [ProcLevelXPDLApp_PROCESSOID] FOREIGN KEY([PROCESSOID])
REFERENCES [dbo].[XPDLApplicationProcess] ([oid])
GO
ALTER TABLE [dbo].[ProcLevelXPDLApp] CHECK CONSTRAINT [ProcLevelXPDLApp_PROCESSOID]
GO
ALTER TABLE [dbo].[ProcLevelXPDLAppTAAppDetail]  WITH CHECK ADD  CONSTRAINT [ProcLevelXPDLAppTAAppDetail_TOOLAGENTOID] FOREIGN KEY([TOOLAGENTOID])
REFERENCES [dbo].[ToolAgentAppDetail] ([oid])
GO
ALTER TABLE [dbo].[ProcLevelXPDLAppTAAppDetail] CHECK CONSTRAINT [ProcLevelXPDLAppTAAppDetail_TOOLAGENTOID]
GO
ALTER TABLE [dbo].[ProcLevelXPDLAppTAAppDetail]  WITH CHECK ADD  CONSTRAINT [ProcLevelXPDLAppTAAppDetail_XPDL_APPOID] FOREIGN KEY([XPDL_APPOID])
REFERENCES [dbo].[ProcLevelXPDLApp] ([oid])
GO
ALTER TABLE [dbo].[ProcLevelXPDLAppTAAppDetail] CHECK CONSTRAINT [ProcLevelXPDLAppTAAppDetail_XPDL_APPOID]
GO
ALTER TABLE [dbo].[ProcLevelXPDLAppTAAppDetailUsr]  WITH CHECK ADD  CONSTRAINT [ProcLevelXPDLAppTAAppDetailUsr_TOOLAGENTOID] FOREIGN KEY([TOOLAGENTOID])
REFERENCES [dbo].[ToolAgentAppDetailUser] ([oid])
GO
ALTER TABLE [dbo].[ProcLevelXPDLAppTAAppDetailUsr] CHECK CONSTRAINT [ProcLevelXPDLAppTAAppDetailUsr_TOOLAGENTOID]
GO
ALTER TABLE [dbo].[ProcLevelXPDLAppTAAppDetailUsr]  WITH CHECK ADD  CONSTRAINT [ProcLevelXPDLAppTAAppDetailUsr_XPDL_APPOID] FOREIGN KEY([XPDL_APPOID])
REFERENCES [dbo].[ProcLevelXPDLApp] ([oid])
GO
ALTER TABLE [dbo].[ProcLevelXPDLAppTAAppDetailUsr] CHECK CONSTRAINT [ProcLevelXPDLAppTAAppDetailUsr_XPDL_APPOID]
GO
ALTER TABLE [dbo].[ProcLevelXPDLAppTAAppUser]  WITH CHECK ADD  CONSTRAINT [ProcLevelXPDLAppTAAppUser_TOOLAGENTOID] FOREIGN KEY([TOOLAGENTOID])
REFERENCES [dbo].[ToolAgentAppUser] ([oid])
GO
ALTER TABLE [dbo].[ProcLevelXPDLAppTAAppUser] CHECK CONSTRAINT [ProcLevelXPDLAppTAAppUser_TOOLAGENTOID]
GO
ALTER TABLE [dbo].[ProcLevelXPDLAppTAAppUser]  WITH CHECK ADD  CONSTRAINT [ProcLevelXPDLAppTAAppUser_XPDL_APPOID] FOREIGN KEY([XPDL_APPOID])
REFERENCES [dbo].[ProcLevelXPDLApp] ([oid])
GO
ALTER TABLE [dbo].[ProcLevelXPDLAppTAAppUser] CHECK CONSTRAINT [ProcLevelXPDLAppTAAppUser_XPDL_APPOID]
GO
ALTER TABLE [dbo].[ProcLevelXPDLAppToolAgentApp]  WITH CHECK ADD  CONSTRAINT [ProcLevelXPDLAppToolAgentApp_TOOLAGENTOID] FOREIGN KEY([TOOLAGENTOID])
REFERENCES [dbo].[ToolAgentApp] ([oid])
GO
ALTER TABLE [dbo].[ProcLevelXPDLAppToolAgentApp] CHECK CONSTRAINT [ProcLevelXPDLAppToolAgentApp_TOOLAGENTOID]
GO
ALTER TABLE [dbo].[ProcLevelXPDLAppToolAgentApp]  WITH CHECK ADD  CONSTRAINT [ProcLevelXPDLAppToolAgentApp_XPDL_APPOID] FOREIGN KEY([XPDL_APPOID])
REFERENCES [dbo].[ProcLevelXPDLApp] ([oid])
GO
ALTER TABLE [dbo].[ProcLevelXPDLAppToolAgentApp] CHECK CONSTRAINT [ProcLevelXPDLAppToolAgentApp_XPDL_APPOID]
GO
ALTER TABLE [dbo].[StateEventAudits]  WITH CHECK ADD  CONSTRAINT [StateEventAudits_NewActivityState] FOREIGN KEY([NewActivityState])
REFERENCES [dbo].[ActivityStateEventAudits] ([oid])
GO
ALTER TABLE [dbo].[StateEventAudits] CHECK CONSTRAINT [StateEventAudits_NewActivityState]
GO
ALTER TABLE [dbo].[StateEventAudits]  WITH CHECK ADD  CONSTRAINT [StateEventAudits_NewProcessState] FOREIGN KEY([NewProcessState])
REFERENCES [dbo].[ProcessStateEventAudits] ([oid])
GO
ALTER TABLE [dbo].[StateEventAudits] CHECK CONSTRAINT [StateEventAudits_NewProcessState]
GO
ALTER TABLE [dbo].[StateEventAudits]  WITH CHECK ADD  CONSTRAINT [StateEventAudits_OldActivityState] FOREIGN KEY([OldActivityState])
REFERENCES [dbo].[ActivityStateEventAudits] ([oid])
GO
ALTER TABLE [dbo].[StateEventAudits] CHECK CONSTRAINT [StateEventAudits_OldActivityState]
GO
ALTER TABLE [dbo].[StateEventAudits]  WITH CHECK ADD  CONSTRAINT [StateEventAudits_OldProcessState] FOREIGN KEY([OldProcessState])
REFERENCES [dbo].[ProcessStateEventAudits] ([oid])
GO
ALTER TABLE [dbo].[StateEventAudits] CHECK CONSTRAINT [StateEventAudits_OldProcessState]
GO
ALTER TABLE [dbo].[StateEventAudits]  WITH CHECK ADD  CONSTRAINT [StateEventAudits_TheType] FOREIGN KEY([TheType])
REFERENCES [dbo].[EventTypes] ([oid])
GO
ALTER TABLE [dbo].[StateEventAudits] CHECK CONSTRAINT [StateEventAudits_TheType]
GO
ALTER TABLE [dbo].[ToolAgentAppDetail]  WITH CHECK ADD  CONSTRAINT [ToolAgentAppDetail_TOOLAGENT_APPOID] FOREIGN KEY([TOOLAGENT_APPOID])
REFERENCES [dbo].[ToolAgentApp] ([oid])
GO
ALTER TABLE [dbo].[ToolAgentAppDetail] CHECK CONSTRAINT [ToolAgentAppDetail_TOOLAGENT_APPOID]
GO
ALTER TABLE [dbo].[ToolAgentAppDetailUser]  WITH CHECK ADD  CONSTRAINT [ToolAgentAppDetailUser_TOOLAGENT_APPOID] FOREIGN KEY([TOOLAGENT_APPOID])
REFERENCES [dbo].[ToolAgentAppDetail] ([oid])
GO
ALTER TABLE [dbo].[ToolAgentAppDetailUser] CHECK CONSTRAINT [ToolAgentAppDetailUser_TOOLAGENT_APPOID]
GO
ALTER TABLE [dbo].[ToolAgentAppDetailUser]  WITH CHECK ADD  CONSTRAINT [ToolAgentAppDetailUser_USEROID] FOREIGN KEY([USEROID])
REFERENCES [dbo].[ToolAgentUser] ([oid])
GO
ALTER TABLE [dbo].[ToolAgentAppDetailUser] CHECK CONSTRAINT [ToolAgentAppDetailUser_USEROID]
GO
ALTER TABLE [dbo].[ToolAgentAppUser]  WITH CHECK ADD  CONSTRAINT [ToolAgentAppUser_TOOLAGENT_APPOID] FOREIGN KEY([TOOLAGENT_APPOID])
REFERENCES [dbo].[ToolAgentApp] ([oid])
GO
ALTER TABLE [dbo].[ToolAgentAppUser] CHECK CONSTRAINT [ToolAgentAppUser_TOOLAGENT_APPOID]
GO
ALTER TABLE [dbo].[ToolAgentAppUser]  WITH CHECK ADD  CONSTRAINT [ToolAgentAppUser_USEROID] FOREIGN KEY([USEROID])
REFERENCES [dbo].[ToolAgentUser] ([oid])
GO
ALTER TABLE [dbo].[ToolAgentAppUser] CHECK CONSTRAINT [ToolAgentAppUser_USEROID]
GO
ALTER TABLE [dbo].[UserGroupTable]  WITH CHECK ADD  CONSTRAINT [UserGroupTable_groupid] FOREIGN KEY([groupid])
REFERENCES [dbo].[GroupTable] ([oid])
GO
ALTER TABLE [dbo].[UserGroupTable] CHECK CONSTRAINT [UserGroupTable_groupid]
GO
ALTER TABLE [dbo].[UserGroupTable]  WITH CHECK ADD  CONSTRAINT [UserGroupTable_userid] FOREIGN KEY([userid])
REFERENCES [dbo].[UserTable] ([oid])
GO
ALTER TABLE [dbo].[UserGroupTable] CHECK CONSTRAINT [UserGroupTable_userid]
GO
ALTER TABLE [dbo].[UserPackLevelParticipant]  WITH CHECK ADD  CONSTRAINT [UserPackLevelParticipant_PARTICIPANTOID] FOREIGN KEY([PARTICIPANTOID])
REFERENCES [dbo].[PackLevelParticipant] ([oid])
GO
ALTER TABLE [dbo].[UserPackLevelParticipant] CHECK CONSTRAINT [UserPackLevelParticipant_PARTICIPANTOID]
GO
ALTER TABLE [dbo].[UserPackLevelParticipant]  WITH CHECK ADD  CONSTRAINT [UserPackLevelParticipant_USEROID] FOREIGN KEY([USEROID])
REFERENCES [dbo].[NormalUser] ([oid])
GO
ALTER TABLE [dbo].[UserPackLevelParticipant] CHECK CONSTRAINT [UserPackLevelParticipant_USEROID]
GO
ALTER TABLE [dbo].[UserProcLevelParticipant]  WITH CHECK ADD  CONSTRAINT [UserProcLevelParticipant_PARTICIPANTOID] FOREIGN KEY([PARTICIPANTOID])
REFERENCES [dbo].[ProcLevelParticipant] ([oid])
GO
ALTER TABLE [dbo].[UserProcLevelParticipant] CHECK CONSTRAINT [UserProcLevelParticipant_PARTICIPANTOID]
GO
ALTER TABLE [dbo].[UserProcLevelParticipant]  WITH CHECK ADD  CONSTRAINT [UserProcLevelParticipant_USEROID] FOREIGN KEY([USEROID])
REFERENCES [dbo].[NormalUser] ([oid])
GO
ALTER TABLE [dbo].[UserProcLevelParticipant] CHECK CONSTRAINT [UserProcLevelParticipant_USEROID]
GO
ALTER TABLE [dbo].[XPDLApplicationProcess]  WITH CHECK ADD  CONSTRAINT [XPDLApplicationProcess_PACKAGEOID] FOREIGN KEY([PACKAGEOID])
REFERENCES [dbo].[XPDLApplicationPackage] ([oid])
GO
ALTER TABLE [dbo].[XPDLApplicationProcess] CHECK CONSTRAINT [XPDLApplicationProcess_PACKAGEOID]
GO
ALTER TABLE [dbo].[XPDLData]  WITH CHECK ADD  CONSTRAINT [XPDLData_XPDL] FOREIGN KEY([XPDL])
REFERENCES [dbo].[XPDLS] ([oid])
GO
ALTER TABLE [dbo].[XPDLData] CHECK CONSTRAINT [XPDLData_XPDL]
GO
ALTER TABLE [dbo].[XPDLHistoryData]  WITH CHECK ADD  CONSTRAINT [XPDLHistoryData_XPDLHistory] FOREIGN KEY([XPDLHistory])
REFERENCES [dbo].[XPDLHistory] ([oid])
GO
ALTER TABLE [dbo].[XPDLHistoryData] CHECK CONSTRAINT [XPDLHistoryData_XPDLHistory]
GO
ALTER TABLE [dbo].[XPDLParticipantProcess]  WITH CHECK ADD  CONSTRAINT [XPDLParticipantProcess_PACKAGEOID] FOREIGN KEY([PACKAGEOID])
REFERENCES [dbo].[XPDLParticipantPackage] ([oid])
GO
ALTER TABLE [dbo].[XPDLParticipantProcess] CHECK CONSTRAINT [XPDLParticipantProcess_PACKAGEOID]
GO
ALTER TABLE [dbo].[XPDLReferences]  WITH CHECK ADD  CONSTRAINT [XPDLReferences_ReferringXPDL] FOREIGN KEY([ReferringXPDL])
REFERENCES [dbo].[XPDLS] ([oid])
GO
ALTER TABLE [dbo].[XPDLReferences] CHECK CONSTRAINT [XPDLReferences_ReferringXPDL]
GO
ALTER TABLE dbo.pm_substitutions ADD CONSTRAINT pm_substitutions_pkey PRIMARY KEY (id)
GO
ALTER TABLE dbo.pm_substitutions ADD CONSTRAINT pm_s_fk_role FOREIGN KEY (role) REFERENCES pm_roles (id)
GO
ALTER TABLE dbo.pm_substitutions ADD CONSTRAINT pm_s_fk_substituted FOREIGN KEY (substituted) REFERENCES usertable (oid)
GO
ALTER TABLE dbo.pm_substitutions ADD CONSTRAINT pm_s_fk_substitute FOREIGN KEY (substitute) REFERENCES usertable (oid)
GO
CREATE NONCLUSTERED INDEX [I4_Activities] ON [dbo].[Activities]
(
	[ProcessId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [I1_PM_AUDITS] ON [dbo].[pm_audits]
(
	[userId] ASC,
	[auditType] ASC,
	[auditStarted] ASC,
	[auditStopped] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
