/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.customChanges;

import com.plusmpm.security.TextCipher;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.LinkedList;
import liquibase.change.custom.CustomSqlChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.UpdateStatement;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSecretEncryptionChange
implements CustomSqlChange {
    private static final Logger log = LoggerFactory.getLogger(ClientSecretEncryptionChange.class);

    public SqlStatement[] generateStatements(Database database) throws CustomChangeException {
        SqlStatement[] sqlStatementArray;
        block9: {
            JdbcConnection connection = (JdbcConnection)database.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * from pm_oauth_client");
            ResultSet resultSet = preparedStatement.executeQuery();
            try {
                LinkedList<UpdateStatement> sqlStatements = new LinkedList<UpdateStatement>();
                while (resultSet.next()) {
                    long id = resultSet.getLong("id");
                    String plainSecret = resultSet.getString("clientsecret");
                    if (!StringUtils.isNotEmpty((CharSequence)plainSecret)) continue;
                    UpdateStatement updateStatement = new UpdateStatement("", "", "pm_oauth_client");
                    updateStatement.addNewColumnValue("clientsecret", (Object)TextCipher.encrypt((String)plainSecret));
                    updateStatement.setWhereClause("id = " + id);
                    sqlStatements.add(updateStatement);
                }
                sqlStatementArray = sqlStatements.toArray(new SqlStatement[0]);
                if (resultSet == null) break block9;
            }
            catch (Throwable throwable) {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            resultSet.close();
        }
        return sqlStatementArray;
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }
}

