/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.changes.views.change;

import com.plusmpm.database.AdvanceSearchVariableTable;
import com.plusmpm.database.SearchMode;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.view.dao.advanceSearchVariable.AdvanceSearchVariableDao;
import java.util.List;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import org.hibernate.query.Query;

public class RestoreAllViewVariablesChange
implements CustomTaskChange {
    private static final String viewsQuery = "select distinct advt.viewid from AdvanceSearchVariableTable advt WHERE advt.viewid NOT IN (SELECT advt1.viewid FROM AdvanceSearchVariableTable advt1 WHERE advt1.name = :name)";
    private static final List<ViewVariable> viewVariables = List.of(new ViewVariable("procDefId"), new ViewVariable("processType"), new ViewVariable("procName"), new ViewVariable("procDescr"), new ViewVariable("procInitiator"), new ViewVariable("procStateSelect"), new ViewVariable("realizationPercent"), new ViewVariable("procStart", SearchMode.RANGE), new ViewVariable("procFinish", SearchMode.RANGE), new ViewVariable("processDeadline", SearchMode.RANGE), new ViewVariable("taskName"), new ViewVariable("taskStateSelect"), new ViewVariable("taskUser"), new ViewVariable("taskStart", SearchMode.RANGE), new ViewVariable("taskFinish", SearchMode.RANGE), new ViewVariable("taskDeadline", SearchMode.RANGE), new ViewVariable("onlyActiveTask"), new ViewVariable("onlyLoggedUserTask"), new ViewVariable("taskDeadlineName"));

    public void execute(Database database) throws CustomChangeException {
        TransactionWrapper.get().doInHibernateTransaction(session -> {
            AdvanceSearchVariableDao advanceSearchVariableDao = (AdvanceSearchVariableDao)SpringContext.getBean(AdvanceSearchVariableDao.class);
            for (ViewVariable viewVariable : viewVariables) {
                Query query = session.createQuery(viewsQuery);
                query.setParameter("name", (Object)viewVariable.name);
                List viewIds = query.list();
                for (String viewId : viewIds) {
                    AdvanceSearchVariableTable variable = AdvanceSearchVariableTable.builder().viewid(viewId).name(viewVariable.name).searchMode(viewVariable.searchMode).build();
                    advanceSearchVariableDao.save((Object)variable);
                }
            }
        });
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }

    private record ViewVariable(String name, SearchMode searchMode) {
        private ViewVariable(String name) {
            this(name, SearchMode.SINGLE);
        }
    }
}

