/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.upgrade;

import com.suncode.pwfl.upgrade.UpgraderLock;
import com.suncode.pwfl.upgrade.UpgraderLockDao;
import com.suncode.pwfl.util.GenericTransactionWrapper;
import jakarta.persistence.LockModeType;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;

class UpgraderLockDaoImpl
implements UpgraderLockDao {
    private final GenericTransactionWrapper transactionWrapper;

    public UpgraderLockDaoImpl(DataSource dataSource, Dialect dialect) {
        Configuration configuration = new Configuration();
        configuration.addAnnotatedClass(UpgraderLock.class);
        Properties properties = configuration.getProperties();
        properties.put("hibernate.connection.datasource", dataSource);
        properties.put("hibernate.dialect", dialect);
        properties.put("hibernate.show_sql", (Object)false);
        properties.put("hibernate.current_session_context_class", "thread");
        properties.put("hibernate.hbm2ddl.auto", "validate");
        properties.put("hibernate.id.new_generator_mappings", (Object)false);
        properties.put("hibernate.native_exception_handling_51_compliance", (Object)true);
        SessionFactory sessionFactory = configuration.buildSessionFactory();
        this.transactionWrapper = new GenericTransactionWrapper(sessionFactory);
    }

    @Override
    public void clearPossiblyAbandonedLocksFromPreviousRun(String nodeId) {
        this.transactionWrapper.doInNewHibernateTransaction(session -> session.createQuery("delete from UpgraderLock where nodeId = :nodeId").setParameter("nodeId", (Object)nodeId).executeUpdate());
    }

    @Override
    public void insertLock(String nodeId, String transactionId, String resourceId, Date deadline) {
        this.transactionWrapper.doInNewHibernateTransaction(session -> session.save((Object)UpgraderLock.builder().nodeId(nodeId).transactionId(transactionId).resourceId(resourceId).deadline(deadline).build()));
    }

    @Override
    public void deleteLock(String nodeId, String transactionId, String resourceId) {
        this.transactionWrapper.doInNewHibernateTransaction(session -> session.createQuery("delete from UpgraderLock where nodeId = :nodeId and transactionId = :transactionId and resourceId = :resourceId").setParameter("nodeId", (Object)nodeId).setParameter("transactionId", (Object)transactionId).setParameter("resourceId", (Object)resourceId).executeUpdate());
    }

    @Override
    public boolean isResourceLockOwning(String nodeId, String transactionId, String resourceId) {
        return (Boolean)this.transactionWrapper.doInNewHibernateTransaction(session -> session.createQuery("select 1 from UpgraderLock where exists (select 1 from UpgraderLock where nodeId = :nodeId and transactionId = :transactionId and resourceId = :resourceId)").setParameter("nodeId", (Object)nodeId).setParameter("transactionId", (Object)transactionId).setParameter("resourceId", (Object)resourceId).uniqueResultOptional().isPresent());
    }

    @Override
    public void postponeLockDeadline(String nodeId, String transactionId, String resourceId, Date nextDeadline) {
        this.transactionWrapper.doInNewHibernateTransaction(session -> {
            List currentNodeProcessLocksToUpgrade = session.createQuery("from UpgraderLock where nodeId = :nodeId and transactionId = :transactionId and resourceId = :resourceId", UpgraderLock.class).setParameter("nodeId", (Object)nodeId).setParameter("transactionId", (Object)transactionId).setParameter("resourceId", (Object)resourceId).setLockMode(LockModeType.PESSIMISTIC_WRITE).list();
            for (UpgraderLock processLock : currentNodeProcessLocksToUpgrade) {
                processLock.setDeadline(nextDeadline);
            }
        });
    }

    @Override
    public int deleteAbandonedLocks() {
        return (Integer)this.transactionWrapper.doInNewHibernateTransaction(session -> session.createQuery("delete from UpgraderLock where deadline < :deadline").setParameter("deadline", (Object)new Date()).executeUpdate());
    }
}

