/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.changes.scheduledtasks;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import liquibase.change.custom.CustomSqlChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.UpdateStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecomposePeriodMillisecondsForPmScheduledTasks
implements CustomSqlChange {
    private static final Logger log = LoggerFactory.getLogger(DecomposePeriodMillisecondsForPmScheduledTasks.class);

    public SqlStatement[] generateStatements(Database database) throws CustomChangeException {
        JdbcConnection connection = (JdbcConnection)database.getConnection();
        ArrayList<UpdateStatement> statements = new ArrayList<UpdateStatement>();
        String query = "SELECT scheduled_task_id, period_value from pm_scheduled_tasks";
        try (PreparedStatement statement = connection.prepareStatement(query);
             ResultSet resultSet = statement.executeQuery();){
            while (resultSet.next()) {
                long id = resultSet.getLong("scheduled_task_id");
                long periodMilliseconds = resultSet.getLong("period_value");
                if (resultSet.wasNull()) continue;
                OldPeriodUnit periodUnit = OldPeriodUnit.estimateUnit(periodMilliseconds);
                long periodValue = periodMilliseconds / periodUnit.getUnitPeriodMilliseconds();
                UpdateStatement updateStatement = new UpdateStatement("", "", "pm_scheduled_tasks");
                updateStatement.addNewColumnValue("period_unit", (Object)periodUnit.name());
                updateStatement.addNewColumnValue("period_value", (Object)periodValue);
                updateStatement.setWhereClause("scheduled_task_id = " + id);
                statements.add(updateStatement);
            }
        }
        catch (Exception e) {
            throw new CustomChangeException("Error occurred during scheduled tasks period decomposing", (Throwable)e);
        }
        return statements.toArray(new SqlStatement[0]);
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }

    private static enum OldPeriodUnit {
        MINUTES("minute", 60000L),
        HOURS("hour", 60L * MINUTES.getUnitPeriodMilliseconds()),
        DAYS("day", 24L * HOURS.getUnitPeriodMilliseconds());

        private static final OldPeriodUnit[] VALUES;
        private final String unitName;
        private final long unitPeriodMilliseconds;

        private OldPeriodUnit(String unit, long milliseconds) {
            this.unitName = unit;
            this.unitPeriodMilliseconds = milliseconds;
        }

        public static OldPeriodUnit estimateUnit(long milliseconds) {
            return Arrays.stream(VALUES).sorted(Comparator.reverseOrder()).filter(unit -> milliseconds % unit.getUnitPeriodMilliseconds() == 0L).findFirst().orElse(MINUTES);
        }

        public String getUnitName() {
            return this.unitName;
        }

        public long getUnitPeriodMilliseconds() {
            return this.unitPeriodMilliseconds;
        }

        static {
            VALUES = OldPeriodUnit.values();
        }
    }
}

