/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.changes.scheduledtasks;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.UUID;
import liquibase.change.custom.CustomSqlChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.UpdateStatement;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssignStaticIdToScheduledTasksChange
implements CustomSqlChange {
    private static final Logger log = LoggerFactory.getLogger(AssignStaticIdToScheduledTasksChange.class);

    public SqlStatement[] generateStatements(Database database) throws CustomChangeException {
        JdbcConnection connection = (JdbcConnection)database.getConnection();
        ArrayList<UpdateStatement> statements = new ArrayList<UpdateStatement>();
        String query = "SELECT scheduled_task_id, static_id from pm_scheduled_tasks";
        try (PreparedStatement statement = connection.prepareStatement(query);
             ResultSet resultSet = statement.executeQuery();){
            while (resultSet.next()) {
                long id = resultSet.getLong("scheduled_task_id");
                String oldStaticId = resultSet.getString("static_id");
                if (StringUtils.isNotBlank((CharSequence)oldStaticId)) continue;
                String newStaticId = UUID.randomUUID().toString();
                UpdateStatement updateStatement = new UpdateStatement("", "", "pm_scheduled_tasks");
                updateStatement.addNewColumnValue("static_id", (Object)newStaticId);
                updateStatement.setWhereClause("scheduled_task_id = " + id);
                statements.add(updateStatement);
            }
        }
        catch (Exception e) {
            throw new CustomChangeException("Error occurred during scheduled tasks unique id assigning", (Throwable)e);
        }
        return statements.toArray(new SqlStatement[0]);
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }
}

