/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.changes.translations;

import com.suncode.pwfl.changes.translations.PopulateTranslations;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import liquibase.database.jvm.JdbcConnection;
import liquibase.statement.core.InsertStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateUserSearchViewsTranslations
extends PopulateTranslations {
    private static final Logger log = LoggerFactory.getLogger(PopulateUserSearchViewsTranslations.class);
    private Map<Long, String> userSearchViewsNames = new HashMap<Long, String>();
    private Map<Long, String> userSearchViewsDescriptions = new HashMap<Long, String>();

    @Override
    protected final void setVariables() {
        this.tableName = "pm_usersearchviews_tr";
        this.sequenceName = "pm_usersearchviews_tr_id_seq";
        this.entityTableName = "pm_usersearchviews";
    }

    @Override
    protected final void loadTranslatableEntities(JdbcConnection connection) {
        String query = String.format("SELECT id as id, viewname as name, viewdescr as description FROM %s", this.entityTableName);
        try (ResultSet resultSet = connection.prepareStatement(query).executeQuery();){
            while (resultSet.next()) {
                this.userSearchViewsNames.put(resultSet.getLong("id"), resultSet.getString("name"));
                this.userSearchViewsDescriptions.put(resultSet.getLong("id"), resultSet.getString("description"));
            }
        }
        catch (Exception e) {
            log.error("Error fetching records from {} table", (Object)this.entityTableName, (Object)e);
        }
    }

    @Override
    protected final List<InsertStatement> getInsertStatements(String locale, Map.Entry<Object, Object> translation) {
        InsertStatement insertStatement;
        ArrayList<InsertStatement> result = new ArrayList<InsertStatement>();
        List<Long> translatedNameEntityIds = this.getTranslatedEntityId(this.userSearchViewsNames, (String)translation.getKey());
        List<Long> translatedDescEntityIds = this.getTranslatedEntityId(this.userSearchViewsDescriptions, (String)translation.getKey());
        for (Long id : translatedNameEntityIds) {
            insertStatement = new InsertStatement("", "", this.tableName);
            if (!this.isMSSQL.booleanValue()) {
                insertStatement.addColumn(this.createSequence());
            }
            insertStatement.addColumnValue("locale", (Object)locale);
            insertStatement.addColumnValue("value", translation.getValue());
            insertStatement.addColumnValue("translated_entity_id", (Object)id);
            insertStatement.addColumnValue("translated_field_type", (Object)"NAME");
            result.add(insertStatement);
        }
        for (Long id : translatedDescEntityIds) {
            insertStatement = new InsertStatement("", "", this.tableName);
            if (!this.isMSSQL.booleanValue()) {
                insertStatement.addColumn(this.createSequence());
            }
            insertStatement.addColumnValue("locale", (Object)locale);
            insertStatement.addColumnValue("value", translation.getValue());
            insertStatement.addColumnValue("translated_entity_id", (Object)id);
            insertStatement.addColumnValue("translated_field_type", (Object)"DESCRIPTION");
            result.add(insertStatement);
        }
        return result;
    }

    public Map<Long, String> getUserSearchViewsNames() {
        return this.userSearchViewsNames;
    }

    public Map<Long, String> getUserSearchViewsDescriptions() {
        return this.userSearchViewsDescriptions;
    }

    public void setUserSearchViewsNames(Map<Long, String> userSearchViewsNames) {
        this.userSearchViewsNames = userSearchViewsNames;
    }

    public void setUserSearchViewsDescriptions(Map<Long, String> userSearchViewsDescriptions) {
        this.userSearchViewsDescriptions = userSearchViewsDescriptions;
    }
}

