CREATE TABLE "PM_DASHBOARD"
(
   ID decimal(19,0) PRIMARY KEY NOT NULL,
   CREATED timestamp NOT NULL,
   DESCRIPTION varchar2(255),
   NAME varchar2(100) NOT NULL,
   OWNER_ID decimal(19,0) NOT NULL
)
;
ALTER TABLE "PM_DASHBOARD"
ADD CONSTRAINT fk_pm_dashboard_usertable
FOREIGN KEY (OWNER_ID)
REFERENCES "USERTABLE"(OID) ON DELETE CASCADE
;
CREATE UNIQUE INDEX uk_pm_dashboard_owner_id_name ON "PM_DASHBOARD"
(
  OWNER_ID,
  NAME
)
;

CREATE SEQUENCE PM_DASHBOARD_ID
INCREMENT BY 1 MINVALUE 1 MAXVALUE 999999999999999999999999999 
CACHE 20 NOCYCLE;

CREATE TABLE "PM_DASHBOARD_DEFAULT"
(
   ID decimal(19,0) PRIMARY KEY NOT NULL,
   DASHBOARD_ID decimal(19,0) NOT NULL,
   GROUP_ID decimal(19,0),
   USER_ID decimal(19,0)
)
;
ALTER TABLE "PM_DASHBOARD_DEFAULT"
ADD CONSTRAINT fk_pm_dash_def_group
FOREIGN KEY (GROUP_ID)
REFERENCES "GROUPTABLE"(OID) ON DELETE CASCADE
;
ALTER TABLE "PM_DASHBOARD_DEFAULT"
ADD CONSTRAINT fk_pm_dash_def_user
FOREIGN KEY (USER_ID)
REFERENCES "USERTABLE"(OID) ON DELETE CASCADE
;
ALTER TABLE "PM_DASHBOARD_DEFAULT"
ADD CONSTRAINT fk_pm_dash_def_pm_dash
FOREIGN KEY (DASHBOARD_ID)
REFERENCES "PM_DASHBOARD"(ID)
;
CREATE UNIQUE INDEX uk_pm_dash_def_group_id ON "PM_DASHBOARD_DEFAULT"(USER_ID)
;
CREATE UNIQUE INDEX uk_pm_dash_def_user_id ON "PM_DASHBOARD_DEFAULT"(GROUP_ID)
;

CREATE SEQUENCE PM_DASHBOARD_DEFAULT_ID
INCREMENT BY 1 MINVALUE 1 MAXVALUE 999999999999999999999999999 
CACHE 20 NOCYCLE;

CREATE TABLE "PM_DASHBOARD_GADGET"
(
   ID decimal(19,0) PRIMARY KEY NOT NULL,
   "key" varchar2(255) NOT NULL,
   COLLAPSED decimal(1,0) NOT NULL,
   HEIGHT decimal(10,0),
   LAYOUTORDER decimal(10,0),
   POSITIONX decimal(10,0),
   WIDTH decimal(10,0),
   DASHBOARD_ID decimal(19,0) NOT NULL
)
;
ALTER TABLE "PM_DASHBOARD_GADGET"
ADD CONSTRAINT fk_pm_dash_gad_pm_dash
FOREIGN KEY (DASHBOARD_ID)
REFERENCES "PM_DASHBOARD"(ID)
;

CREATE SEQUENCE PM_DASHBOARD_GADGET_ID
INCREMENT BY 1 MINVALUE 1 MAXVALUE 999999999999999999999999999 
CACHE 20 NOCYCLE;

CREATE TABLE "PM_DASHBOARD_GADGETPROP"
(
   ID decimal(19,0) PRIMARY KEY NOT NULL,
   NAME varchar2(100),
   VALUE varchar2(4000),
   GADGET_ID decimal(19,0) NOT NULL
)
;
ALTER TABLE "PM_DASHBOARD_GADGETPROP"
ADD CONSTRAINT fk_pm_dash_gadget_pm_dash_gad
FOREIGN KEY (GADGET_ID)
REFERENCES "PM_DASHBOARD_GADGET"(ID)
;
CREATE UNIQUE INDEX uk_pm_dash_gpr_gad_name ON "PM_DASHBOARD_GADGETPROP"
(
  GADGET_ID,
  NAME
)
;

CREATE SEQUENCE PM_DASHBOARD_GADGETPROP_ID
INCREMENT BY 1 MINVALUE 1 MAXVALUE 999999999999999999999999999 
CACHE 20 NOCYCLE;

CREATE TABLE "PM_DASHBOARD_SHARE"
(
   TYPE varchar2(31) NOT NULL,
   ID decimal(19,0) PRIMARY KEY NOT NULL,
   DASHBOARD_ID decimal(19,0) NOT NULL,
   GROUP_ID decimal(19,0),
   USER_ID decimal(19,0)
)
;
ALTER TABLE "PM_DASHBOARD_SHARE"
ADD CONSTRAINT fk_pm_dash_share_user
FOREIGN KEY (USER_ID)
REFERENCES "USERTABLE"(OID) ON DELETE CASCADE
;
ALTER TABLE "PM_DASHBOARD_SHARE"
ADD CONSTRAINT fk_pm_dash_sh_pm_dash
FOREIGN KEY (DASHBOARD_ID)
REFERENCES "PM_DASHBOARD"(ID)
;
ALTER TABLE "PM_DASHBOARD_SHARE"
ADD CONSTRAINT fk_pm_dash_sh_group
FOREIGN KEY (GROUP_ID)
REFERENCES "GROUPTABLE"(OID) ON DELETE CASCADE
;

CREATE SEQUENCE PM_DASHBOARD_SHARE_ID_SEQ
INCREMENT BY 1 MINVALUE 1 MAXVALUE 999999999999999999999999999 
CACHE 20 NOCYCLE;