/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.customChanges;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import liquibase.change.custom.CustomSqlChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.InsertStatement;

public class SystemMessagesGroupChange
implements CustomSqlChange {
    private String groupObjectIdColumnName;

    public SqlStatement[] generateStatements(Database database) throws CustomChangeException {
        JdbcConnection connection = (JdbcConnection)database.getConnection();
        PreparedStatement systemMessagesQuery = connection.prepareStatement("SELECT * from pm_system_message WHERE groupid IS NOT NULL");
        PreparedStatement groupQuery = connection.prepareStatement("SELECT * from grouptable WHERE groupid = ?");
        ArrayList<InsertStatement> statementsList = new ArrayList<InsertStatement>();
        try (ResultSet resultSet = systemMessagesQuery.executeQuery();){
            while (resultSet.next()) {
                Long messageId = resultSet.getLong("id");
                String groupId = resultSet.getString("groupid");
                Long groupObjectId = this.getGroupObjectId(groupQuery, groupId);
                if (groupObjectId == null) continue;
                InsertStatement insertStatement = new InsertStatement("", "", "pm_system_message_group");
                insertStatement.addColumnValue("system_message_id", (Object)messageId);
                insertStatement.addColumnValue("group_id", (Object)groupObjectId);
                statementsList.add(insertStatement);
            }
        }
        return statementsList.toArray(new SqlStatement[statementsList.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Long getGroupObjectId(PreparedStatement groupQuery, String groupId) {
        groupQuery.setString(1, groupId);
        try (ResultSet groupResultSet = groupQuery.executeQuery();){
            if (!groupResultSet.next()) return null;
            Long l = groupResultSet.getLong(this.groupObjectIdColumnName);
            return l;
        }
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }

    public String getGroupObjectIdColumnName() {
        return this.groupObjectIdColumnName;
    }

    public void setGroupObjectIdColumnName(String groupObjectIdColumnName) {
        this.groupObjectIdColumnName = groupObjectIdColumnName;
    }
}

