/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.customChanges;

import com.suncode.pwfl.web.ui.DivanteColor;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import liquibase.change.ColumnConfig;
import liquibase.change.custom.CustomSqlChange;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SequenceNextValueFunction;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.InsertStatement;
import liquibase.statement.core.UpdateStatement;

public class BackgroundColorAssigmentChange
implements CustomSqlChange {
    private String userIdColumnName;

    public SqlStatement[] generateStatements(Database database) throws CustomChangeException {
        JdbcConnection connection = (JdbcConnection)database.getConnection();
        PreparedStatement userQuery = connection.prepareStatement("SELECT * from usertable");
        ArrayList<Long> userIds = new ArrayList<Long>();
        try (ResultSet resultSet = userQuery.executeQuery();){
            while (resultSet.next()) {
                userIds.add(resultSet.getLong(this.userIdColumnName));
            }
        }
        PreparedStatement avatarQuery = connection.prepareStatement("SELECT * from pm_user_avatar");
        HashSet<Long> avatarUserIds = new HashSet<Long>();
        try (ResultSet resultSet = avatarQuery.executeQuery();){
            while (resultSet.next()) {
                long avatarUserId = resultSet.getLong("userid");
                avatarUserIds.add(avatarUserId);
            }
        }
        List colors = DivanteColor.getColorsForAvatar();
        ArrayList<Object> statementsList = new ArrayList<Object>();
        for (int i = 0; i < userIds.size(); ++i) {
            DivanteColor backgroundColor = (DivanteColor)colors.get(i % colors.size());
            if (avatarUserIds.contains(userIds.get(i))) {
                UpdateStatement updateStatement = new UpdateStatement("", "", "pm_user_avatar");
                updateStatement.setWhereClause("userid = '" + String.valueOf(userIds.get(i)) + "'");
                updateStatement.addNewColumnValue("backgroundcolor", (Object)backgroundColor.name());
                statementsList.add(updateStatement);
                continue;
            }
            InsertStatement avatarInsertStatement = new InsertStatement("", "", "pm_user_avatar");
            InsertStatement miniAvatarInsertStatement = new InsertStatement("", "", "pm_user_avatar");
            if (!(database instanceof MSSQLDatabase)) {
                avatarInsertStatement.addColumn(this.createSequence());
                miniAvatarInsertStatement.addColumn(this.createSequence());
            }
            avatarInsertStatement.addColumnValue("userid", userIds.get(i));
            avatarInsertStatement.addColumnValue("mini", (Object)false);
            avatarInsertStatement.addColumnValue("backgroundcolor", (Object)backgroundColor.name());
            statementsList.add(avatarInsertStatement);
            miniAvatarInsertStatement.addColumnValue("userid", userIds.get(i));
            miniAvatarInsertStatement.addColumnValue("mini", (Object)true);
            miniAvatarInsertStatement.addColumnValue("backgroundcolor", (Object)backgroundColor.name());
            statementsList.add(miniAvatarInsertStatement);
        }
        return statementsList.toArray(new SqlStatement[statementsList.size()]);
    }

    private ColumnConfig createSequence() {
        ColumnConfig config = new ColumnConfig();
        config.setName("id");
        config.setValueSequenceNext(new SequenceNextValueFunction("pm_user_avatar_id_seq"));
        return config;
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }

    public String getUserIdColumnName() {
        return this.userIdColumnName;
    }

    public void setUserIdColumnName(String userIdColumnName) {
        this.userIdColumnName = userIdColumnName;
    }
}

