/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.upgrade;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.UniqueConstraint;
import java.beans.ConstructorProperties;
import java.util.Date;

@Entity
@Table(name="pm_upgrader_lock", uniqueConstraints={@UniqueConstraint(name="pm_upgrader_lock_unique_res", columnNames={"resourceid"})})
class UpgraderLock {
    private static final String SEQ = "pm_upgrader_lock_id_seq";
    @Id
    @SequenceGenerator(name="pm_upgrader_lock_id_seq", sequenceName="pm_upgrader_lock_id_seq")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_upgrader_lock_id_seq")
    private Long id;
    @Column
    private String nodeId;
    @Column
    private String transactionId;
    @Column
    private String resourceId;
    @Column
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date deadline;

    public static UpgraderLockBuilder builder() {
        return new UpgraderLockBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public Date getDeadline() {
        return this.deadline;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public void setDeadline(Date deadline) {
        this.deadline = deadline;
    }

    public UpgraderLock() {
    }

    @ConstructorProperties(value={"id", "nodeId", "transactionId", "resourceId", "deadline"})
    public UpgraderLock(Long id, String nodeId, String transactionId, String resourceId, Date deadline) {
        this.id = id;
        this.nodeId = nodeId;
        this.transactionId = transactionId;
        this.resourceId = resourceId;
        this.deadline = deadline;
    }

    public static class UpgraderLockBuilder {
        private Long id;
        private String nodeId;
        private String transactionId;
        private String resourceId;
        private Date deadline;

        UpgraderLockBuilder() {
        }

        public UpgraderLockBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public UpgraderLockBuilder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public UpgraderLockBuilder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public UpgraderLockBuilder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public UpgraderLockBuilder deadline(Date deadline) {
            this.deadline = deadline;
            return this;
        }

        public UpgraderLock build() {
            return new UpgraderLock(this.id, this.nodeId, this.transactionId, this.resourceId, this.deadline);
        }

        public String toString() {
            return "UpgraderLock.UpgraderLockBuilder(id=" + this.id + ", nodeId=" + this.nodeId + ", transactionId=" + this.transactionId + ", resourceId=" + this.resourceId + ", deadline=" + String.valueOf(this.deadline) + ")";
        }
    }
}

