/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.customChanges;

import com.suncode.plugin.dashboard.Dashboard;
import com.suncode.plugin.dashboard.DashboardService;
import com.suncode.plugin.dashboard.Gadget;
import com.suncode.plugin.dashboard.gadget.Layout;
import com.suncode.pwfl.dashboard.internal.UserDashboard;
import com.suncode.pwfl.util.SpringContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;

public class NetSizeConverterChange
implements CustomTaskChange {
    public void execute(Database database) {
        DashboardService dashboardService = (DashboardService)SpringContext.getBean(DashboardService.class);
        List userDashboards = dashboardService.getAll();
        if (userDashboards.isEmpty()) {
            return;
        }
        for (UserDashboard userDashboard : userDashboards) {
            Dashboard dashboard = dashboardService.getDashboard(userDashboard.getId(), Boolean.valueOf(false));
            Gadget[] gadgets = dashboard.getGadgets();
            if (gadgets.length == 0) continue;
            Map<Integer, List<Gadget>> gadgetsByLineMap = this.createGadgetsByLine(gadgets);
            this.convertGadgetsByLine(gadgetsByLineMap);
            dashboardService.updateDashboard(dashboard, Boolean.valueOf(false));
        }
    }

    private Map<Integer, List<Gadget>> createGadgetsByLine(Gadget[] gadgets) {
        HashMap<Integer, List<Gadget>> gadgetsByLineMap = new HashMap<Integer, List<Gadget>>();
        ArrayList<Gadget> gadgetsLine = new ArrayList<Gadget>();
        int lineIndex = 0;
        int lineTempWidth = 0;
        int iterator = 0;
        for (Gadget gadget : gadgets) {
            Layout layout = gadget.getLayout();
            if (Objects.isNull(layout) || Objects.isNull(layout.getWidth())) continue;
            if (lineTempWidth + layout.getWidth() >= 8) {
                gadgetsLine.add(gadget);
                gadgetsByLineMap.put(lineIndex, gadgetsLine);
                ++lineIndex;
                gadgetsLine = new ArrayList();
            } else {
                gadgetsLine.add(gadget);
                lineTempWidth += gadget.getLayout().getWidth().intValue();
                if (gadgets.length - 1 == iterator) {
                    gadgetsByLineMap.put(lineIndex, gadgetsLine);
                }
            }
            ++iterator;
        }
        return gadgetsByLineMap;
    }

    private void convertGadgetsByLine(Map<Integer, List<Gadget>> gadgetsByLineMap) {
        for (Map.Entry<Integer, List<Gadget>> gadgetsByLine : gadgetsByLineMap.entrySet()) {
            List<Gadget> lineGadgets = gadgetsByLine.getValue();
            if (lineGadgets.size() == 1) {
                lineGadgets.get(0).getLayout().setWidth(Integer.valueOf(lineGadgets.get(0).getLayout().getWidth() + 4));
            }
            if (lineGadgets.size() <= 1) continue;
            lineGadgets.get(lineGadgets.size() - 2).getLayout().setWidth(Integer.valueOf(lineGadgets.get(lineGadgets.size() - 2).getLayout().getWidth() + 2));
            lineGadgets.get(lineGadgets.size() - 1).getLayout().setPositionX(Integer.valueOf(lineGadgets.get(lineGadgets.size() - 1).getLayout().getPositionX() + 2));
            lineGadgets.get(lineGadgets.size() - 1).getLayout().setWidth(Integer.valueOf(lineGadgets.get(lineGadgets.size() - 1).getLayout().getWidth() + 2));
        }
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }
}

