/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.changes.translations;

import java.io.File;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import liquibase.database.jvm.JdbcConnection;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TranslationUpgradeHelper {
    private static final Logger log = LoggerFactory.getLogger(TranslationUpgradeHelper.class);
    private static TranslationUpgradeHelper instance;
    private final String GET_PATH_TO_CUSTOM_BUNDLE_QUERY = "SELECT valuestring as value FROM pm_systemparameter WHERE parameterkey = 'PATH_TO_CUSTOM_BUNDLE'";
    private final JdbcConnection connection;
    private Map<String, Properties> localeTranslations = new HashMap<String, Properties>();

    private TranslationUpgradeHelper(JdbcConnection connection) {
        this.connection = connection;
        this.loadLocaleTranslations();
    }

    public static TranslationUpgradeHelper getInstance(JdbcConnection connection) {
        if (instance == null) {
            instance = new TranslationUpgradeHelper(connection);
        }
        return instance;
    }

    private void loadLocaleTranslations() {
        File customBundleDirectory;
        String pathToCustomBundle = this.getPathToCustomBundle();
        if (!StringUtils.isBlank((CharSequence)pathToCustomBundle) && (customBundleDirectory = new File(pathToCustomBundle)).isDirectory()) {
            for (File file2 : customBundleDirectory.listFiles(file -> file.getName().startsWith("customMessages") && file.getName().endsWith(".i18n"))) {
                String locale = this.getLocale(file2.getName());
                try (InputStreamReader inputStreamReader = new InputStreamReader(Files.newInputStream(file2.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
                    Properties translations = new Properties();
                    translations.load(inputStreamReader);
                    this.localeTranslations.put(locale, translations);
                }
                catch (Exception e) {
                    log.error("Error opening file %s", (Object)file2.getName(), (Object)e);
                }
            }
        }
    }

    private String getPathToCustomBundle() {
        String pathToCustomBundle = "";
        try {
            ResultSet resultSet = this.connection.prepareStatement("SELECT valuestring as value FROM pm_systemparameter WHERE parameterkey = 'PATH_TO_CUSTOM_BUNDLE'").executeQuery();
            if (resultSet.next()) {
                pathToCustomBundle = resultSet.getString("value");
            }
        }
        catch (Exception e) {
            log.error("Could not get PATH_TO_CUSTOM_BUNDLE parameter from database", (Throwable)e);
        }
        return pathToCustomBundle;
    }

    private String getLocale(String fileName) {
        String locale = "";
        if (fileName.contains("_")) {
            locale = fileName.substring(fileName.indexOf("_") + 1, fileName.indexOf(".i18n"));
        }
        return locale;
    }

    public Map<String, Properties> getLocaleTranslations() {
        return this.localeTranslations;
    }
}

